/*
 * Decompiled with CFR 0.152.
 */
package superlord.prehistoricfauna.client.render.henos;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.ChatFormatting;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import superlord.prehistoricfauna.client.ClientEvents;
import superlord.prehistoricfauna.client.model.henos.HenosModel;
import superlord.prehistoricfauna.client.model.henos.HenosSummonedModel;
import superlord.prehistoricfauna.client.render.layer.HenosGemGlowLayer;
import superlord.prehistoricfauna.client.render.layer.HenosLaserGlowLayer;
import superlord.prehistoricfauna.common.entity.henos.Henos;
import superlord.prehistoricfauna.init.PFRenderTypes;

@OnlyIn(value=Dist.CLIENT)
public class HenosRenderer
extends MobRenderer<Henos, EntityModel<Henos>> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("prehistoricfauna", "textures/entities/henos/henos.png");
    private static final ResourceLocation SUMMONED_TEXTURE = new ResourceLocation("prehistoricfauna", "textures/entities/henos/henos_summoned.png");
    private static final ResourceLocation FUNKY_MONKEY = new ResourceLocation("prehistoricfauna", "textures/entities/henos/brass_monkey.png");
    private static final ResourceLocation TEXTURE_LIT = new ResourceLocation("prehistoricfauna", "textures/entities/henos/henos_lit.png");
    private static final ResourceLocation SUMMONED_TEXTURE_LIT = new ResourceLocation("prehistoricfauna", "textures/entities/henos/henos_summoned_lit.png");
    private static final ResourceLocation FUNKY_MONKEY_LIT = new ResourceLocation("prehistoricfauna", "textures/entities/henos/brass_monkey_lit.png");
    private static HenosModel HENOS;
    private static HenosModel HENOS_HEALING;
    private static HenosSummonedModel SUMMONED;
    private static HenosSummonedModel SUMMONED_HEALING;
    private static final ResourceLocation BEAM_TEXTURE;
    private static final RenderType BEAM_RENDER_TYPE;

    public HenosRenderer(EntityRendererProvider.Context renderManagerIn) {
        super(renderManagerIn, (EntityModel)new HenosModel(renderManagerIn.m_174023_(ClientEvents.HENOS), 0.0f), 1.25f);
        this.m_115326_(new HenosGemGlowLayer((RenderLayerParent<Henos, EntityModel<Henos>>)this));
        this.m_115326_(new HealingLayer((RenderLayerParent<Henos, EntityModel<Henos>>)this));
        this.m_115326_(new HenosLaserGlowLayer((RenderLayerParent<Henos, EntityModel<Henos>>)this));
        HENOS = new HenosModel(renderManagerIn.m_174023_(ClientEvents.HENOS), 0.0f);
        HENOS_HEALING = new HenosModel(renderManagerIn.m_174023_(ClientEvents.HENOS), 0.5f);
        SUMMONED = new HenosSummonedModel(renderManagerIn.m_174023_(ClientEvents.SUMMONED_HENOS), 0.0f);
        SUMMONED_HEALING = new HenosSummonedModel(renderManagerIn.m_174023_(ClientEvents.SUMMONED_HENOS), 0.5f);
    }

    public boolean shouldRender(Henos p_114836_, Frustum p_114837_, double p_114838_, double p_114839_, double p_114840_) {
        LivingEntity livingentity;
        if (super.m_5523_((Mob)p_114836_, p_114837_, p_114838_, p_114839_, p_114840_)) {
            return true;
        }
        if (p_114836_.hasLaserTarget() && (livingentity = p_114836_.getLaserTarget()) != null) {
            Vec3 vec3 = this.getPosition(livingentity, (double)livingentity.m_20206_() * 0.5, 1.0f);
            Vec3 vec31 = this.getPosition((LivingEntity)p_114836_, p_114836_.m_20192_(), 1.0f);
            return p_114837_.m_113029_(new AABB(vec31.f_82479_, vec31.f_82480_, vec31.f_82481_, vec3.f_82479_, vec3.f_82480_, vec3.f_82481_));
        }
        return false;
    }

    private Vec3 getPosition(LivingEntity p_114803_, double p_114804_, float p_114805_) {
        double d0 = Mth.m_14139_((double)p_114805_, (double)p_114803_.f_19790_, (double)p_114803_.m_20185_());
        double d1 = Mth.m_14139_((double)p_114805_, (double)p_114803_.f_19791_, (double)p_114803_.m_20186_()) + p_114804_;
        double d2 = Mth.m_14139_((double)p_114805_, (double)p_114803_.f_19792_, (double)p_114803_.m_20189_());
        return new Vec3(d0, d1, d2);
    }

    protected void setupRotations(Henos entityIn, PoseStack matrixStackIn, float ageInTicks, float rotationYaw, float partialTicks) {
        super.m_7523_((LivingEntity)entityIn, matrixStackIn, ageInTicks, rotationYaw, partialTicks);
        Vec3 vec = entityIn.getLaserTargetPos(partialTicks);
        double d0 = vec.f_82479_ - entityIn.m_20185_();
        double d2 = vec.f_82481_ - entityIn.m_20189_();
        float f1 = Mth.m_14177_((float)(180.0f - rotationYaw));
        float f2 = Mth.m_14177_((float)((float)(Mth.m_14136_((double)d2, (double)d0) * 57.2957763671875) + 90.0f));
        float f3 = entityIn.getLaserTargetProgress(partialTicks);
        matrixStackIn.m_252781_(Axis.f_252392_.m_252977_(f1 * f3));
        matrixStackIn.m_252781_(Axis.f_252392_.m_252977_(f2 * f3));
    }

    public void render(Henos entityIn, float entityYaw, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn) {
        super.m_7392_((Mob)entityIn, entityYaw, partialTicks, matrixStackIn, bufferIn, packedLightIn);
        LivingEntity livingentity = entityIn.getLaserTarget();
        if (livingentity != null) {
            float f1 = (float)entityIn.m_9236_().m_46467_() + partialTicks;
            float f2 = f1 * -0.2f % 1.0f;
            float f3 = entityIn.m_20206_() * 0.625f;
            matrixStackIn.m_85836_();
            matrixStackIn.m_85837_(0.0, (double)f3, 0.0);
            Vec3 vector3d = entityIn.getLaserTargetPos(partialTicks);
            Vec3 vector3d1 = this.getPosition((LivingEntity)entityIn, f3, partialTicks);
            Vec3 vector3d2 = vector3d.m_82546_(vector3d1);
            float f4 = (float)vector3d2.m_82553_();
            vector3d2 = vector3d2.m_82541_();
            float f5 = (float)Math.acos(vector3d2.f_82480_);
            float f6 = (float)Math.atan2(vector3d2.f_82481_, vector3d2.f_82479_);
            matrixStackIn.m_252781_(Axis.f_252436_.m_252977_((1.5707964f - f6) * 57.295776f));
            matrixStackIn.m_252781_(Axis.f_252529_.m_252977_(f5 * 57.295776f));
            float f8 = 1.0f;
            int j = (int)(f8 * 255.0f);
            int k = (int)(f8 * 255.0f);
            int l = (int)(f8 * 255.0f);
            float width = (float)(100 - (100 - Mth.m_14045_((int)entityIn.getLaserTick(), (int)5, (int)100))) * 0.01f;
            float f11 = Mth.m_14089_((float)2.3561945f) * 0.8f;
            float f12 = Mth.m_14031_((float)2.3561945f) * 0.8f;
            float f13 = Mth.m_14089_((float)0.7853982f) * 0.8f;
            float f14 = Mth.m_14031_((float)0.7853982f) * 0.8f;
            float f15 = Mth.m_14089_((float)3.926991f) * 0.8f;
            float f16 = Mth.m_14031_((float)3.926991f) * 0.8f;
            float f17 = Mth.m_14089_((float)5.4977875f) * 0.8f;
            float f18 = Mth.m_14031_((float)5.4977875f) * 0.8f;
            float f19 = Mth.m_14089_((float)((float)Math.PI)) * width;
            float f20 = Mth.m_14031_((float)((float)Math.PI)) * width;
            float f21 = Mth.m_14089_((float)0.0f) * width;
            float f22 = Mth.m_14031_((float)0.0f) * width;
            float f23 = Mth.m_14089_((float)1.5707964f) * width;
            float f24 = Mth.m_14031_((float)1.5707964f) * width;
            float f25 = Mth.m_14089_((float)4.712389f) * width;
            float f26 = Mth.m_14031_((float)4.712389f) * width;
            float f29 = -1.0f + f2;
            float f30 = f4 * 0.5f + f29;
            VertexConsumer ivertexbuilder = bufferIn.m_6299_(BEAM_RENDER_TYPE);
            PoseStack.Pose matrixstack$entry = matrixStackIn.m_85850_();
            Matrix4f matrix4f = matrixstack$entry.m_252922_();
            Matrix3f matrix3f = matrixstack$entry.m_252943_();
            HenosRenderer.vertex(ivertexbuilder, matrix4f, matrix3f, f19, f4, f20, j, k, l, 0.4999f, f30);
            HenosRenderer.vertex(ivertexbuilder, matrix4f, matrix3f, f19, 0.0f, f20, j, k, l, 0.4999f, f29);
            HenosRenderer.vertex(ivertexbuilder, matrix4f, matrix3f, f21, 0.0f, f22, j, k, l, 0.0f, f29);
            HenosRenderer.vertex(ivertexbuilder, matrix4f, matrix3f, f21, f4, f22, j, k, l, 0.0f, f30);
            HenosRenderer.vertex(ivertexbuilder, matrix4f, matrix3f, f23, f4, f24, j, k, l, 0.4999f, f30);
            HenosRenderer.vertex(ivertexbuilder, matrix4f, matrix3f, f23, 0.0f, f24, j, k, l, 0.4999f, f29);
            HenosRenderer.vertex(ivertexbuilder, matrix4f, matrix3f, f25, 0.0f, f26, j, k, l, 0.0f, f29);
            HenosRenderer.vertex(ivertexbuilder, matrix4f, matrix3f, f25, f4, f26, j, k, l, 0.0f, f30);
            float f31 = 0.0f;
            if (entityIn.f_19797_ % 2 == 0) {
                f31 = 0.5f;
            }
            HenosRenderer.vertex(ivertexbuilder, matrix4f, matrix3f, f11, f4, f12, j, k, l, 0.5f, f31 + 0.5f);
            HenosRenderer.vertex(ivertexbuilder, matrix4f, matrix3f, f13, f4, f14, j, k, l, 1.0f, f31 + 0.5f);
            HenosRenderer.vertex(ivertexbuilder, matrix4f, matrix3f, f17, f4, f18, j, k, l, 1.0f, f31);
            HenosRenderer.vertex(ivertexbuilder, matrix4f, matrix3f, f15, f4, f16, j, k, l, 0.5f, f31);
            matrixStackIn.m_85849_();
        }
    }

    private static void vertex(VertexConsumer p_114842_, Matrix4f p_114843_, Matrix3f p_114844_, float p_114845_, float p_114846_, float p_114847_, int p_114848_, int p_114849_, int p_114850_, float p_114851_, float p_114852_) {
        p_114842_.m_252986_(p_114843_, p_114845_, p_114846_, p_114847_).m_6122_(p_114848_, p_114849_, p_114850_, 255).m_7421_(p_114851_, p_114852_).m_86008_(OverlayTexture.f_118083_).m_85969_(240).m_252939_(p_114844_, 0.0f, 1.0f, 0.0f).m_5752_();
    }

    protected void scale(Henos entityIn, PoseStack matrixStackIn, float partialTickTime) {
        this.f_115290_ = entityIn.isSummoned() ? SUMMONED : HENOS;
        super.m_7546_((LivingEntity)entityIn, matrixStackIn, partialTickTime);
    }

    public ResourceLocation getTextureLocation(Henos entity) {
        String s = ChatFormatting.m_126649_((String)entity.m_7755_().getString());
        if (!entity.isSummoned() && s != null && "Brass Monkey".equals(s)) {
            if (entity.getLaserTick() > 0) {
                return FUNKY_MONKEY_LIT;
            }
            return FUNKY_MONKEY;
        }
        if (entity.isSummoned()) {
            if (entity.getLaserTick() > 0) {
                return SUMMONED_TEXTURE_LIT;
            }
            return SUMMONED_TEXTURE;
        }
        if (entity.getLaserTick() > 0) {
            return TEXTURE_LIT;
        }
        return TEXTURE;
    }

    static {
        BEAM_TEXTURE = new ResourceLocation("prehistoricfauna", "textures/entities/henos/beam.png");
        BEAM_RENDER_TYPE = PFRenderTypes.getBossBeam(BEAM_TEXTURE);
    }

    class HealingLayer
    extends RenderLayer<Henos, EntityModel<Henos>> {
        public HealingLayer(RenderLayerParent<Henos, EntityModel<Henos>> entityRendererIn) {
            super(entityRendererIn);
        }

        public void render(PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn, Henos entitylivingbaseIn, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
            if (entitylivingbaseIn.hasHealingShield()) {
                EntityModel model = entitylivingbaseIn.isSummoned() ? SUMMONED_HEALING : HENOS_HEALING;
                VertexConsumer vertexBuilder = bufferIn.m_6299_(PFRenderTypes.getBossGlint());
                model.m_6973_((Entity)entitylivingbaseIn, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
                model.m_7695_(matrixStackIn, vertexBuilder, packedLightIn, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, entitylivingbaseIn.getShieldThickness());
            }
        }
    }
}

