/*
 * Decompiled with CFR 0.152.
 */
package superlord.prehistoricfauna.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockAndTintGetter;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import superlord.prehistoricfauna.common.entity.Paleopainting;

public class PaleopaintingRenderer
extends EntityRenderer<Paleopainting> {
    private static final ResourceLocation BACK = new ResourceLocation("prehistoricfauna", "textures/painting/back.png");
    private static final Map<Paleopainting.PaleopaintingType, ResourceLocation> PALEOPAINTINGS = new HashMap<Paleopainting.PaleopaintingType, ResourceLocation>();

    public PaleopaintingRenderer(EntityRendererProvider.Context renderManager) {
        super(renderManager);
    }

    public void render(Paleopainting entityIn, float entityYaw, float partialTicks, PoseStack matrixStack, MultiBufferSource buffer, int packedLightIn) {
        matrixStack.m_85836_();
        matrixStack.m_252781_(Axis.f_252436_.m_252977_(180.0f - entityYaw));
        Paleopainting.PaleopaintingType painting = entityIn.paleopainting;
        float f = 0.0625f;
        matrixStack.m_85841_(f, f, f);
        this.renderPainting(matrixStack, buffer, entityIn, painting.getWidth(), painting.getHeight());
        matrixStack.m_85849_();
        super.m_7392_((Entity)entityIn, entityYaw, partialTicks, matrixStack, buffer, packedLightIn);
    }

    public ResourceLocation getTextureLocation(Paleopainting entity) {
        return PALEOPAINTINGS.computeIfAbsent(entity.paleopainting, k -> new ResourceLocation("prehistoricfauna", "textures/painting/" + k.name().toLowerCase() + ".png"));
    }

    private void renderPainting(PoseStack p_229122_1_, MultiBufferSource vertexProvider, Paleopainting painting, int width, int height) {
        PoseStack.Pose matrixstack$entry = p_229122_1_.m_85850_();
        Matrix4f matrix4f = matrixstack$entry.m_252922_();
        Matrix3f matrix3f = matrixstack$entry.m_252943_();
        float f = (float)(-width) / 2.0f;
        float f1 = (float)(-height) / 2.0f;
        float backMinU = 0.0f;
        float backMaxU = 1.0f;
        float backMinV = 0.0f;
        float backMaxV = 1.0f;
        float backInterpolatedU = 0.0625f;
        float backInterpolatedV = 0.0625f;
        int i = width / 16;
        int j = height / 16;
        float d0 = 16.0f / (float)i;
        float d1 = 16.0f / (float)j;
        for (int k = 0; k < i; ++k) {
            for (int l = 0; l < j; ++l) {
                float uStart = f + (float)(k * 16);
                float uEnd = f + (float)((k + 1) * 16);
                float vStart = f1 + (float)(l * 16);
                float vEnd = f1 + (float)((l + 1) * 16);
                int x = Mth.m_14143_((float)painting.m_146903_());
                int y = Mth.m_14107_((double)(painting.m_20186_() + (double)((vEnd + vStart) / 2.0f / 16.0f)));
                int z = Mth.m_14143_((float)painting.m_146907_());
                Direction direction = painting.m_6350_();
                switch (direction) {
                    case NORTH: {
                        x = Mth.m_14107_((double)((double)painting.m_146903_() + (double)((uEnd + uStart) / 2.0f / 16.0f)));
                        break;
                    }
                    case WEST: {
                        z = Mth.m_14107_((double)((double)painting.m_146907_() - (double)((uEnd + uStart) / 2.0f / 16.0f)));
                        break;
                    }
                    case SOUTH: {
                        x = Mth.m_14107_((double)((double)painting.m_146903_() - (double)((uEnd + uStart) / 2.0f / 16.0f)));
                        break;
                    }
                    case EAST: {
                        z = Mth.m_14107_((double)((double)painting.m_146907_() + (double)((uEnd + uStart) / 2.0f / 16.0f)));
                        break;
                    }
                    default: {
                        x = Mth.m_14107_((double)((double)painting.m_146903_() + (double)((uEnd + uStart) / 2.0f / 16.0f)));
                    }
                }
                int light = LevelRenderer.m_109541_((BlockAndTintGetter)painting.m_9236_(), (BlockPos)new BlockPos(x, y, z));
                float spriteMinU = d0 * (float)(i - k) / 16.0f;
                float spriteMaxU = d0 * (float)(i - (k + 1)) / 16.0f;
                float spriteMinV = d1 * (float)(j - l) / 16.0f;
                float spriteMaxV = d1 * (float)(j - (l + 1)) / 16.0f;
                VertexConsumer paintingBuffer = vertexProvider.m_6299_(RenderType.m_110446_((ResourceLocation)this.getTextureLocation(painting)));
                this.vertex(matrix4f, matrix3f, paintingBuffer, uEnd, vStart, spriteMaxU, spriteMinV, -0.5f, 0, 0, -1, light);
                this.vertex(matrix4f, matrix3f, paintingBuffer, uStart, vStart, spriteMinU, spriteMinV, -0.5f, 0, 0, -1, light);
                this.vertex(matrix4f, matrix3f, paintingBuffer, uStart, vEnd, spriteMinU, spriteMaxV, -0.5f, 0, 0, -1, light);
                this.vertex(matrix4f, matrix3f, paintingBuffer, uEnd, vEnd, spriteMaxU, spriteMaxV, -0.5f, 0, 0, -1, light);
                VertexConsumer backBuffer = vertexProvider.m_6299_(RenderType.m_110446_((ResourceLocation)BACK));
                this.vertex(matrix4f, matrix3f, backBuffer, uEnd, vEnd, backMinU, backMinV, 0.5f, 0, 0, 1, light);
                this.vertex(matrix4f, matrix3f, backBuffer, uStart, vEnd, backMaxU, backMinV, 0.5f, 0, 0, 1, light);
                this.vertex(matrix4f, matrix3f, backBuffer, uStart, vStart, backMaxU, backMaxV, 0.5f, 0, 0, 1, light);
                this.vertex(matrix4f, matrix3f, backBuffer, uEnd, vStart, backMinU, backMaxV, 0.5f, 0, 0, 1, light);
                this.vertex(matrix4f, matrix3f, backBuffer, uEnd, vEnd, backMinU, backMinV, -0.5f, 0, 1, 0, light);
                this.vertex(matrix4f, matrix3f, backBuffer, uStart, vEnd, backMaxU, backMinV, -0.5f, 0, 1, 0, light);
                this.vertex(matrix4f, matrix3f, backBuffer, uStart, vEnd, backMaxU, backInterpolatedV, 0.5f, 0, 1, 0, light);
                this.vertex(matrix4f, matrix3f, backBuffer, uEnd, vEnd, backMinU, backInterpolatedV, 0.5f, 0, 1, 0, light);
                this.vertex(matrix4f, matrix3f, backBuffer, uEnd, vStart, backMinU, backMinV, 0.5f, 0, -1, 0, light);
                this.vertex(matrix4f, matrix3f, backBuffer, uStart, vStart, backMaxU, backMinV, 0.5f, 0, -1, 0, light);
                this.vertex(matrix4f, matrix3f, backBuffer, uStart, vStart, backMaxU, backInterpolatedV, -0.5f, 0, -1, 0, light);
                this.vertex(matrix4f, matrix3f, backBuffer, uEnd, vStart, backMinU, backInterpolatedV, -0.5f, 0, -1, 0, light);
                this.vertex(matrix4f, matrix3f, backBuffer, uEnd, vEnd, backInterpolatedU, backMinV, 0.5f, -1, 0, 0, light);
                this.vertex(matrix4f, matrix3f, backBuffer, uEnd, vStart, backInterpolatedU, backMaxV, 0.5f, -1, 0, 0, light);
                this.vertex(matrix4f, matrix3f, backBuffer, uEnd, vStart, backMinU, backMaxV, -0.5f, -1, 0, 0, light);
                this.vertex(matrix4f, matrix3f, backBuffer, uEnd, vEnd, backMinU, backMinV, -0.5f, -1, 0, 0, light);
                this.vertex(matrix4f, matrix3f, backBuffer, uStart, vEnd, backInterpolatedU, backMinV, -0.5f, 1, 0, 0, light);
                this.vertex(matrix4f, matrix3f, backBuffer, uStart, vStart, backInterpolatedU, backMaxV, -0.5f, 1, 0, 0, light);
                this.vertex(matrix4f, matrix3f, backBuffer, uStart, vStart, backMinU, backMaxV, 0.5f, 1, 0, 0, light);
                this.vertex(matrix4f, matrix3f, backBuffer, uStart, vEnd, backMinU, backMinV, 0.5f, 1, 0, 0, light);
            }
        }
    }

    private void vertex(Matrix4f matrix, Matrix3f normal, VertexConsumer buffer, float x, float y, float u, float v, float z, int normalX, int normalY, int normalZ, int light) {
        buffer.m_252986_(matrix, x, y, z).m_6122_(255, 255, 255, 255).m_7421_(u, v).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_252939_(normal, (float)normalX, (float)normalY, (float)normalZ).m_5752_();
    }
}

