/*
 * Decompiled with CFR 0.152.
 */
package superlord.prehistoricfauna.client.model.triassic.ischigualasto;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import superlord.prehistoricfauna.common.entity.DinosaurEntity;
import superlord.prehistoricfauna.common.entity.triassic.ischigualasto.Ischigualastia;

public class IschigualastiaModel
extends EntityModel<Ischigualastia> {
    private final ModelPart Body;
    private final ModelPart LegL;
    private final ModelPart LegR;
    private final ModelPart ArmL;
    private final ModelPart ArmR;
    private final ModelPart Tail;
    private final ModelPart Neck;

    public IschigualastiaModel(ModelPart root) {
        this.Body = root.m_171324_("Body");
        this.Neck = this.Body.m_171324_("Neck");
        this.Tail = this.Body.m_171324_("Tail");
        this.ArmL = this.Body.m_171324_("ArmL");
        this.ArmR = this.Body.m_171324_("ArmR");
        this.LegL = this.Body.m_171324_("LegL");
        this.LegR = this.Body.m_171324_("LegR");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition Body = partdefinition.m_171599_("Body", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-10.0f, -16.0f, -24.0f, 20.0f, 22.0f, 34.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)9.0f, (float)8.0f));
        PartDefinition Neck = Body.m_171599_("Neck", CubeListBuilder.m_171558_().m_171514_(0, 64).m_171488_(-6.0f, -6.0f, -13.0f, 12.0f, 14.0f, 13.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-6.0f, (float)-23.0f, (float)0.1f, (float)0.0f, (float)0.0f));
        PartDefinition Face = Neck.m_171599_("Face", CubeListBuilder.m_171558_().m_171514_(0, 99).m_171488_(-4.5f, -6.0f, -8.0f, 9.0f, 12.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)2.0f, (float)-13.0f));
        PartDefinition LegR = Body.m_171599_("LegR", CubeListBuilder.m_171558_().m_171514_(62, 63).m_171488_(-4.0f, 0.0f, -4.0f, 8.0f, 17.0f, 10.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-7.0f, (float)-2.0f, (float)3.0f));
        PartDefinition LegL = Body.m_171599_("LegL", CubeListBuilder.m_171558_().m_171514_(62, 63).m_171488_(-4.0f, 0.0f, -4.0f, 8.0f, 17.0f, 10.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)7.0f, (float)-2.0f, (float)3.0f));
        PartDefinition ArmL = Body.m_171599_("ArmL", CubeListBuilder.m_171558_().m_171514_(62, 99).m_171488_(-2.0f, 0.0f, -4.0f, 6.0f, 17.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)7.0f, (float)-2.0f, (float)-18.0f));
        PartDefinition Tail = Body.m_171599_("Tail", CubeListBuilder.m_171558_().m_171514_(100, 0).m_171488_(-4.5f, -3.0f, 0.0f, 9.0f, 7.0f, 14.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-9.0f, (float)9.0f, (float)-0.25f, (float)0.0f, (float)0.0f));
        PartDefinition ArmR = Body.m_171599_("ArmR", CubeListBuilder.m_171558_().m_171514_(62, 99).m_171488_(-4.0f, 0.0f, -4.0f, 6.0f, 17.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-7.0f, (float)-2.0f, (float)-18.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)200, (int)200);
    }

    public void setupAnim(Ischigualastia entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        float speed = 1.0f;
        float degree = 1.0f;
        float partialTick = ageInTicks - (float)entity.f_19797_;
        float attackProgress = entity.getMeleeProgress(partialTick) * 2.0f;
        float sleepProgress = entity.getSleepProgress(partialTick);
        this.resetModel();
        if (entity.isAsleep()) {
            if (sleepProgress != 0.0f && (Integer)entity.m_20088_().m_135370_(DinosaurEntity.SLEEP_TICK) > 0) {
                this.Body.f_104201_ = Mth.m_14179_((float)sleepProgress, (float)9.0f, (float)14.0f);
                this.Body.f_104205_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-1.5707964f);
                this.LegL.f_104200_ = Mth.m_14179_((float)sleepProgress, (float)7.0f, (float)10.4f);
                this.LegL.f_104205_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)0.5235988f);
                this.ArmR.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)0.5235988f);
                this.LegR.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)0.41887903f);
                this.Neck.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)0.5934119f);
                this.Neck.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-0.13962634f);
                this.Neck.f_104205_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)0.83775806f);
                this.Tail.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-0.2443461f);
                this.Tail.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-0.10471976f);
                this.Tail.f_104205_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)0.5934119f);
                this.ArmL.f_104200_ = Mth.m_14179_((float)sleepProgress, (float)7.0f, (float)11.0f);
                this.ArmL.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)0.4537856f);
                this.ArmL.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)0.2443461f);
                this.ArmL.f_104205_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)0.5235988f);
            } else {
                this.sleepPose();
            }
        } else if (sleepProgress != 0.0f && (Integer)entity.m_20088_().m_135370_(DinosaurEntity.SLEEP_TICK) > 0) {
            this.Body.f_104201_ = Mth.m_14179_((float)sleepProgress, (float)14.0f, (float)9.0f);
            this.Body.f_104205_ = Mth.m_14179_((float)sleepProgress, (float)-1.5707964f, (float)0.0f);
            this.LegL.f_104200_ = Mth.m_14179_((float)sleepProgress, (float)10.4f, (float)7.0f);
            this.LegL.f_104205_ = Mth.m_14179_((float)sleepProgress, (float)0.5235988f, (float)0.0f);
            this.ArmR.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.5235988f, (float)0.0f);
            this.LegR.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.41887903f, (float)0.0f);
            this.Neck.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.5934119f, (float)0.0f);
            this.Neck.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)-0.13962634f, (float)0.0f);
            this.Neck.f_104205_ = Mth.m_14179_((float)sleepProgress, (float)0.83775806f, (float)0.0f);
            this.Tail.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)-0.2443461f, (float)0.0f);
            this.Tail.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)-0.10471976f, (float)0.0f);
            this.Tail.f_104205_ = Mth.m_14179_((float)sleepProgress, (float)0.5934119f, (float)0.0f);
            this.ArmL.f_104200_ = Mth.m_14179_((float)sleepProgress, (float)11.0f, (float)7.0f);
            this.ArmL.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.4537856f, (float)0.0f);
            this.ArmL.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)0.2443461f, (float)0.0f);
            this.ArmL.f_104205_ = Mth.m_14179_((float)sleepProgress, (float)0.5235988f, (float)0.0f);
        } else {
            this.Neck.f_104203_ = -Math.abs(-0.025f * Mth.m_14031_((float)(0.1f * ageInTicks / 3.0f))) + (Mth.m_14089_((float)(-1.0f + limbSwing * speed * 0.3f)) * degree * 0.05f * limbSwingAmount + 0.1f) + attackProgress * (float)Math.toRadians(25.0);
            this.Neck.f_104204_ = netHeadYaw * ((float)Math.PI / 180);
            this.LegR.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
            this.LegL.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
            this.ArmL.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
            this.ArmR.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
            this.Tail.f_104204_ = -0.12f * Mth.m_14031_((float)(0.2f * ageInTicks / 5.0f));
            this.Tail.f_104203_ = -Math.abs(-0.05f * Mth.m_14031_((float)(0.1f * ageInTicks / 5.0f))) - 0.25f;
            if (entity.isEating()) {
                this.Neck.f_104203_ = Math.abs(Mth.m_14031_((float)(0.05f * ageInTicks)) * 0.45f) + 0.15f;
            }
            if (entity.m_20069_()) {
                this.Body.f_104201_ = 20.0f;
                this.Body.f_104203_ = -0.125f;
                this.Tail.f_104203_ = 0.0625f;
                this.LegL.f_104203_ = -0.25f * Mth.m_14031_((float)(0.2f * ageInTicks / 1.5f));
                this.LegR.f_104203_ = 0.25f * Mth.m_14031_((float)(0.2f * ageInTicks / 1.5f));
                this.ArmR.f_104203_ = -0.25f * Mth.m_14031_((float)(0.2f * ageInTicks / 1.5f));
                this.ArmL.f_104203_ = 0.25f * Mth.m_14031_((float)(0.2f * ageInTicks / 1.5f));
                this.Neck.f_104203_ = 0.0625f;
                this.Tail.f_104203_ = -Math.abs(-0.05f * Mth.m_14031_((float)(0.1f * ageInTicks / 5.0f))) - 0.25f;
            }
        }
    }

    public void resetModel() {
        this.Body.f_104201_ = 9.0f;
        this.Body.f_104203_ = 0.0f;
        this.Body.f_104205_ = 0.0f;
        this.LegL.f_104200_ = 7.0f;
        this.LegL.f_104203_ = 0.0f;
        this.LegL.f_104205_ = 0.0f;
        this.ArmR.f_104203_ = 0.0f;
        this.LegR.f_104203_ = 0.0f;
        this.Neck.f_104203_ = 0.0f;
        this.Neck.f_104204_ = 0.0f;
        this.Neck.f_104205_ = 0.0f;
        this.Tail.f_104203_ = 0.0f;
        this.Tail.f_104204_ = 0.0f;
        this.Tail.f_104205_ = 0.0f;
        this.ArmL.f_104200_ = 7.0f;
        this.ArmL.f_104203_ = 0.0f;
        this.ArmL.f_104204_ = 0.0f;
        this.ArmL.f_104205_ = 0.0f;
    }

    public void sleepPose() {
        this.Body.f_104201_ = 14.0f;
        this.Body.f_104205_ = -1.5707964f;
        this.LegL.f_104200_ = 10.4f;
        this.LegL.f_104205_ = 0.5235988f;
        this.ArmR.f_104203_ = 0.5235988f;
        this.LegR.f_104203_ = 0.41887903f;
        this.Neck.f_104203_ = 0.5934119f;
        this.Neck.f_104204_ = -0.13962634f;
        this.Neck.f_104205_ = 0.83775806f;
        this.Tail.f_104203_ = -0.2443461f;
        this.Tail.f_104204_ = -0.10471976f;
        this.Tail.f_104205_ = 0.5934119f;
        this.ArmL.f_104200_ = 11.0f;
        this.ArmL.f_104203_ = 0.4537856f;
        this.ArmL.f_104204_ = 0.2443461f;
        this.ArmL.f_104205_ = 0.5235988f;
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.Body.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
    }
}

