/*
 * Decompiled with CFR 0.152.
 */
package superlord.prehistoricfauna.client.model.triassic.ischigualasto;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import superlord.prehistoricfauna.common.entity.DinosaurEntity;
import superlord.prehistoricfauna.common.entity.triassic.ischigualasto.Hyperodapedon;

public class HyperodapedonModel
extends EntityModel<Hyperodapedon> {
    private final ModelPart Body;
    private final ModelPart Head;
    private final ModelPart Tail;
    private final ModelPart RLeg;
    private final ModelPart RArm;
    private final ModelPart LLeg;
    private final ModelPart LArm;

    public HyperodapedonModel(ModelPart root) {
        this.Body = root.m_171324_("Body");
        this.Head = this.Body.m_171324_("Head");
        this.Tail = this.Body.m_171324_("Tail");
        this.RLeg = this.Body.m_171324_("RLeg");
        this.RArm = this.Body.m_171324_("RArm");
        this.LLeg = this.Body.m_171324_("LLeg");
        this.LArm = this.Body.m_171324_("LArm");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition Body = partdefinition.m_171599_("Body", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-2.0f, 0.0f, 0.0f, 4.0f, 3.0f, 10.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)19.0f, (float)-5.0f));
        PartDefinition Head = Body.m_171599_("Head", CubeListBuilder.m_171558_().m_171514_(0, 13).m_171488_(-2.5f, -1.5f, -3.0f, 5.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)1.5f, (float)0.0f));
        PartDefinition Snout = Head.m_171599_("Snout", CubeListBuilder.m_171558_().m_171514_(0, 19).m_171488_(-2.5f, -0.5f, 0.0f, 3.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)1.0f, (float)0.0f, (float)-4.0f));
        PartDefinition RArm = Body.m_171599_("RArm", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171480_().m_171488_(-2.0f, -1.0f, -1.0f, 2.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)-1.0f, (float)3.0f, (float)1.01f));
        PartDefinition LArm = Body.m_171599_("LArm", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(0.0f, -1.0f, -1.0f, 2.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)1.0f, (float)3.0f, (float)1.01f));
        PartDefinition RLeg = Body.m_171599_("RLeg", CubeListBuilder.m_171558_().m_171514_(18, 0).m_171480_().m_171488_(-2.0f, -1.0f, -1.0f, 2.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)-1.0f, (float)2.0f, (float)8.0f));
        PartDefinition LLeg = Body.m_171599_("LLeg", CubeListBuilder.m_171558_().m_171514_(18, 0).m_171488_(0.0f, -1.0f, -1.0f, 2.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)1.0f, (float)2.0f, (float)8.0f));
        PartDefinition Tail = Body.m_171599_("Tail", CubeListBuilder.m_171558_().m_171514_(19, 0).m_171488_(-1.0f, -1.0f, 0.0f, 2.0f, 2.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)2.0f, (float)10.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)32);
    }

    public void setupAnim(Hyperodapedon entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        float partialTick = ageInTicks - (float)entity.f_19797_;
        float sleepProgress = entity.getSleepProgress(partialTick);
        this.resetModel();
        if (entity.isAsleep()) {
            if (sleepProgress != 0.0f && (Integer)entity.m_20088_().m_135370_(DinosaurEntity.SLEEP_TICK) > 0) {
                this.Body.f_104200_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)0.1f);
                this.Body.f_104201_ = Mth.m_14179_((float)sleepProgress, (float)19.0f, (float)21.0f);
                this.Body.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-0.03647738f);
                this.Body.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-0.03647738f);
                this.Body.f_104205_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-0.83950335f);
                this.RLeg.f_104200_ = Mth.m_14179_((float)sleepProgress, (float)-1.0f, (float)-1.4f);
                this.RLeg.f_104201_ = Mth.m_14179_((float)sleepProgress, (float)2.0f, (float)1.3f);
                this.RLeg.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-0.07295476f);
                this.RLeg.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)0.03647738f);
                this.RLeg.f_104205_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-0.7665486f);
                this.Head.f_104201_ = Mth.m_14179_((float)sleepProgress, (float)1.5f, (float)1.6f);
                this.Head.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)0.25569072f);
                this.Head.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-0.36459926f);
                this.Head.f_104205_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)0.6932448f);
                this.LArm.f_104200_ = Mth.m_14179_((float)sleepProgress, (float)1.0f, (float)0.7f);
                this.LArm.f_104202_ = Mth.m_14179_((float)sleepProgress, (float)1.01f, (float)2.41f);
                this.LArm.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)0.109432146f);
                this.LArm.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)0.07120943f);
                this.LArm.f_104205_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)0.3647738f);
                this.RArm.f_104201_ = Mth.m_14179_((float)sleepProgress, (float)3.0f, (float)1.4f);
                this.RArm.f_104202_ = Mth.m_14179_((float)sleepProgress, (float)1.01f, (float)0.71f);
                this.RArm.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-0.18256144f);
                this.RArm.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-0.109781206f);
                this.RArm.f_104205_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-0.62029004f);
                this.Tail.f_104201_ = Mth.m_14179_((float)sleepProgress, (float)2.0f, (float)0.9f);
                this.Tail.f_104202_ = Mth.m_14179_((float)sleepProgress, (float)10.0f, (float)9.7f);
                this.Tail.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-0.14590952f);
                this.Tail.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)0.9482374f);
                this.Tail.f_104205_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)0.80320054f);
                this.LLeg.f_104201_ = Mth.m_14179_((float)sleepProgress, (float)2.0f, (float)3.1f);
                this.LArm.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)0.5836381f);
            } else {
                this.sleepPose();
            }
        } else if (sleepProgress != 0.0f && (Integer)entity.m_20088_().m_135370_(DinosaurEntity.SLEEP_TICK) > 0) {
            this.Body.f_104200_ = Mth.m_14179_((float)sleepProgress, (float)0.1f, (float)0.0f);
            this.Body.f_104201_ = Mth.m_14179_((float)sleepProgress, (float)21.0f, (float)19.0f);
            this.Body.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)-0.03647738f, (float)0.0f);
            this.Body.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)-0.03647738f, (float)0.0f);
            this.Body.f_104205_ = Mth.m_14179_((float)sleepProgress, (float)-0.83950335f, (float)0.0f);
            this.RLeg.f_104200_ = Mth.m_14179_((float)sleepProgress, (float)-1.4f, (float)-1.0f);
            this.RLeg.f_104201_ = Mth.m_14179_((float)sleepProgress, (float)1.3f, (float)2.0f);
            this.RLeg.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)-0.07295476f, (float)0.0f);
            this.RLeg.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)0.03647738f, (float)0.0f);
            this.RLeg.f_104205_ = Mth.m_14179_((float)sleepProgress, (float)-0.7665486f, (float)0.0f);
            this.Head.f_104201_ = Mth.m_14179_((float)sleepProgress, (float)1.6f, (float)1.5f);
            this.Head.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.25569072f, (float)0.0f);
            this.Head.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)-0.36459926f, (float)0.0f);
            this.Head.f_104205_ = Mth.m_14179_((float)sleepProgress, (float)0.6932448f, (float)0.0f);
            this.LArm.f_104200_ = Mth.m_14179_((float)sleepProgress, (float)0.7f, (float)1.0f);
            this.LArm.f_104202_ = Mth.m_14179_((float)sleepProgress, (float)2.41f, (float)1.01f);
            this.LArm.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.109432146f, (float)0.0f);
            this.LArm.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)0.07120943f, (float)0.0f);
            this.LArm.f_104205_ = Mth.m_14179_((float)sleepProgress, (float)0.3647738f, (float)0.0f);
            this.RArm.f_104201_ = Mth.m_14179_((float)sleepProgress, (float)1.4f, (float)3.0f);
            this.RArm.f_104202_ = Mth.m_14179_((float)sleepProgress, (float)0.71f, (float)1.01f);
            this.RArm.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)-0.18256144f, (float)0.0f);
            this.RArm.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)-0.109781206f, (float)0.0f);
            this.RArm.f_104205_ = Mth.m_14179_((float)sleepProgress, (float)-0.62029004f, (float)0.0f);
            this.Tail.f_104201_ = Mth.m_14179_((float)sleepProgress, (float)0.9f, (float)2.0f);
            this.Tail.f_104202_ = Mth.m_14179_((float)sleepProgress, (float)9.7f, (float)10.0f);
            this.Tail.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)-0.14590952f, (float)0.0f);
            this.Tail.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)0.9482374f, (float)0.0f);
            this.Tail.f_104205_ = Mth.m_14179_((float)sleepProgress, (float)0.80320054f, (float)0.0f);
            this.LLeg.f_104201_ = Mth.m_14179_((float)sleepProgress, (float)3.1f, (float)2.0f);
            this.LArm.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.5836381f, (float)0.0f);
        } else {
            this.Head.f_104203_ = headPitch * ((float)Math.PI / 180);
            this.Head.f_104204_ = netHeadYaw * ((float)Math.PI / 180);
            this.LLeg.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
            this.RLeg.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
            this.LArm.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
            this.RArm.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
            if (entity.isEating()) {
                this.Head.f_104203_ = Math.abs(Mth.m_14031_((float)(0.05f * ageInTicks)) * 0.45f) + 0.15f;
            }
            if (entity.m_20069_()) {
                this.RLeg.f_104203_ = 0.25f * Mth.m_14031_((float)(0.15f * ageInTicks / 1.5f));
                this.LLeg.f_104203_ = 0.25f * Mth.m_14031_((float)(0.15f * ageInTicks / 1.5f));
                this.LArm.f_104203_ = -0.25f * Mth.m_14031_((float)(0.15f * ageInTicks / 1.5f));
                this.RArm.f_104203_ = -0.25f * Mth.m_14031_((float)(0.15f * ageInTicks / 1.5f));
                this.Tail.f_104204_ = Mth.m_14089_((float)(limbSwing * 2.6662f)) * 1.4f * limbSwingAmount + 0.0625f * Mth.m_14031_((float)(0.15f * ageInTicks / 1.5f));
            }
        }
    }

    public void resetModel() {
        this.Body.f_104200_ = 0.0f;
        this.Body.f_104201_ = 19.0f;
        this.Body.f_104203_ = 0.0f;
        this.Body.f_104204_ = 0.0f;
        this.Body.f_104205_ = 0.0f;
        this.RLeg.f_104200_ = -1.0f;
        this.RLeg.f_104201_ = 2.0f;
        this.RLeg.f_104203_ = 0.0f;
        this.RLeg.f_104204_ = 0.0f;
        this.RLeg.f_104205_ = 0.0f;
        this.Head.f_104201_ = 1.5f;
        this.Head.f_104203_ = 0.0f;
        this.Head.f_104204_ = 0.0f;
        this.Head.f_104205_ = 0.0f;
        this.LArm.f_104200_ = 1.0f;
        this.LArm.f_104202_ = 1.01f;
        this.LArm.f_104203_ = 0.0f;
        this.LArm.f_104204_ = 0.0f;
        this.LArm.f_104205_ = 0.0f;
        this.RArm.f_104201_ = 3.0f;
        this.RArm.f_104202_ = 1.01f;
        this.RArm.f_104203_ = 0.0f;
        this.RArm.f_104204_ = 0.0f;
        this.RArm.f_104205_ = 0.0f;
        this.Tail.f_104201_ = 2.0f;
        this.Tail.f_104202_ = 10.0f;
        this.Tail.f_104203_ = 0.0f;
        this.Tail.f_104204_ = 0.0f;
        this.Tail.f_104205_ = 0.0f;
        this.LLeg.f_104201_ = 2.0f;
        this.LArm.f_104203_ = 0.0f;
    }

    public void sleepPose() {
        this.Body.f_104200_ = 0.1f;
        this.Body.f_104201_ = 21.0f;
        this.Body.f_104203_ = -0.03647738f;
        this.Body.f_104204_ = -0.03647738f;
        this.Body.f_104205_ = -0.83950335f;
        this.RLeg.f_104200_ = -1.4f;
        this.RLeg.f_104201_ = 1.3f;
        this.RLeg.f_104203_ = -0.07295476f;
        this.RLeg.f_104204_ = 0.03647738f;
        this.RLeg.f_104205_ = -0.7665486f;
        this.Head.f_104201_ = 1.6f;
        this.Head.f_104203_ = 0.25569072f;
        this.Head.f_104204_ = -0.36459926f;
        this.Head.f_104205_ = 0.6932448f;
        this.LArm.f_104200_ = 0.7f;
        this.LArm.f_104202_ = 2.41f;
        this.LArm.f_104203_ = 0.109432146f;
        this.LArm.f_104204_ = 0.07120943f;
        this.LArm.f_104205_ = 0.3647738f;
        this.RArm.f_104201_ = 1.4f;
        this.RArm.f_104202_ = 0.71f;
        this.RArm.f_104203_ = -0.18256144f;
        this.RArm.f_104204_ = -0.109781206f;
        this.RArm.f_104205_ = -0.62029004f;
        this.Tail.f_104201_ = 0.9f;
        this.Tail.f_104202_ = 9.7f;
        this.Tail.f_104203_ = -0.14590952f;
        this.Tail.f_104204_ = 0.9482374f;
        this.Tail.f_104205_ = 0.80320054f;
        this.LLeg.f_104201_ = 3.1f;
        this.LArm.f_104203_ = 0.5836381f;
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.Body.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
    }
}

