/*
 * Decompiled with CFR 0.152.
 */
package superlord.prehistoricfauna.client.model.triassic.ischigualasto;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import superlord.prehistoricfauna.common.entity.DinosaurEntity;
import superlord.prehistoricfauna.common.entity.triassic.ischigualasto.Exaeretodon;

public class ExaeretodonModel
extends EntityModel<Exaeretodon> {
    private final ModelPart Body;
    private final ModelPart Tail;
    private final ModelPart Head;
    private final ModelPart LeftFrontLeg;
    private final ModelPart RightFrontLeg;
    private final ModelPart LeftBackLeg;
    private final ModelPart RightBackLeg;

    public ExaeretodonModel(ModelPart root) {
        this.Body = root.m_171324_("Body");
        this.Tail = this.Body.m_171324_("Tail");
        this.Head = this.Body.m_171324_("Head");
        this.LeftFrontLeg = this.Body.m_171324_("LeftFrontLeg");
        this.LeftBackLeg = this.Body.m_171324_("LeftBackLeg");
        this.RightBackLeg = this.Body.m_171324_("RightBackLeg");
        this.RightFrontLeg = this.Body.m_171324_("RightFrontLeg");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition Body = partdefinition.m_171599_("Body", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-4.0f, -6.0f, -2.0f, 8.0f, 6.0f, 12.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)21.0f, (float)-4.0f));
        PartDefinition LeftBackLeg = Body.m_171599_("LeftBackLeg", CubeListBuilder.m_171558_().m_171514_(28, 0).m_171480_().m_171488_(-3.0f, -1.5f, -1.51f, 3.0f, 6.0f, 3.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)-3.0f, (float)-1.5f, (float)8.5f));
        PartDefinition LeftFrontLeg = Body.m_171599_("LeftFrontLeg", CubeListBuilder.m_171558_().m_171514_(30, 18).m_171480_().m_171488_(-3.0f, -1.5f, -1.51f, 3.0f, 5.0f, 3.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)-3.0f, (float)-0.5f, (float)-0.5f));
        PartDefinition Head = Body.m_171599_("Head", CubeListBuilder.m_171558_().m_171514_(0, 18).m_171488_(-2.5f, -3.0f, -6.0f, 5.0f, 4.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-3.0f, (float)-2.0f));
        PartDefinition Snoot = Head.m_171599_("Snoot", CubeListBuilder.m_171558_().m_171514_(0, 28).m_171488_(-1.5f, -3.0f, -4.0f, 3.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)-6.0f));
        PartDefinition RightFrontLeg = Body.m_171599_("RightFrontLeg", CubeListBuilder.m_171558_().m_171514_(30, 18).m_171488_(0.0f, -1.5f, -1.51f, 3.0f, 5.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)3.0f, (float)-0.5f, (float)-0.5f));
        PartDefinition RightBackLeg = Body.m_171599_("RightBackLeg", CubeListBuilder.m_171558_().m_171514_(28, 0).m_171488_(0.0f, -1.5f, -1.51f, 3.0f, 6.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)3.0f, (float)-1.5f, (float)8.5f));
        PartDefinition Tail = Body.m_171599_("Tail", CubeListBuilder.m_171558_().m_171514_(16, 22).m_171488_(-2.0f, 0.0f, 0.0f, 4.0f, 3.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-5.0f, (float)10.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)48, (int)48);
    }

    public void setupAnim(Exaeretodon entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        float partialTick = ageInTicks - (float)entity.f_19797_;
        float sleepProgress = entity.getSleepProgress(partialTick);
        this.resetModel();
        if (entity.isAsleep()) {
            if (sleepProgress != 0.0f && (Integer)entity.m_20088_().m_135370_(DinosaurEntity.SLEEP_TICK) > 0) {
                this.LeftBackLeg.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)1.6816247f);
                this.LeftBackLeg.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-0.4012512f);
                this.Tail.f_104202_ = Mth.m_14179_((float)sleepProgress, (float)10.0f, (float)9.1f);
                this.Tail.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-0.07295476f);
                this.Tail.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)0.3647738f);
                this.Tail.f_104205_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)0.019024089f);
                this.Head.f_104201_ = Mth.m_14179_((float)sleepProgress, (float)-3.0f, (float)-2.6f);
                this.Head.f_104202_ = Mth.m_14179_((float)sleepProgress, (float)-2.0f, (float)0.0f);
                this.Head.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)0.32847095f);
                this.Head.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-0.40194935f);
                this.Head.f_104205_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-0.29181904f);
                this.Body.f_104201_ = Mth.m_14179_((float)sleepProgress, (float)21.0f, (float)23.6f);
                this.Body.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-0.14590952f);
                this.LeftFrontLeg.f_104200_ = Mth.m_14179_((float)sleepProgress, (float)-3.0f, (float)-2.6f);
                this.LeftFrontLeg.f_104201_ = Mth.m_14179_((float)sleepProgress, (float)-0.5f, (float)-0.1f);
                this.LeftFrontLeg.f_104202_ = Mth.m_14179_((float)sleepProgress, (float)-0.5f, (float)-0.6f);
                this.LeftFrontLeg.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-1.3144075f);
                this.LeftFrontLeg.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-1.1299261f);
                this.LeftFrontLeg.f_104205_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-0.25569072f);
                this.RightBackLeg.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)1.6057029f);
                this.RightBackLeg.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)0.29181904f);
                this.RightFrontLeg.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-0.80302596f);
                this.RightFrontLeg.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)1.1311479f);
                this.RightFrontLeg.f_104205_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)0.62011546f);
            } else {
                this.sleepPose();
            }
        } else if (sleepProgress != 0.0f && (Integer)entity.m_20088_().m_135370_(DinosaurEntity.SLEEP_TICK) > 0) {
            this.LeftBackLeg.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)1.6816247f, (float)0.0f);
            this.LeftBackLeg.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)-0.4012512f, (float)0.0f);
            this.Tail.f_104202_ = Mth.m_14179_((float)sleepProgress, (float)9.1f, (float)10.0f);
            this.Tail.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)-0.07295476f, (float)0.0f);
            this.Tail.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)0.3647738f, (float)0.0f);
            this.Tail.f_104205_ = Mth.m_14179_((float)sleepProgress, (float)0.019024089f, (float)0.0f);
            this.Head.f_104201_ = Mth.m_14179_((float)sleepProgress, (float)-2.6f, (float)-3.0f);
            this.Head.f_104202_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-2.0f);
            this.Head.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.32847095f, (float)0.0f);
            this.Head.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)-0.40194935f, (float)0.0f);
            this.Head.f_104205_ = Mth.m_14179_((float)sleepProgress, (float)-0.29181904f, (float)0.0f);
            this.Body.f_104201_ = Mth.m_14179_((float)sleepProgress, (float)23.6f, (float)21.0f);
            this.Body.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)-0.14590952f, (float)0.0f);
            this.LeftFrontLeg.f_104200_ = Mth.m_14179_((float)sleepProgress, (float)-2.6f, (float)-3.0f);
            this.LeftFrontLeg.f_104201_ = Mth.m_14179_((float)sleepProgress, (float)-0.1f, (float)-0.5f);
            this.LeftFrontLeg.f_104202_ = Mth.m_14179_((float)sleepProgress, (float)-0.6f, (float)-0.5f);
            this.LeftFrontLeg.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)-1.3144075f, (float)0.0f);
            this.LeftFrontLeg.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)-1.1299261f, (float)0.0f);
            this.LeftFrontLeg.f_104205_ = Mth.m_14179_((float)sleepProgress, (float)-0.25569072f, (float)0.0f);
            this.RightBackLeg.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)1.6057029f, (float)0.0f);
            this.RightBackLeg.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)0.29181904f, (float)0.0f);
            this.RightFrontLeg.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)-0.80302596f, (float)0.0f);
            this.RightFrontLeg.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)1.1311479f, (float)0.0f);
            this.RightFrontLeg.f_104205_ = Mth.m_14179_((float)sleepProgress, (float)0.62011546f, (float)0.0f);
        } else {
            this.Head.f_104203_ = headPitch * ((float)Math.PI / 180);
            this.Head.f_104204_ = netHeadYaw * ((float)Math.PI / 180);
            this.LeftBackLeg.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
            this.RightBackLeg.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
            this.LeftFrontLeg.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
            this.RightFrontLeg.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
            if (entity.isEating()) {
                this.Head.f_104203_ = Math.abs(Mth.m_14031_((float)(0.05f * ageInTicks)) * 0.45f) + 0.15f;
            }
            if (entity.m_20069_()) {
                this.LeftFrontLeg.f_104203_ = 0.25f * Mth.m_14031_((float)(0.15f * ageInTicks / 1.5f));
                this.RightFrontLeg.f_104203_ = -0.25f * Mth.m_14031_((float)(0.15f * ageInTicks / 1.5f));
                this.LeftBackLeg.f_104203_ = -0.25f * Mth.m_14031_((float)(0.15f * ageInTicks / 1.5f));
                this.RightBackLeg.f_104203_ = 0.25f * Mth.m_14031_((float)(0.15f * ageInTicks / 1.5f));
                this.Tail.f_104203_ = Mth.m_14089_((float)(limbSwing * 2.6662f)) * 1.4f * limbSwingAmount + 0.25f * Mth.m_14031_((float)(0.15f * ageInTicks / 1.5f));
            }
        }
    }

    public void resetModel() {
        this.LeftBackLeg.f_104203_ = 0.0f;
        this.LeftBackLeg.f_104204_ = 0.0f;
        this.Tail.f_104202_ = 10.0f;
        this.Tail.f_104203_ = 0.0f;
        this.Tail.f_104204_ = 0.0f;
        this.Tail.f_104205_ = 0.0f;
        this.Head.f_104201_ = -3.0f;
        this.Head.f_104202_ = -2.0f;
        this.Head.f_104203_ = 0.0f;
        this.Head.f_104204_ = 0.0f;
        this.Head.f_104205_ = 0.0f;
        this.Body.f_104201_ = 21.0f;
        this.Body.f_104203_ = 0.0f;
        this.LeftFrontLeg.f_104200_ = -3.0f;
        this.LeftFrontLeg.f_104201_ = -0.5f;
        this.LeftFrontLeg.f_104202_ = -0.5f;
        this.LeftFrontLeg.f_104203_ = 0.0f;
        this.LeftFrontLeg.f_104204_ = 0.0f;
        this.LeftFrontLeg.f_104205_ = 0.0f;
        this.RightBackLeg.f_104203_ = 0.0f;
        this.RightBackLeg.f_104204_ = 0.0f;
        this.RightFrontLeg.f_104203_ = 0.0f;
        this.RightFrontLeg.f_104204_ = 0.0f;
        this.RightFrontLeg.f_104205_ = 0.0f;
    }

    public void sleepPose() {
        this.LeftBackLeg.f_104203_ = 1.6816247f;
        this.LeftBackLeg.f_104204_ = -0.4012512f;
        this.Tail.f_104202_ = 9.1f;
        this.Tail.f_104203_ = -0.07295476f;
        this.Tail.f_104204_ = 0.3647738f;
        this.Tail.f_104205_ = 0.019024089f;
        this.Head.f_104201_ = -2.6f;
        this.Head.f_104202_ = 0.0f;
        this.Head.f_104203_ = 0.32847095f;
        this.Head.f_104204_ = -0.40194935f;
        this.Head.f_104205_ = -0.29181904f;
        this.Body.f_104201_ = 23.6f;
        this.Body.f_104203_ = -0.14590952f;
        this.LeftFrontLeg.f_104200_ = -2.6f;
        this.LeftFrontLeg.f_104201_ = -0.1f;
        this.LeftFrontLeg.f_104202_ = -0.6f;
        this.LeftFrontLeg.f_104203_ = -1.3144075f;
        this.LeftFrontLeg.f_104204_ = -1.1299261f;
        this.LeftFrontLeg.f_104205_ = -0.25569072f;
        this.RightBackLeg.f_104203_ = 1.6057029f;
        this.RightBackLeg.f_104204_ = 0.29181904f;
        this.RightFrontLeg.f_104203_ = -0.80302596f;
        this.RightFrontLeg.f_104204_ = 1.1311479f;
        this.RightFrontLeg.f_104205_ = 0.62011546f;
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.Body.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
    }
}

