/*
 * Decompiled with CFR 0.152.
 */
package superlord.prehistoricfauna.client.model.triassic.chinle;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import superlord.prehistoricfauna.common.entity.DinosaurEntity;
import superlord.prehistoricfauna.common.entity.triassic.chinle.Trilophosaurus;

public class TrilophosaurusModel
extends EntityModel<Trilophosaurus> {
    private final ModelPart RightArm;
    private final ModelPart RightHand;
    private final ModelPart LeftLeg;
    private final ModelPart LeftFoot;
    private final ModelPart LeftArm;
    private final ModelPart LeftHand;
    private final ModelPart RightLeg;
    private final ModelPart RightFoot;
    private final ModelPart Body;
    private final ModelPart Neck;
    private final ModelPart TailBase;
    private final ModelPart TailEnd;

    public TrilophosaurusModel(ModelPart root) {
        this.RightArm = root.m_171324_("RightArm");
        this.RightHand = this.RightArm.m_171324_("RightHand");
        this.LeftLeg = root.m_171324_("LeftLeg");
        this.LeftFoot = this.LeftLeg.m_171324_("LeftFoot");
        this.LeftArm = root.m_171324_("LeftArm");
        this.LeftHand = this.LeftArm.m_171324_("LeftHand");
        this.RightLeg = root.m_171324_("RightLeg");
        this.RightFoot = this.RightLeg.m_171324_("RightFoot");
        this.Body = root.m_171324_("Body");
        this.Neck = this.Body.m_171324_("Neck");
        this.TailBase = this.Body.m_171324_("TailBase");
        this.TailEnd = this.TailBase.m_171324_("TailEnd");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition RightArm = partdefinition.m_171599_("RightArm", CubeListBuilder.m_171558_().m_171514_(0, 10).m_171488_(-1.0f, -2.0f, -1.5f, 2.0f, 5.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)3.0f, (float)20.99f, (float)-4.0f));
        PartDefinition RightHand = RightArm.m_171599_("RightHand", CubeListBuilder.m_171558_().m_171514_(53, 27).m_171488_(-1.5f, 0.0f, -2.0f, 3.0f, 0.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)1.0f, (float)3.01f, (float)-1.0f));
        PartDefinition LeftLeg = partdefinition.m_171599_("LeftLeg", CubeListBuilder.m_171558_().m_171514_(0, 18).m_171480_().m_171488_(-1.0f, -2.0f, -1.5f, 2.0f, 6.0f, 3.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)-3.0f, (float)19.99f, (float)6.5f));
        PartDefinition LeftFoot = LeftLeg.m_171599_("LeftFoot", CubeListBuilder.m_171558_().m_171514_(52, 16).m_171488_(-1.5f, 0.0f, -2.5f, 3.0f, 0.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-1.0f, (float)4.01f, (float)-2.0f));
        PartDefinition LeftArm = partdefinition.m_171599_("LeftArm", CubeListBuilder.m_171558_().m_171514_(0, 10).m_171480_().m_171488_(-1.0f, -2.0f, -1.5f, 2.0f, 5.0f, 3.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)-3.0f, (float)20.89f, (float)-4.0f));
        PartDefinition LeftHand = LeftArm.m_171599_("LeftHand", CubeListBuilder.m_171558_().m_171514_(53, 27).m_171488_(-1.5f, 0.0f, -2.0f, 3.0f, 0.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-1.0f, (float)3.01f, (float)-1.0f));
        PartDefinition RightLeg = partdefinition.m_171599_("RightLeg", CubeListBuilder.m_171558_().m_171514_(0, 18).m_171488_(-1.0f, -2.0f, -1.5f, 2.0f, 6.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)3.0f, (float)19.99f, (float)6.5f));
        PartDefinition RightFoot = RightLeg.m_171599_("RightFoot", CubeListBuilder.m_171558_().m_171514_(52, 16).m_171488_(-1.5f, 0.0f, -2.5f, 3.0f, 0.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)1.0f, (float)4.01f, (float)-2.0f));
        PartDefinition Body = partdefinition.m_171599_("Body", CubeListBuilder.m_171558_().m_171514_(14, 0).m_171488_(-2.0f, -2.0f, -2.0f, 4.0f, 5.0f, 14.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)18.0f, (float)-4.0f));
        PartDefinition Neck = Body.m_171599_("Neck", CubeListBuilder.m_171558_().m_171514_(10, 0).m_171488_(-1.0f, -5.0f, -4.0f, 2.0f, 7.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition Head = Neck.m_171599_("Head", CubeListBuilder.m_171558_().m_171514_(0, 5).m_171488_(-1.5f, -2.0f, -2.0f, 3.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-2.9f, (float)-3.0f));
        PartDefinition Snoot = Head.m_171599_("Snoot", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-1.0f, -2.0f, -2.0f, 2.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)-2.0f));
        PartDefinition TailBase = Body.m_171599_("TailBase", CubeListBuilder.m_171558_().m_171514_(38, 0).m_171488_(-1.5f, -2.0f, 0.0f, 3.0f, 4.0f, 10.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.2f, (float)11.0f));
        PartDefinition TailEnd = TailBase.m_171599_("TailEnd", CubeListBuilder.m_171558_().m_171514_(12, 19).m_171488_(-1.0f, -1.0f, 0.0f, 2.0f, 2.0f, 24.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-0.01f, (float)9.3f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void setupAnim(Trilophosaurus entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        float partialTick = ageInTicks - (float)entity.f_19797_;
        float sleepProgress = entity.getSleepProgress(partialTick);
        this.resetModel();
        if (entity.isAsleep()) {
            if (sleepProgress != 0.0f && (Integer)entity.m_20088_().m_135370_(DinosaurEntity.SLEEP_TICK) > 0) {
                this.Neck.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)0.70371675f);
                this.Neck.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-0.4691445f);
                this.RightFoot.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-0.11728612f);
                this.RightFoot.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)0.039095376f);
                this.RightFoot.f_104205_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)1.251052f);
                this.RightHand.f_104205_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)1.3688618f);
                this.LeftHand.f_104205_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-1.3683381f);
                this.Body.f_104201_ = Mth.m_14179_((float)sleepProgress, (float)18.0f, (float)21.0f);
                this.RightArm.f_104201_ = Mth.m_14179_((float)sleepProgress, (float)20.89f, (float)23.89f);
                this.RightArm.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-0.4691445f);
                this.RightArm.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)0.1563815f);
                this.RightArm.f_104205_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-1.3683381f);
                this.TailBase.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)-0.27366763f, (float)-0.11728612f);
                this.TailBase.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)0.4691445f);
                this.RightLeg.f_104201_ = Mth.m_14179_((float)sleepProgress, (float)19.99f, (float)22.99f);
                this.RightLeg.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)0.35185838f);
                this.RightLeg.f_104205_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-1.1728612f);
                this.TailEnd.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.11728612f, (float)0.07819075f);
                this.TailEnd.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)0.39095375f);
                this.LeftLeg.f_104201_ = Mth.m_14179_((float)sleepProgress, (float)19.99f, (float)22.99f);
                this.LeftLeg.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)0.35185838f);
                this.LeftLeg.f_104205_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)1.1728612f);
                this.LeftArm.f_104201_ = Mth.m_14179_((float)sleepProgress, (float)20.99f, (float)22.99f);
                this.LeftArm.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-0.4691445f);
                this.LeftArm.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-0.1563815f);
                this.LeftArm.f_104205_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)1.3683381f);
                this.LeftFoot.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-0.11728612f);
                this.LeftFoot.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)0.039095376f);
                this.LeftFoot.f_104205_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-1.251052f);
            } else {
                this.sleepPose();
            }
        } else if (sleepProgress != 0.0f && (Integer)entity.m_20088_().m_135370_(DinosaurEntity.SLEEP_TICK) > 0) {
            this.Neck.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.70371675f, (float)0.0f);
            this.Neck.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)-0.4691445f, (float)0.0f);
            this.RightFoot.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)-0.11728612f, (float)0.0f);
            this.RightFoot.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)0.039095376f, (float)0.0f);
            this.RightFoot.f_104205_ = Mth.m_14179_((float)sleepProgress, (float)1.251052f, (float)0.0f);
            this.RightHand.f_104205_ = Mth.m_14179_((float)sleepProgress, (float)1.3688618f, (float)0.0f);
            this.LeftHand.f_104205_ = Mth.m_14179_((float)sleepProgress, (float)-1.3683381f, (float)0.0f);
            this.Body.f_104201_ = Mth.m_14179_((float)sleepProgress, (float)21.0f, (float)18.0f);
            this.RightArm.f_104201_ = Mth.m_14179_((float)sleepProgress, (float)23.89f, (float)20.89f);
            this.RightArm.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)-0.4691445f, (float)0.0f);
            this.RightArm.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)0.1563815f, (float)0.0f);
            this.RightArm.f_104205_ = Mth.m_14179_((float)sleepProgress, (float)-1.3683381f, (float)0.0f);
            this.TailBase.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)-0.11728612f, (float)-0.27366763f);
            this.TailBase.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)0.4691445f, (float)0.0f);
            this.RightLeg.f_104201_ = Mth.m_14179_((float)sleepProgress, (float)22.99f, (float)19.99f);
            this.RightLeg.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.35185838f, (float)0.0f);
            this.RightLeg.f_104205_ = Mth.m_14179_((float)sleepProgress, (float)-1.1728612f, (float)0.0f);
            this.TailEnd.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.07819075f, (float)0.11728612f);
            this.TailEnd.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)0.39095375f, (float)0.0f);
            this.LeftLeg.f_104201_ = Mth.m_14179_((float)sleepProgress, (float)22.99f, (float)19.99f);
            this.LeftLeg.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.35185838f, (float)0.0f);
            this.LeftLeg.f_104205_ = Mth.m_14179_((float)sleepProgress, (float)1.1728612f, (float)0.0f);
            this.LeftArm.f_104201_ = Mth.m_14179_((float)sleepProgress, (float)22.99f, (float)20.99f);
            this.LeftArm.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)-0.4691445f, (float)0.0f);
            this.LeftArm.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)-0.1563815f, (float)0.0f);
            this.LeftArm.f_104205_ = Mth.m_14179_((float)sleepProgress, (float)1.3683381f, (float)0.0f);
            this.LeftFoot.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)-0.11728612f, (float)0.0f);
            this.LeftFoot.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)0.039095376f, (float)0.0f);
            this.LeftFoot.f_104205_ = Mth.m_14179_((float)sleepProgress, (float)-1.251052f, (float)0.0f);
        } else {
            this.LeftLeg.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
            this.RightLeg.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
            this.TailBase.f_104204_ = -0.12f * Mth.m_14031_((float)(0.2f * ageInTicks / 5.0f));
            this.TailEnd.f_104204_ = -0.12f * Mth.m_14031_((float)(0.2f * ageInTicks / 5.0f));
            this.TailBase.f_104203_ = -Math.abs(-0.05f * Mth.m_14031_((float)(0.1f * ageInTicks / 5.0f)));
            this.TailEnd.f_104203_ = -Math.abs(-0.05f * Mth.m_14031_((float)(0.1f * ageInTicks / 5.0f)));
            this.Neck.f_104203_ = headPitch * ((float)Math.PI / 180) + Math.abs(-0.025f * Mth.m_14031_((float)(0.1f * ageInTicks / 3.0f)));
            this.RightArm.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
            this.LeftArm.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
            this.Neck.f_104204_ = netHeadYaw * ((float)Math.PI / 180);
            if (entity.isEating()) {
                this.Neck.f_104203_ = Math.abs(Mth.m_14031_((float)(0.05f * ageInTicks)) * 0.75f) + 0.5f;
            }
            if (entity.m_20069_()) {
                this.RightArm.f_104203_ = 1.25f;
                this.RightArm.f_104204_ = 0.25f;
                this.LeftArm.f_104203_ = 1.25f;
                this.LeftArm.f_104204_ = -0.25f;
                this.LeftLeg.f_104203_ = 1.25f;
                this.LeftLeg.f_104204_ = -0.25f + 0.25f * Mth.m_14031_((float)(0.25f * ageInTicks / 1.0f));
                this.RightLeg.f_104203_ = 1.25f;
                this.RightLeg.f_104204_ = 0.25f + 0.25f * Mth.m_14031_((float)(0.25f * ageInTicks / 1.0f));
                this.TailBase.f_104204_ = 0.25f * Mth.m_14031_((float)(0.25f * ageInTicks / 1.0f));
                this.TailEnd.f_104204_ = 0.25f * Mth.m_14031_((float)(0.25f * ageInTicks / 1.0f));
                this.RightHand.f_104205_ = 1.3688618f;
                this.LeftHand.f_104205_ = -1.3683381f;
                this.RightFoot.f_104203_ = -0.11728612f;
                this.RightFoot.f_104204_ = 0.039095376f;
                this.RightFoot.f_104205_ = 1.251052f;
                this.LeftFoot.f_104203_ = -0.11728612f;
                this.LeftFoot.f_104204_ = 0.039095376f;
                this.LeftFoot.f_104205_ = -1.251052f;
            }
        }
    }

    public void resetModel() {
        this.Neck.f_104203_ = 0.0f;
        this.Neck.f_104204_ = 0.0f;
        this.RightFoot.f_104203_ = 0.0f;
        this.RightFoot.f_104204_ = 0.0f;
        this.RightFoot.f_104205_ = 0.0f;
        this.RightHand.f_104205_ = 0.0f;
        this.LeftHand.f_104205_ = 0.0f;
        this.Body.f_104201_ = 18.0f;
        this.RightArm.f_104201_ = 20.89f;
        this.RightArm.f_104203_ = 0.0f;
        this.RightArm.f_104204_ = 0.0f;
        this.RightArm.f_104205_ = 0.0f;
        this.TailBase.f_104203_ = -0.27366763f;
        this.TailBase.f_104204_ = 0.0f;
        this.RightLeg.f_104201_ = 19.99f;
        this.RightLeg.f_104203_ = 0.0f;
        this.RightLeg.f_104204_ = 0.0f;
        this.RightLeg.f_104205_ = 0.0f;
        this.TailEnd.f_104203_ = 0.11728612f;
        this.TailEnd.f_104204_ = 0.0f;
        this.LeftLeg.f_104201_ = 19.99f;
        this.LeftLeg.f_104203_ = 0.0f;
        this.LeftLeg.f_104204_ = 0.0f;
        this.LeftLeg.f_104205_ = 0.0f;
        this.LeftArm.f_104201_ = 20.99f;
        this.LeftArm.f_104203_ = 0.0f;
        this.LeftArm.f_104204_ = 0.0f;
        this.LeftArm.f_104205_ = 0.0f;
        this.LeftFoot.f_104203_ = 0.0f;
        this.LeftFoot.f_104204_ = 0.0f;
        this.LeftFoot.f_104205_ = 0.0f;
    }

    public void sleepPose() {
        this.Neck.f_104203_ = 0.70371675f;
        this.Neck.f_104204_ = -0.4691445f;
        this.RightFoot.f_104203_ = -0.11728612f;
        this.RightFoot.f_104204_ = 0.039095376f;
        this.RightFoot.f_104205_ = 1.251052f;
        this.RightHand.f_104205_ = 1.3688618f;
        this.LeftHand.f_104205_ = -1.3683381f;
        this.Body.f_104201_ = 21.0f;
        this.RightArm.f_104201_ = 23.89f;
        this.RightArm.f_104203_ = -0.4691445f;
        this.RightArm.f_104204_ = 0.1563815f;
        this.RightArm.f_104205_ = -1.3683381f;
        this.TailBase.f_104203_ = -0.11728612f;
        this.TailBase.f_104204_ = 0.4691445f;
        this.RightLeg.f_104201_ = 22.99f;
        this.RightLeg.f_104203_ = 0.35185838f;
        this.RightLeg.f_104205_ = -1.1728612f;
        this.TailEnd.f_104203_ = 0.07819075f;
        this.TailEnd.f_104204_ = 0.39095375f;
        this.LeftLeg.f_104201_ = 22.99f;
        this.LeftLeg.f_104203_ = 0.35185838f;
        this.LeftLeg.f_104205_ = 1.1728612f;
        this.LeftArm.f_104201_ = 22.99f;
        this.LeftArm.f_104203_ = -0.4691445f;
        this.LeftArm.f_104204_ = -0.1563815f;
        this.LeftArm.f_104205_ = 1.3683381f;
        this.LeftFoot.f_104203_ = -0.11728612f;
        this.LeftFoot.f_104204_ = 0.039095376f;
        this.LeftFoot.f_104205_ = -1.251052f;
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.RightArm.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.LeftLeg.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.LeftArm.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.RightLeg.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.Body.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
    }
}

