/*
 * Decompiled with CFR 0.152.
 */
package superlord.prehistoricfauna.client.model.triassic.chinle;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import superlord.prehistoricfauna.common.entity.DinosaurEntity;
import superlord.prehistoricfauna.common.entity.triassic.chinle.Coelophysis;

public class CoelophysisModel
extends EntityModel<Coelophysis> {
    private final ModelPart Body;
    private final ModelPart Neck;
    private final ModelPart Head;
    private final ModelPart Tail1;
    private final ModelPart Tail2;
    private final ModelPart LArm;
    private final ModelPart RArm;
    private final ModelPart RThigh;
    private final ModelPart RLeg;
    private final ModelPart RFoot;
    private final ModelPart LThigh;
    private final ModelPart LLeg;
    private final ModelPart LFoot;

    public CoelophysisModel(ModelPart root) {
        this.Body = root.m_171324_("Body");
        this.Neck = this.Body.m_171324_("Neck");
        this.Head = this.Neck.m_171324_("Head");
        this.Tail1 = this.Body.m_171324_("Tail1");
        this.Tail2 = this.Tail1.m_171324_("Tail2");
        this.LArm = this.Body.m_171324_("LArm");
        this.RArm = this.Body.m_171324_("RArm");
        this.RThigh = this.Body.m_171324_("RThigh");
        this.RLeg = this.RThigh.m_171324_("RLeg");
        this.RFoot = this.RLeg.m_171324_("RFoot");
        this.LThigh = this.Body.m_171324_("LThigh");
        this.LLeg = this.LThigh.m_171324_("LLeg");
        this.LFoot = this.LLeg.m_171324_("LFoot");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition Body = partdefinition.m_171599_("Body", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-1.5f, 0.0f, 0.0f, 3.0f, 5.0f, 14.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)11.0f, (float)-8.0f));
        PartDefinition LArm = Body.m_171599_("LArm", CubeListBuilder.m_171558_().m_171514_(82, 0).m_171488_(0.0f, -1.0f, -1.0f, 1.0f, 6.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)1.0f, (float)4.0f, (float)3.0f));
        PartDefinition RArm = Body.m_171599_("RArm", CubeListBuilder.m_171558_().m_171514_(82, 0).m_171480_().m_171488_(-1.0f, -1.0f, -1.0f, 1.0f, 6.0f, 2.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)-1.0f, (float)4.0f, (float)3.0f));
        PartDefinition RThigh = Body.m_171599_("RThigh", CubeListBuilder.m_171558_().m_171514_(100, 0).m_171480_().m_171488_(-1.5f, -1.5f, -2.0f, 2.0f, 6.0f, 4.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)-1.0f, (float)2.5f, (float)11.0f));
        PartDefinition RLeg = RThigh.m_171599_("RLeg", CubeListBuilder.m_171558_().m_171514_(6, 3).m_171480_().m_171488_(-1.0f, 0.0f, 0.0f, 2.0f, 6.0f, 0.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)-0.5f, (float)4.5f, (float)2.0f));
        PartDefinition RFoot = RLeg.m_171599_("RFoot", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171480_().m_171488_(-1.0f, 0.0f, -3.0f, 2.0f, 0.0f, 3.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)0.0f, (float)6.0f, (float)0.0f));
        PartDefinition LThigh = Body.m_171599_("LThigh", CubeListBuilder.m_171558_().m_171514_(100, 0).m_171488_(-0.5f, -1.5f, -2.0f, 2.0f, 6.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)1.0f, (float)2.5f, (float)11.0f));
        PartDefinition LLeg = LThigh.m_171599_("LLeg", CubeListBuilder.m_171558_().m_171514_(6, 3).m_171488_(-1.0f, 0.0f, 0.0f, 2.0f, 6.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.5f, (float)4.5f, (float)2.0f));
        PartDefinition LFoot = LLeg.m_171599_("LFoot", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-1.0f, 0.0f, -3.0f, 2.0f, 0.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)6.0f, (float)0.0f));
        PartDefinition Tail1 = Body.m_171599_("Tail1", CubeListBuilder.m_171558_().m_171514_(55, 0).m_171488_(-1.0f, -1.5f, -1.0f, 2.0f, 3.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)1.6f, (float)14.0f));
        PartDefinition Tail2 = Tail1.m_171599_("Tail2", CubeListBuilder.m_171558_().m_171514_(0, 31).m_171488_(-0.5f, -1.0f, -0.5f, 1.0f, 2.0f, 24.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-0.4f, (float)6.4f));
        PartDefinition Neck = Body.m_171599_("Neck", CubeListBuilder.m_171558_().m_171514_(34, 0).m_171488_(-1.0f, -8.0f, -2.0f, 2.0f, 9.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)2.0f, (float)0.5f));
        PartDefinition Head = Neck.m_171599_("Head", CubeListBuilder.m_171558_().m_171514_(41, 13).m_171488_(-1.0f, -2.0f, -6.0f, 2.0f, 2.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-6.0f, (float)-2.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)128, (int)128);
    }

    public void setupAnim(Coelophysis entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        float partialTick = ageInTicks - (float)entity.f_19797_;
        float attackProgress = entity.getMeleeProgress(partialTick);
        float sleepProgress = entity.getSleepProgress(partialTick);
        this.resetModel();
        if (entity.isAsleep()) {
            if (sleepProgress != 0.0f && (Integer)entity.m_20088_().m_135370_(DinosaurEntity.SLEEP_TICK) > 0) {
                this.Neck.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)0.6646214f);
                this.Neck.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-2.3848178f);
                this.RLeg.f_104201_ = Mth.m_14179_((float)sleepProgress, (float)4.5f, (float)4.2f);
                this.RLeg.f_104202_ = Mth.m_14179_((float)sleepProgress, (float)2.0f, (float)0.9f);
                this.RLeg.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-0.39793506f);
                this.RLeg.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-0.07819075f);
                this.RLeg.f_104205_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-0.27366763f);
                this.LThigh.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-1.1728612f);
                this.LThigh.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-0.4691445f);
                this.Tail1.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-0.23457225f);
                this.Tail1.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)0.5864306f);
                this.RArm.f_104205_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)1.3292428f);
                this.Tail2.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)0.11728612f);
                this.Tail2.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)0.70371675f);
                this.RFoot.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)1.5707964f);
                this.LArm.f_104205_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-1.3264502f);
                this.Body.f_104201_ = Mth.m_14179_((float)sleepProgress, (float)11.0f, (float)19.0f);
                this.LLeg.f_104201_ = Mth.m_14179_((float)sleepProgress, (float)4.5f, (float)4.2f);
                this.LLeg.f_104202_ = Mth.m_14179_((float)sleepProgress, (float)2.0f, (float)0.9f);
                this.LLeg.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-0.39793506f);
                this.LLeg.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)0.07819075f);
                this.LLeg.f_104205_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)0.27366763f);
                this.RThigh.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-1.1728612f);
                this.RThigh.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)0.4691445f);
                this.LFoot.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)1.5707964f);
            } else {
                this.sleepPose();
            }
        } else if (sleepProgress != 0.0f && (Integer)entity.m_20088_().m_135370_(DinosaurEntity.SLEEP_TICK) > 0) {
            this.Neck.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.6646214f, (float)0.0f);
            this.Neck.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)-2.3848178f, (float)0.0f);
            this.RLeg.f_104201_ = Mth.m_14179_((float)sleepProgress, (float)4.2f, (float)4.5f);
            this.RLeg.f_104202_ = Mth.m_14179_((float)sleepProgress, (float)0.9f, (float)2.0f);
            this.RLeg.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)-0.39793506f, (float)0.0f);
            this.RLeg.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)-0.07819075f, (float)0.0f);
            this.RLeg.f_104205_ = Mth.m_14179_((float)sleepProgress, (float)-0.27366763f, (float)0.0f);
            this.LThigh.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)-1.1728612f, (float)0.0f);
            this.LThigh.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)-0.4691445f, (float)0.0f);
            this.Tail1.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)-0.23457225f, (float)0.0f);
            this.Tail1.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)0.5864306f, (float)0.0f);
            this.RArm.f_104205_ = Mth.m_14179_((float)sleepProgress, (float)1.3292428f, (float)0.0f);
            this.Tail2.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.11728612f, (float)0.0f);
            this.Tail2.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)0.70371675f, (float)0.0f);
            this.RFoot.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)1.5707964f, (float)0.0f);
            this.LArm.f_104205_ = Mth.m_14179_((float)sleepProgress, (float)-1.3264502f, (float)0.0f);
            this.Body.f_104201_ = Mth.m_14179_((float)sleepProgress, (float)19.0f, (float)11.0f);
            this.LLeg.f_104201_ = Mth.m_14179_((float)sleepProgress, (float)4.2f, (float)4.5f);
            this.LLeg.f_104202_ = Mth.m_14179_((float)sleepProgress, (float)0.9f, (float)2.0f);
            this.LLeg.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)-0.39793506f, (float)0.0f);
            this.LLeg.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)0.07819075f, (float)0.0f);
            this.LLeg.f_104205_ = Mth.m_14179_((float)sleepProgress, (float)0.27366763f, (float)0.0f);
            this.RThigh.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)-1.1728612f, (float)0.0f);
            this.RThigh.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)0.4691445f, (float)0.0f);
            this.LFoot.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)1.5707964f, (float)0.0f);
        } else {
            this.LThigh.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
            this.RThigh.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
            this.Tail1.f_104204_ = -0.12f * Mth.m_14031_((float)(0.2f * ageInTicks / 5.0f));
            this.Tail2.f_104204_ = -0.12f * Mth.m_14031_((float)(0.2f * ageInTicks / 5.0f));
            this.Tail1.f_104203_ = -Math.abs(-0.05f * Mth.m_14031_((float)(0.1f * ageInTicks / 5.0f)));
            this.Tail2.f_104203_ = -Math.abs(-0.05f * Mth.m_14031_((float)(0.1f * ageInTicks / 5.0f)));
            this.Neck.f_104203_ = headPitch * ((float)Math.PI / 180) + Math.abs(-0.025f * Mth.m_14031_((float)(0.1f * ageInTicks / 3.0f))) + attackProgress * (float)Math.toRadians(40.0);
            this.RArm.f_104205_ = Math.abs(-0.05f * Mth.m_14031_((float)(0.15f * ageInTicks / 3.0f)));
            this.LArm.f_104205_ = -Math.abs(-0.05f * Mth.m_14031_((float)(0.15f * ageInTicks / 3.0f)));
            this.Neck.f_104204_ = netHeadYaw * ((float)Math.PI / 180);
            this.Head.f_104203_ = attackProgress * (float)Math.toRadians(-15.0);
            if (entity.m_20069_()) {
                this.Body.f_104201_ = 14.0f;
                this.Body.f_104203_ = -0.5f;
                this.Tail1.f_104203_ = 0.25f;
                this.Tail2.f_104203_ = 0.25f;
                this.Neck.f_104203_ = 0.5f;
                this.RThigh.f_104203_ = -0.5f * Mth.m_14031_((float)(0.2f * ageInTicks / 1.5f));
                this.LThigh.f_104203_ = 0.5f * Mth.m_14031_((float)(0.2f * ageInTicks / 1.5f));
                this.RLeg.f_104203_ = -0.3f * Mth.m_14031_((float)(0.2f * ageInTicks / 1.5f));
                this.LLeg.f_104203_ = 0.3f * Mth.m_14031_((float)(0.2f * ageInTicks / 1.5f));
                this.LArm.f_104203_ = 0.5f;
                this.RArm.f_104203_ = 0.5f;
                this.Tail1.f_104204_ = Mth.m_14089_((float)(limbSwing * 2.6662f)) * 1.4f * limbSwingAmount + 0.0625f * Mth.m_14031_((float)(0.15f * ageInTicks / 1.5f));
                this.Tail2.f_104204_ = Mth.m_14089_((float)(limbSwing * 2.6662f)) * 1.4f * limbSwingAmount + 0.0625f * Mth.m_14031_((float)(0.15f * ageInTicks / 1.5f));
            }
        }
    }

    public void resetModel() {
        this.Neck.f_104203_ = 0.0f;
        this.Neck.f_104204_ = -2.0f;
        this.RLeg.f_104201_ = 4.5f;
        this.RLeg.f_104202_ = 2.0f;
        this.RLeg.f_104203_ = 0.0f;
        this.RLeg.f_104204_ = 0.0f;
        this.RLeg.f_104205_ = 0.0f;
        this.LThigh.f_104203_ = 0.0f;
        this.LThigh.f_104204_ = 0.0f;
        this.Tail1.f_104203_ = 0.0f;
        this.Tail1.f_104204_ = 0.0f;
        this.RArm.f_104205_ = 0.0f;
        this.Tail2.f_104203_ = 0.0f;
        this.Tail2.f_104204_ = 0.0f;
        this.RFoot.f_104203_ = 0.0f;
        this.LArm.f_104205_ = 0.0f;
        this.Body.f_104201_ = 11.0f;
        this.LLeg.f_104201_ = 4.5f;
        this.LLeg.f_104202_ = 2.0f;
        this.LLeg.f_104203_ = 0.0f;
        this.LLeg.f_104204_ = 0.0f;
        this.LLeg.f_104205_ = 0.0f;
        this.RThigh.f_104203_ = 0.0f;
        this.RThigh.f_104204_ = 0.0f;
        this.LFoot.f_104203_ = 0.0f;
        this.Body.f_104203_ = 0.0f;
    }

    public void sleepPose() {
        this.Neck.f_104203_ = 0.6646214f;
        this.Neck.f_104204_ = -2.3848178f;
        this.RLeg.f_104201_ = 4.2f;
        this.RLeg.f_104202_ = 0.9f;
        this.RLeg.f_104203_ = -0.39793506f;
        this.RLeg.f_104204_ = -0.07819075f;
        this.RLeg.f_104205_ = -0.27366763f;
        this.LThigh.f_104203_ = -1.1728612f;
        this.LThigh.f_104204_ = -0.4691445f;
        this.Tail1.f_104203_ = -0.23457225f;
        this.Tail1.f_104204_ = 0.5864306f;
        this.RArm.f_104205_ = 1.3292428f;
        this.Tail2.f_104203_ = 0.11728612f;
        this.Tail2.f_104204_ = 0.70371675f;
        this.RFoot.f_104203_ = 1.5707964f;
        this.LArm.f_104205_ = -1.3264502f;
        this.Body.f_104201_ = 19.0f;
        this.LLeg.f_104201_ = 4.2f;
        this.LLeg.f_104202_ = 0.9f;
        this.LLeg.f_104203_ = -0.39793506f;
        this.LLeg.f_104204_ = 0.07819075f;
        this.LLeg.f_104205_ = 0.27366763f;
        this.RThigh.f_104203_ = -1.1728612f;
        this.RThigh.f_104204_ = 0.4691445f;
        this.LFoot.f_104203_ = 1.5707964f;
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.Body.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
    }
}

