/*
 * Decompiled with CFR 0.152.
 */
package superlord.prehistoricfauna.client.model.jurassic.morrison;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import superlord.prehistoricfauna.common.entity.DinosaurEntity;
import superlord.prehistoricfauna.common.entity.jurassic.morrison.Stegosaurus;

public class StegosaurusModel
extends EntityModel<Stegosaurus> {
    private final ModelPart RightArm;
    private final ModelPart RightThigh;
    private final ModelPart RightLeg;
    private final ModelPart RightFoot;
    private final ModelPart LeftThigh;
    private final ModelPart LeftLeg;
    private final ModelPart LeftFoot;
    private final ModelPart LeftArm;
    private final ModelPart Body;
    private final ModelPart Neck;
    private final ModelPart Head;
    private final ModelPart Tail1;
    private final ModelPart Tail2;

    public StegosaurusModel(ModelPart root) {
        this.RightArm = root.m_171324_("RightArm");
        this.RightThigh = root.m_171324_("RightThigh");
        this.RightLeg = this.RightThigh.m_171324_("RightLeg");
        this.RightFoot = this.RightLeg.m_171324_("RightFoot");
        this.LeftThigh = root.m_171324_("LeftThigh");
        this.LeftLeg = this.LeftThigh.m_171324_("LeftLeg");
        this.LeftFoot = this.LeftLeg.m_171324_("LeftFoot");
        this.LeftArm = root.m_171324_("LeftArm");
        this.Body = root.m_171324_("Body");
        this.Neck = this.Body.m_171324_("Neck");
        this.Head = this.Neck.m_171324_("Head");
        this.Tail1 = this.Body.m_171324_("Tail1");
        this.Tail2 = this.Tail1.m_171324_("Tail2");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition RightArm = partdefinition.m_171599_("RightArm", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171480_().m_171488_(-2.0f, -4.0f, -4.0f, 7.0f, 27.0f, 8.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)8.0f, (float)1.0f, (float)-14.0f));
        PartDefinition RightThigh = partdefinition.m_171599_("RightThigh", CubeListBuilder.m_171558_().m_171514_(0, 71).m_171480_().m_171488_(-3.0f, -3.0f, -7.0f, 9.0f, 21.0f, 15.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)8.0f, (float)-8.0f, (float)13.0f));
        PartDefinition RightLeg = RightThigh.m_171599_("RightLeg", CubeListBuilder.m_171558_().m_171514_(0, 107).m_171480_().m_171488_(-3.0f, -1.0f, -4.0f, 6.0f, 15.0f, 8.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)1.5f, (float)17.0f, (float)2.0f));
        PartDefinition RightFoot = RightLeg.m_171599_("RightFoot", CubeListBuilder.m_171558_().m_171514_(0, 130).m_171480_().m_171488_(-3.5f, 0.0f, -6.0f, 7.0f, 3.0f, 10.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)0.0f, (float)12.0f, (float)0.1f));
        PartDefinition LeftThigh = partdefinition.m_171599_("LeftThigh", CubeListBuilder.m_171558_().m_171514_(0, 71).m_171488_(-7.0f, -3.0f, -7.0f, 9.0f, 21.0f, 15.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-7.0f, (float)-8.0f, (float)13.0f));
        PartDefinition LeftLeg = LeftThigh.m_171599_("LeftLeg", CubeListBuilder.m_171558_().m_171514_(0, 107).m_171488_(-3.0f, -1.0f, -4.0f, 6.0f, 15.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-2.5f, (float)17.0f, (float)2.0f));
        PartDefinition LeftFoot = LeftLeg.m_171599_("LeftFoot", CubeListBuilder.m_171558_().m_171514_(0, 130).m_171488_(-3.5f, 0.0f, -6.0f, 7.0f, 3.0f, 10.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)12.0f, (float)0.1f));
        PartDefinition LeftArm = partdefinition.m_171599_("LeftArm", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-4.0f, -4.0f, -4.0f, 7.0f, 27.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-9.0f, (float)1.0f, (float)-14.0f));
        PartDefinition Body = partdefinition.m_171599_("Body", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-12.0f, 0.0f, 0.0f, 24.0f, 26.0f, 45.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-18.0f, (float)-21.0f));
        PartDefinition LeftBackPlates = Body.m_171599_("LeftBackPlates", CubeListBuilder.m_171558_().m_171514_(153, 24).m_171480_().m_171488_(0.0f, -21.0f, -1.0f, 0.0f, 22.0f, 46.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)-2.0f, (float)0.0f, (float)4.0f, (float)0.0f, (float)0.0f, (float)-0.1396f));
        PartDefinition InsideLeftBackPlates = LeftBackPlates.m_171599_("InsideLeftBackPlates", CubeListBuilder.m_171558_().m_171514_(153, 47).m_171480_().m_171488_(0.0f, -21.0f, -1.0f, 0.0f, 22.0f, 46.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)0.1f, (float)0.0f, (float)0.0f));
        PartDefinition RightBackPlates = Body.m_171599_("RightBackPlates", CubeListBuilder.m_171558_().m_171514_(153, 74).m_171488_(0.0f, -21.0f, 0.0f, 0.0f, 21.0f, 42.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)2.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.1396f));
        PartDefinition InsideRightBackPlates = RightBackPlates.m_171599_("InsideRightBackPlates", CubeListBuilder.m_171558_().m_171514_(153, 96).m_171488_(0.0f, -21.0f, 0.0f, 0.0f, 21.0f, 42.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-0.1f, (float)0.0f, (float)0.0f));
        PartDefinition Neck = Body.m_171599_("Neck", CubeListBuilder.m_171558_().m_171514_(83, 73).m_171488_(-3.5f, -5.0f, -23.0f, 7.0f, 10.0f, 23.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)12.0f, (float)0.0f));
        PartDefinition Head = Neck.m_171599_("Head", CubeListBuilder.m_171558_().m_171514_(94, 2).m_171488_(-3.5f, -3.5f, -5.0f, 7.0f, 7.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-1.5f, (float)-23.0f));
        PartDefinition Snout = Head.m_171599_("Snout", CubeListBuilder.m_171558_().m_171514_(96, 16).m_171488_(-2.0f, -3.0f, -6.0f, 4.0f, 6.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-0.5f, (float)-5.0f));
        PartDefinition RightNeckPlates = Neck.m_171599_("RightNeckPlates", CubeListBuilder.m_171558_().m_171514_(137, -18).m_171488_(0.0f, -11.0f, -18.0f, 0.0f, 11.0f, 18.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)1.0f, (float)-5.0f, (float)-3.0f, (float)0.0f, (float)0.0f, (float)0.0698f));
        PartDefinition InsideRightNeckPlates = RightNeckPlates.m_171599_("InsideRightNeckPlates", CubeListBuilder.m_171558_().m_171514_(137, -6).m_171488_(0.0f, -11.0f, -18.0f, 0.0f, 11.0f, 18.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-0.1f, (float)0.0f, (float)0.0f));
        PartDefinition LeftNeckPlates = Neck.m_171599_("LeftNeckPlates", CubeListBuilder.m_171558_().m_171514_(40, 120).m_171480_().m_171488_(0.0f, -10.0f, 0.0f, 0.0f, 10.0f, 18.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)-1.0f, (float)-5.0f, (float)-18.0f, (float)0.0f, (float)0.0f, (float)-0.0698f));
        PartDefinition InsideLeftNeckPlates = LeftNeckPlates.m_171599_("InsideLeftNeckPlates", CubeListBuilder.m_171558_().m_171514_(40, 131).m_171480_().m_171488_(0.0f, -10.0f, 0.0f, 0.0f, 10.0f, 18.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)0.1f, (float)0.0f, (float)0.0f));
        PartDefinition Tail1 = Body.m_171599_("Tail1", CubeListBuilder.m_171558_().m_171514_(28, 73).m_171488_(-5.0f, -6.0f, 0.0f, 10.0f, 12.0f, 34.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)6.5f, (float)44.0f, (float)-0.0698f, (float)0.0f, (float)0.0f));
        PartDefinition LeftTail1Plates = Tail1.m_171599_("LeftTail1Plates", CubeListBuilder.m_171558_().m_171514_(172, 4).m_171480_().m_171488_(0.0f, -20.0f, 0.0f, 0.0f, 20.0f, 24.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)-2.0f, (float)-6.0f, (float)9.0f, (float)0.0f, (float)0.0f, (float)-0.1396f));
        PartDefinition InsideLeftTail1Plates = LeftTail1Plates.m_171599_("InsideLeftTail1Plates", CubeListBuilder.m_171558_().m_171514_(172, 25).m_171480_().m_171488_(0.0f, -20.0f, 0.0f, 0.0f, 20.0f, 24.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)0.1f, (float)0.0f, (float)0.0f));
        PartDefinition RightTail1Plates = Tail1.m_171599_("RightTail1Plates", CubeListBuilder.m_171558_().m_171514_(88, 87).m_171488_(0.0f, -19.0f, -5.0f, 0.0f, 19.0f, 33.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)2.0f, (float)-6.0f, (float)1.0f, (float)0.0f, (float)0.0f, (float)0.1396f));
        PartDefinition InsideRightTail1Plates = RightTail1Plates.m_171599_("InsideRightTail1Plates", CubeListBuilder.m_171558_().m_171514_(85, 107).m_171488_(0.0f, -19.0f, 0.0f, 0.0f, 19.0f, 33.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-0.1f, (float)0.0f, (float)0.0f));
        PartDefinition Tail2 = Tail1.m_171599_("Tail2", CubeListBuilder.m_171558_().m_171514_(94, 7).m_171488_(-3.0f, -3.0f, 0.0f, 6.0f, 7.0f, 30.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-2.0f, (float)33.0f, (float)-0.0698f, (float)0.0f, (float)0.0f));
        PartDefinition RightTail2Plates = Tail2.m_171599_("RightTail2Plates", CubeListBuilder.m_171558_().m_171514_(174, -25).m_171488_(0.0f, -13.0f, 0.0f, 0.0f, 13.0f, 25.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)1.0f, (float)-3.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0698f));
        PartDefinition InsideRightTail2Plates = RightTail2Plates.m_171599_("InsideRightTail2Plates", CubeListBuilder.m_171558_().m_171514_(174, -11).m_171488_(0.0f, -13.0f, 0.0f, 0.0f, 13.0f, 25.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-0.1f, (float)0.0f, (float)0.0f));
        PartDefinition LeftTail2Plates = Tail2.m_171599_("LeftTail2Plates", CubeListBuilder.m_171558_().m_171514_(139, 29).m_171480_().m_171488_(0.0f, -9.0f, 0.0f, 0.0f, 9.0f, 16.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)-1.0f, (float)-3.0f, (float)5.0f, (float)0.0f, (float)0.0f, (float)-0.0698f));
        PartDefinition InsideLeftTail2Plates = LeftTail2Plates.m_171599_("InsideLeftTail2Plates", CubeListBuilder.m_171558_().m_171514_(139, 39).m_171480_().m_171488_(0.0f, -9.0f, 0.0f, 0.0f, 9.0f, 16.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)0.1f, (float)0.0f, (float)0.0f));
        PartDefinition RightThagomizers = Tail2.m_171599_("RightThagomizers", CubeListBuilder.m_171558_().m_171514_(39, 119).m_171488_(0.0f, 0.0f, 0.0f, 21.0f, 0.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)3.0f, (float)-2.0f, (float)20.0f, (float)0.0f, (float)0.0f, (float)-0.6632f));
        PartDefinition LeftThagomizers = Tail2.m_171599_("LeftThagomizers", CubeListBuilder.m_171558_().m_171514_(39, 119).m_171480_().m_171488_(-21.0f, 0.0f, 0.0f, 21.0f, 0.0f, 8.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)-3.0f, (float)-2.0f, (float)20.0f, (float)0.0f, (float)0.0f, (float)0.6632f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)256, (int)160);
    }

    public void setupAnim(Stegosaurus entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        float speed = 1.0f;
        float degree = 1.0f;
        float partialTick = ageInTicks - (float)entity.f_19797_;
        float attackProgress = entity.getMeleeProgress(partialTick);
        float leftOrRight = entity.getMeleeDirection() ? 1.0f : -1.0f;
        float sleepProgress = entity.getSleepProgress(partialTick);
        this.resetModel();
        if (entity.isAsleep()) {
            if (sleepProgress != 0.0f && (Integer)entity.m_20088_().m_135370_(DinosaurEntity.SLEEP_TICK) > 0) {
                this.Neck.f_104200_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)3.0f);
                this.Neck.f_104201_ = Mth.m_14179_((float)sleepProgress, (float)10.0f, (float)11.0f);
                this.Neck.f_104202_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)2.0f);
                this.Neck.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)0.8025024f);
                this.Neck.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-0.036651913f);
                this.LeftFoot.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)0.18256144f);
                this.LeftFoot.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)0.18256144f);
                this.LeftFoot.f_104205_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-0.03647738f);
                this.LeftThigh.f_104200_ = Mth.m_14179_((float)sleepProgress, (float)-8.0f, (float)-6.0f);
                this.LeftThigh.f_104201_ = Mth.m_14179_((float)sleepProgress, (float)-8.0f, (float)1.0f);
                this.LeftThigh.f_104202_ = Mth.m_14179_((float)sleepProgress, (float)15.0f, (float)14.0f);
                this.LeftThigh.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-0.14608406f);
                this.LeftThigh.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-0.1462586f);
                this.LeftThigh.f_104205_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)0.6932448f);
                this.RightArm.f_104201_ = Mth.m_14179_((float)sleepProgress, (float)1.0f, (float)21.2f);
                this.RightArm.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-0.21868975f);
                this.RightArm.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-0.03647738f);
                this.RightArm.f_104205_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)1.4604915f);
                this.RightLeg.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)0.14590952f);
                this.RightLeg.f_104205_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)0.07278023f);
                this.Tail1.f_104201_ = Mth.m_14179_((float)sleepProgress, (float)7.0f, (float)8.0f);
                this.Tail1.f_104202_ = Mth.m_14179_((float)sleepProgress, (float)44.0f, (float)43.0f);
                this.Tail1.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-0.4782202f);
                this.Tail1.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)0.1823869f);
                this.Tail1.f_104205_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-0.25534168f);
                this.Body.f_104200_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)17.0f);
                this.Body.f_104201_ = Mth.m_14179_((float)sleepProgress, (float)-18.0f, (float)6.6f);
                this.Body.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-0.036651913f);
                this.Body.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-0.0731293f);
                this.Body.f_104205_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)1.2407545f);
                this.RightThigh.f_104201_ = Mth.m_14179_((float)sleepProgress, (float)-8.0f, (float)17.7f);
                this.RightThigh.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)0.47420597f);
                this.RightThigh.f_104205_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)1.4606661f);
                this.Head.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-0.03647738f);
                this.Tail2.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-0.109432146f);
                this.Tail2.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-0.40107664f);
                this.Tail2.f_104205_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-0.32829642f);
                this.LeftArm.f_104201_ = Mth.m_14179_((float)sleepProgress, (float)1.0f, (float)5.0f);
                this.LeftArm.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)0.32829642f);
                this.LeftArm.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-1.7453292E-4f);
                this.LeftArm.f_104205_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)0.3647738f);
            } else {
                this.sleepPose();
            }
        } else if (sleepProgress != 0.0f && (Integer)entity.m_20088_().m_135370_(DinosaurEntity.SLEEP_TICK) > 0) {
            this.Neck.f_104200_ = Mth.m_14179_((float)sleepProgress, (float)3.0f, (float)0.0f);
            this.Neck.f_104201_ = Mth.m_14179_((float)sleepProgress, (float)11.0f, (float)10.0f);
            this.Neck.f_104202_ = Mth.m_14179_((float)sleepProgress, (float)2.0f, (float)0.0f);
            this.Neck.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.8025024f, (float)0.0f);
            this.Neck.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)-0.036651913f, (float)0.0f);
            this.LeftFoot.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.18256144f, (float)0.0f);
            this.LeftFoot.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)0.18256144f, (float)0.0f);
            this.LeftFoot.f_104205_ = Mth.m_14179_((float)sleepProgress, (float)-0.03647738f, (float)0.0f);
            this.LeftThigh.f_104200_ = Mth.m_14179_((float)sleepProgress, (float)-6.0f, (float)-8.0f);
            this.LeftThigh.f_104201_ = Mth.m_14179_((float)sleepProgress, (float)1.0f, (float)-8.0f);
            this.LeftThigh.f_104202_ = Mth.m_14179_((float)sleepProgress, (float)14.0f, (float)15.0f);
            this.LeftThigh.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)-0.14608406f, (float)0.0f);
            this.LeftThigh.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)-0.1462586f, (float)0.0f);
            this.LeftThigh.f_104205_ = Mth.m_14179_((float)sleepProgress, (float)0.6932448f, (float)0.0f);
            this.RightArm.f_104201_ = Mth.m_14179_((float)sleepProgress, (float)21.2f, (float)1.0f);
            this.RightArm.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)-0.21868975f, (float)0.0f);
            this.RightArm.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)-0.03647738f, (float)0.0f);
            this.RightArm.f_104205_ = Mth.m_14179_((float)sleepProgress, (float)1.4604915f, (float)0.0f);
            this.RightLeg.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.14590952f, (float)0.0f);
            this.RightLeg.f_104205_ = Mth.m_14179_((float)sleepProgress, (float)0.07278023f, (float)0.0f);
            this.Tail1.f_104201_ = Mth.m_14179_((float)sleepProgress, (float)8.0f, (float)7.0f);
            this.Tail1.f_104202_ = Mth.m_14179_((float)sleepProgress, (float)43.0f, (float)44.0f);
            this.Tail1.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)-0.4782202f, (float)0.0f);
            this.Tail1.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)0.1823869f, (float)0.0f);
            this.Tail1.f_104205_ = Mth.m_14179_((float)sleepProgress, (float)-0.25534168f, (float)0.0f);
            this.Body.f_104200_ = Mth.m_14179_((float)sleepProgress, (float)17.0f, (float)0.0f);
            this.Body.f_104201_ = Mth.m_14179_((float)sleepProgress, (float)6.6f, (float)-18.0f);
            this.Body.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)-0.036651913f, (float)0.0f);
            this.Body.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)-0.0731293f, (float)0.0f);
            this.Body.f_104205_ = Mth.m_14179_((float)sleepProgress, (float)1.2407545f, (float)0.0f);
            this.RightThigh.f_104201_ = Mth.m_14179_((float)sleepProgress, (float)17.7f, (float)-8.0f);
            this.RightThigh.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.47420597f, (float)0.0f);
            this.RightThigh.f_104205_ = Mth.m_14179_((float)sleepProgress, (float)1.4606661f, (float)0.0f);
            this.Head.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)-0.03647738f, (float)0.0f);
            this.Tail2.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)-0.109432146f, (float)0.0f);
            this.Tail2.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)-0.40107664f, (float)0.0f);
            this.Tail2.f_104205_ = Mth.m_14179_((float)sleepProgress, (float)-0.32829642f, (float)0.0f);
            this.LeftArm.f_104201_ = Mth.m_14179_((float)sleepProgress, (float)5.0f, (float)1.0f);
            this.LeftArm.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.32829642f, (float)0.0f);
            this.LeftArm.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)-1.7453292E-4f, (float)0.0f);
            this.LeftArm.f_104205_ = Mth.m_14179_((float)sleepProgress, (float)0.3647738f, (float)0.0f);
        } else {
            this.RightArm.f_104203_ = Mth.m_14089_((float)(limbSwing * speed * 0.3f)) * degree * 0.8f * limbSwingAmount;
            this.LeftArm.f_104203_ = Mth.m_14089_((float)(limbSwing * speed * 0.3f)) * degree * -0.8f * limbSwingAmount;
            this.RightThigh.f_104203_ = Mth.m_14089_((float)(1.0f + limbSwing * speed * 0.3f)) * degree * 0.4f * limbSwingAmount;
            this.RightLeg.f_104203_ = Mth.m_14089_((float)(limbSwing * speed * 0.3f)) * degree * 0.3f * limbSwingAmount;
            this.RightFoot.f_104203_ = Mth.m_14089_((float)(limbSwing * speed * 0.3f)) * degree * -0.3f * limbSwingAmount;
            this.LeftThigh.f_104203_ = Mth.m_14089_((float)(1.0f + limbSwing * speed * 0.3f)) * degree * -0.4f * limbSwingAmount;
            this.LeftLeg.f_104203_ = Mth.m_14089_((float)(limbSwing * speed * 0.3f)) * degree * -0.3f * limbSwingAmount;
            this.LeftFoot.f_104203_ = Mth.m_14089_((float)(limbSwing * speed * 0.3f)) * degree * 0.3f * limbSwingAmount;
            this.Tail1.f_104204_ = -0.12f * Mth.m_14031_((float)(0.2f * ageInTicks / 5.0f)) + Mth.m_14089_((float)(-1.0f + limbSwing * speed * 0.15f)) * degree * 0.3f * limbSwingAmount + attackProgress * leftOrRight * (float)Math.toRadians(30.0);
            this.Tail2.f_104204_ = -0.12f * Mth.m_14031_((float)(0.2f * ageInTicks / 5.0f)) + Mth.m_14089_((float)(-1.0f + limbSwing * speed * 0.15f)) * degree * 0.3f * limbSwingAmount + attackProgress * leftOrRight * (float)Math.toRadians(30.0);
            this.Tail1.f_104203_ = -Math.abs(-0.05f * Mth.m_14031_((float)(0.1f * ageInTicks / 5.0f))) + (Mth.m_14089_((float)(limbSwing * speed * 0.3f)) * degree * -0.15f * limbSwingAmount - 0.15f);
            this.Tail2.f_104203_ = -Math.abs(-0.05f * Mth.m_14031_((float)(0.1f * ageInTicks / 5.0f))) + Mth.m_14089_((float)(-1.0f + limbSwing * speed * 0.15f)) * degree * 0.3f * limbSwingAmount;
            this.Tail2.f_104205_ = attackProgress * leftOrRight * (float)Math.toRadians(30.0);
            this.Body.f_104203_ = Math.abs(-0.025f * Mth.m_14031_((float)(0.1f * ageInTicks / 3.0f)));
            this.Neck.f_104203_ = Math.abs(-0.025f * Mth.m_14031_((float)(0.1f * ageInTicks / 3.0f))) + headPitch * ((float)Math.PI / 180);
            this.Neck.f_104204_ = netHeadYaw * ((float)Math.PI / 180);
            if (entity.isEating()) {
                this.Neck.f_104203_ = Math.abs(Mth.m_14031_((float)(0.05f * ageInTicks)) * 0.5f) + 0.25f;
                this.Body.f_104203_ = 0.2f;
                this.LeftArm.f_104205_ = 0.3f;
                this.RightArm.f_104205_ = -0.3f;
            }
            if (entity.m_20069_()) {
                this.Body.f_104201_ = 3.0f;
                this.Body.f_104203_ = -0.125f;
                this.Tail1.f_104203_ = 0.0625f;
                this.Tail2.f_104203_ = 0.0625f;
                this.RightThigh.f_104201_ = 19.0f;
                this.LeftThigh.f_104201_ = 19.0f;
                this.RightArm.f_104201_ = 23.0f;
                this.LeftArm.f_104201_ = 23.0f;
                this.RightThigh.f_104203_ = -0.25f * Mth.m_14031_((float)(0.2f * ageInTicks / 1.5f));
                this.LeftThigh.f_104203_ = 0.25f * Mth.m_14031_((float)(0.2f * ageInTicks / 1.5f));
                this.RightLeg.f_104203_ = -0.3f * Mth.m_14031_((float)(0.2f * ageInTicks / 1.5f));
                this.LeftLeg.f_104203_ = 0.3f * Mth.m_14031_((float)(0.2f * ageInTicks / 1.5f));
                this.RightFoot.f_104203_ = 0.5f - 0.3f * Mth.m_14031_((float)(0.2f * ageInTicks / 1.5f));
                this.LeftFoot.f_104203_ = 0.5f + 0.3f * Mth.m_14031_((float)(0.2f * ageInTicks / 1.5f));
                this.LeftArm.f_104203_ = -0.25f * Mth.m_14031_((float)(0.2f * ageInTicks / 1.5f));
                this.RightArm.f_104203_ = 0.25f * Mth.m_14031_((float)(0.2f * ageInTicks / 1.5f));
                this.Neck.f_104203_ = 0.125f;
                this.Tail1.f_104204_ = Mth.m_14089_((float)(limbSwing * 2.6662f)) * 1.4f * limbSwingAmount + 0.0625f * Mth.m_14031_((float)(0.15f * ageInTicks / 1.5f));
                this.Tail2.f_104204_ = Mth.m_14089_((float)(limbSwing * 2.6662f)) * 1.4f * limbSwingAmount + 0.0625f * Mth.m_14031_((float)(0.15f * ageInTicks / 1.5f));
            }
        }
    }

    public void resetModel() {
        this.Neck.f_104200_ = 0.0f;
        this.Neck.f_104201_ = 10.0f;
        this.Neck.f_104202_ = 0.0f;
        this.Neck.f_104203_ = 0.0f;
        this.Neck.f_104204_ = 0.0f;
        this.LeftFoot.f_104203_ = 0.0f;
        this.LeftFoot.f_104204_ = 0.0f;
        this.LeftFoot.f_104205_ = 0.0f;
        this.LeftThigh.f_104200_ = -8.0f;
        this.LeftThigh.f_104201_ = -8.0f;
        this.LeftThigh.f_104202_ = 15.0f;
        this.LeftThigh.f_104203_ = 0.0f;
        this.LeftThigh.f_104204_ = 0.0f;
        this.LeftThigh.f_104205_ = 0.0f;
        this.RightArm.f_104201_ = 1.0f;
        this.RightArm.f_104203_ = 0.0f;
        this.RightArm.f_104204_ = 0.0f;
        this.RightArm.f_104205_ = 0.0f;
        this.RightLeg.f_104203_ = 0.0f;
        this.RightLeg.f_104205_ = 0.0f;
        this.Tail1.f_104201_ = 7.0f;
        this.Tail1.f_104202_ = 44.0f;
        this.Tail1.f_104203_ = 0.0f;
        this.Tail1.f_104204_ = 0.0f;
        this.Tail1.f_104205_ = 0.0f;
        this.Body.f_104200_ = 0.0f;
        this.Body.f_104201_ = -18.0f;
        this.Body.f_104203_ = 0.0f;
        this.Body.f_104204_ = 0.0f;
        this.Body.f_104205_ = 0.0f;
        this.RightThigh.f_104201_ = -8.0f;
        this.RightThigh.f_104203_ = 0.0f;
        this.RightThigh.f_104204_ = 0.0f;
        this.RightThigh.f_104205_ = 0.0f;
        this.Head.f_104203_ = 0.0f;
        this.Tail2.f_104203_ = 0.0f;
        this.Tail2.f_104204_ = 0.0f;
        this.Tail2.f_104205_ = 0.0f;
        this.LeftArm.f_104201_ = 1.0f;
        this.LeftArm.f_104203_ = 0.0f;
        this.LeftArm.f_104204_ = 0.0f;
        this.LeftArm.f_104205_ = 0.0f;
    }

    public void sleepPose() {
        this.Neck.f_104200_ = 3.0f;
        this.Neck.f_104201_ = 11.0f;
        this.Neck.f_104202_ = 2.0f;
        this.Neck.f_104203_ = 0.8025024f;
        this.Neck.f_104204_ = -0.036651913f;
        this.LeftFoot.f_104203_ = 0.18256144f;
        this.LeftFoot.f_104204_ = 0.18256144f;
        this.LeftFoot.f_104205_ = -0.03647738f;
        this.LeftThigh.f_104200_ = -6.0f;
        this.LeftThigh.f_104201_ = 1.0f;
        this.LeftThigh.f_104202_ = 14.0f;
        this.LeftThigh.f_104203_ = -0.14608406f;
        this.LeftThigh.f_104204_ = -0.1462586f;
        this.LeftThigh.f_104205_ = 0.6932448f;
        this.RightArm.f_104201_ = 21.2f;
        this.RightArm.f_104203_ = -0.21868975f;
        this.RightArm.f_104204_ = -0.03647738f;
        this.RightArm.f_104205_ = 1.4604915f;
        this.RightLeg.f_104203_ = 0.14590952f;
        this.RightLeg.f_104205_ = 0.07278023f;
        this.Tail1.f_104201_ = 8.0f;
        this.Tail1.f_104202_ = 43.0f;
        this.Tail1.f_104203_ = -0.4782202f;
        this.Tail1.f_104204_ = 0.1823869f;
        this.Tail1.f_104205_ = -0.25534168f;
        this.Body.f_104200_ = 17.0f;
        this.Body.f_104201_ = 6.6f;
        this.Body.f_104203_ = -0.036651913f;
        this.Body.f_104204_ = -0.0731293f;
        this.Body.f_104205_ = 1.2407545f;
        this.RightThigh.f_104201_ = 17.7f;
        this.RightThigh.f_104203_ = 0.47420597f;
        this.RightThigh.f_104205_ = 1.4606661f;
        this.Head.f_104203_ = -0.03647738f;
        this.Tail2.f_104203_ = -0.109432146f;
        this.Tail2.f_104204_ = -0.40107664f;
        this.Tail2.f_104205_ = -0.32829642f;
        this.LeftArm.f_104201_ = 5.0f;
        this.LeftArm.f_104203_ = 0.32829642f;
        this.LeftArm.f_104204_ = -1.7453292E-4f;
        this.LeftArm.f_104205_ = 0.3647738f;
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.RightArm.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.RightThigh.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.LeftThigh.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.LeftArm.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.Body.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
    }
}

