/*
 * Decompiled with CFR 0.152.
 */
package superlord.prehistoricfauna.client.model.jurassic.morrison;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import superlord.prehistoricfauna.common.entity.DinosaurEntity;
import superlord.prehistoricfauna.common.entity.jurassic.morrison.Stegosaurus;

public class StegosaurusBabyModel
extends EntityModel<Stegosaurus> {
    private final ModelPart Torso;
    private final ModelPart Neck;
    private final ModelPart Head;
    private final ModelPart TailBase;
    private final ModelPart RForeleg;
    private final ModelPart LForeleg;
    private final ModelPart RLeg;
    private final ModelPart LLeg;

    public StegosaurusBabyModel(ModelPart root) {
        this.Torso = root.m_171324_("Torso");
        this.Neck = this.Torso.m_171324_("Neck");
        this.Head = this.Neck.m_171324_("Head");
        this.TailBase = this.Torso.m_171324_("TailBase");
        this.RForeleg = root.m_171324_("RForeleg");
        this.LForeleg = root.m_171324_("LForeleg");
        this.RLeg = root.m_171324_("RLeg");
        this.LLeg = root.m_171324_("LLeg");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition Torso = partdefinition.m_171599_("Torso", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-3.0f, 0.0f, 0.0f, 6.0f, 7.0f, 10.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)14.0f, (float)-5.0f));
        PartDefinition Neck = Torso.m_171599_("Neck", CubeListBuilder.m_171558_().m_171514_(16, 17).m_171488_(-1.0f, -1.5f, -6.0f, 2.0f, 3.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)2.5f, (float)0.0f, (float)0.0698f, (float)0.0f, (float)0.0f));
        PartDefinition Head = Neck.m_171599_("Head", CubeListBuilder.m_171558_().m_171514_(22, 0).m_171488_(-1.5f, -1.0f, -4.0f, 3.0f, 2.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-0.6f, (float)-4.0f));
        PartDefinition part7 = Neck.m_171599_("part7", CubeListBuilder.m_171558_().m_171514_(0, 31).m_171488_(-1.0f, -2.0f, 0.0f, 2.0f, 2.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-1.5f, (float)-4.0f));
        PartDefinition TailBase = Torso.m_171599_("TailBase", CubeListBuilder.m_171558_().m_171514_(1, 17).m_171488_(-1.0f, -1.0f, -1.0f, 2.0f, 3.0f, 11.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)2.0f, (float)10.0f));
        PartDefinition Spines_1 = TailBase.m_171599_("Spines_1", CubeListBuilder.m_171558_().m_171514_(12, 31).m_171488_(-1.0f, -2.0f, 0.0f, 2.0f, 2.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-1.0f, (float)0.0f));
        PartDefinition part6 = TailBase.m_171599_("part6", CubeListBuilder.m_171558_().m_171514_(10, 41).m_171488_(-3.0f, 0.0f, 0.0f, 6.0f, 0.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-1.0f, (float)7.0f));
        PartDefinition Spines = Torso.m_171599_("Spines", CubeListBuilder.m_171558_().m_171514_(0, 40).m_171488_(-1.0f, -3.0f, 0.0f, 2.0f, 3.0f, 9.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition RForeleg = partdefinition.m_171599_("RForeleg", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171480_().m_171488_(-1.0f, -1.0f, -1.0f, 2.0f, 5.0f, 2.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)2.5f, (float)20.0f, (float)-3.0f));
        PartDefinition LForeleg = partdefinition.m_171599_("LForeleg", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-1.0f, -1.0f, -1.0f, 2.0f, 5.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-2.5f, (float)20.0f, (float)-3.0f));
        PartDefinition RLeg = partdefinition.m_171599_("RLeg", CubeListBuilder.m_171558_().m_171514_(0, 17).m_171480_().m_171488_(-1.5f, -2.0f, -1.5f, 3.0f, 8.0f, 3.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)2.5f, (float)18.0f, (float)2.5f));
        PartDefinition LLeg = partdefinition.m_171599_("LLeg", CubeListBuilder.m_171558_().m_171514_(0, 17).m_171488_(-1.5f, -2.0f, -1.5f, 3.0f, 8.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-2.5f, (float)18.0f, (float)2.5f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)36, (int)52);
    }

    public void setupAnim(Stegosaurus entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        float speed = 1.0f;
        float degree = 1.0f;
        float partialTick = ageInTicks - (float)entity.f_19797_;
        float attackProgress = entity.getMeleeProgress(partialTick);
        float leftOrRight = entity.getMeleeDirection() ? 1.0f : -1.0f;
        float sleepProgress = entity.getSleepProgress(partialTick);
        this.resetModel();
        if (entity.isAsleep()) {
            if (sleepProgress != 0.0f && (Integer)entity.m_20088_().m_135370_(DinosaurEntity.SLEEP_TICK) > 0) {
                this.Neck.f_104200_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)0.0f);
                this.Neck.f_104201_ = Mth.m_14179_((float)sleepProgress, (float)2.5f, (float)3.0f);
                this.Neck.f_104202_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-0.5f);
                this.Neck.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.0698f, (float)0.8025024f);
                this.Neck.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-0.036651913f);
                this.LLeg.f_104200_ = Mth.m_14179_((float)sleepProgress, (float)-2.5f, (float)-1.0f);
                this.LLeg.f_104201_ = Mth.m_14179_((float)sleepProgress, (float)18.0f, (float)18.5f);
                this.LLeg.f_104202_ = Mth.m_14179_((float)sleepProgress, (float)2.5f, (float)2.0f);
                this.LLeg.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-0.14608406f);
                this.LLeg.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-0.1462586f);
                this.LLeg.f_104205_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)0.6932448f);
                this.RForeleg.f_104201_ = Mth.m_14179_((float)sleepProgress, (float)20.0f, (float)24.2f);
                this.RForeleg.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-0.21868975f);
                this.RForeleg.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-0.03647738f);
                this.RForeleg.f_104205_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)1.4604915f);
                this.TailBase.f_104201_ = Mth.m_14179_((float)sleepProgress, (float)2.0f, (float)3.0f);
                this.TailBase.f_104202_ = Mth.m_14179_((float)sleepProgress, (float)10.0f, (float)10.0f);
                this.TailBase.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-0.4782202f);
                this.TailBase.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)0.1823869f);
                this.TailBase.f_104205_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-0.25534168f);
                this.Torso.f_104200_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)5.0f);
                this.Torso.f_104201_ = Mth.m_14179_((float)sleepProgress, (float)14.0f, (float)20.0f);
                this.Torso.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-0.036651913f);
                this.Torso.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-0.0731293f);
                this.Torso.f_104205_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)1.2407545f);
                this.RLeg.f_104201_ = Mth.m_14179_((float)sleepProgress, (float)18.0f, (float)23.7f);
                this.RLeg.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)0.47420597f);
                this.RLeg.f_104205_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)1.4606661f);
                this.Head.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-0.03647738f);
                this.LForeleg.f_104201_ = Mth.m_14179_((float)sleepProgress, (float)20.0f, (float)19.0f);
                this.LForeleg.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)0.32829642f);
                this.LForeleg.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-1.7453292E-4f);
                this.LForeleg.f_104205_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)0.3647738f);
            } else {
                this.sleepPose();
            }
        } else if (sleepProgress != 0.0f && (Integer)entity.m_20088_().m_135370_(DinosaurEntity.SLEEP_TICK) > 0) {
            this.Neck.f_104200_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)0.0f);
            this.Neck.f_104201_ = Mth.m_14179_((float)sleepProgress, (float)3.0f, (float)2.5f);
            this.Neck.f_104202_ = Mth.m_14179_((float)sleepProgress, (float)-0.5f, (float)0.0f);
            this.Neck.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.8025024f, (float)0.0698f);
            this.Neck.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)-0.036651913f, (float)0.0f);
            this.LLeg.f_104200_ = Mth.m_14179_((float)sleepProgress, (float)-1.0f, (float)-2.5f);
            this.LLeg.f_104201_ = Mth.m_14179_((float)sleepProgress, (float)18.5f, (float)18.0f);
            this.LLeg.f_104202_ = Mth.m_14179_((float)sleepProgress, (float)2.0f, (float)2.5f);
            this.LLeg.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)-0.14608406f, (float)0.0f);
            this.LLeg.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)-0.1462586f, (float)0.0f);
            this.LLeg.f_104205_ = Mth.m_14179_((float)sleepProgress, (float)0.6932448f, (float)0.0f);
            this.RForeleg.f_104201_ = Mth.m_14179_((float)sleepProgress, (float)24.2f, (float)20.0f);
            this.RForeleg.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)-0.21868975f, (float)0.0f);
            this.RForeleg.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)-0.03647738f, (float)0.0f);
            this.RForeleg.f_104205_ = Mth.m_14179_((float)sleepProgress, (float)1.4604915f, (float)0.0f);
            this.TailBase.f_104201_ = Mth.m_14179_((float)sleepProgress, (float)3.0f, (float)2.0f);
            this.TailBase.f_104202_ = Mth.m_14179_((float)sleepProgress, (float)10.0f, (float)10.0f);
            this.TailBase.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)-0.4782202f, (float)0.0f);
            this.TailBase.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)0.1823869f, (float)0.0f);
            this.TailBase.f_104205_ = Mth.m_14179_((float)sleepProgress, (float)-0.25534168f, (float)0.0f);
            this.Torso.f_104200_ = Mth.m_14179_((float)sleepProgress, (float)5.0f, (float)0.0f);
            this.Torso.f_104201_ = Mth.m_14179_((float)sleepProgress, (float)20.0f, (float)14.0f);
            this.Torso.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)-0.036651913f, (float)0.0f);
            this.Torso.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)-0.0731293f, (float)0.0f);
            this.Torso.f_104205_ = Mth.m_14179_((float)sleepProgress, (float)1.2407545f, (float)0.0f);
            this.RLeg.f_104201_ = Mth.m_14179_((float)sleepProgress, (float)23.7f, (float)18.0f);
            this.RLeg.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.47420597f, (float)0.0f);
            this.RLeg.f_104205_ = Mth.m_14179_((float)sleepProgress, (float)1.4606661f, (float)0.0f);
            this.Head.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)-0.03647738f, (float)0.0f);
            this.LForeleg.f_104201_ = Mth.m_14179_((float)sleepProgress, (float)19.0f, (float)20.0f);
            this.LForeleg.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.32829642f, (float)0.0f);
            this.LForeleg.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)-1.7453292E-4f, (float)0.0f);
            this.LForeleg.f_104205_ = Mth.m_14179_((float)sleepProgress, (float)0.3647738f, (float)0.0f);
        } else {
            this.RForeleg.f_104203_ = Mth.m_14089_((float)(limbSwing * speed * 0.3f)) * degree * 0.8f * limbSwingAmount;
            this.LForeleg.f_104203_ = Mth.m_14089_((float)(limbSwing * speed * 0.3f)) * degree * -0.8f * limbSwingAmount;
            this.RLeg.f_104203_ = Mth.m_14089_((float)(1.0f + limbSwing * speed * 0.3f)) * degree * 0.4f * limbSwingAmount;
            this.LLeg.f_104203_ = Mth.m_14089_((float)(1.0f + limbSwing * speed * 0.3f)) * degree * -0.4f * limbSwingAmount;
            this.TailBase.f_104204_ = -0.12f * Mth.m_14031_((float)(0.2f * ageInTicks / 5.0f)) + Mth.m_14089_((float)(-1.0f + limbSwing * speed * 0.15f)) * degree * 0.3f * limbSwingAmount + attackProgress * leftOrRight * (float)Math.toRadians(30.0);
            this.TailBase.f_104203_ = -Math.abs(-0.05f * Mth.m_14031_((float)(0.1f * ageInTicks / 5.0f))) + (Mth.m_14089_((float)(limbSwing * speed * 0.3f)) * degree * -0.15f * limbSwingAmount - 0.15f);
            this.Torso.f_104203_ = Math.abs(-0.025f * Mth.m_14031_((float)(0.1f * ageInTicks / 3.0f)));
            this.Neck.f_104203_ = Math.abs(-0.025f * Mth.m_14031_((float)(0.1f * ageInTicks / 3.0f))) + headPitch * ((float)Math.PI / 180);
            this.Neck.f_104204_ = netHeadYaw * ((float)Math.PI / 180);
            if (entity.isEating()) {
                this.Neck.f_104203_ = Math.abs(Mth.m_14031_((float)(0.05f * ageInTicks)) * 0.5f) + 0.25f;
                this.Torso.f_104203_ = 0.2f;
                this.LForeleg.f_104205_ = 0.3f;
                this.RForeleg.f_104205_ = -0.3f;
            }
            if (entity.m_20069_()) {
                this.Torso.f_104201_ = 3.0f;
                this.Torso.f_104203_ = -0.125f;
                this.TailBase.f_104203_ = 0.0625f;
                this.RLeg.f_104201_ = 19.0f;
                this.LLeg.f_104201_ = 19.0f;
                this.RForeleg.f_104201_ = 23.0f;
                this.LForeleg.f_104201_ = 23.0f;
                this.RLeg.f_104203_ = -0.25f * Mth.m_14031_((float)(0.2f * ageInTicks / 1.5f));
                this.LLeg.f_104203_ = 0.25f * Mth.m_14031_((float)(0.2f * ageInTicks / 1.5f));
                this.LForeleg.f_104203_ = -0.25f * Mth.m_14031_((float)(0.2f * ageInTicks / 1.5f));
                this.RForeleg.f_104203_ = 0.25f * Mth.m_14031_((float)(0.2f * ageInTicks / 1.5f));
                this.Neck.f_104203_ = 0.125f;
                this.TailBase.f_104204_ = Mth.m_14089_((float)(limbSwing * 2.6662f)) * 1.4f * limbSwingAmount + 0.0625f * Mth.m_14031_((float)(0.15f * ageInTicks / 1.5f));
            }
        }
    }

    public void resetModel() {
        this.Neck.f_104200_ = 0.0f;
        this.Neck.f_104201_ = 2.5f;
        this.Neck.f_104202_ = 0.0f;
        this.Neck.f_104203_ = 0.0698f;
        this.Neck.f_104204_ = 0.0f;
        this.LLeg.f_104200_ = -2.5f;
        this.LLeg.f_104201_ = 18.0f;
        this.LLeg.f_104202_ = 2.5f;
        this.LLeg.f_104203_ = 0.0f;
        this.LLeg.f_104204_ = 0.0f;
        this.LLeg.f_104205_ = 0.0f;
        this.RForeleg.f_104201_ = 20.0f;
        this.RForeleg.f_104203_ = 0.0f;
        this.RForeleg.f_104204_ = 0.0f;
        this.RForeleg.f_104205_ = 0.0f;
        this.TailBase.f_104201_ = 2.0f;
        this.TailBase.f_104202_ = 10.0f;
        this.TailBase.f_104203_ = 0.0f;
        this.TailBase.f_104204_ = 0.0f;
        this.TailBase.f_104205_ = 0.0f;
        this.Torso.f_104200_ = 0.0f;
        this.Torso.f_104201_ = 14.0f;
        this.Torso.f_104203_ = 0.0f;
        this.Torso.f_104204_ = 0.0f;
        this.Torso.f_104205_ = 0.0f;
        this.RLeg.f_104201_ = 18.0f;
        this.RLeg.f_104203_ = 0.0f;
        this.RLeg.f_104204_ = 0.0f;
        this.RLeg.f_104205_ = 0.0f;
        this.Head.f_104203_ = 0.0f;
        this.LForeleg.f_104201_ = 20.0f;
        this.LForeleg.f_104203_ = 0.0f;
        this.LForeleg.f_104204_ = 0.0f;
        this.LForeleg.f_104205_ = 0.0f;
    }

    public void sleepPose() {
        this.Neck.f_104200_ = 0.0f;
        this.Neck.f_104201_ = 3.0f;
        this.Neck.f_104202_ = -0.5f;
        this.Neck.f_104203_ = 0.8025024f;
        this.Neck.f_104204_ = -0.036651913f;
        this.LLeg.f_104200_ = -1.0f;
        this.LLeg.f_104201_ = 18.5f;
        this.LLeg.f_104202_ = 2.0f;
        this.LLeg.f_104203_ = -0.14608406f;
        this.LLeg.f_104204_ = -0.1462586f;
        this.LLeg.f_104205_ = 0.6932448f;
        this.RForeleg.f_104201_ = 24.2f;
        this.RForeleg.f_104203_ = -0.21868975f;
        this.RForeleg.f_104204_ = -0.03647738f;
        this.RForeleg.f_104205_ = 1.4604915f;
        this.TailBase.f_104201_ = 3.0f;
        this.TailBase.f_104202_ = 10.0f;
        this.TailBase.f_104203_ = -0.4782202f;
        this.TailBase.f_104204_ = 0.1823869f;
        this.TailBase.f_104205_ = -0.25534168f;
        this.Torso.f_104200_ = 5.0f;
        this.Torso.f_104201_ = 20.0f;
        this.Torso.f_104203_ = -0.036651913f;
        this.Torso.f_104204_ = -0.0731293f;
        this.Torso.f_104205_ = 1.2407545f;
        this.RLeg.f_104201_ = 23.7f;
        this.RLeg.f_104203_ = 0.47420597f;
        this.RLeg.f_104205_ = 1.4606661f;
        this.Head.f_104203_ = -0.03647738f;
        this.LForeleg.f_104201_ = 19.0f;
        this.LForeleg.f_104203_ = 0.32829642f;
        this.LForeleg.f_104204_ = -1.7453292E-4f;
        this.LForeleg.f_104205_ = 0.3647738f;
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.Torso.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.RForeleg.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.LForeleg.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.RLeg.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.LLeg.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
    }
}

