/*
 * Decompiled with CFR 0.152.
 */
package superlord.prehistoricfauna.client.model.jurassic.morrison;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import superlord.prehistoricfauna.common.entity.DinosaurEntity;
import superlord.prehistoricfauna.common.entity.jurassic.morrison.Hesperornithoides;

public class HesperornithoidesModel
extends EntityModel<Hesperornithoides> {
    private final ModelPart Body;
    private final ModelPart RightLeg;
    private final ModelPart LeftLeg;
    private final ModelPart RightWing;
    private final ModelPart LeftWing;
    private final ModelPart Head;
    private final ModelPart Fluff;
    private final ModelPart Tail;

    public HesperornithoidesModel(ModelPart root) {
        this.Body = root.m_171324_("Body");
        this.RightLeg = this.Body.m_171324_("RightLeg");
        this.LeftLeg = this.Body.m_171324_("LeftLeg");
        this.Head = this.Body.m_171324_("Head");
        this.Fluff = this.Head.m_171324_("Fluff");
        this.Tail = this.Body.m_171324_("Tail");
        this.LeftWing = this.Body.m_171324_("LeftWing");
        this.RightWing = this.Body.m_171324_("RightWing");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition Body = partdefinition.m_171599_("Body", CubeListBuilder.m_171558_().m_171514_(1, 8).m_171488_(-1.5f, 0.0f, 0.0f, 3.0f, 3.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)17.0f, (float)-2.5f));
        PartDefinition LeftWing = Body.m_171599_("LeftWing", CubeListBuilder.m_171558_().m_171514_(13, 5).m_171488_(-1.0f, 0.0f, 0.0f, 1.0f, 2.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-1.5f, (float)0.0f, (float)1.0f));
        PartDefinition RightWing = Body.m_171599_("RightWing", CubeListBuilder.m_171558_().m_171514_(13, 5).m_171480_().m_171488_(0.0f, 0.0f, 0.0f, 1.0f, 2.0f, 4.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)1.5f, (float)0.0f, (float)1.0f));
        PartDefinition RightLeg = Body.m_171599_("RightLeg", CubeListBuilder.m_171558_().m_171514_(17, 16).m_171488_(0.0f, 0.0f, -1.0f, 1.0f, 4.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.25f, (float)3.0f, (float)4.0f));
        PartDefinition Head = Body.m_171599_("Head", CubeListBuilder.m_171558_().m_171514_(1, 17).m_171488_(-1.0f, -4.0f, -1.0f, 2.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)2.0f, (float)0.0f));
        PartDefinition Fluff = Head.m_171599_("Fluff", CubeListBuilder.m_171558_().m_171514_(10, 18).m_171488_(-0.5f, -2.0f, 0.0f, 1.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-4.0f, (float)-1.0f));
        PartDefinition Snoot = Head.m_171599_("Snoot", CubeListBuilder.m_171558_().m_171514_(1, 24).m_171488_(-0.5f, 0.0f, -2.0f, 1.0f, 1.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-4.0f, (float)-1.0f));
        PartDefinition LeftLeg = Body.m_171599_("LeftLeg", CubeListBuilder.m_171558_().m_171514_(17, 16).m_171480_().m_171488_(-1.0f, 0.0f, -1.0f, 1.0f, 4.0f, 1.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)-0.25f, (float)3.0f, (float)4.0f));
        PartDefinition Tail = Body.m_171599_("Tail", CubeListBuilder.m_171558_().m_171514_(19, 5).m_171488_(-1.0f, 0.0f, -1.0f, 2.0f, 2.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)5.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)32);
    }

    public void setupAnim(Hesperornithoides entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        float partialTick = ageInTicks - (float)entity.f_19797_;
        float attackProgress = entity.getMeleeProgress(partialTick);
        float sleepProgress = entity.getSleepProgress(partialTick);
        this.resetModel();
        if (entity.isAsleep()) {
            if (sleepProgress != 0.0f && (Integer)entity.m_20088_().m_135370_(DinosaurEntity.SLEEP_TICK) > 0) {
                this.RightLeg.f_104201_ = Mth.m_14179_((float)sleepProgress, (float)3.0f, (float)0.0f);
                this.LeftLeg.f_104201_ = Mth.m_14179_((float)sleepProgress, (float)3.0f, (float)0.0f);
                this.RightWing.f_104201_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)0.3f);
                this.RightWing.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-0.33004177f);
                this.RightWing.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-0.21537364f);
                this.LeftWing.f_104201_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)0.3f);
                this.LeftWing.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-0.33004177f);
                this.LeftWing.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)0.21537364f);
                this.Head.f_104201_ = Mth.m_14179_((float)sleepProgress, (float)2.0f, (float)2.4f);
                this.Head.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-0.18221237f);
                this.Tail.f_104201_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)0.6f);
                this.Tail.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-0.21938789f);
                this.Tail.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-0.10960668f);
                this.Tail.f_104205_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-0.07295476f);
                this.Body.f_104201_ = Mth.m_14179_((float)sleepProgress, (float)17.0f, (float)20.8f);
                this.Body.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)0.07278023f);
                this.Fluff.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-1.0583676f);
                this.Fluff.f_104201_ = Mth.m_14179_((float)sleepProgress, (float)-4.0f, (float)-4.5f);
                this.Fluff.f_104202_ = Mth.m_14179_((float)sleepProgress, (float)-1.0f, (float)-0.1f);
            } else {
                this.sleepPose();
            }
        } else if (sleepProgress != 0.0f && (Integer)entity.m_20088_().m_135370_(DinosaurEntity.SLEEP_TICK) > 0) {
            this.RightLeg.f_104201_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)3.0f);
            this.LeftLeg.f_104201_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)3.0f);
            this.RightWing.f_104201_ = Mth.m_14179_((float)sleepProgress, (float)0.3f, (float)0.0f);
            this.RightWing.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)-0.33004177f, (float)0.0f);
            this.RightWing.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)-0.21537364f, (float)0.0f);
            this.LeftWing.f_104201_ = Mth.m_14179_((float)sleepProgress, (float)0.3f, (float)0.0f);
            this.LeftWing.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)-0.33004177f, (float)0.0f);
            this.LeftWing.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)0.21537364f, (float)0.0f);
            this.Head.f_104201_ = Mth.m_14179_((float)sleepProgress, (float)2.4f, (float)2.0f);
            this.Head.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)-0.18221237f, (float)0.0f);
            this.Tail.f_104201_ = Mth.m_14179_((float)sleepProgress, (float)0.6f, (float)0.0f);
            this.Tail.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)-0.21938789f, (float)0.0f);
            this.Tail.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)-0.10960668f, (float)0.0f);
            this.Tail.f_104205_ = Mth.m_14179_((float)sleepProgress, (float)-0.07295476f, (float)0.0f);
            this.Body.f_104201_ = Mth.m_14179_((float)sleepProgress, (float)20.8f, (float)17.0f);
            this.Body.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.07278023f, (float)0.0f);
            this.Fluff.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)-1.0583676f, (float)0.0f);
            this.Fluff.f_104201_ = Mth.m_14179_((float)sleepProgress, (float)-4.5f, (float)-4.0f);
            this.Fluff.f_104202_ = Mth.m_14179_((float)sleepProgress, (float)-0.1f, (float)-1.0f);
        } else {
            this.Head.f_104203_ = headPitch * ((float)Math.PI / 180) + Math.abs(-0.025f * Mth.m_14031_((float)(0.1f * ageInTicks / 3.0f))) + attackProgress * (float)Math.toRadians(40.0);
            this.RightWing.f_104205_ = -Math.abs(-0.05f * Mth.m_14031_((float)(0.15f * ageInTicks / 3.0f))) + attackProgress * (float)Math.toRadians(-50.0);
            this.LeftWing.f_104205_ = Math.abs(-0.05f * Mth.m_14031_((float)(0.15f * ageInTicks / 3.0f))) + attackProgress * (float)Math.toRadians(50.0);
            this.Fluff.f_104203_ = -Math.abs(-0.05f * Mth.m_14031_((float)(0.1f * ageInTicks / 3.0f)));
            this.Head.f_104204_ = netHeadYaw * ((float)Math.PI / 180);
            this.LeftLeg.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
            this.RightLeg.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
            this.Tail.f_104204_ = -0.12f * Mth.m_14031_((float)(0.2f * ageInTicks / 5.0f));
            this.Tail.f_104203_ = -Math.abs(-0.05f * Mth.m_14031_((float)(0.1f * ageInTicks / 5.0f)));
            this.RightWing.f_104204_ = Math.abs(-0.05f * Mth.m_14031_((float)(0.15f * ageInTicks / 3.0f)));
            this.LeftWing.f_104204_ = -Math.abs(-0.05f * Mth.m_14031_((float)(0.15f * ageInTicks / 3.0f)));
            if (entity.isDustBathing()) {
                this.RightWing.f_104204_ = Math.abs(-0.25f * Mth.m_14031_((float)(0.3f * ageInTicks)));
                this.LeftWing.f_104204_ = -Math.abs(-0.25f * Mth.m_14031_((float)(0.3f * ageInTicks)));
                this.RightWing.f_104205_ = -Math.abs(-0.5f * Mth.m_14031_((float)(0.3f * ageInTicks)));
                this.LeftWing.f_104205_ = Math.abs(-0.5f * Mth.m_14031_((float)(0.3f * ageInTicks)));
            }
            if (entity.m_20069_()) {
                this.Body.f_104201_ = 17.0f;
                this.Body.f_104203_ = -0.25f;
                this.Tail.f_104203_ = 0.25f;
                this.Head.f_104203_ = 0.25f;
                this.RightWing.f_104205_ = -1.5f + Math.abs(-1.0f * Mth.m_14031_((float)(0.15f * ageInTicks / 2.0f)));
                this.LeftWing.f_104205_ = 1.5f - Math.abs(-1.0f * Mth.m_14031_((float)(0.15f * ageInTicks / 2.0f)));
                this.RightLeg.f_104203_ = -0.25f * Mth.m_14031_((float)(0.2f * ageInTicks / 1.5f));
                this.LeftLeg.f_104203_ = 0.25f * Mth.m_14031_((float)(0.2f * ageInTicks / 1.5f));
                this.Tail.f_104204_ = Mth.m_14089_((float)(limbSwing * 2.6662f)) * 1.4f * limbSwingAmount;
            }
        }
    }

    public void resetModel() {
        this.RightLeg.f_104201_ = 3.0f;
        this.LeftLeg.f_104201_ = 3.0f;
        this.RightWing.f_104201_ = 0.0f;
        this.RightWing.f_104203_ = 0.0f;
        this.RightWing.f_104204_ = 0.0f;
        this.RightWing.f_104205_ = 0.0f;
        this.LeftWing.f_104201_ = 0.0f;
        this.LeftWing.f_104203_ = 0.0f;
        this.LeftWing.f_104204_ = 0.0f;
        this.LeftWing.f_104205_ = 0.0f;
        this.Head.f_104201_ = 2.0f;
        this.Head.f_104203_ = 0.0f;
        this.Head.f_104204_ = 0.0f;
        this.Tail.f_104201_ = 0.0f;
        this.Tail.f_104203_ = 0.0f;
        this.Tail.f_104204_ = 0.0f;
        this.Tail.f_104205_ = 0.0f;
        this.Body.f_104201_ = 17.0f;
        this.Body.f_104203_ = 0.0f;
        this.Fluff.f_104201_ = -4.0f;
        this.Fluff.f_104202_ = -1.0f;
        this.Fluff.f_104203_ = 0.0f;
    }

    public void sleepPose() {
        this.RightLeg.f_104201_ = 0.0f;
        this.LeftLeg.f_104201_ = 0.0f;
        this.RightWing.f_104201_ = 0.3f;
        this.RightWing.f_104203_ = -0.33004177f;
        this.RightWing.f_104204_ = -0.21537364f;
        this.LeftWing.f_104201_ = 0.3f;
        this.LeftWing.f_104203_ = -0.33004177f;
        this.LeftWing.f_104204_ = 0.21537364f;
        this.Head.f_104201_ = 2.4f;
        this.Head.f_104203_ = -0.18221237f;
        this.Tail.f_104201_ = 0.6f;
        this.Tail.f_104203_ = -0.21938789f;
        this.Tail.f_104204_ = -0.10960668f;
        this.Tail.f_104205_ = -0.07295476f;
        this.Body.f_104201_ = 20.8f;
        this.Body.f_104203_ = 0.07278023f;
        this.Fluff.f_104203_ = -1.0583676f;
        this.Fluff.f_104201_ = -4.5f;
        this.Fluff.f_104202_ = -0.1f;
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.Body.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
    }
}

