/*
 * Decompiled with CFR 0.152.
 */
package superlord.prehistoricfauna.client.model.jurassic.morrison;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import superlord.prehistoricfauna.common.entity.DinosaurEntity;
import superlord.prehistoricfauna.common.entity.jurassic.morrison.Eilenodon;

public class EilenodonModel
extends EntityModel<Eilenodon> {
    private final ModelPart Body;
    private final ModelPart Neck;
    private final ModelPart ArmL;
    private final ModelPart ArmR;
    private final ModelPart LegL;
    private final ModelPart LegR;
    private final ModelPart Tail;

    public EilenodonModel(ModelPart root) {
        this.Body = root.m_171324_("Body");
        this.Neck = this.Body.m_171324_("Neck");
        this.ArmL = this.Body.m_171324_("ArmL");
        this.ArmR = this.Body.m_171324_("ArmR");
        this.LegL = this.Body.m_171324_("LegL");
        this.LegR = this.Body.m_171324_("LegR");
        this.Tail = this.Body.m_171324_("Tail");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition Body = partdefinition.m_171599_("Body", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-2.0f, -2.0f, -5.0f, 4.0f, 3.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)22.0f, (float)2.0f));
        PartDefinition ArmR = Body.m_171599_("ArmR", CubeListBuilder.m_171558_().m_171514_(28, 5).m_171488_(0.0f, 0.0f, -1.0f, 1.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)2.0f, (float)-1.0f, (float)-4.0f));
        PartDefinition LegR = Body.m_171599_("LegR", CubeListBuilder.m_171558_().m_171514_(35, 5).m_171488_(0.0f, 0.0f, -1.0f, 1.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)2.0f, (float)-1.0f, (float)1.0f));
        PartDefinition Neck = Body.m_171599_("Neck", CubeListBuilder.m_171558_().m_171514_(0, 12).m_171488_(-1.0f, -2.0f, -2.0f, 2.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-1.0f, (float)-5.0f));
        PartDefinition HeadSpine = Neck.m_171599_("HeadSpine", CubeListBuilder.m_171558_().m_171514_(9, 17).m_171488_(0.0f, -0.5f, -1.0f, 0.0f, 1.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-2.5f, (float)-1.0f));
        PartDefinition Head = Neck.m_171599_("Head", CubeListBuilder.m_171558_().m_171514_(0, 18).m_171488_(-1.0f, -1.0f, -2.0f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-1.0f, (float)-2.0f));
        PartDefinition Dewlap = Head.m_171599_("Dewlap", CubeListBuilder.m_171558_().m_171514_(9, 11).m_171488_(0.0f, -1.0f, -1.0f, 0.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)2.0f, (float)0.0f));
        PartDefinition Tail = Body.m_171599_("Tail", CubeListBuilder.m_171558_().m_171514_(18, 11).m_171488_(-1.0f, -1.0f, 0.0f, 2.0f, 2.0f, 9.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)2.0f));
        PartDefinition BackSpine = Body.m_171599_("BackSpine", CubeListBuilder.m_171558_().m_171514_(0, 17).m_171488_(0.0f, -0.5f, -1.0f, 0.0f, 2.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-2.5f, (float)-4.0f));
        PartDefinition LegL = Body.m_171599_("LegL", CubeListBuilder.m_171558_().m_171514_(35, 0).m_171488_(-1.0f, 0.0f, -1.0f, 1.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-2.0f, (float)-1.0f, (float)1.0f));
        PartDefinition ArmL = Body.m_171599_("ArmL", CubeListBuilder.m_171558_().m_171514_(28, 0).m_171488_(-1.0f, 0.0f, -1.0f, 1.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-2.0f, (float)-1.0f, (float)-4.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void setupAnim(Eilenodon entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        float partialTick = ageInTicks - (float)entity.f_19797_;
        float sleepProgress = entity.getSleepProgress(partialTick);
        this.resetModel();
        if (entity.isAsleep()) {
            if (sleepProgress != 0.0f && (Integer)entity.m_20088_().m_135370_(DinosaurEntity.SLEEP_TICK) > 0) {
                this.Body.f_104201_ = Mth.m_14179_((float)sleepProgress, (float)22.0f, (float)23.0f);
                this.LegR.f_104201_ = Mth.m_14179_((float)sleepProgress, (float)-1.0f, (float)1.0f);
                this.LegR.f_104205_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-1.5707964f);
                this.ArmR.f_104201_ = Mth.m_14179_((float)sleepProgress, (float)-1.0f, (float)1.0f);
                this.ArmR.f_104205_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-1.5707964f);
                this.LegL.f_104201_ = Mth.m_14179_((float)sleepProgress, (float)-1.0f, (float)1.0f);
                this.LegL.f_104205_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)1.5707964f);
                this.ArmL.f_104201_ = Mth.m_14179_((float)sleepProgress, (float)-1.0f, (float)1.0f);
                this.ArmL.f_104205_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)1.5707964f);
                this.Neck.f_104202_ = Mth.m_14179_((float)sleepProgress, (float)-5.0f, (float)-4.8f);
                this.Neck.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)0.19547687f);
                this.Neck.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)0.27366763f);
                this.Neck.f_104205_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-1.2901473f);
            } else {
                this.sleepPose();
            }
        } else if (entity.isSitting() && !entity.isAsleep()) {
            if (sleepProgress != 0.0f && (Integer)entity.m_20088_().m_135370_(DinosaurEntity.SLEEP_TICK) > 0) {
                this.Body.f_104201_ = Mth.m_14179_((float)sleepProgress, (float)22.0f, (float)23.0f);
                this.LegR.f_104201_ = Mth.m_14179_((float)sleepProgress, (float)-1.0f, (float)1.0f);
                this.LegR.f_104205_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-1.5707964f);
                this.ArmR.f_104201_ = Mth.m_14179_((float)sleepProgress, (float)-1.0f, (float)1.0f);
                this.ArmR.f_104205_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-1.5707964f);
                this.LegL.f_104201_ = Mth.m_14179_((float)sleepProgress, (float)-1.0f, (float)1.0f);
                this.LegL.f_104205_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)1.5707964f);
                this.ArmL.f_104201_ = Mth.m_14179_((float)sleepProgress, (float)-1.0f, (float)1.0f);
                this.ArmL.f_104205_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)1.5707964f);
            } else {
                this.sittingPose();
            }
        } else if (sleepProgress != 0.0f && (Integer)entity.m_20088_().m_135370_(DinosaurEntity.SLEEP_TICK) > 0) {
            this.Body.f_104201_ = Mth.m_14179_((float)sleepProgress, (float)23.0f, (float)22.0f);
            this.LegR.f_104201_ = Mth.m_14179_((float)sleepProgress, (float)1.0f, (float)-1.0f);
            this.LegR.f_104205_ = Mth.m_14179_((float)sleepProgress, (float)-1.5707964f, (float)0.0f);
            this.ArmR.f_104201_ = Mth.m_14179_((float)sleepProgress, (float)1.0f, (float)-1.0f);
            this.ArmR.f_104205_ = Mth.m_14179_((float)sleepProgress, (float)-1.5707964f, (float)0.0f);
            this.LegL.f_104201_ = Mth.m_14179_((float)sleepProgress, (float)1.0f, (float)-1.0f);
            this.LegL.f_104205_ = Mth.m_14179_((float)sleepProgress, (float)1.5707964f, (float)0.0f);
            this.ArmL.f_104201_ = Mth.m_14179_((float)sleepProgress, (float)1.0f, (float)-1.0f);
            this.ArmL.f_104205_ = Mth.m_14179_((float)sleepProgress, (float)1.5707964f, (float)0.0f);
            this.Neck.f_104202_ = Mth.m_14179_((float)sleepProgress, (float)-4.8f, (float)-5.0f);
            this.Neck.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.19547687f, (float)0.0f);
            this.Neck.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)0.27366763f, (float)0.0f);
            this.Neck.f_104205_ = Mth.m_14179_((float)sleepProgress, (float)-1.2901473f, (float)0.0f);
        } else {
            this.Neck.f_104203_ = headPitch * ((float)Math.PI / 180);
            this.Neck.f_104204_ = netHeadYaw * ((float)Math.PI / 180);
            this.LegL.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
            this.LegR.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
            this.ArmL.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
            this.ArmR.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
            this.Tail.f_104204_ = -0.12f * Mth.m_14031_((float)(0.2f * ageInTicks / 5.0f));
            this.Tail.f_104203_ = -Math.abs(-0.05f * Mth.m_14031_((float)(0.1f * ageInTicks / 5.0f)));
            this.Neck.f_104203_ = -0.12f * Mth.m_14031_((float)(0.2f * ageInTicks / 5.0f));
            if (entity.isEating()) {
                this.Neck.f_104203_ = Math.abs(Mth.m_14031_((float)(0.05f * ageInTicks)) * 0.45f) + 0.5f;
            }
            if (entity.m_20069_()) {
                this.ArmR.f_104203_ = 0.25f * Mth.m_14031_((float)(0.15f * ageInTicks / 1.5f));
                this.ArmL.f_104203_ = 0.25f * Mth.m_14031_((float)(0.15f * ageInTicks / 1.5f));
                this.LegL.f_104203_ = -0.25f * Mth.m_14031_((float)(0.15f * ageInTicks / 1.5f));
                this.LegR.f_104203_ = -0.25f * Mth.m_14031_((float)(0.15f * ageInTicks / 1.5f));
                this.Tail.f_104204_ = Mth.m_14089_((float)(limbSwing * 2.6662f)) * 1.4f * limbSwingAmount + 0.0625f * Mth.m_14031_((float)(0.15f * ageInTicks / 1.5f));
            }
        }
    }

    public void resetModel() {
        this.Body.f_104201_ = 22.0f;
        this.LegR.f_104201_ = -1.0f;
        this.LegR.f_104205_ = 0.0f;
        this.LegR.f_104203_ = 0.0f;
        this.LegR.f_104204_ = 0.0f;
        this.ArmR.f_104201_ = -1.0f;
        this.ArmR.f_104205_ = 0.0f;
        this.ArmR.f_104203_ = 0.0f;
        this.ArmR.f_104204_ = 0.0f;
        this.LegL.f_104201_ = -1.0f;
        this.LegL.f_104205_ = 0.0f;
        this.LegL.f_104203_ = 0.0f;
        this.LegL.f_104204_ = 0.0f;
        this.ArmL.f_104201_ = -1.0f;
        this.ArmL.f_104205_ = 0.0f;
        this.ArmL.f_104203_ = 0.0f;
        this.ArmL.f_104204_ = 0.0f;
        this.Neck.f_104203_ = 0.0f;
        this.Tail.f_104203_ = 0.0f;
        this.Tail.f_104204_ = 0.0f;
        this.Neck.f_104203_ = 0.0f;
        this.Neck.f_104204_ = 0.0f;
        this.Neck.f_104205_ = 0.0f;
        this.Neck.f_104202_ = -5.0f;
    }

    public void sleepPose() {
        this.Body.f_104201_ = 23.0f;
        this.LegR.f_104201_ = 1.0f;
        this.LegR.f_104205_ = -1.5707964f;
        this.ArmR.f_104201_ = 1.0f;
        this.ArmR.f_104205_ = -1.5707964f;
        this.LegL.f_104201_ = 1.0f;
        this.LegL.f_104205_ = 1.5707964f;
        this.ArmL.f_104201_ = 1.0f;
        this.ArmL.f_104205_ = 1.5707964f;
        this.Neck.f_104202_ = -4.8f;
        this.Neck.f_104203_ = 0.19547687f;
        this.Neck.f_104204_ = 0.27366763f;
        this.Neck.f_104205_ = -1.2901473f;
    }

    public void sittingPose() {
        this.Body.f_104201_ = 23.0f;
        this.LegR.f_104201_ = 1.0f;
        this.LegR.f_104205_ = -1.5707964f;
        this.ArmR.f_104201_ = 1.0f;
        this.ArmR.f_104205_ = -1.5707964f;
        this.LegL.f_104201_ = 1.0f;
        this.LegL.f_104205_ = 1.5707964f;
        this.ArmL.f_104201_ = 1.0f;
        this.ArmL.f_104205_ = 1.5707964f;
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.Body.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
    }
}

