/*
 * Decompiled with CFR 0.152.
 */
package superlord.prehistoricfauna.client.model.jurassic.morrison;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import superlord.prehistoricfauna.common.entity.DinosaurEntity;
import superlord.prehistoricfauna.common.entity.jurassic.morrison.Dryosaurus;

public class DryosaurusModel
extends EntityModel<Dryosaurus> {
    private final ModelPart Body;
    private final ModelPart Neck;
    private final ModelPart Head;
    private final ModelPart Tail1;
    private final ModelPart Tail2;
    private final ModelPart RArm;
    private final ModelPart LArm;
    private final ModelPart LLeg1;
    private final ModelPart LLeg2;
    private final ModelPart LLeg3;
    private final ModelPart RLeg1;
    private final ModelPart RLeg2;
    private final ModelPart RLeg3;

    public DryosaurusModel(ModelPart root) {
        this.Body = root.m_171324_("Body");
        this.Neck = this.Body.m_171324_("Neck");
        this.Head = this.Neck.m_171324_("Head");
        this.Tail1 = this.Body.m_171324_("Tail1");
        this.Tail2 = this.Tail1.m_171324_("Tail2");
        this.RArm = this.Body.m_171324_("RArm");
        this.LArm = this.Body.m_171324_("LArm");
        this.LLeg1 = this.Body.m_171324_("LLeg1");
        this.LLeg2 = this.LLeg1.m_171324_("LLeg2");
        this.LLeg3 = this.LLeg2.m_171324_("LLeg3");
        this.RLeg1 = this.Body.m_171324_("RLeg1");
        this.RLeg2 = this.RLeg1.m_171324_("RLeg2");
        this.RLeg3 = this.RLeg2.m_171324_("RLeg3");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition Body = partdefinition.m_171599_("Body", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-3.0f, 0.0f, 0.0f, 6.0f, 8.0f, 19.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)5.0f, (float)-10.0f));
        PartDefinition RLeg1 = Body.m_171599_("RLeg1", CubeListBuilder.m_171558_().m_171514_(31, 0).m_171488_(-1.0f, -3.0f, -3.0f, 3.0f, 9.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-3.0f, (float)5.0f, (float)14.0f));
        PartDefinition RLeg2 = RLeg1.m_171599_("RLeg2", CubeListBuilder.m_171558_().m_171514_(6, 3).m_171480_().m_171488_(-1.0f, 0.0f, 0.0f, 2.0f, 8.0f, 0.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)0.5f, (float)6.0f, (float)3.0f));
        PartDefinition RLeg3 = RLeg2.m_171599_("RLeg3", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171480_().m_171488_(-1.0f, 0.0f, -3.0f, 2.0f, 0.0f, 3.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)0.0f, (float)8.0f, (float)0.0f));
        PartDefinition RArm = Body.m_171599_("RArm", CubeListBuilder.m_171558_().m_171514_(49, 0).m_171480_().m_171488_(-1.0f, -1.0f, -1.0f, 2.0f, 6.0f, 2.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)-3.0f, (float)7.0f, (float)3.0f));
        PartDefinition LLeg1 = Body.m_171599_("LLeg1", CubeListBuilder.m_171558_().m_171514_(31, 0).m_171480_().m_171488_(-2.0f, -3.0f, -3.0f, 3.0f, 9.0f, 6.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)3.0f, (float)5.0f, (float)14.0f));
        PartDefinition LLeg2 = LLeg1.m_171599_("LLeg2", CubeListBuilder.m_171558_().m_171514_(6, 3).m_171488_(-1.0f, 0.0f, 0.0f, 2.0f, 8.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-0.5f, (float)6.0f, (float)3.0f));
        PartDefinition LLeg3 = LLeg2.m_171599_("LLeg3", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-1.0f, 0.0f, -3.0f, 2.0f, 0.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)8.0f, (float)0.0f));
        PartDefinition Neck = Body.m_171599_("Neck", CubeListBuilder.m_171558_().m_171514_(0, 27).m_171488_(-1.5f, -3.0f, -3.0f, 3.0f, 5.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)3.0f, (float)0.0f));
        PartDefinition Head = Neck.m_171599_("Head", CubeListBuilder.m_171558_().m_171514_(0, 47).m_171488_(-1.5f, -3.0f, -4.0f, 3.0f, 3.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-3.0f, (float)-1.0f));
        PartDefinition Snout = Head.m_171599_("Snout", CubeListBuilder.m_171558_().m_171514_(0, 11).m_171488_(-1.0f, -1.0f, -2.0f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-1.0f, (float)-4.0f));
        PartDefinition LArm = Body.m_171599_("LArm", CubeListBuilder.m_171558_().m_171514_(49, 0).m_171488_(-1.0f, -1.0f, -1.0f, 2.0f, 6.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)3.0f, (float)7.0f, (float)3.0f));
        PartDefinition Tail1 = Body.m_171599_("Tail1", CubeListBuilder.m_171558_().m_171514_(0, 27).m_171488_(-2.0f, -2.5f, 0.0f, 4.0f, 5.0f, 15.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)3.5f, (float)19.0f));
        PartDefinition Tail2 = Tail1.m_171599_("Tail2", CubeListBuilder.m_171558_().m_171514_(50, 0).m_171488_(-1.0f, -1.5f, 0.0f, 2.0f, 3.0f, 21.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)15.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)128, (int)64);
    }

    public void setupAnim(Dryosaurus entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        float partialTick = ageInTicks - (float)entity.f_19797_;
        float sleepProgress = entity.getSleepProgress(partialTick);
        this.resetModel();
        if (entity.isAsleep()) {
            if (sleepProgress != 0.0f && (Integer)entity.m_20088_().m_135370_(DinosaurEntity.SLEEP_TICK) > 0) {
                this.LLeg2.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-0.4537856f);
                this.LLeg1.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-0.87266463f);
                this.LLeg1.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-0.29670596f);
                this.LLeg1.f_104201_ = Mth.m_14179_((float)sleepProgress, (float)5.0f, (float)3.2f);
                this.LArm.f_104202_ = Mth.m_14179_((float)sleepProgress, (float)3.0f, (float)2.5f);
                this.LArm.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)0.87266463f);
                this.LLeg3.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)1.5707964f);
                this.RLeg3.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)1.5707964f);
                this.Body.f_104201_ = Mth.m_14179_((float)sleepProgress, (float)5.0f, (float)12.0f);
                this.Body.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-0.2443461f);
                this.Tail2.f_104200_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)0.5f);
                this.Tail2.f_104202_ = Mth.m_14179_((float)sleepProgress, (float)15.0f, (float)14.4f);
                this.Tail2.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)0.13962634f);
                this.Tail2.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-0.5934119f);
                this.Tail2.f_104205_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-0.10471976f);
                this.RLeg1.f_104201_ = Mth.m_14179_((float)sleepProgress, (float)5.0f, (float)3.2f);
                this.RLeg1.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-0.87266463f);
                this.RLeg1.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)0.29670596f);
                this.Neck.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)0.87266463f);
                this.Neck.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)0.9773844f);
                this.Head.f_104200_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)0.5f);
                this.Head.f_104202_ = Mth.m_14179_((float)sleepProgress, (float)-1.0f, (float)-1.5f);
                this.Head.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)0.55850536f);
                this.Head.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)1.3962634f);
                this.RLeg2.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-0.4537856f);
                this.RArm.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)0.87266463f);
                this.RArm.f_104202_ = Mth.m_14179_((float)sleepProgress, (float)3.0f, (float)2.5f);
                this.Tail1.f_104200_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)0.7f);
                this.Tail1.f_104202_ = Mth.m_14179_((float)sleepProgress, (float)19.0f, (float)18.0f);
                this.Tail1.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)0.07853982f);
                this.Tail1.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-0.5934119f);
                this.Tail1.f_104205_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-0.10471976f);
            } else {
                this.sleepPose();
            }
        } else if (sleepProgress != 0.0f && (Integer)entity.m_20088_().m_135370_(DinosaurEntity.SLEEP_TICK) > 0) {
            this.LLeg2.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)-0.4537856f, (float)0.0f);
            this.LLeg1.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)-0.87266463f, (float)0.0f);
            this.LLeg1.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)-0.29670596f, (float)0.0f);
            this.LLeg1.f_104201_ = Mth.m_14179_((float)sleepProgress, (float)3.2f, (float)5.0f);
            this.LArm.f_104202_ = Mth.m_14179_((float)sleepProgress, (float)2.5f, (float)3.0f);
            this.LArm.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.87266463f, (float)0.0f);
            this.LLeg3.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)1.5707964f, (float)0.0f);
            this.RLeg3.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)1.5707964f, (float)0.0f);
            this.Body.f_104201_ = Mth.m_14179_((float)sleepProgress, (float)12.0f, (float)5.0f);
            this.Body.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)-0.2443461f, (float)0.0f);
            this.Tail2.f_104200_ = Mth.m_14179_((float)sleepProgress, (float)0.5f, (float)0.0f);
            this.Tail2.f_104202_ = Mth.m_14179_((float)sleepProgress, (float)14.4f, (float)15.0f);
            this.Tail2.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.13962634f, (float)0.0f);
            this.Tail2.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)-0.5934119f, (float)0.0f);
            this.Tail2.f_104205_ = Mth.m_14179_((float)sleepProgress, (float)-0.10471976f, (float)0.0f);
            this.RLeg1.f_104201_ = Mth.m_14179_((float)sleepProgress, (float)3.2f, (float)5.0f);
            this.RLeg1.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)-0.87266463f, (float)0.0f);
            this.RLeg1.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)0.29670596f, (float)0.0f);
            this.Neck.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.87266463f, (float)0.0f);
            this.Neck.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)0.9773844f, (float)0.0f);
            this.Head.f_104200_ = Mth.m_14179_((float)sleepProgress, (float)0.5f, (float)0.0f);
            this.Head.f_104202_ = Mth.m_14179_((float)sleepProgress, (float)-1.5f, (float)-1.0f);
            this.Head.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.55850536f, (float)0.0f);
            this.Head.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)1.3962634f, (float)0.0f);
            this.RLeg2.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)-0.4537856f, (float)0.0f);
            this.RArm.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.87266463f, (float)0.0f);
            this.RArm.f_104202_ = Mth.m_14179_((float)sleepProgress, (float)2.5f, (float)3.0f);
            this.Tail1.f_104200_ = Mth.m_14179_((float)sleepProgress, (float)0.7f, (float)0.0f);
            this.Tail1.f_104202_ = Mth.m_14179_((float)sleepProgress, (float)18.0f, (float)19.0f);
            this.Tail1.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.07853982f, (float)0.0f);
            this.Tail1.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)-0.5934119f, (float)0.0f);
            this.Tail1.f_104205_ = Mth.m_14179_((float)sleepProgress, (float)-0.10471976f, (float)0.0f);
        } else {
            this.LLeg1.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
            this.RLeg1.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
            this.Tail1.f_104204_ = -0.12f * Mth.m_14031_((float)(0.2f * ageInTicks / 5.0f));
            this.Tail2.f_104204_ = -0.12f * Mth.m_14031_((float)(0.2f * ageInTicks / 5.0f));
            this.Tail1.f_104203_ = -Math.abs(-0.05f * Mth.m_14031_((float)(0.1f * ageInTicks / 5.0f)));
            this.Tail2.f_104203_ = -Math.abs(-0.05f * Mth.m_14031_((float)(0.1f * ageInTicks / 5.0f)));
            this.Neck.f_104203_ = headPitch * ((float)Math.PI / 180) + Math.abs(-0.025f * Mth.m_14031_((float)(0.1f * ageInTicks / 3.0f)));
            this.RArm.f_104205_ = Math.abs(-0.05f * Mth.m_14031_((float)(0.15f * ageInTicks / 3.0f)));
            this.LArm.f_104205_ = -Math.abs(-0.05f * Mth.m_14031_((float)(0.15f * ageInTicks / 3.0f)));
            this.Neck.f_104204_ = netHeadYaw * ((float)Math.PI / 180);
            if (entity.isEating()) {
                this.Neck.f_104203_ = Math.abs(Mth.m_14031_((float)(0.05f * ageInTicks)) * 0.75f) + 0.5f;
            }
            if (entity.m_20069_()) {
                this.Body.f_104201_ = 10.0f;
                this.Body.f_104203_ = -0.5f;
                this.Tail1.f_104203_ = 0.25f;
                this.Tail2.f_104203_ = 0.25f;
                this.Neck.f_104203_ = 0.5f;
                this.RLeg1.f_104203_ = -0.5f * Mth.m_14031_((float)(0.2f * ageInTicks / 1.5f));
                this.LLeg1.f_104203_ = 0.5f * Mth.m_14031_((float)(0.2f * ageInTicks / 1.5f));
                this.RLeg2.f_104203_ = -0.3f * Mth.m_14031_((float)(0.2f * ageInTicks / 1.5f));
                this.LLeg2.f_104203_ = 0.3f * Mth.m_14031_((float)(0.2f * ageInTicks / 1.5f));
                this.LArm.f_104203_ = 0.5f;
                this.RArm.f_104203_ = 0.5f;
                this.Tail1.f_104204_ = Mth.m_14089_((float)(limbSwing * 2.6662f)) * 1.4f * limbSwingAmount + 0.0625f * Mth.m_14031_((float)(0.15f * ageInTicks / 1.5f));
                this.Tail2.f_104204_ = Mth.m_14089_((float)(limbSwing * 2.6662f)) * 1.4f * limbSwingAmount + 0.0625f * Mth.m_14031_((float)(0.15f * ageInTicks / 1.5f));
            }
        }
    }

    public void resetModel() {
        this.LLeg2.f_104203_ = 0.0f;
        this.LLeg1.f_104201_ = 5.0f;
        this.LLeg1.f_104203_ = 0.0f;
        this.LLeg1.f_104204_ = 0.0f;
        this.LArm.f_104202_ = 3.0f;
        this.LArm.f_104203_ = 0.0f;
        this.LLeg3.f_104203_ = 0.0f;
        this.RLeg3.f_104203_ = 0.0f;
        this.Body.f_104201_ = 5.0f;
        this.Body.f_104203_ = 0.0f;
        this.Tail2.f_104200_ = 0.0f;
        this.Tail2.f_104202_ = 15.0f;
        this.Tail2.f_104203_ = 0.0f;
        this.Tail2.f_104204_ = 0.0f;
        this.Tail2.f_104205_ = 0.0f;
        this.RLeg1.f_104201_ = 5.0f;
        this.RLeg1.f_104203_ = 0.0f;
        this.RLeg1.f_104204_ = 0.0f;
        this.Neck.f_104203_ = 0.0f;
        this.Neck.f_104204_ = 0.0f;
        this.Head.f_104200_ = 0.0f;
        this.Head.f_104202_ = -1.0f;
        this.Head.f_104203_ = 0.0f;
        this.Head.f_104204_ = 0.0f;
        this.RLeg2.f_104203_ = 0.0f;
        this.RArm.f_104202_ = 3.0f;
        this.RArm.f_104203_ = 0.0f;
        this.Tail1.f_104200_ = 0.0f;
        this.Tail1.f_104202_ = 19.0f;
        this.Tail1.f_104203_ = 0.0f;
        this.Tail1.f_104204_ = 0.0f;
        this.Tail1.f_104205_ = 0.0f;
    }

    public void sleepPose() {
        this.LLeg2.f_104203_ = -0.4537856f;
        this.LLeg1.f_104203_ = -0.87266463f;
        this.LLeg1.f_104204_ = -0.29670596f;
        this.LLeg1.f_104201_ = 3.2f;
        this.LArm.f_104202_ = 2.5f;
        this.LArm.f_104203_ = 0.87266463f;
        this.LLeg3.f_104203_ = 1.5707964f;
        this.RLeg3.f_104203_ = 1.5707964f;
        this.Body.f_104201_ = 12.0f;
        this.Body.f_104203_ = -0.2443461f;
        this.Tail2.f_104200_ = 0.5f;
        this.Tail2.f_104202_ = 14.4f;
        this.Tail2.f_104203_ = 0.13962634f;
        this.Tail2.f_104204_ = -0.5934119f;
        this.Tail2.f_104205_ = -0.10471976f;
        this.RLeg1.f_104201_ = 3.2f;
        this.RLeg1.f_104203_ = -0.87266463f;
        this.RLeg1.f_104204_ = 0.29670596f;
        this.Neck.f_104203_ = 0.87266463f;
        this.Neck.f_104204_ = 0.9773844f;
        this.Head.f_104200_ = 0.5f;
        this.Head.f_104202_ = -1.5f;
        this.Head.f_104203_ = 0.55850536f;
        this.Head.f_104204_ = 1.3962634f;
        this.RLeg2.f_104203_ = -0.4537856f;
        this.RArm.f_104203_ = 0.87266463f;
        this.RArm.f_104202_ = 2.5f;
        this.Tail1.f_104200_ = 0.7f;
        this.Tail1.f_104202_ = 18.0f;
        this.Tail1.f_104203_ = 0.07853982f;
        this.Tail1.f_104204_ = -0.5934119f;
        this.Tail1.f_104205_ = -0.10471976f;
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.Body.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
    }
}

