/*
 * Decompiled with CFR 0.152.
 */
package superlord.prehistoricfauna.client.model.jurassic.morrison;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import superlord.prehistoricfauna.common.entity.DinosaurEntity;
import superlord.prehistoricfauna.common.entity.jurassic.morrison.Allosaurus;

public class AllosaurusModel
extends EntityModel<Allosaurus> {
    private final ModelPart LeftLeg1;
    private final ModelPart LeftLeg2;
    private final ModelPart LeftFoot;
    private final ModelPart RightLeg1;
    private final ModelPart RightLeg2;
    private final ModelPart RightFoot;
    private final ModelPart Body1;
    private final ModelPart Body2;
    private final ModelPart Tail1;
    private final ModelPart Tail2;
    private final ModelPart Neck;
    private final ModelPart Head1;
    private final ModelPart Jaw1;
    private final ModelPart LeftArm;
    private final ModelPart RightArm;

    public AllosaurusModel(ModelPart root) {
        this.LeftLeg1 = root.m_171324_("LeftLeg1");
        this.LeftLeg2 = this.LeftLeg1.m_171324_("LeftLeg2");
        this.LeftFoot = this.LeftLeg2.m_171324_("LeftFoot");
        this.RightLeg1 = root.m_171324_("RightLeg1");
        this.RightLeg2 = this.RightLeg1.m_171324_("RightLeg2");
        this.RightFoot = this.RightLeg2.m_171324_("RightFoot");
        this.Body1 = root.m_171324_("Body1");
        this.Body2 = this.Body1.m_171324_("Body2");
        this.Neck = this.Body2.m_171324_("Neck");
        this.Head1 = this.Neck.m_171324_("Head1");
        this.Jaw1 = this.Head1.m_171324_("Jaw1");
        this.Tail1 = this.Body1.m_171324_("Tail1");
        this.Tail2 = this.Tail1.m_171324_("Tail2");
        this.LeftArm = this.Body2.m_171324_("LeftArm");
        this.RightArm = this.Body2.m_171324_("RightArm");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition LeftLeg1 = partdefinition.m_171599_("LeftLeg1", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171480_().m_171488_(-8.0f, -3.0f, -6.0f, 8.0f, 22.0f, 14.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)-3.0f, (float)-13.5f, (float)3.0f, (float)-0.1f, (float)0.0f, (float)0.0f));
        PartDefinition LeftLeg2 = LeftLeg1.m_171599_("LeftLeg2", CubeListBuilder.m_171558_().m_171514_(44, 0).m_171488_(-3.5f, 0.0f, -3.0f, 7.0f, 20.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-4.0f, (float)15.0f, (float)6.0f, (float)0.1f, (float)0.0f, (float)0.0f));
        PartDefinition LeftFoot = LeftLeg2.m_171599_("LeftFoot", CubeListBuilder.m_171558_().m_171514_(72, 0).m_171488_(-4.0f, 0.0f, -11.0f, 8.0f, 3.0f, 11.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)19.0f, (float)2.0f));
        PartDefinition RightLeg1 = partdefinition.m_171599_("RightLeg1", CubeListBuilder.m_171558_().m_171514_(96, 0).m_171488_(0.0f, -3.0f, -6.0f, 8.0f, 22.0f, 14.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)3.0f, (float)-13.5f, (float)3.0f, (float)-0.1f, (float)0.0f, (float)0.0f));
        PartDefinition RightLeg2 = RightLeg1.m_171599_("RightLeg2", CubeListBuilder.m_171558_().m_171514_(140, 0).m_171488_(-3.5f, 1.0f, -3.0f, 7.0f, 20.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)4.0f, (float)14.0f, (float)6.0f, (float)0.1f, (float)0.0f, (float)0.0f));
        PartDefinition RightFoot = RightLeg2.m_171599_("RightFoot", CubeListBuilder.m_171558_().m_171514_(168, 0).m_171488_(-4.0f, 1.0f, -11.0f, 8.0f, 3.0f, 11.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)19.0f, (float)2.0f));
        PartDefinition Body1 = partdefinition.m_171599_("Body1", CubeListBuilder.m_171558_().m_171514_(144, 14).m_171488_(-7.5f, -5.0f, -11.0f, 15.0f, 23.0f, 24.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-16.0f, (float)3.0f));
        PartDefinition Body2 = Body1.m_171599_("Body2", CubeListBuilder.m_171558_().m_171514_(0, 59).m_171488_(-8.5f, -5.0f, -18.0f, 17.0f, 20.0f, 18.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)1.0f, (float)-11.0f));
        PartDefinition Neck = Body2.m_171599_("Neck", CubeListBuilder.m_171558_().m_171514_(210, 49).m_171488_(-3.5f, -21.0f, -12.0f, 7.0f, 22.0f, 12.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)9.0f, (float)-13.0f, (float)0.35f, (float)0.0f, (float)0.0f));
        PartDefinition Head1 = Neck.m_171599_("Head1", CubeListBuilder.m_171558_().m_171514_(198, 22).m_171488_(-5.0f, -7.0f, -7.0f, 10.0f, 7.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-14.0f, (float)-9.0f, (float)-0.2f, (float)0.0f, (float)0.0f));
        PartDefinition Jaw1 = Head1.m_171599_("Jaw1", CubeListBuilder.m_171558_().m_171514_(37, 29).m_171488_(-5.0f, 0.0f, -7.0f, 10.0f, 4.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition Head1_1 = Jaw1.m_171599_("Head1_1", CubeListBuilder.m_171558_().m_171514_(222, 36).m_171488_(-4.0f, -5.0f, -5.0f, 8.0f, 7.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition Jaw2 = Jaw1.m_171599_("Jaw2", CubeListBuilder.m_171558_().m_171514_(0, 36).m_171488_(-3.5f, -1.0f, -12.0f, 7.0f, 3.0f, 12.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)1.0f, (float)-7.0f));
        PartDefinition LowerTeeth = Jaw2.m_171599_("LowerTeeth", CubeListBuilder.m_171558_().m_171514_(52, 59).m_171488_(-2.0f, -1.5f, 0.0f, 4.0f, 3.0f, 10.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-0.5f, (float)-11.0f, (float)-0.0436f, (float)0.0f, (float)0.0f));
        PartDefinition LowerTeeth_1 = LowerTeeth.m_171599_("LowerTeeth_1", CubeListBuilder.m_171558_().m_171514_(64, 69).m_171488_(-1.5f, -1.5f, 0.0f, 3.0f, 1.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition Snout = Head1.m_171599_("Snout", CubeListBuilder.m_171558_().m_171514_(84, 59).m_171488_(-3.5f, -2.0f, -9.0f, 7.0f, 6.0f, 9.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-4.0f, (float)-7.0f));
        PartDefinition Snout2 = Snout.m_171599_("Snout2", CubeListBuilder.m_171558_().m_171514_(226, 0).m_171488_(-3.5f, -2.0f, -3.0f, 7.0f, 5.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)1.0f, (float)-9.0f));
        PartDefinition CrestLeft = Snout.m_171599_("CrestLeft", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171480_().m_171488_(-0.5f, -2.0f, -3.0f, 2.0f, 2.0f, 3.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)-3.0f, (float)-2.0f, (float)0.0f));
        PartDefinition CrestRight = Snout.m_171599_("CrestRight", CubeListBuilder.m_171558_().m_171514_(30, 0).m_171488_(0.0f, -2.0f, -3.0f, 2.0f, 2.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)1.5f, (float)-2.0f, (float)0.0f));
        PartDefinition UpperTeeth = Snout.m_171599_("UpperTeeth", CubeListBuilder.m_171558_().m_171514_(136, 61).m_171488_(-2.5f, -1.5f, 0.0f, 5.0f, 3.0f, 10.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)3.0f, (float)-11.0f, (float)0.0436f, (float)0.0f, (float)0.0f));
        PartDefinition RightArm = Body2.m_171599_("RightArm", CubeListBuilder.m_171558_().m_171514_(206, 0).m_171488_(0.0f, -2.0f, -3.0f, 4.0f, 16.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)5.5f, (float)11.5f, (float)-12.0f, (float)0.15f, (float)0.0f, (float)0.0f));
        PartDefinition LeftArm = Body2.m_171599_("LeftArm", CubeListBuilder.m_171558_().m_171514_(181, 61).m_171480_().m_171488_(-3.0f, -2.0f, -3.0f, 4.0f, 16.0f, 6.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)-6.5f, (float)11.5f, (float)-12.0f, (float)0.15f, (float)0.0f, (float)0.0f));
        PartDefinition Tail1 = Body1.m_171599_("Tail1", CubeListBuilder.m_171558_().m_171514_(40, 14).m_171488_(-5.0f, -4.0f, -3.0f, 10.0f, 13.0f, 32.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)13.0f, (float)-0.05f, (float)0.0f, (float)0.0f));
        PartDefinition Tail2 = Tail1.m_171599_("Tail2", CubeListBuilder.m_171558_().m_171514_(79, 36).m_171488_(-3.0f, -4.0f, -3.0f, 6.0f, 8.0f, 45.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)1.0f, (float)29.0f, (float)0.05f, (float)0.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)250, (int)125);
    }

    public void setupAnim(Allosaurus entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        float walkSpeed = 1.0f;
        float walkDegree = 0.5f;
        float idleSpeed = 1.0f;
        float idleDegree = 1.0f;
        float partialTick = ageInTicks - (float)entity.f_19797_;
        float attackProgress = entity.getMeleeProgress(partialTick);
        float leftOrRight = entity.getMeleeDirection() ? 1.0f : -1.0f;
        float sleepProgress = entity.getSleepProgress(partialTick);
        this.resetModel();
        if (entity.isAsleep()) {
            if (sleepProgress != 0.0f && (Integer)entity.m_20088_().m_135370_(DinosaurEntity.SLEEP_TICK) > 0) {
                this.Body2.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)0.07819075f);
                this.RightLeg2.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-0.89919364f);
                this.RightLeg2.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-0.50823987f);
                this.RightLeg2.f_104205_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)0.4691445f);
                this.LeftLeg2.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-0.86009824f);
                this.LeftLeg2.f_104201_ = Mth.m_14179_((float)sleepProgress, (float)14.0f, (float)13.0f);
                this.Tail1.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-0.43004912f);
                this.Tail1.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)0.19547687f);
                this.Head1.f_104201_ = Mth.m_14179_((float)sleepProgress, (float)-14.0f, (float)-15.0f);
                this.Head1.f_104202_ = Mth.m_14179_((float)sleepProgress, (float)-9.0f, (float)-7.0f);
                this.Head1.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-1.7201965f);
                this.Head1.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)0.039095376f);
                this.Head1.f_104205_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-0.07819075f);
                this.LeftLeg1.f_104200_ = Mth.m_14179_((float)sleepProgress, (float)-3.0f, (float)1.0f);
                this.LeftLeg1.f_104201_ = Mth.m_14179_((float)sleepProgress, (float)-13.5f, (float)0.0f);
                this.LeftLeg1.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-0.74281216f);
                this.LeftLeg1.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)0.23457225f);
                this.LeftFoot.f_104202_ = Mth.m_14179_((float)sleepProgress, (float)2.0f, (float)-3.0f);
                this.LeftFoot.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)1.6029103f);
                this.Neck.f_104201_ = Mth.m_14179_((float)sleepProgress, (float)9.0f, (float)-4.0f);
                this.Neck.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)1.6811011f);
                this.Neck.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)0.039095376f);
                this.Neck.f_104205_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)0.27366763f);
                this.Tail2.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-0.19547687f);
                this.Tail2.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)0.39095375f);
                this.Body1.f_104201_ = Mth.m_14179_((float)sleepProgress, (float)-16.0f, (float)6.0f);
                this.Body1.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)0.07819075f);
                this.Body1.f_104205_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-0.4691445f);
                this.RightFoot.f_104202_ = Mth.m_14179_((float)sleepProgress, (float)2.0f, (float)-3.0f);
                this.RightFoot.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)1.4465288f);
                this.RightFoot.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)0.27366763f);
                this.LeftArm.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-1.4856243f);
                this.LeftArm.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)0.39095375f);
                this.LeftArm.f_104205_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)0.35133475f);
                this.RightArm.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-0.35185838f);
                this.RightArm.f_104205_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-0.43004912f);
                this.RightLeg1.f_104200_ = Mth.m_14179_((float)sleepProgress, (float)3.0f, (float)3.0f);
                this.RightLeg1.f_104201_ = Mth.m_14179_((float)sleepProgress, (float)-13.5f, (float)9.0f);
                this.RightLeg1.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-0.54716074f);
                this.RightLeg1.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-0.35185838f);
                this.RightLeg1.f_104205_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-0.39095375f);
            } else {
                this.sleepPose();
            }
        } else if (sleepProgress != 0.0f && (Integer)entity.m_20088_().m_135370_(DinosaurEntity.SLEEP_TICK) > 0) {
            this.Body2.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.07819075f, (float)0.0f);
            this.RightLeg2.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)-0.89919364f, (float)0.0f);
            this.RightLeg2.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)-0.50823987f, (float)0.0f);
            this.RightLeg2.f_104205_ = Mth.m_14179_((float)sleepProgress, (float)0.4691445f, (float)0.0f);
            this.LeftLeg2.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)-0.86009824f, (float)0.0f);
            this.LeftLeg2.f_104201_ = Mth.m_14179_((float)sleepProgress, (float)13.0f, (float)14.0f);
            this.Tail1.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)-0.43004912f, (float)0.0f);
            this.Tail1.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)0.19547687f, (float)0.0f);
            this.Head1.f_104201_ = Mth.m_14179_((float)sleepProgress, (float)-15.0f, (float)-14.0f);
            this.Head1.f_104202_ = Mth.m_14179_((float)sleepProgress, (float)-7.0f, (float)-9.0f);
            this.Head1.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)-1.7201965f, (float)0.0f);
            this.Head1.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)0.039095376f, (float)0.0f);
            this.Head1.f_104205_ = Mth.m_14179_((float)sleepProgress, (float)-0.07819075f, (float)0.0f);
            this.LeftLeg1.f_104200_ = Mth.m_14179_((float)sleepProgress, (float)1.0f, (float)-3.0f);
            this.LeftLeg1.f_104201_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-13.5f);
            this.LeftLeg1.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)-0.74281216f, (float)0.0f);
            this.LeftLeg1.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)0.23457225f, (float)0.0f);
            this.LeftFoot.f_104202_ = Mth.m_14179_((float)sleepProgress, (float)-3.0f, (float)2.0f);
            this.LeftFoot.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)1.6029103f, (float)0.0f);
            this.Neck.f_104201_ = Mth.m_14179_((float)sleepProgress, (float)-4.0f, (float)9.0f);
            this.Neck.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)1.6811011f, (float)0.0f);
            this.Neck.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)0.039095376f, (float)0.0f);
            this.Neck.f_104205_ = Mth.m_14179_((float)sleepProgress, (float)0.27366763f, (float)0.0f);
            this.Tail2.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)-0.19547687f, (float)0.0f);
            this.Tail2.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)0.39095375f, (float)0.0f);
            this.Body1.f_104201_ = Mth.m_14179_((float)sleepProgress, (float)6.0f, (float)-16.0f);
            this.Body1.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.07819075f, (float)0.0f);
            this.Body1.f_104205_ = Mth.m_14179_((float)sleepProgress, (float)-0.4691445f, (float)0.0f);
            this.RightFoot.f_104202_ = Mth.m_14179_((float)sleepProgress, (float)-3.0f, (float)2.0f);
            this.RightFoot.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)1.4465288f, (float)0.0f);
            this.RightFoot.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)0.27366763f, (float)0.0f);
            this.LeftArm.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)-1.4856243f, (float)0.0f);
            this.LeftArm.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)0.39095375f, (float)0.0f);
            this.LeftArm.f_104205_ = Mth.m_14179_((float)sleepProgress, (float)0.35133475f, (float)0.0f);
            this.RightArm.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)-0.35185838f, (float)0.0f);
            this.RightArm.f_104205_ = Mth.m_14179_((float)sleepProgress, (float)-0.43004912f, (float)0.0f);
            this.RightLeg1.f_104200_ = Mth.m_14179_((float)sleepProgress, (float)3.0f, (float)3.0f);
            this.RightLeg1.f_104201_ = Mth.m_14179_((float)sleepProgress, (float)9.0f, (float)-13.5f);
            this.RightLeg1.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)-0.54716074f, (float)0.0f);
            this.RightLeg1.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)-0.35185838f, (float)0.0f);
            this.RightLeg1.f_104205_ = Mth.m_14179_((float)sleepProgress, (float)-0.39095375f, (float)0.0f);
        } else {
            this.Neck.f_104203_ = Mth.m_14089_((float)(-1.0f + limbSwing * walkSpeed * 0.3f)) * walkDegree * 0.3f * limbSwingAmount + 0.35f + headPitch * ((float)Math.PI / 180) + attackProgress * (float)Math.toRadians(30.0);
            this.Body2.f_104203_ = Mth.m_14089_((float)(1.0f + limbSwing * walkSpeed * 0.3f)) * walkDegree * 0.01f * limbSwingAmount;
            this.Body1.f_104203_ = Math.abs(-0.025f * Mth.m_14031_((float)(0.1f * ageInTicks / 3.0f))) + Mth.m_14089_((float)(1.0f + limbSwing * walkSpeed * 0.3f)) * walkDegree * 0.1f * limbSwingAmount;
            this.Tail1.f_104203_ = -Math.abs(-0.05f * Mth.m_14031_((float)(0.1f * ageInTicks / 5.0f))) + Mth.m_14089_((float)(limbSwing * walkSpeed * 0.3f)) * walkDegree * 0.1f * limbSwingAmount - 0.05f;
            this.Tail2.f_104203_ = -Math.abs(-0.05f * Mth.m_14031_((float)(0.1f * ageInTicks / 5.0f))) + Mth.m_14089_((float)(-1.0f + limbSwing * walkSpeed * 0.3f)) * walkDegree * 0.15f * limbSwingAmount + 0.05f;
            this.Tail1.f_104204_ = -0.12f * Mth.m_14031_((float)(0.2f * ageInTicks / 5.0f)) + Mth.m_14089_((float)(limbSwing * walkSpeed * 0.15f)) * walkDegree * 0.6f * limbSwingAmount;
            this.Tail2.f_104204_ = -0.12f * Mth.m_14031_((float)(0.2f * ageInTicks / 5.0f)) + Mth.m_14089_((float)(limbSwing * walkSpeed * 0.15f)) * walkDegree * 1.0f * limbSwingAmount;
            this.Head1.f_104203_ = Mth.m_14089_((float)(-1.0f + limbSwing * walkSpeed * 0.3f)) * walkDegree * 0.25f * limbSwingAmount - 0.2f + attackProgress * (float)Math.toRadians(-40.0);
            this.Jaw1.f_104203_ = attackProgress * (float)Math.toRadians(25.0);
            this.Neck.f_104205_ = attackProgress * leftOrRight * (float)Math.toRadians(15.0);
            this.Head1.f_104205_ = attackProgress * leftOrRight * (float)Math.toRadians(15.0);
            this.RightArm.f_104203_ = -Math.abs(-0.05f * Mth.m_14031_((float)(0.15f * ageInTicks / 3.0f))) + Mth.m_14089_((float)(limbSwing * walkSpeed * 0.3f)) * walkDegree * 0.2f * limbSwingAmount + 0.15f;
            this.LeftArm.f_104203_ = Math.abs(-0.05f * Mth.m_14031_((float)(0.15f * ageInTicks / 3.0f))) + Mth.m_14089_((float)(2.0f + limbSwing * walkSpeed * 0.3f)) * walkDegree * 0.2f * limbSwingAmount + 0.15f;
            this.RightLeg1.f_104203_ = Mth.m_14089_((float)(1.0f + limbSwing * idleSpeed * 0.3f)) * idleDegree * 0.6f * limbSwingAmount - 0.05f + Mth.m_14089_((float)(1.0f + limbSwing * walkSpeed * 0.3f)) * walkDegree * 0.6f * limbSwingAmount - 0.05f;
            this.RightLeg2.f_104203_ = Mth.m_14089_((float)(1.0f + limbSwing * idleSpeed * 0.3f)) * idleDegree * 0.4f * limbSwingAmount + 0.05f + Mth.m_14089_((float)(1.0f + limbSwing * walkSpeed * 0.3f)) * walkDegree * 0.4f * limbSwingAmount + 0.05f;
            this.RightFoot.f_104203_ = Mth.m_14089_((float)(2.0f + limbSwing * idleSpeed * 0.3f)) * idleDegree * 0.3f * limbSwingAmount + Mth.m_14089_((float)(2.0f + limbSwing * walkSpeed * 0.3f)) * walkDegree * 0.3f * limbSwingAmount;
            this.LeftLeg1.f_104203_ = Mth.m_14089_((float)(1.0f + limbSwing * idleSpeed * 0.3f)) * idleDegree * -0.6f * limbSwingAmount - 0.05f + Mth.m_14089_((float)(1.0f + limbSwing * walkSpeed * 0.3f)) * walkDegree * -0.6f * limbSwingAmount - 0.05f;
            this.LeftLeg2.f_104203_ = Mth.m_14089_((float)(1.0f + limbSwing * idleSpeed * 0.3f)) * idleDegree * -0.4f * limbSwingAmount + 0.05f + Mth.m_14089_((float)(1.0f + limbSwing * walkSpeed * 0.3f)) * walkDegree * -0.4f * limbSwingAmount + 0.05f;
            this.LeftFoot.f_104203_ = Mth.m_14089_((float)(2.0f + limbSwing * idleSpeed * 0.3f)) * idleDegree * -0.3f * limbSwingAmount + Mth.m_14089_((float)(2.0f + limbSwing * walkSpeed * 0.3f)) * walkDegree * -0.3f * limbSwingAmount;
            this.Neck.f_104204_ = netHeadYaw * ((float)Math.PI / 180);
            if (entity.m_20069_()) {
                this.RightLeg1.f_104201_ = 20.0f;
                this.LeftLeg1.f_104201_ = 20.0f;
                this.Body1.f_104201_ = 17.0f;
                this.Body1.f_104203_ = -0.125f;
                this.Tail1.f_104203_ = 0.0625f;
                this.Tail2.f_104203_ = 0.0625f;
                this.Neck.f_104203_ = 0.25f;
                this.RightLeg1.f_104203_ = -0.25f * Mth.m_14031_((float)(0.2f * ageInTicks / 1.5f));
                this.LeftLeg1.f_104203_ = 0.25f * Mth.m_14031_((float)(0.2f * ageInTicks / 1.5f));
                this.LeftArm.f_104203_ = 0.125f;
                this.RightArm.f_104203_ = 0.125f;
                this.RightLeg2.f_104203_ = -0.3f * Mth.m_14031_((float)(0.2f * ageInTicks / 1.5f));
                this.LeftLeg2.f_104203_ = 0.3f * Mth.m_14031_((float)(0.2f * ageInTicks / 1.5f));
                this.RightFoot.f_104203_ = 0.5f - 0.3f * Mth.m_14031_((float)(0.2f * ageInTicks / 1.5f));
                this.LeftFoot.f_104203_ = 0.5f + 0.3f * Mth.m_14031_((float)(0.2f * ageInTicks / 1.5f));
                this.Tail1.f_104204_ = Mth.m_14089_((float)(limbSwing * 2.6662f)) * 1.4f * limbSwingAmount + 0.0625f * Mth.m_14031_((float)(0.15f * ageInTicks / 1.5f));
                this.Tail2.f_104204_ = Mth.m_14089_((float)(limbSwing * 2.6662f)) * 1.4f * limbSwingAmount + 0.0625f * Mth.m_14031_((float)(0.15f * ageInTicks / 1.5f));
            }
        }
    }

    public void resetModel() {
        this.Body2.f_104203_ = 0.0f;
        this.RightLeg2.f_104203_ = 0.0f;
        this.RightLeg2.f_104204_ = 0.0f;
        this.RightLeg2.f_104205_ = 0.0f;
        this.LeftLeg2.f_104203_ = 0.0f;
        this.LeftLeg2.f_104201_ = 14.0f;
        this.Tail1.f_104203_ = 0.0f;
        this.Tail1.f_104204_ = 0.0f;
        this.Head1.f_104201_ = -14.0f;
        this.Head1.f_104202_ = -9.0f;
        this.Head1.f_104203_ = 0.0f;
        this.Head1.f_104204_ = 0.0f;
        this.Head1.f_104205_ = 0.0f;
        this.LeftLeg1.f_104200_ = -3.0f;
        this.LeftLeg1.f_104201_ = -13.5f;
        this.LeftLeg1.f_104203_ = 0.0f;
        this.LeftLeg1.f_104204_ = 0.0f;
        this.LeftFoot.f_104202_ = 2.0f;
        this.LeftFoot.f_104203_ = 0.0f;
        this.Neck.f_104201_ = 9.0f;
        this.Neck.f_104202_ = -13.0f;
        this.Neck.f_104203_ = 0.0f;
        this.Neck.f_104204_ = 0.0f;
        this.Neck.f_104205_ = 0.0f;
        this.Tail2.f_104203_ = 0.0f;
        this.Tail2.f_104204_ = 0.0f;
        this.Body1.f_104201_ = -16.0f;
        this.Body1.f_104203_ = 0.0f;
        this.Body1.f_104205_ = 0.0f;
        this.RightFoot.f_104202_ = 2.0f;
        this.RightFoot.f_104203_ = 0.0f;
        this.RightFoot.f_104204_ = 0.0f;
        this.LeftArm.f_104203_ = 0.0f;
        this.LeftArm.f_104204_ = 0.0f;
        this.LeftArm.f_104205_ = 0.0f;
        this.RightArm.f_104203_ = 0.0f;
        this.RightArm.f_104205_ = 0.0f;
        this.RightLeg1.f_104200_ = 3.0f;
        this.RightLeg1.f_104201_ = -13.5f;
        this.RightLeg1.f_104203_ = 0.0f;
        this.RightLeg1.f_104204_ = 0.0f;
        this.RightLeg1.f_104205_ = 0.0f;
    }

    public void sleepPose() {
        this.Body2.f_104203_ = 0.07819075f;
        this.RightLeg2.f_104203_ = -0.89919364f;
        this.RightLeg2.f_104204_ = -0.50823987f;
        this.RightLeg2.f_104205_ = 0.4691445f;
        this.LeftLeg2.f_104203_ = -0.86009824f;
        this.LeftLeg2.f_104201_ = 13.0f;
        this.Tail1.f_104203_ = -0.43004912f;
        this.Tail1.f_104204_ = 0.19547687f;
        this.Head1.f_104201_ = -15.0f;
        this.Head1.f_104202_ = -7.0f;
        this.Head1.f_104203_ = -1.7201965f;
        this.Head1.f_104204_ = 0.039095376f;
        this.Head1.f_104205_ = -0.07819075f;
        this.LeftLeg1.f_104200_ = 1.0f;
        this.LeftLeg1.f_104201_ = 10.0f;
        this.LeftLeg1.f_104203_ = -0.74281216f;
        this.LeftLeg1.f_104204_ = 0.23457225f;
        this.LeftFoot.f_104202_ = -3.0f;
        this.LeftFoot.f_104203_ = 1.6029103f;
        this.Neck.f_104201_ = -4.0f;
        this.Neck.f_104203_ = 1.6811011f;
        this.Neck.f_104204_ = 0.039095376f;
        this.Neck.f_104205_ = 0.27366763f;
        this.Tail2.f_104203_ = -0.19547687f;
        this.Tail2.f_104204_ = 0.39095375f;
        this.Body1.f_104201_ = 6.0f;
        this.Body1.f_104203_ = 0.07819075f;
        this.Body1.f_104205_ = -0.4691445f;
        this.RightFoot.f_104202_ = -3.0f;
        this.RightFoot.f_104203_ = 1.4465288f;
        this.RightFoot.f_104204_ = 0.27366763f;
        this.LeftArm.f_104203_ = -1.4856243f;
        this.LeftArm.f_104204_ = 0.39095375f;
        this.LeftArm.f_104205_ = 0.35133475f;
        this.RightArm.f_104203_ = -0.35185838f;
        this.RightArm.f_104205_ = -0.43004912f;
        this.RightLeg1.f_104200_ = 3.0f;
        this.RightLeg1.f_104201_ = 9.0f;
        this.RightLeg1.f_104203_ = -0.54716074f;
        this.RightLeg1.f_104204_ = -0.35185838f;
        this.RightLeg1.f_104205_ = -0.39095375f;
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.LeftLeg1.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.RightLeg1.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.Body1.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
    }
}

