/*
 * Decompiled with CFR 0.152.
 */
package superlord.prehistoricfauna.client.model.jurassic.kayenta;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import superlord.prehistoricfauna.common.entity.DinosaurEntity;
import superlord.prehistoricfauna.common.entity.jurassic.kayenta.Sarahsaurus;

public class SarahsaurusModel
extends EntityModel<Sarahsaurus> {
    private final ModelPart Body;
    private final ModelPart Neck1;
    private final ModelPart Neck2;
    private final ModelPart Head;
    private final ModelPart Tail1;
    private final ModelPart Tail2;
    private final ModelPart LArm;
    private final ModelPart RArm;
    private final ModelPart LLeg1;
    private final ModelPart LLeg2;
    private final ModelPart LFoot;
    private final ModelPart RLeg1;
    private final ModelPart RLeg2;
    private final ModelPart RFoot;

    public SarahsaurusModel(ModelPart root) {
        this.Body = root.m_171324_("Body");
        this.Neck1 = this.Body.m_171324_("Neck1");
        this.Neck2 = this.Neck1.m_171324_("Neck2");
        this.Head = this.Neck2.m_171324_("Head");
        this.Tail1 = this.Body.m_171324_("Tail1");
        this.Tail2 = this.Tail1.m_171324_("Tail2");
        this.LArm = this.Body.m_171324_("LArm");
        this.RArm = this.Body.m_171324_("RArm");
        this.LLeg1 = this.Body.m_171324_("LLeg1");
        this.LLeg2 = this.LLeg1.m_171324_("LLeg2");
        this.LFoot = this.LLeg2.m_171324_("LFoot");
        this.RLeg1 = this.Body.m_171324_("RLeg1");
        this.RLeg2 = this.RLeg1.m_171324_("RLeg2");
        this.RFoot = this.RLeg2.m_171324_("RFoot");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition Body = partdefinition.m_171599_("Body", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-4.0f, 0.0f, -12.0f, 8.0f, 9.0f, 18.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)6.0f, (float)3.0f));
        PartDefinition Tail1 = Body.m_171599_("Tail1", CubeListBuilder.m_171558_().m_171514_(0, 27).m_171488_(-2.0f, 0.0f, 0.0f, 4.0f, 7.0f, 14.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.01f, (float)4.0f));
        PartDefinition Tail2 = Tail1.m_171599_("Tail2", CubeListBuilder.m_171558_().m_171514_(18, 30).m_171488_(-1.0f, 0.0f, 0.0f, 2.0f, 4.0f, 18.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)1.0f, (float)13.0f));
        PartDefinition RLeg1 = Body.m_171599_("RLeg1", CubeListBuilder.m_171558_().m_171514_(0, 48).m_171488_(-1.0f, -2.0f, -3.0f, 4.0f, 10.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)3.0f, (float)4.0f, (float)1.0f));
        PartDefinition RLeg2 = RLeg1.m_171599_("RLeg2", CubeListBuilder.m_171558_().m_171514_(8, 31).m_171488_(-1.5f, 0.0f, 0.0f, 3.0f, 6.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.5f, (float)8.0f, (float)4.0f));
        PartDefinition RFoot = RLeg2.m_171599_("RFoot", CubeListBuilder.m_171558_().m_171514_(0, 27).m_171480_().m_171488_(-1.6f, 0.0f, -4.0f, 3.0f, 0.0f, 4.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)0.0f, (float)6.0f, (float)0.0f));
        PartDefinition LArm = Body.m_171599_("LArm", CubeListBuilder.m_171558_().m_171514_(52, 13).m_171488_(-2.0f, -1.0f, -1.5f, 2.0f, 8.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-3.0f, (float)6.0f, (float)-8.5f));
        PartDefinition RArm = Body.m_171599_("RArm", CubeListBuilder.m_171558_().m_171514_(22, 52).m_171480_().m_171488_(0.0f, -1.0f, -1.5f, 2.0f, 8.0f, 3.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)3.0f, (float)6.0f, (float)-8.5f));
        PartDefinition LLeg1 = Body.m_171599_("LLeg1", CubeListBuilder.m_171558_().m_171514_(40, 27).m_171480_().m_171488_(-3.0f, -2.0f, -3.0f, 4.0f, 10.0f, 7.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)-3.0f, (float)4.0f, (float)1.0f));
        PartDefinition LLeg2 = LLeg1.m_171599_("LLeg2", CubeListBuilder.m_171558_().m_171514_(8, 31).m_171480_().m_171488_(-1.5f, 0.0f, 0.0f, 3.0f, 6.0f, 0.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)-0.5f, (float)8.0f, (float)4.0f));
        PartDefinition LFoot = LLeg2.m_171599_("LFoot", CubeListBuilder.m_171558_().m_171514_(0, 27).m_171480_().m_171488_(-1.6f, 0.0f, -4.0f, 3.0f, 0.0f, 4.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)0.0f, (float)6.0f, (float)0.0f));
        PartDefinition Neck1 = Body.m_171599_("Neck1", CubeListBuilder.m_171558_().m_171514_(34, 0).m_171488_(-2.0f, 0.0f, -8.0f, 4.0f, 4.0f, 9.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)1.0f, (float)-11.0f));
        PartDefinition Neck2 = Neck1.m_171599_("Neck2", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-2.0f, -7.0f, 0.0f, 4.0f, 7.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)-8.0f));
        PartDefinition Collar = Neck2.m_171599_("Collar", CubeListBuilder.m_171558_().m_171514_(32, 67).m_171488_(-4.0f, 0.0f, 0.0f, 4.0f, 6.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)2.0f, (float)-2.0f, (float)-0.5f));
        PartDefinition Head = Neck2.m_171599_("Head", CubeListBuilder.m_171558_().m_171514_(0, 10).m_171488_(-2.0f, 0.0f, -5.0f, 4.0f, 3.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-7.0f, (float)0.0f));
        PartDefinition Feathers = Head.m_171599_("Feathers", CubeListBuilder.m_171558_().m_171514_(37, 48).m_171480_().m_171488_(0.0f, 0.0f, 0.0f, 0.0f, 6.0f, 8.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)0.0f, (float)-5.0f, (float)-1.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)80);
    }

    public void setupAnim(Sarahsaurus entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        float partialTick = ageInTicks - (float)entity.f_19797_;
        float attackProgress = entity.getMeleeProgress(partialTick);
        float sleepProgress = entity.getSleepProgress(partialTick);
        this.resetModel();
        if (entity.isAsleep()) {
            if (sleepProgress != 0.0f && (Integer)entity.m_20088_().m_135370_(DinosaurEntity.SLEEP_TICK) > 0) {
                this.LArm.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-0.23457225f);
                this.LArm.f_104205_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)0.8210029f);
                this.Head.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-1.8374826f);
                this.RArm.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-0.23457225f);
                this.RArm.f_104205_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-0.8210029f);
                this.RFoot.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)1.5707964f);
                this.RLeg1.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-1.0164797f);
                this.RLeg1.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-0.23457225f);
                this.Tail1.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-0.1563815f);
                this.Tail1.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)0.11728612f);
                this.LLeg2.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-0.54733527f);
                this.LLeg2.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)0.07819075f);
                this.LLeg2.f_104205_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)0.07819075f);
                this.RLeg2.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-0.54733527f);
                this.RLeg2.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-0.07819075f);
                this.RLeg2.f_104205_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-0.07819075f);
                this.LLeg1.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-1.0164797f);
                this.LLeg1.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)0.23457225f);
                this.Tail2.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)0.07819075f);
                this.Tail2.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)0.39095375f);
                this.Neck1.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)0.4691445f);
                this.Neck1.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-0.43004912f);
                this.Neck2.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)1.3683381f);
                this.LFoot.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)1.5707964f);
                this.Body.f_104201_ = Mth.m_14179_((float)sleepProgress, (float)6.0f, (float)15.0f);
                this.Head.f_104202_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)3.0f);
                this.Head.f_104201_ = Mth.m_14179_((float)sleepProgress, (float)-7.0f, (float)-6.0f);
                this.RLeg2.f_104200_ = Mth.m_14179_((float)sleepProgress, (float)0.5f, (float)1.5f);
                this.RLeg2.f_104202_ = Mth.m_14179_((float)sleepProgress, (float)4.0f, (float)0.8f);
                this.LLeg2.f_104200_ = Mth.m_14179_((float)sleepProgress, (float)-0.5f, (float)-1.5f);
                this.LLeg2.f_104202_ = Mth.m_14179_((float)sleepProgress, (float)4.0f, (float)0.8f);
                this.RArm.f_104201_ = Mth.m_14179_((float)sleepProgress, (float)6.0f, (float)5.5f);
                this.LArm.f_104201_ = Mth.m_14179_((float)sleepProgress, (float)6.0f, (float)5.5f);
                this.Neck2.f_104201_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)3.0f);
            } else {
                this.sleepPose();
            }
        } else if (sleepProgress != 0.0f && (Integer)entity.m_20088_().m_135370_(DinosaurEntity.SLEEP_TICK) > 0) {
            this.LArm.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)-0.23457225f, (float)0.0f);
            this.LArm.f_104205_ = Mth.m_14179_((float)sleepProgress, (float)0.8210029f, (float)0.0f);
            this.Head.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)-1.8374826f, (float)0.0f);
            this.RArm.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)-0.23457225f, (float)0.0f);
            this.RArm.f_104205_ = Mth.m_14179_((float)sleepProgress, (float)-0.8210029f, (float)0.0f);
            this.RFoot.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)1.5707964f, (float)0.0f);
            this.RLeg1.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)-1.0164797f, (float)0.0f);
            this.RLeg1.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)-0.23457225f, (float)0.0f);
            this.Tail1.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)-0.1563815f, (float)0.0f);
            this.Tail1.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)0.11728612f, (float)0.0f);
            this.LLeg2.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)-0.54733527f, (float)0.0f);
            this.LLeg2.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)0.07819075f, (float)0.0f);
            this.LLeg2.f_104205_ = Mth.m_14179_((float)sleepProgress, (float)0.07819075f, (float)0.0f);
            this.RLeg2.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)-0.54733527f, (float)0.0f);
            this.RLeg2.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)-0.07819075f, (float)0.0f);
            this.RLeg2.f_104205_ = Mth.m_14179_((float)sleepProgress, (float)-0.07819075f, (float)0.0f);
            this.LLeg1.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)-1.0164797f, (float)0.0f);
            this.LLeg1.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)0.23457225f, (float)0.0f);
            this.Tail2.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.07819075f, (float)0.0f);
            this.Tail2.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)0.39095375f, (float)0.0f);
            this.Neck1.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.4691445f, (float)0.0f);
            this.Neck1.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)-0.43004912f, (float)0.0f);
            this.Neck2.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)1.3683381f, (float)0.0f);
            this.LFoot.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)1.5707964f, (float)0.0f);
            this.Body.f_104201_ = Mth.m_14179_((float)sleepProgress, (float)15.0f, (float)6.0f);
            this.Head.f_104202_ = Mth.m_14179_((float)sleepProgress, (float)3.0f, (float)0.0f);
            this.Head.f_104201_ = Mth.m_14179_((float)sleepProgress, (float)-6.0f, (float)-7.0f);
            this.RLeg2.f_104200_ = Mth.m_14179_((float)sleepProgress, (float)1.5f, (float)0.5f);
            this.RLeg2.f_104202_ = Mth.m_14179_((float)sleepProgress, (float)0.8f, (float)4.0f);
            this.LLeg2.f_104200_ = Mth.m_14179_((float)sleepProgress, (float)-1.5f, (float)-0.5f);
            this.LLeg2.f_104202_ = Mth.m_14179_((float)sleepProgress, (float)0.8f, (float)4.0f);
            this.RArm.f_104201_ = Mth.m_14179_((float)sleepProgress, (float)5.5f, (float)6.0f);
            this.LArm.f_104201_ = Mth.m_14179_((float)sleepProgress, (float)5.5f, (float)6.0f);
            this.Neck2.f_104201_ = Mth.m_14179_((float)sleepProgress, (float)3.0f, (float)0.0f);
        } else {
            this.LLeg1.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
            this.RLeg1.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
            this.Tail1.f_104204_ = -0.12f * Mth.m_14031_((float)(0.2f * ageInTicks / 5.0f));
            this.Tail2.f_104204_ = -0.12f * Mth.m_14031_((float)(0.2f * ageInTicks / 5.0f));
            this.Tail1.f_104203_ = -Math.abs(-0.05f * Mth.m_14031_((float)(0.1f * ageInTicks / 5.0f)));
            this.Tail2.f_104203_ = -Math.abs(-0.05f * Mth.m_14031_((float)(0.1f * ageInTicks / 5.0f)));
            this.Neck1.f_104203_ = headPitch * ((float)Math.PI / 180) + Math.abs(-0.025f * Mth.m_14031_((float)(0.1f * ageInTicks / 3.0f))) + attackProgress * (float)Math.toRadians(45.0);
            this.RArm.f_104205_ = Math.abs(-0.05f * Mth.m_14031_((float)(0.15f * ageInTicks / 3.0f)));
            this.LArm.f_104205_ = -Math.abs(-0.05f * Mth.m_14031_((float)(0.15f * ageInTicks / 3.0f)));
            this.Neck1.f_104204_ = netHeadYaw * ((float)Math.PI / 180);
            this.Head.f_104203_ = attackProgress * (float)Math.toRadians(-15.0);
            if (entity.isEating()) {
                this.Neck1.f_104203_ = Math.abs(Mth.m_14031_((float)(0.05f * ageInTicks)) * 0.75f) + 1.2f;
            }
            if (entity.m_20069_()) {
                this.Body.f_104201_ = 15.0f;
                this.Body.f_104203_ = -0.25f;
                this.Tail1.f_104203_ = 0.125f;
                this.Tail2.f_104203_ = 0.125f;
                this.Neck1.f_104203_ = 0.25f;
                this.RLeg1.f_104203_ = -0.25f * Mth.m_14031_((float)(0.2f * ageInTicks / 1.5f));
                this.LLeg1.f_104203_ = 0.25f * Mth.m_14031_((float)(0.2f * ageInTicks / 1.5f));
                this.LArm.f_104203_ = 0.25f;
                this.RArm.f_104203_ = 0.25f;
                this.RLeg2.f_104203_ = -0.3f * Mth.m_14031_((float)(0.2f * ageInTicks / 1.5f));
                this.LLeg2.f_104203_ = 0.3f * Mth.m_14031_((float)(0.2f * ageInTicks / 1.5f));
                this.Tail1.f_104204_ = Mth.m_14089_((float)(limbSwing * 2.6662f)) * 1.4f * limbSwingAmount + 0.0625f * Mth.m_14031_((float)(0.15f * ageInTicks / 1.5f));
                this.Tail2.f_104204_ = Mth.m_14089_((float)(limbSwing * 2.6662f)) * 1.4f * limbSwingAmount + 0.0625f * Mth.m_14031_((float)(0.15f * ageInTicks / 1.5f));
            }
        }
    }

    public void resetModel() {
        this.LArm.f_104203_ = 0.0f;
        this.LArm.f_104205_ = 0.0f;
        this.Head.f_104203_ = 0.0f;
        this.RArm.f_104203_ = 0.0f;
        this.RArm.f_104205_ = 0.0f;
        this.RFoot.f_104203_ = 0.0f;
        this.RFoot.f_104201_ = 6.0f;
        this.RLeg1.f_104203_ = 0.0f;
        this.RLeg1.f_104204_ = 0.0f;
        this.Tail1.f_104203_ = 0.0f;
        this.Tail1.f_104204_ = 0.0f;
        this.LLeg2.f_104203_ = 0.0f;
        this.LLeg2.f_104204_ = 0.0f;
        this.LLeg2.f_104205_ = 0.0f;
        this.RLeg2.f_104203_ = 0.0f;
        this.RLeg2.f_104204_ = 0.0f;
        this.RLeg2.f_104205_ = 0.0f;
        this.LLeg2.f_104200_ = -0.5f;
        this.RLeg2.f_104200_ = 0.5f;
        this.LLeg1.f_104203_ = 0.0f;
        this.LLeg1.f_104204_ = 0.0f;
        this.Tail2.f_104203_ = 0.0f;
        this.Tail2.f_104204_ = 0.0f;
        this.Neck1.f_104203_ = 0.0f;
        this.Neck1.f_104204_ = 0.0f;
        this.Neck2.f_104203_ = 0.0f;
        this.Neck2.f_104201_ = 0.0f;
        this.LFoot.f_104203_ = 0.0f;
        this.Body.f_104201_ = 6.0f;
        this.Head.f_104202_ = 0.0f;
        this.Head.f_104201_ = -7.0f;
        this.RLeg2.f_104202_ = 4.0f;
        this.LLeg2.f_104202_ = 4.0f;
        this.RArm.f_104201_ = 6.0f;
        this.LArm.f_104201_ = 6.0f;
        this.Body.f_104203_ = 0.0f;
    }

    public void sleepPose() {
        this.LArm.f_104203_ = -0.23457225f;
        this.LArm.f_104205_ = 0.8210029f;
        this.Head.f_104203_ = -1.8374826f;
        this.RArm.f_104203_ = -0.23457225f;
        this.RArm.f_104205_ = -0.8210029f;
        this.RFoot.f_104203_ = 1.5707964f;
        this.RLeg1.f_104203_ = -1.0164797f;
        this.RLeg1.f_104204_ = -0.23457225f;
        this.Tail1.f_104203_ = -0.1563815f;
        this.Tail1.f_104204_ = 0.11728612f;
        this.LLeg2.f_104203_ = -0.54733527f;
        this.LLeg2.f_104204_ = 0.07819075f;
        this.LLeg2.f_104205_ = 0.07819075f;
        this.LLeg2.f_104200_ = -1.5f;
        this.RLeg2.f_104203_ = -0.54733527f;
        this.RLeg2.f_104204_ = -0.07819075f;
        this.RLeg2.f_104205_ = -0.07819075f;
        this.RLeg2.f_104200_ = 1.5f;
        this.LLeg1.f_104203_ = -1.0164797f;
        this.LLeg1.f_104204_ = 0.23457225f;
        this.Tail2.f_104203_ = 0.07819075f;
        this.Tail2.f_104204_ = 0.39095375f;
        this.Neck1.f_104203_ = 0.4691445f;
        this.Neck1.f_104204_ = -0.43004912f;
        this.Neck2.f_104203_ = 1.3683381f;
        this.Neck2.f_104201_ = 3.0f;
        this.LFoot.f_104203_ = 1.5707964f;
        this.Body.f_104201_ = 15.0f;
        this.Head.f_104202_ = 3.0f;
        this.Head.f_104201_ = -6.0f;
        this.RLeg2.f_104202_ = 0.8f;
        this.LLeg2.f_104202_ = 0.8f;
        this.RArm.f_104201_ = 5.5f;
        this.LArm.f_104201_ = 5.5f;
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.Body.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
    }
}

