/*
 * Decompiled with CFR 0.152.
 */
package superlord.prehistoricfauna.client.model.jurassic.kayenta;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import superlord.prehistoricfauna.common.entity.DinosaurEntity;
import superlord.prehistoricfauna.common.entity.jurassic.kayenta.Megapnosaurus;

public class MegapnosaurusModel
extends EntityModel<Megapnosaurus> {
    private final ModelPart Body;
    private final ModelPart Neck;
    private final ModelPart Head;
    private final ModelPart Tail;
    private final ModelPart Tail2;
    private final ModelPart ArmRight;
    private final ModelPart ArmLeft;
    private final ModelPart Leg_1;
    private final ModelPart Leg2_1;
    private final ModelPart Leg;
    private final ModelPart Leg2;

    public MegapnosaurusModel(ModelPart root) {
        this.Body = root.m_171324_("Body");
        this.Neck = this.Body.m_171324_("Neck");
        this.Head = this.Neck.m_171324_("Head");
        this.Tail = this.Body.m_171324_("Tail");
        this.Tail2 = this.Tail.m_171324_("Tail2");
        this.ArmRight = this.Body.m_171324_("ArmRight");
        this.ArmLeft = this.Body.m_171324_("ArmLeft");
        this.Leg_1 = root.m_171324_("Leg_1");
        this.Leg2_1 = this.Leg_1.m_171324_("Leg2_1");
        this.Leg = root.m_171324_("Leg");
        this.Leg2 = this.Leg.m_171324_("Leg2");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition Body = partdefinition.m_171599_("Body", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-1.5f, -2.0f, -10.0f, 3.0f, 4.0f, 12.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)15.0f, (float)3.0f));
        PartDefinition Neck = Body.m_171599_("Neck", CubeListBuilder.m_171558_().m_171514_(0, 17).m_171488_(-0.5f, -5.0f, -2.0f, 1.0f, 6.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)-9.0f));
        PartDefinition Head = Neck.m_171599_("Head", CubeListBuilder.m_171558_().m_171514_(0, 25).m_171488_(-0.5f, -1.0f, -4.0f, 1.0f, 2.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-4.0f, (float)-2.0f));
        PartDefinition Snout = Head.m_171599_("Snout", CubeListBuilder.m_171558_().m_171514_(0, 32).m_171488_(-0.5f, -1.0f, -2.5f, 1.0f, 1.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-1.0f, (float)-0.9f));
        PartDefinition Tail = Body.m_171599_("Tail", CubeListBuilder.m_171558_().m_171514_(21, 0).m_171488_(-1.0f, -1.0f, 0.0f, 2.0f, 2.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-1.0f, (float)2.0f));
        PartDefinition Tail2 = Tail.m_171599_("Tail2", CubeListBuilder.m_171558_().m_171514_(36, 0).m_171488_(-0.5f, -0.5f, 0.0f, 1.0f, 1.0f, 12.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-0.5f, (float)6.0f));
        PartDefinition ArmLeft = Body.m_171599_("ArmLeft", CubeListBuilder.m_171558_().m_171514_(42, 17).m_171480_().m_171488_(0.0f, -1.0f, -0.5f, 1.0f, 6.0f, 1.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)0.7f, (float)1.0f, (float)-7.5f));
        PartDefinition ArmRight = Body.m_171599_("ArmRight", CubeListBuilder.m_171558_().m_171514_(37, 17).m_171480_().m_171488_(-1.0f, -1.0f, -0.5f, 1.0f, 6.0f, 1.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)-0.7f, (float)1.0f, (float)-7.5f));
        PartDefinition Leg_1 = partdefinition.m_171599_("Leg_1", CubeListBuilder.m_171558_().m_171514_(26, 17).m_171480_().m_171488_(0.0f, -2.0f, -1.5f, 2.0f, 5.0f, 3.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)0.0f, (float)15.5f, (float)2.5f));
        PartDefinition Leg2_1 = Leg_1.m_171599_("Leg2_1", CubeListBuilder.m_171558_().m_171514_(27, 27).m_171480_().m_171488_(-2.0f, 0.0f, -3.0f, 3.0f, 6.0f, 3.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)1.5f, (float)2.5f, (float)1.49f));
        PartDefinition Leg = partdefinition.m_171599_("Leg", CubeListBuilder.m_171558_().m_171514_(14, 17).m_171480_().m_171488_(-2.0f, -2.0f, -1.5f, 2.0f, 5.0f, 3.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)0.0f, (float)15.5f, (float)2.5f));
        PartDefinition Leg2 = Leg.m_171599_("Leg2", CubeListBuilder.m_171558_().m_171514_(14, 27).m_171480_().m_171488_(-1.0f, 0.0f, -3.0f, 3.0f, 6.0f, 3.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)-1.5f, (float)2.5f, (float)1.49f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)80, (int)50);
    }

    public void setupAnim(Megapnosaurus entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        float partialTick = ageInTicks - (float)entity.f_19797_;
        float attackProgress = entity.getMeleeProgress(partialTick);
        float sleepProgress = entity.getSleepProgress(partialTick);
        this.resetModel();
        if (entity.isAsleep()) {
            if (sleepProgress != 0.0f && (Integer)entity.m_20088_().m_135370_(DinosaurEntity.SLEEP_TICK) > 0) {
                this.Tail.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-0.23457225f);
                this.Tail.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)0.39095375f);
                this.Tail.f_104202_ = Mth.m_14179_((float)sleepProgress, (float)2.0f, (float)1.0f);
                this.Leg2_1.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)1.4074335f);
                this.Leg2_1.f_104200_ = Mth.m_14179_((float)sleepProgress, (float)1.5f, (float)1.2f);
                this.Leg2_1.f_104201_ = Mth.m_14179_((float)sleepProgress, (float)2.5f, (float)4.5f);
                this.Leg2_1.f_104202_ = Mth.m_14179_((float)sleepProgress, (float)1.49f, (float)1.5f);
                this.Leg.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-1.4074335f);
                this.Leg.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)0.39095375f);
                this.Leg.f_104201_ = Mth.m_14179_((float)sleepProgress, (float)15.5f, (float)22.5f);
                this.Leg.f_104202_ = Mth.m_14179_((float)sleepProgress, (float)2.5f, (float)2.2f);
                this.ArmRight.f_104205_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)1.1339405f);
                this.ArmRight.f_104201_ = Mth.m_14179_((float)sleepProgress, (float)1.0f, (float)0.0f);
                this.ArmRight.f_104202_ = Mth.m_14179_((float)sleepProgress, (float)-7.5f, (float)-7.0f);
                this.Tail2.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)0.11728612f);
                this.Tail2.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)0.6646214f);
                this.Tail2.f_104200_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-0.3f);
                this.Tail2.f_104201_ = Mth.m_14179_((float)sleepProgress, (float)-0.5f, (float)0.0f);
                this.Leg2.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)1.4074335f);
                this.Leg2.f_104200_ = Mth.m_14179_((float)sleepProgress, (float)-1.5f, (float)-1.2f);
                this.Leg2.f_104201_ = Mth.m_14179_((float)sleepProgress, (float)2.5f, (float)4.5f);
                this.Leg2.f_104202_ = Mth.m_14179_((float)sleepProgress, (float)1.49f, (float)1.5f);
                this.ArmLeft.f_104205_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-1.1337658f);
                this.ArmLeft.f_104201_ = Mth.m_14179_((float)sleepProgress, (float)1.0f, (float)0.0f);
                this.ArmLeft.f_104202_ = Mth.m_14179_((float)sleepProgress, (float)-7.5f, (float)-7.0f);
                this.Leg_1.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-1.4074335f);
                this.Leg_1.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-0.39095375f);
                this.Leg_1.f_104201_ = Mth.m_14179_((float)sleepProgress, (float)15.5f, (float)22.5f);
                this.Leg_1.f_104202_ = Mth.m_14179_((float)sleepProgress, (float)2.5f, (float)2.2f);
                this.Body.f_104201_ = Mth.m_14179_((float)sleepProgress, (float)15.0f, (float)22.0f);
                this.Neck.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)0.0f);
                this.Neck.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-1.2901473f);
                this.Neck.f_104205_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)0.312763f);
            } else {
                this.sleepPose();
            }
        } else if (sleepProgress != 0.0f && (Integer)entity.m_20088_().m_135370_(DinosaurEntity.SLEEP_TICK) > 0) {
            this.Tail.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)-0.23457225f, (float)0.0f);
            this.Tail.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)0.39095375f, (float)0.0f);
            this.Tail.f_104202_ = Mth.m_14179_((float)sleepProgress, (float)1.0f, (float)2.0f);
            this.Leg2_1.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)1.4074335f, (float)0.0f);
            this.Leg2_1.f_104200_ = Mth.m_14179_((float)sleepProgress, (float)1.2f, (float)1.5f);
            this.Leg2_1.f_104201_ = Mth.m_14179_((float)sleepProgress, (float)4.5f, (float)2.5f);
            this.Leg2_1.f_104202_ = Mth.m_14179_((float)sleepProgress, (float)1.5f, (float)1.49f);
            this.Leg.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)-1.4074335f, (float)0.0f);
            this.Leg.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)0.39095375f, (float)0.0f);
            this.Leg.f_104201_ = Mth.m_14179_((float)sleepProgress, (float)22.5f, (float)15.5f);
            this.Leg.f_104202_ = Mth.m_14179_((float)sleepProgress, (float)2.2f, (float)2.5f);
            this.ArmRight.f_104205_ = Mth.m_14179_((float)sleepProgress, (float)1.1339405f, (float)0.0f);
            this.ArmRight.f_104201_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)1.0f);
            this.ArmRight.f_104202_ = Mth.m_14179_((float)sleepProgress, (float)-7.0f, (float)-7.5f);
            this.Tail2.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.11728612f, (float)0.0f);
            this.Tail2.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)0.6646214f, (float)0.0f);
            this.Tail2.f_104200_ = Mth.m_14179_((float)sleepProgress, (float)-0.3f, (float)0.0f);
            this.Tail2.f_104201_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-0.5f);
            this.Leg2.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)1.4074335f, (float)0.0f);
            this.Leg2.f_104200_ = Mth.m_14179_((float)sleepProgress, (float)-1.2f, (float)-1.5f);
            this.Leg2.f_104201_ = Mth.m_14179_((float)sleepProgress, (float)4.5f, (float)2.5f);
            this.Leg2.f_104202_ = Mth.m_14179_((float)sleepProgress, (float)1.5f, (float)1.49f);
            this.ArmLeft.f_104205_ = Mth.m_14179_((float)sleepProgress, (float)-1.1337658f, (float)0.0f);
            this.ArmLeft.f_104201_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)1.0f);
            this.ArmLeft.f_104202_ = Mth.m_14179_((float)sleepProgress, (float)-7.0f, (float)-7.5f);
            this.Leg_1.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)-1.4074335f, (float)0.0f);
            this.Leg_1.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)-0.39095375f, (float)0.0f);
            this.Leg_1.f_104201_ = Mth.m_14179_((float)sleepProgress, (float)22.5f, (float)15.5f);
            this.Leg_1.f_104202_ = Mth.m_14179_((float)sleepProgress, (float)2.2f, (float)2.5f);
            this.Body.f_104201_ = Mth.m_14179_((float)sleepProgress, (float)22.0f, (float)15.0f);
            this.Neck.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)0.0f);
            this.Neck.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)-1.2901473f, (float)0.0f);
            this.Neck.f_104205_ = Mth.m_14179_((float)sleepProgress, (float)0.312763f, (float)0.0f);
        } else {
            this.Leg_1.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
            this.Leg.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
            this.Tail.f_104204_ = -0.12f * Mth.m_14031_((float)(0.2f * ageInTicks / 5.0f));
            this.Tail2.f_104204_ = -0.12f * Mth.m_14031_((float)(0.2f * ageInTicks / 5.0f));
            this.Tail.f_104203_ = -Math.abs(-0.05f * Mth.m_14031_((float)(0.1f * ageInTicks / 5.0f)));
            this.Tail2.f_104203_ = -Math.abs(-0.05f * Mth.m_14031_((float)(0.1f * ageInTicks / 5.0f)));
            this.Neck.f_104203_ = headPitch * ((float)Math.PI / 180) + Math.abs(-0.025f * Mth.m_14031_((float)(0.1f * ageInTicks / 3.0f))) + attackProgress * (float)Math.toRadians(40.0);
            this.ArmRight.f_104205_ = Math.abs(-0.05f * Mth.m_14031_((float)(0.15f * ageInTicks / 3.0f)));
            this.ArmLeft.f_104205_ = -Math.abs(-0.05f * Mth.m_14031_((float)(0.15f * ageInTicks / 3.0f)));
            this.Neck.f_104204_ = netHeadYaw * ((float)Math.PI / 180);
            this.Head.f_104203_ = attackProgress * (float)Math.toRadians(-15.0);
            if (entity.m_20069_()) {
                this.Leg_1.f_104201_ = 22.0f;
                this.Leg.f_104201_ = 22.0f;
                this.Body.f_104201_ = 20.0f;
                this.Body.f_104203_ = -0.25f;
                this.Tail.f_104203_ = 0.125f;
                this.Tail2.f_104203_ = 0.125f;
                this.Neck.f_104203_ = 0.25f;
                this.Leg_1.f_104203_ = -0.25f * Mth.m_14031_((float)(0.2f * ageInTicks / 1.5f));
                this.Leg.f_104203_ = 0.25f * Mth.m_14031_((float)(0.2f * ageInTicks / 1.5f));
                this.ArmLeft.f_104203_ = 0.25f;
                this.ArmRight.f_104203_ = 0.25f;
                this.Leg2_1.f_104203_ = -0.3f * Mth.m_14031_((float)(0.2f * ageInTicks / 1.5f));
                this.Leg2.f_104203_ = 0.3f * Mth.m_14031_((float)(0.2f * ageInTicks / 1.5f));
                this.Tail.f_104204_ = Mth.m_14089_((float)(limbSwing * 2.6662f)) * 1.4f * limbSwingAmount + 0.0625f * Mth.m_14031_((float)(0.15f * ageInTicks / 1.5f));
                this.Tail2.f_104204_ = Mth.m_14089_((float)(limbSwing * 2.6662f)) * 1.4f * limbSwingAmount + 0.0625f * Mth.m_14031_((float)(0.15f * ageInTicks / 1.5f));
            }
        }
    }

    public void resetModel() {
        this.Neck.f_104203_ = 0.0f;
        this.Neck.f_104204_ = 0.0f;
        this.Neck.f_104205_ = 0.0f;
        this.ArmRight.f_104203_ = 0.0f;
        this.ArmRight.f_104204_ = 0.0f;
        this.ArmRight.f_104205_ = 0.0f;
        this.ArmLeft.f_104203_ = 0.0f;
        this.ArmLeft.f_104204_ = 0.0f;
        this.ArmLeft.f_104205_ = 0.0f;
        this.Leg_1.f_104203_ = 0.0f;
        this.Leg_1.f_104204_ = 0.0f;
        this.Body.f_104203_ = 0.0f;
        this.Tail.f_104203_ = 0.0f;
        this.Tail.f_104204_ = 0.0f;
        this.Leg2_1.f_104203_ = 0.0f;
        this.Leg.f_104203_ = 0.0f;
        this.Leg.f_104204_ = 0.0f;
        this.ArmRight.f_104205_ = 0.0f;
        this.Tail2.f_104203_ = 0.0f;
        this.Tail2.f_104204_ = 0.0f;
        this.Leg2.f_104203_ = 0.0f;
        this.ArmLeft.f_104205_ = 0.0f;
        this.Body.f_104201_ = 15.0f;
        this.Leg2.f_104200_ = -1.5f;
        this.Leg2.f_104201_ = 2.5f;
        this.Leg2.f_104202_ = 1.49f;
        this.Leg_1.f_104201_ = 15.5f;
        this.Leg_1.f_104202_ = 2.5f;
        this.Leg2_1.f_104200_ = 1.5f;
        this.Leg2_1.f_104201_ = 2.5f;
        this.Leg2_1.f_104202_ = 1.49f;
        this.Tail.f_104202_ = 2.0f;
        this.Tail2.f_104200_ = 0.0f;
        this.Tail2.f_104201_ = -0.5f;
        this.ArmRight.f_104201_ = 1.0f;
        this.ArmRight.f_104202_ = -7.5f;
        this.Leg.f_104201_ = 15.5f;
        this.Leg.f_104202_ = 2.5f;
        this.ArmLeft.f_104201_ = 1.0f;
        this.ArmLeft.f_104202_ = -7.5f;
    }

    public void sleepPose() {
        this.Tail.f_104203_ = -0.23457225f;
        this.Tail.f_104204_ = 0.39095375f;
        this.Tail.f_104202_ = 1.0f;
        this.Leg2_1.f_104203_ = 1.4074335f;
        this.Leg2_1.f_104200_ = 1.2f;
        this.Leg2_1.f_104201_ = 4.5f;
        this.Leg2_1.f_104202_ = 1.5f;
        this.Leg.f_104203_ = -1.4074335f;
        this.Leg.f_104204_ = 0.39095375f;
        this.Leg.f_104201_ = 22.5f;
        this.Leg.f_104202_ = 2.2f;
        this.ArmRight.f_104205_ = 1.1339405f;
        this.ArmRight.f_104201_ = 0.0f;
        this.ArmRight.f_104202_ = -7.0f;
        this.Tail2.f_104203_ = 0.11728612f;
        this.Tail2.f_104204_ = 0.6646214f;
        this.Tail2.f_104200_ = -0.3f;
        this.Tail2.f_104201_ = 0.0f;
        this.Leg2.f_104203_ = 1.4074335f;
        this.Leg2.f_104200_ = -1.2f;
        this.Leg2.f_104201_ = 4.5f;
        this.Leg2.f_104202_ = 1.5f;
        this.ArmLeft.f_104205_ = -1.1337658f;
        this.ArmLeft.f_104201_ = 0.0f;
        this.ArmLeft.f_104202_ = -7.0f;
        this.Leg_1.f_104203_ = -1.4074335f;
        this.Leg_1.f_104204_ = -0.39095375f;
        this.Leg_1.f_104201_ = 22.5f;
        this.Leg_1.f_104202_ = 2.2f;
        this.Body.f_104201_ = 22.0f;
        this.Neck.f_104203_ = 0.0f;
        this.Neck.f_104204_ = -1.2901473f;
        this.Neck.f_104205_ = 0.312763f;
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.Body.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.Leg_1.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.Leg.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
    }
}

