/*
 * Decompiled with CFR 0.152.
 */
package superlord.prehistoricfauna.client.model.jurassic.kayenta;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import superlord.prehistoricfauna.common.entity.DinosaurEntity;
import superlord.prehistoricfauna.common.entity.jurassic.kayenta.Kayentatherium;

public class KayentatheriumModel
extends EntityModel<Kayentatherium> {
    private final ModelPart Body;
    private final ModelPart Head;
    private final ModelPart Tail;
    private final ModelPart RightLeg;
    private final ModelPart LeftLeg;
    private final ModelPart RightArm;
    private final ModelPart LeftArm;

    public KayentatheriumModel(ModelPart root) {
        this.Body = root.m_171324_("Body");
        this.Head = this.Body.m_171324_("Head");
        this.Tail = this.Body.m_171324_("Tail");
        this.RightLeg = this.Body.m_171324_("RightLeg");
        this.LeftLeg = this.Body.m_171324_("LeftLeg");
        this.RightArm = this.Body.m_171324_("RightArm");
        this.LeftArm = this.Body.m_171324_("LeftArm");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition Body = partdefinition.m_171599_("Body", CubeListBuilder.m_171558_().m_171514_(1, 8).m_171488_(-2.5f, 0.0f, 0.0f, 5.0f, 4.0f, 12.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)18.0f, (float)-7.0f));
        PartDefinition Head = Body.m_171599_("Head", CubeListBuilder.m_171558_().m_171514_(10, 0).m_171488_(-1.5f, -2.0f, -5.0f, 3.0f, 3.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)1.0f, (float)1.0f));
        PartDefinition RightArm = Body.m_171599_("RightArm", CubeListBuilder.m_171558_().m_171514_(27, 0).m_171480_().m_171488_(-0.99f, 0.0f, -1.0f, 2.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)-1.5f, (float)3.0f, (float)2.0f));
        PartDefinition LeftLeg = Body.m_171599_("LeftLeg", CubeListBuilder.m_171558_().m_171514_(25, 5).m_171488_(-1.01f, 0.0f, -1.5f, 2.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)1.5f, (float)3.0f, (float)10.5f));
        PartDefinition RightLeg = Body.m_171599_("RightLeg", CubeListBuilder.m_171558_().m_171514_(25, 5).m_171480_().m_171488_(-0.99f, 0.0f, -1.5f, 2.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)-1.5f, (float)3.0f, (float)10.5f));
        PartDefinition Tail = Body.m_171599_("Tail", CubeListBuilder.m_171558_().m_171514_(1, 24).m_171488_(-2.0f, -1.0f, 0.0f, 4.0f, 2.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)2.0f, (float)11.75f, (float)-0.25f, (float)0.0f, (float)0.0f));
        PartDefinition LeftArm = Body.m_171599_("LeftArm", CubeListBuilder.m_171558_().m_171514_(27, 0).m_171488_(-1.01f, 0.0f, -1.0f, 2.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)1.5f, (float)3.0f, (float)2.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)35, (int)50);
    }

    public void setupAnim(Kayentatherium entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        float partialTick = ageInTicks - (float)entity.f_19797_;
        float sleepProgress = entity.getSleepProgress(partialTick);
        this.resetModel();
        if (entity.isAsleep()) {
            if (sleepProgress != 0.0f && (Integer)entity.m_20088_().m_135370_(DinosaurEntity.SLEEP_TICK) > 0) {
                this.Body.f_104201_ = Mth.m_14179_((float)sleepProgress, (float)18.0f, (float)20.0f);
                this.Body.f_104202_ = Mth.m_14179_((float)sleepProgress, (float)-7.0f, (float)-6.0f);
                this.Head.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)0.46931902f);
                this.LeftLeg.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)1.6029103f);
                this.LeftLeg.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)0.39095375f);
                this.Tail.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-0.23457225f);
                this.LeftArm.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-1.0164797f);
                this.LeftArm.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-0.89919364f);
                this.RightArm.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-1.0164797f);
                this.RightArm.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)0.89919364f);
                this.RightLeg.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)1.6030849f);
                this.RightLeg.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-0.39095375f);
            } else {
                this.sleepPose();
            }
        } else if (sleepProgress != 0.0f && (Integer)entity.m_20088_().m_135370_(DinosaurEntity.SLEEP_TICK) > 0) {
            this.Body.f_104201_ = Mth.m_14179_((float)sleepProgress, (float)20.0f, (float)18.0f);
            this.Body.f_104202_ = Mth.m_14179_((float)sleepProgress, (float)-6.0f, (float)-7.0f);
            this.Head.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.46931902f, (float)0.0f);
            this.LeftLeg.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)1.6029103f, (float)0.0f);
            this.LeftLeg.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)0.39095375f, (float)0.0f);
            this.Tail.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)-0.23457225f, (float)0.0f);
            this.LeftArm.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)-1.0164797f, (float)0.0f);
            this.LeftArm.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)-0.89919364f, (float)0.0f);
            this.RightArm.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)-1.0164797f, (float)0.0f);
            this.RightArm.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)0.89919364f, (float)0.0f);
            this.RightLeg.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)1.6030849f, (float)0.0f);
            this.RightLeg.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)-0.39095375f, (float)0.0f);
        } else {
            this.Head.f_104203_ = headPitch * ((float)Math.PI / 180);
            this.Head.f_104204_ = netHeadYaw * ((float)Math.PI / 180);
            this.LeftLeg.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
            this.RightLeg.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
            this.LeftArm.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
            this.RightArm.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
            if (entity.isEating()) {
                this.Head.f_104203_ = Math.abs(Mth.m_14031_((float)(0.05f * ageInTicks)) * 0.45f) + 0.15f;
            }
            if (entity.m_20069_()) {
                this.LeftArm.f_104203_ = 0.25f * Mth.m_14031_((float)(0.15f * ageInTicks / 1.5f));
                this.RightArm.f_104203_ = -0.25f * Mth.m_14031_((float)(0.15f * ageInTicks / 1.5f));
                this.LeftLeg.f_104203_ = -0.25f * Mth.m_14031_((float)(0.15f * ageInTicks / 1.5f));
                this.RightLeg.f_104203_ = 0.25f * Mth.m_14031_((float)(0.15f * ageInTicks / 1.5f));
                this.Tail.f_104203_ = Mth.m_14089_((float)(limbSwing * 2.6662f)) * 1.4f * limbSwingAmount + 0.25f * Mth.m_14031_((float)(0.15f * ageInTicks / 1.5f));
            }
        }
    }

    public void resetModel() {
        this.Body.f_104201_ = 18.0f;
        this.Body.f_104202_ = -7.0f;
        this.Head.f_104203_ = 0.0f;
        this.Head.f_104204_ = 0.0f;
        this.Head.f_104205_ = 0.0f;
        this.LeftLeg.f_104203_ = 0.0f;
        this.LeftLeg.f_104204_ = 0.0f;
        this.Tail.f_104203_ = 0.0f;
        this.LeftArm.f_104203_ = 0.0f;
        this.LeftArm.f_104204_ = 0.0f;
        this.RightArm.f_104203_ = 0.0f;
        this.RightArm.f_104204_ = 0.0f;
        this.RightLeg.f_104203_ = 0.0f;
        this.RightLeg.f_104204_ = 0.0f;
        this.Tail.f_104203_ = -0.25f;
        this.Tail.f_104202_ = 11.75f;
    }

    public void sleepPose() {
        this.Body.f_104201_ = 20.0f;
        this.Body.f_104202_ = -6.0f;
        this.Head.f_104203_ = 0.46931902f;
        this.LeftLeg.f_104203_ = 1.6029103f;
        this.LeftLeg.f_104204_ = 0.39095375f;
        this.Tail.f_104203_ = -0.23457225f;
        this.LeftArm.f_104203_ = -1.0164797f;
        this.LeftArm.f_104204_ = -0.89919364f;
        this.RightArm.f_104203_ = -1.0164797f;
        this.RightArm.f_104204_ = 0.89919364f;
        this.RightLeg.f_104203_ = 1.6030849f;
        this.RightLeg.f_104204_ = -0.39095375f;
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.Body.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
    }
}

