/*
 * Decompiled with CFR 0.152.
 */
package superlord.prehistoricfauna.client.model.jurassic.kayenta;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import superlord.prehistoricfauna.common.entity.DinosaurEntity;
import superlord.prehistoricfauna.common.entity.jurassic.kayenta.Dilophosaurus;

public class DilophosaurusModel
extends EntityModel<Dilophosaurus> {
    private final ModelPart Torso;
    private final ModelPart Neck;
    private final ModelPart Head;
    private final ModelPart Jaw;
    private final ModelPart Tail;
    private final ModelPart Tail2;
    private final ModelPart ArmRight;
    private final ModelPart ArmLeft;
    private final ModelPart Leg1Left;
    private final ModelPart Leg2Left;
    private final ModelPart FootLeft;
    private final ModelPart Leg1Right;
    private final ModelPart Leg2Right;
    private final ModelPart FootRight;

    public DilophosaurusModel(ModelPart root) {
        this.Torso = root.m_171324_("Torso");
        this.Neck = this.Torso.m_171324_("Neck");
        this.Head = this.Neck.m_171324_("Head");
        this.Jaw = this.Head.m_171324_("Jaw");
        this.Tail = this.Torso.m_171324_("Tail");
        this.Tail2 = this.Tail.m_171324_("Tail2");
        this.ArmLeft = this.Torso.m_171324_("ArmLeft");
        this.ArmRight = this.Torso.m_171324_("ArmRight");
        this.Leg1Left = root.m_171324_("Leg1Left");
        this.Leg2Left = this.Leg1Left.m_171324_("Leg2Left");
        this.FootLeft = this.Leg2Left.m_171324_("FootLeft");
        this.Leg1Right = root.m_171324_("Leg1Right");
        this.Leg2Right = this.Leg1Right.m_171324_("Leg2Right");
        this.FootRight = this.Leg2Right.m_171324_("FootRight");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition Torso = partdefinition.m_171599_("Torso", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-4.0f, -4.0f, -27.0f, 8.0f, 14.0f, 32.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-3.0f, (float)9.0f));
        PartDefinition Neck = Torso.m_171599_("Neck", CubeListBuilder.m_171558_().m_171514_(0, 46).m_171488_(-2.0f, -14.0f, -6.0f, 4.0f, 17.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)3.0f, (float)-25.0f, (float)0.35f, (float)0.0f, (float)0.0f));
        PartDefinition Head = Neck.m_171599_("Head", CubeListBuilder.m_171558_().m_171514_(0, 70).m_171488_(-2.5f, -5.0f, -6.0f, 5.0f, 5.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-9.5f, (float)-2.0f, (float)-0.2f, (float)0.0f, (float)0.0f));
        PartDefinition Snout = Head.m_171599_("Snout", CubeListBuilder.m_171558_().m_171514_(0, 81).m_171488_(-2.0f, -2.0f, -8.0f, 4.0f, 4.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-2.0f, (float)-6.0f));
        PartDefinition CrestLeft = Snout.m_171599_("CrestLeft", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-2.0f, -6.0f, -8.0f, 1.0f, 6.0f, 11.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-2.0f, (float)1.0f, (float)0.0782f, (float)-0.1047f, (float)0.0f));
        PartDefinition CrestRight = Snout.m_171599_("CrestRight", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171480_().m_171488_(1.0f, -6.0f, -8.0f, 1.0f, 6.0f, 11.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)0.0f, (float)-2.0f, (float)1.0f, (float)0.0782f, (float)0.1047f, (float)0.0f));
        PartDefinition Teeth = Snout.m_171599_("Teeth", CubeListBuilder.m_171558_().m_171514_(0, 113).m_171488_(-1.5f, -2.0f, -8.0f, 3.0f, 4.0f, 9.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)2.0f, (float)0.35f));
        PartDefinition Jaw = Head.m_171599_("Jaw", CubeListBuilder.m_171558_().m_171514_(0, 103).m_171488_(-2.5f, 0.0f, -6.0f, 5.0f, 3.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition Mouth = Jaw.m_171599_("Mouth", CubeListBuilder.m_171558_().m_171514_(0, 93).m_171488_(-2.0f, 0.0f, -8.0f, 4.0f, 2.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)-6.0f));
        PartDefinition BottomTeeth = Mouth.m_171599_("BottomTeeth", CubeListBuilder.m_171558_().m_171514_(-1, 132).m_171488_(-1.0f, 0.0f, -8.0f, 2.0f, 4.0f, 9.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-1.5f, (float)0.4f));
        PartDefinition Waddle = Jaw.m_171599_("Waddle", CubeListBuilder.m_171558_().m_171514_(22, 46).m_171488_(-1.5f, 0.0f, -6.0f, 3.0f, 3.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)2.0f, (float)-4.0f));
        PartDefinition Cheek = Jaw.m_171599_("Cheek", CubeListBuilder.m_171558_().m_171514_(24, 110).m_171488_(-1.5f, 0.0f, -5.0f, 3.0f, 3.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-3.0f, (float)0.0f));
        PartDefinition QuillsNeck = Neck.m_171599_("QuillsNeck", CubeListBuilder.m_171558_().m_171514_(40, 70).m_171488_(0.0f, -9.0f, 0.0f, 0.0f, 9.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-9.0f, (float)-1.0f));
        PartDefinition Tail = Torso.m_171599_("Tail", CubeListBuilder.m_171558_().m_171514_(50, 4).m_171488_(-3.0f, 0.0f, 0.0f, 6.0f, 9.0f, 18.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-3.5f, (float)1.5f, (float)-0.05f, (float)0.0f, (float)0.0f));
        PartDefinition Tail2 = Tail.m_171599_("Tail2", CubeListBuilder.m_171558_().m_171514_(95, 3).m_171488_(-1.5f, 0.0f, 0.0f, 3.0f, 5.0f, 47.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.5f, (float)15.0f, (float)0.05f, (float)0.0f, (float)0.0f));
        PartDefinition ArmRight = Torso.m_171599_("ArmRight", CubeListBuilder.m_171558_().m_171514_(41, 46).m_171488_(0.0f, 0.0f, -2.0f, 3.0f, 13.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)2.5f, (float)5.0f, (float)-23.0f, (float)0.15f, (float)0.0f, (float)0.0f));
        PartDefinition ArmLeft = Torso.m_171599_("ArmLeft", CubeListBuilder.m_171558_().m_171514_(41, 46).m_171480_().m_171488_(-3.0f, 0.0f, -2.0f, 3.0f, 13.0f, 4.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)-2.5f, (float)5.0f, (float)-23.0f, (float)0.15f, (float)0.0f, (float)0.0f));
        PartDefinition Leg1Left = partdefinition.m_171599_("Leg1Left", CubeListBuilder.m_171558_().m_171514_(72, 49).m_171480_().m_171488_(-5.0f, -3.0f, -5.0f, 6.0f, 16.0f, 10.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)-2.0f, (float)-2.0f, (float)5.0f, (float)-0.1f, (float)0.0f, (float)0.0f));
        PartDefinition Leg2Left = Leg1Left.m_171599_("Leg2Left", CubeListBuilder.m_171558_().m_171514_(72, 75).m_171480_().m_171488_(-2.0f, 0.0f, 0.0f, 4.0f, 15.0f, 4.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)-2.5f, (float)10.0f, (float)2.0f, (float)0.1f, (float)0.0f, (float)0.0f));
        PartDefinition FootLeft = Leg2Left.m_171599_("FootLeft", CubeListBuilder.m_171558_().m_171514_(72, 94).m_171480_().m_171488_(-2.5f, 0.0f, -6.0f, 5.0f, 2.0f, 8.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)0.0f, (float)14.0f, (float)1.0f));
        PartDefinition Leg1Right = partdefinition.m_171599_("Leg1Right", CubeListBuilder.m_171558_().m_171514_(72, 49).m_171488_(-2.0f, -3.0f, -5.0f, 6.0f, 16.0f, 10.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)3.0f, (float)-2.0f, (float)5.0f, (float)-0.1f, (float)0.0f, (float)0.0f));
        PartDefinition Leg2Right = Leg1Right.m_171599_("Leg2Right", CubeListBuilder.m_171558_().m_171514_(72, 75).m_171488_(-2.0f, 0.0f, 0.0f, 4.0f, 15.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)1.5f, (float)10.0f, (float)2.0f, (float)0.1f, (float)0.0f, (float)0.0f));
        PartDefinition FootRight = Leg2Right.m_171599_("FootRight", CubeListBuilder.m_171558_().m_171514_(72, 94).m_171488_(-2.5f, 0.0f, -6.0f, 5.0f, 2.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)14.0f, (float)1.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)200, (int)200);
    }

    public void setupAnim(Dilophosaurus entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        float walkSpeed = 1.0f;
        float walkDegree = 0.5f;
        float idleSpeed = 1.0f;
        float idleDegree = 1.0f;
        float partialTick = ageInTicks - (float)entity.f_19797_;
        float attackProgress = entity.getMeleeProgress(partialTick);
        float sleepProgress = entity.getSleepProgress(partialTick);
        this.resetModel();
        if (entity.isAsleep()) {
            if (sleepProgress != 0.0f && (Integer)entity.m_20088_().m_135370_(DinosaurEntity.SLEEP_TICK) > 0) {
                this.Head.f_104201_ = Mth.m_14179_((float)sleepProgress, (float)-9.5f, (float)-10.0f);
                this.Head.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-0.07819075f);
                this.Head.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)0.03874631f);
                this.Head.f_104205_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)0.19547687f);
                this.Tail2.f_104200_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-0.5f);
                this.Tail2.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-0.43004912f);
                this.Tail2.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)0.19547687f);
                this.Tail2.f_104205_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-0.19547687f);
                this.FootLeft.f_104201_ = Mth.m_14179_((float)sleepProgress, (float)14.0f, (float)15.0f);
                this.FootLeft.f_104202_ = Mth.m_14179_((float)sleepProgress, (float)1.0f, (float)0.0f);
                this.FootLeft.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)2.0722294f);
                this.FootLeft.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)1.7453292E-4f);
                this.FootLeft.f_104205_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)0.037350047f);
                this.Leg2Right.f_104201_ = Mth.m_14179_((float)sleepProgress, (float)10.0f, (float)11.0f);
                this.Leg2Right.f_104202_ = Mth.m_14179_((float)sleepProgress, (float)2.0f, (float)5.0f);
                this.Leg2Right.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-1.3685127f);
                this.Leg2Right.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-1.7453292E-4f);
                this.Leg2Right.f_104205_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)0.43004912f);
                this.Neck.f_104200_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-1.0f);
                this.Neck.f_104201_ = Mth.m_14179_((float)sleepProgress, (float)3.0f, (float)1.0f);
                this.Neck.f_104202_ = Mth.m_14179_((float)sleepProgress, (float)-25.0f, (float)-24.0f);
                this.Neck.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)1.6418313f);
                this.Neck.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)0.31223938f);
                this.Neck.f_104205_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-0.23457225f);
                this.Tail.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-0.27366763f);
                this.Tail.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-0.07819075f);
                this.Tail.f_104205_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)0.0f);
                this.Torso.f_104200_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-3.0f);
                this.Torso.f_104201_ = Mth.m_14179_((float)sleepProgress, (float)-3.0f, (float)19.0f);
                this.Torso.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-0.11728612f);
                this.Torso.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-0.03926991f);
                this.Torso.f_104205_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-1.2901473f);
                this.ArmLeft.f_104200_ = Mth.m_14179_((float)sleepProgress, (float)-2.5f, (float)-3.0f);
                this.ArmLeft.f_104201_ = Mth.m_14179_((float)sleepProgress, (float)5.0f, (float)2.0f);
                this.ArmLeft.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-0.039095376f);
                this.ArmLeft.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-0.039095376f);
                this.ArmLeft.f_104205_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-0.23457225f);
                this.FootRight.f_104201_ = Mth.m_14179_((float)sleepProgress, (float)14.0f, (float)15.0f);
                this.FootRight.f_104202_ = Mth.m_14179_((float)sleepProgress, (float)1.0f, (float)0.9f);
                this.FootRight.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)1.8387043f);
                this.FootRight.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-0.15725417f);
                this.FootRight.f_104205_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-0.1563815f);
                this.Leg2Left.f_104201_ = Mth.m_14179_((float)sleepProgress, (float)10.0f, (float)11.0f);
                this.Leg2Left.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-0.43004912f);
                this.Leg2Left.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-0.11728612f);
                this.Leg2Left.f_104205_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-0.19547687f);
                this.Leg1Right.f_104200_ = Mth.m_14179_((float)sleepProgress, (float)3.0f, (float)0.5f);
                this.Leg1Right.f_104201_ = Mth.m_14179_((float)sleepProgress, (float)-2.0f, (float)17.0f);
                this.Leg1Right.f_104202_ = Mth.m_14179_((float)sleepProgress, (float)5.0f, (float)7.0f);
                this.Leg1Right.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-0.1563815f);
                this.Leg1Right.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-1.7453292E-4f);
                this.Leg1Right.f_104205_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-1.0555751f);
                this.Leg1Left.f_104200_ = Mth.m_14179_((float)sleepProgress, (float)-2.0f, (float)-2.5f);
                this.Leg1Left.f_104201_ = Mth.m_14179_((float)sleepProgress, (float)-2.0f, (float)21.2f);
                this.Leg1Left.f_104202_ = Mth.m_14179_((float)sleepProgress, (float)5.0f, (float)5.0f);
                this.Leg1Left.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)0.43004912f);
                this.Leg1Left.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-0.11728612f);
                this.Leg1Left.f_104205_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-1.4467034f);
                this.ArmRight.f_104200_ = Mth.m_14179_((float)sleepProgress, (float)2.5f, (float)3.0f);
                this.ArmRight.f_104201_ = Mth.m_14179_((float)sleepProgress, (float)5.0f, (float)6.0f);
                this.ArmRight.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)0.27384216f);
                this.ArmRight.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)0.43004912f);
                this.ArmRight.f_104205_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)0.70354223f);
            } else {
                this.sleepPose();
            }
        } else if (sleepProgress != 0.0f && (Integer)entity.m_20088_().m_135370_(DinosaurEntity.SLEEP_TICK) > 0) {
            this.Head.f_104201_ = Mth.m_14179_((float)sleepProgress, (float)-10.0f, (float)-9.5f);
            this.Head.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)-0.07819075f, (float)0.0f);
            this.Head.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)0.03874631f, (float)0.0f);
            this.Head.f_104205_ = Mth.m_14179_((float)sleepProgress, (float)0.19547687f, (float)0.0f);
            this.Tail2.f_104200_ = Mth.m_14179_((float)sleepProgress, (float)-0.5f, (float)0.0f);
            this.Tail2.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)-0.43004912f, (float)0.0f);
            this.Tail2.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)0.19547687f, (float)0.0f);
            this.Tail2.f_104205_ = Mth.m_14179_((float)sleepProgress, (float)-0.19547687f, (float)0.0f);
            this.FootLeft.f_104201_ = Mth.m_14179_((float)sleepProgress, (float)15.0f, (float)14.0f);
            this.FootLeft.f_104202_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)1.0f);
            this.FootLeft.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)2.0722294f, (float)0.0f);
            this.FootLeft.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)1.7453292E-4f, (float)0.0f);
            this.FootLeft.f_104205_ = Mth.m_14179_((float)sleepProgress, (float)0.037350047f, (float)0.0f);
            this.Leg2Right.f_104201_ = Mth.m_14179_((float)sleepProgress, (float)11.0f, (float)10.0f);
            this.Leg2Right.f_104202_ = Mth.m_14179_((float)sleepProgress, (float)5.0f, (float)2.0f);
            this.Leg2Right.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)-1.3685127f, (float)0.0f);
            this.Leg2Right.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)-1.7453292E-4f, (float)0.0f);
            this.Leg2Right.f_104205_ = Mth.m_14179_((float)sleepProgress, (float)0.43004912f, (float)0.43004912f);
            this.Neck.f_104200_ = Mth.m_14179_((float)sleepProgress, (float)-1.0f, (float)0.0f);
            this.Neck.f_104201_ = Mth.m_14179_((float)sleepProgress, (float)1.0f, (float)3.0f);
            this.Neck.f_104202_ = Mth.m_14179_((float)sleepProgress, (float)-24.0f, (float)-25.0f);
            this.Neck.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)1.6418313f, (float)0.0f);
            this.Neck.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)0.31223938f, (float)0.0f);
            this.Neck.f_104205_ = Mth.m_14179_((float)sleepProgress, (float)-0.23457225f, (float)0.0f);
            this.Tail.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)-0.27366763f, (float)0.0f);
            this.Tail.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)-0.07819075f, (float)0.0f);
            this.Tail.f_104205_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)0.0f);
            this.Torso.f_104200_ = Mth.m_14179_((float)sleepProgress, (float)-3.0f, (float)0.0f);
            this.Torso.f_104201_ = Mth.m_14179_((float)sleepProgress, (float)19.0f, (float)-3.0f);
            this.Torso.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)-0.11728612f, (float)0.0f);
            this.Torso.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)-0.03926991f, (float)0.0f);
            this.Torso.f_104205_ = Mth.m_14179_((float)sleepProgress, (float)-1.2901473f, (float)0.0f);
            this.ArmLeft.f_104200_ = Mth.m_14179_((float)sleepProgress, (float)-3.0f, (float)-2.5f);
            this.ArmLeft.f_104201_ = Mth.m_14179_((float)sleepProgress, (float)2.0f, (float)5.0f);
            this.ArmLeft.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)-0.039095376f, (float)0.0f);
            this.ArmLeft.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)-0.039095376f, (float)0.0f);
            this.ArmLeft.f_104205_ = Mth.m_14179_((float)sleepProgress, (float)-0.23457225f, (float)0.0f);
            this.FootRight.f_104201_ = Mth.m_14179_((float)sleepProgress, (float)15.0f, (float)14.0f);
            this.FootRight.f_104202_ = Mth.m_14179_((float)sleepProgress, (float)0.9f, (float)1.0f);
            this.FootRight.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)1.8387043f, (float)0.0f);
            this.FootRight.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)-0.15725417f, (float)0.0f);
            this.FootRight.f_104205_ = Mth.m_14179_((float)sleepProgress, (float)-0.1563815f, (float)0.0f);
            this.Leg2Left.f_104201_ = Mth.m_14179_((float)sleepProgress, (float)11.0f, (float)10.0f);
            this.Leg2Left.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)-0.43004912f, (float)0.0f);
            this.Leg2Left.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)-0.11728612f, (float)0.0f);
            this.Leg2Left.f_104205_ = Mth.m_14179_((float)sleepProgress, (float)-0.19547687f, (float)0.0f);
            this.Leg1Right.f_104200_ = Mth.m_14179_((float)sleepProgress, (float)0.5f, (float)3.0f);
            this.Leg1Right.f_104201_ = Mth.m_14179_((float)sleepProgress, (float)17.0f, (float)-2.0f);
            this.Leg1Right.f_104202_ = Mth.m_14179_((float)sleepProgress, (float)7.0f, (float)5.0f);
            this.Leg1Right.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)-0.1563815f, (float)0.0f);
            this.Leg1Right.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)-1.7453292E-4f, (float)0.0f);
            this.Leg1Right.f_104205_ = Mth.m_14179_((float)sleepProgress, (float)-1.0555751f, (float)0.0f);
            this.Leg1Left.f_104200_ = Mth.m_14179_((float)sleepProgress, (float)-2.5f, (float)-2.0f);
            this.Leg1Left.f_104201_ = Mth.m_14179_((float)sleepProgress, (float)-21.2f, (float)-2.0f);
            this.Leg1Left.f_104202_ = Mth.m_14179_((float)sleepProgress, (float)5.0f, (float)5.0f);
            this.Leg1Left.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.43004912f, (float)0.0f);
            this.Leg1Left.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)-0.11728612f, (float)0.0f);
            this.Leg1Left.f_104205_ = Mth.m_14179_((float)sleepProgress, (float)-1.4467034f, (float)0.0f);
            this.ArmRight.f_104200_ = Mth.m_14179_((float)sleepProgress, (float)3.0f, (float)2.5f);
            this.ArmRight.f_104201_ = Mth.m_14179_((float)sleepProgress, (float)6.0f, (float)5.0f);
            this.ArmRight.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.27384216f, (float)0.0f);
            this.ArmRight.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)0.43004912f, (float)0.0f);
            this.ArmRight.f_104205_ = Mth.m_14179_((float)sleepProgress, (float)0.70354223f, (float)0.0f);
        } else {
            this.Neck.f_104203_ = Mth.m_14089_((float)(-1.0f + limbSwing * walkSpeed * 0.3f)) * walkDegree * 0.3f * limbSwingAmount + 0.35f + headPitch * ((float)Math.PI / 180) + attackProgress * (float)Math.toRadians(35.0);
            this.Torso.f_104203_ = Math.abs(-0.025f * Mth.m_14031_((float)(0.1f * ageInTicks / 3.0f))) + Mth.m_14089_((float)(1.0f + limbSwing * walkSpeed * 0.3f)) * walkDegree * 0.1f * limbSwingAmount;
            this.Tail.f_104203_ = -Math.abs(-0.05f * Mth.m_14031_((float)(0.1f * ageInTicks / 5.0f))) + Mth.m_14089_((float)(limbSwing * walkSpeed * 0.3f)) * walkDegree * 0.1f * limbSwingAmount - 0.05f;
            this.Tail2.f_104203_ = -Math.abs(-0.05f * Mth.m_14031_((float)(0.1f * ageInTicks / 5.0f))) + Mth.m_14089_((float)(-1.0f + limbSwing * walkSpeed * 0.3f)) * walkDegree * 0.15f * limbSwingAmount + 0.05f;
            this.Tail.f_104204_ = -0.12f * Mth.m_14031_((float)(0.2f * ageInTicks / 5.0f)) + Mth.m_14089_((float)(limbSwing * walkSpeed * 0.15f)) * walkDegree * 0.6f * limbSwingAmount;
            this.Tail2.f_104204_ = -0.12f * Mth.m_14031_((float)(0.2f * ageInTicks / 5.0f)) + Mth.m_14089_((float)(limbSwing * walkSpeed * 0.15f)) * walkDegree * 1.0f * limbSwingAmount;
            this.Head.f_104203_ = Mth.m_14089_((float)(-1.0f + limbSwing * walkSpeed * 0.3f)) * walkDegree * 0.25f * limbSwingAmount - 0.2f + attackProgress * (float)Math.toRadians(-35.0);
            this.ArmRight.f_104203_ = -Math.abs(-0.05f * Mth.m_14031_((float)(0.15f * ageInTicks / 3.0f))) + Mth.m_14089_((float)(limbSwing * walkSpeed * 0.3f)) * walkDegree * 0.2f * limbSwingAmount + 0.15f;
            this.ArmLeft.f_104203_ = Math.abs(-0.05f * Mth.m_14031_((float)(0.15f * ageInTicks / 3.0f))) + Mth.m_14089_((float)(2.0f + limbSwing * walkSpeed * 0.3f)) * walkDegree * 0.2f * limbSwingAmount + 0.15f;
            this.Leg1Right.f_104203_ = Mth.m_14089_((float)(1.0f + limbSwing * idleSpeed * 0.3f)) * idleDegree * 0.6f * limbSwingAmount - 0.05f + Mth.m_14089_((float)(1.0f + limbSwing * walkSpeed * 0.3f)) * walkDegree * 0.6f * limbSwingAmount - 0.05f;
            this.Leg2Left.f_104203_ = Mth.m_14089_((float)(1.0f + limbSwing * idleSpeed * 0.3f)) * idleDegree * 0.4f * limbSwingAmount + 0.05f + Mth.m_14089_((float)(1.0f + limbSwing * walkSpeed * 0.3f)) * walkDegree * 0.4f * limbSwingAmount + 0.05f;
            this.FootRight.f_104203_ = Mth.m_14089_((float)(2.0f + limbSwing * idleSpeed * 0.3f)) * idleDegree * 0.3f * limbSwingAmount + Mth.m_14089_((float)(2.0f + limbSwing * walkSpeed * 0.3f)) * walkDegree * 0.3f * limbSwingAmount;
            this.Leg1Left.f_104203_ = Mth.m_14089_((float)(1.0f + limbSwing * idleSpeed * 0.3f)) * idleDegree * -0.6f * limbSwingAmount - 0.05f + Mth.m_14089_((float)(1.0f + limbSwing * walkSpeed * 0.3f)) * walkDegree * -0.6f * limbSwingAmount - 0.05f;
            this.Leg2Left.f_104203_ = Mth.m_14089_((float)(1.0f + limbSwing * idleSpeed * 0.3f)) * idleDegree * -0.4f * limbSwingAmount + 0.05f + Mth.m_14089_((float)(1.0f + limbSwing * walkSpeed * 0.3f)) * walkDegree * -0.4f * limbSwingAmount + 0.05f;
            this.FootLeft.f_104203_ = Mth.m_14089_((float)(2.0f + limbSwing * idleSpeed * 0.3f)) * idleDegree * -0.3f * limbSwingAmount + Mth.m_14089_((float)(2.0f + limbSwing * walkSpeed * 0.3f)) * walkDegree * -0.3f * limbSwingAmount;
            this.Neck.f_104204_ = netHeadYaw * ((float)Math.PI / 180);
            this.Jaw.f_104203_ = attackProgress * (float)Math.toRadians(25.0);
            if (entity.m_20069_()) {
                this.Leg1Right.f_104201_ = 20.0f;
                this.Leg1Left.f_104201_ = 20.0f;
                this.Torso.f_104201_ = 20.0f;
                this.Torso.f_104203_ = -0.25f;
                this.Tail.f_104203_ = 0.125f;
                this.Tail2.f_104203_ = 0.125f;
                this.Neck.f_104203_ = 0.5f;
                this.Leg1Right.f_104203_ = -0.24271f * Mth.m_14031_((float)(0.2f * ageInTicks / 1.5f));
                this.Leg1Left.f_104203_ = 0.24271f * Mth.m_14031_((float)(0.2f * ageInTicks / 1.5f));
                this.ArmLeft.f_104203_ = 0.25f;
                this.ArmRight.f_104203_ = 0.25f;
                this.Leg2Right.f_104203_ = -0.3f * Mth.m_14031_((float)(0.2f * ageInTicks / 1.5f));
                this.Leg2Left.f_104203_ = 0.3f * Mth.m_14031_((float)(0.2f * ageInTicks / 1.5f));
                this.FootRight.f_104203_ = 0.5f - 0.3f * Mth.m_14031_((float)(0.2f * ageInTicks / 1.5f));
                this.FootLeft.f_104203_ = 0.5f + 0.3f * Mth.m_14031_((float)(0.2f * ageInTicks / 1.5f));
                this.Tail.f_104204_ = Mth.m_14089_((float)(limbSwing * 2.6662f)) * 1.4f * limbSwingAmount + 0.0625f * Mth.m_14031_((float)(0.15f * ageInTicks / 1.5f));
                this.Tail2.f_104204_ = Mth.m_14089_((float)(limbSwing * 2.6662f)) * 1.4f * limbSwingAmount + 0.0625f * Mth.m_14031_((float)(0.15f * ageInTicks / 1.5f));
            }
        }
    }

    public void resetModel() {
        this.Head.f_104201_ = -9.5f;
        this.Head.f_104203_ = -0.20001474f;
        this.Head.f_104204_ = 0.0f;
        this.Head.f_104205_ = 0.0f;
        this.Tail2.f_104200_ = 0.0f;
        this.Tail2.f_104203_ = 0.05f;
        this.Tail2.f_104204_ = 0.0f;
        this.Tail2.f_104205_ = 0.0f;
        this.FootLeft.f_104200_ = 0.0f;
        this.FootLeft.f_104201_ = 14.0f;
        this.FootLeft.f_104202_ = 1.0f;
        this.FootLeft.f_104203_ = 0.0f;
        this.FootLeft.f_104204_ = 0.0f;
        this.FootLeft.f_104205_ = 0.0f;
        this.Leg2Right.f_104201_ = 10.0f;
        this.Leg2Right.f_104202_ = 2.0f;
        this.Leg2Right.f_104203_ = 0.10000737f;
        this.Leg2Right.f_104204_ = 0.0f;
        this.Leg2Right.f_104205_ = 0.0f;
        this.Neck.f_104200_ = 0.0f;
        this.Neck.f_104201_ = 3.0f;
        this.Neck.f_104202_ = -25.0f;
        this.Neck.f_104203_ = 0.35f;
        this.Neck.f_104204_ = 0.0f;
        this.Neck.f_104205_ = 0.0f;
        this.Tail.f_104203_ = -0.05f;
        this.Tail.f_104204_ = 0.0f;
        this.Tail.f_104204_ = 0.0f;
        this.Torso.f_104200_ = 0.0f;
        this.Torso.f_104201_ = -3.0f;
        this.Torso.f_104203_ = 0.0f;
        this.Torso.f_104204_ = 0.0f;
        this.Torso.f_104205_ = 0.0f;
        this.ArmLeft.f_104200_ = -2.5f;
        this.ArmLeft.f_104201_ = 5.0f;
        this.ArmLeft.f_104203_ = 0.14992379f;
        this.ArmLeft.f_104204_ = 0.0f;
        this.ArmLeft.f_104205_ = 0.0f;
        this.FootRight.f_104200_ = 0.0f;
        this.FootRight.f_104201_ = 14.0f;
        this.FootRight.f_104202_ = 1.0f;
        this.FootRight.f_104203_ = 0.0f;
        this.FootRight.f_104204_ = 0.0f;
        this.FootRight.f_104205_ = 0.0f;
        this.Leg2Left.f_104201_ = 10.0f;
        this.Leg2Left.f_104203_ = 0.10000737f;
        this.Leg2Left.f_104204_ = 0.0f;
        this.Leg2Left.f_104205_ = 0.0f;
        this.Leg1Right.f_104200_ = 3.0f;
        this.Leg1Right.f_104201_ = -2.0f;
        this.Leg1Right.f_104202_ = 5.0f;
        this.Leg1Right.f_104203_ = -0.10000737f;
        this.Leg1Right.f_104204_ = 0.0f;
        this.Leg1Right.f_104205_ = 0.0f;
        this.Leg1Left.f_104200_ = -2.0f;
        this.Leg1Left.f_104201_ = -2.0f;
        this.Leg1Left.f_104202_ = 5.0f;
        this.Leg1Left.f_104203_ = -0.10000737f;
        this.Leg1Left.f_104204_ = 0.0f;
        this.Leg1Left.f_104205_ = 0.0f;
        this.ArmRight.f_104200_ = 2.5f;
        this.ArmRight.f_104201_ = 5.0f;
        this.ArmRight.f_104203_ = 0.14992379f;
        this.ArmRight.f_104204_ = 0.0f;
        this.ArmRight.f_104205_ = 0.0f;
    }

    public void sleepPose() {
        this.Head.f_104201_ = -10.0f;
        this.Head.f_104203_ = -0.07819075f;
        this.Head.f_104204_ = 0.03874631f;
        this.Head.f_104205_ = 0.19547687f;
        this.Tail2.f_104200_ = -0.5f;
        this.Tail2.f_104203_ = -0.43004912f;
        this.Tail2.f_104204_ = 0.19547687f;
        this.Tail2.f_104205_ = -0.19547687f;
        this.FootLeft.f_104201_ = 15.0f;
        this.FootLeft.f_104202_ = 0.0f;
        this.FootLeft.f_104203_ = 2.0722294f;
        this.FootLeft.f_104204_ = 1.7453292E-4f;
        this.FootLeft.f_104205_ = 0.037350047f;
        this.Leg2Right.f_104201_ = 11.0f;
        this.Leg2Right.f_104202_ = 5.0f;
        this.Leg2Right.f_104203_ = -1.3685127f;
        this.Leg2Right.f_104204_ = -1.7453292E-4f;
        this.Leg2Right.f_104205_ = 0.43004912f;
        this.Neck.f_104200_ = -1.0f;
        this.Neck.f_104201_ = 1.0f;
        this.Neck.f_104202_ = -24.0f;
        this.Neck.f_104203_ = 1.6418313f;
        this.Neck.f_104204_ = 0.31223938f;
        this.Neck.f_104205_ = -0.23457225f;
        this.Tail.f_104203_ = -0.27366763f;
        this.Tail.f_104204_ = -0.07819075f;
        this.Tail.f_104205_ = 0.0f;
        this.Torso.f_104200_ = -3.0f;
        this.Torso.f_104201_ = 19.0f;
        this.Torso.f_104203_ = -0.11728612f;
        this.Torso.f_104204_ = -0.03926991f;
        this.Torso.f_104205_ = -1.2901473f;
        this.ArmLeft.f_104200_ = -3.0f;
        this.ArmLeft.f_104201_ = 2.0f;
        this.ArmLeft.f_104203_ = -0.039095376f;
        this.ArmLeft.f_104204_ = -0.039095376f;
        this.ArmLeft.f_104205_ = -0.23457225f;
        this.FootRight.f_104201_ = 15.0f;
        this.FootRight.f_104202_ = 0.9f;
        this.FootRight.f_104203_ = 1.8387043f;
        this.FootRight.f_104204_ = -0.15725417f;
        this.FootRight.f_104205_ = -0.1563815f;
        this.Leg2Left.f_104201_ = 11.0f;
        this.Leg2Left.f_104203_ = -0.43004912f;
        this.Leg2Left.f_104204_ = -0.11728612f;
        this.Leg2Left.f_104205_ = -0.19547687f;
        this.Leg1Right.f_104200_ = 0.5f;
        this.Leg1Right.f_104201_ = 17.0f;
        this.Leg1Right.f_104202_ = 7.0f;
        this.Leg1Right.f_104203_ = -0.1563815f;
        this.Leg1Right.f_104204_ = -1.7453292E-4f;
        this.Leg1Right.f_104205_ = -1.0555751f;
        this.Leg1Left.f_104200_ = -2.5f;
        this.Leg1Left.f_104201_ = 21.2f;
        this.Leg1Left.f_104202_ = 5.0f;
        this.Leg1Left.f_104203_ = 0.43004912f;
        this.Leg1Left.f_104204_ = -0.11728612f;
        this.Leg1Left.f_104205_ = -1.4467034f;
        this.ArmRight.f_104200_ = 3.0f;
        this.ArmRight.f_104201_ = 6.0f;
        this.ArmRight.f_104203_ = 0.27384216f;
        this.ArmRight.f_104204_ = 0.43004912f;
        this.ArmRight.f_104205_ = 0.70354223f;
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.Torso.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.Leg1Left.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.Leg1Right.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
    }
}

