/*
 * Decompiled with CFR 0.152.
 */
package superlord.prehistoricfauna.client.model.henos;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import superlord.prehistoricfauna.common.entity.henos.Henos;

public class HenosModel
extends EntityModel<Henos> {
    private final ModelPart Body;
    private final ModelPart RLeg;
    private final ModelPart LLeg;
    private final ModelPart Head;
    private final ModelPart Hips;
    private final ModelPart LArm;
    private final ModelPart RArm;
    private final ModelPart RThumb;
    private final ModelPart ROFinger;
    private final ModelPart RIFinger;
    private final ModelPart RMFinger;
    private final ModelPart LThumb;
    private final ModelPart LOFinger;
    private final ModelPart LIFinger;
    private final ModelPart LMFinger;

    public HenosModel(ModelPart root, float modelScale) {
        this.Body = root.m_171324_("Body");
        this.Hips = this.Body.m_171324_("Hips");
        this.RLeg = this.Hips.m_171324_("RLeg");
        this.LLeg = this.Hips.m_171324_("LLeg");
        this.Head = this.Body.m_171324_("Head");
        this.LArm = this.Body.m_171324_("LArm");
        this.RArm = this.Body.m_171324_("RArm");
        this.LIFinger = this.LArm.m_171324_("LIFinger");
        this.LMFinger = this.LArm.m_171324_("LMFinger");
        this.LOFinger = this.LArm.m_171324_("LOFinger");
        this.LThumb = this.LArm.m_171324_("LThumb");
        this.RIFinger = this.RArm.m_171324_("RIFinger");
        this.RMFinger = this.RArm.m_171324_("RMFinger");
        this.ROFinger = this.RArm.m_171324_("ROFinger");
        this.RThumb = this.RArm.m_171324_("RThumb");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition Body = partdefinition.m_171599_("Body", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-34.0f, 0.0f, 0.0f, 34.0f, 21.0f, 21.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)17.0f, (float)-20.0f, (float)-11.0f));
        PartDefinition Hips = Body.m_171599_("Hips", CubeListBuilder.m_171558_().m_171514_(56, 42).m_171488_(-8.0f, 0.0f, -6.0f, 16.0f, 9.0f, 13.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-17.0f, (float)21.1f, (float)11.0f));
        PartDefinition RLeg = Hips.m_171599_("RLeg", CubeListBuilder.m_171558_().m_171514_(56, 64).m_171488_(-9.0f, -1.0f, -4.0f, 9.0f, 17.0f, 9.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-4.0f, (float)7.0f, (float)0.0f));
        PartDefinition LLeg = Hips.m_171599_("LLeg", CubeListBuilder.m_171558_().m_171514_(56, 64).m_171488_(0.0f, -1.0f, -4.0f, 9.0f, 17.0f, 9.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)4.0f, (float)7.0f, (float)0.0f));
        PartDefinition RArm = Body.m_171599_("RArm", CubeListBuilder.m_171558_().m_171514_(0, 42).m_171488_(-14.0f, -4.0f, -7.0f, 14.0f, 20.0f, 14.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-36.0f, (float)13.0f, (float)11.0f));
        PartDefinition RMFinger = RArm.m_171599_("RMFinger", CubeListBuilder.m_171558_().m_171514_(1, 44).m_171488_(-1.5f, 0.0f, -1.5f, 3.0f, 8.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-7.5f, (float)17.0f, (float)-5.5f));
        PartDefinition RThumb = RArm.m_171599_("RThumb", CubeListBuilder.m_171558_().m_171514_(1, 44).m_171488_(0.0f, 0.0f, -1.5f, 3.0f, 8.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)1.0f, (float)11.0f, (float)-3.5f));
        PartDefinition RIFinger = RArm.m_171599_("RIFinger", CubeListBuilder.m_171558_().m_171514_(1, 44).m_171488_(-1.5f, 0.0f, -1.5f, 3.0f, 8.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-2.5f, (float)17.0f, (float)-5.5f));
        PartDefinition ROFinger = RArm.m_171599_("ROFinger", CubeListBuilder.m_171558_().m_171514_(1, 44).m_171488_(-1.5f, 0.0f, -1.5f, 3.0f, 8.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-12.5f, (float)17.0f, (float)-5.5f));
        PartDefinition LArm = Body.m_171599_("LArm", CubeListBuilder.m_171558_().m_171514_(0, 42).m_171488_(0.0f, -4.0f, -7.0f, 14.0f, 20.0f, 14.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)2.0f, (float)13.0f, (float)11.0f));
        PartDefinition LMFinger = LArm.m_171599_("LMFinger", CubeListBuilder.m_171558_().m_171514_(1, 44).m_171488_(-1.5f, 0.0f, -1.5f, 3.0f, 8.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)7.5f, (float)17.0f, (float)-5.5f));
        PartDefinition LIFinger = LArm.m_171599_("LIFinger", CubeListBuilder.m_171558_().m_171514_(1, 44).m_171488_(-1.5f, 0.0f, -1.5f, 3.0f, 8.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)2.5f, (float)17.0f, (float)-5.5f));
        PartDefinition LOFinger = LArm.m_171599_("LOFinger", CubeListBuilder.m_171558_().m_171514_(1, 44).m_171488_(-1.5f, 0.0f, -1.5f, 3.0f, 8.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)12.5f, (float)17.0f, (float)-5.5f));
        PartDefinition LThumb = LArm.m_171599_("LThumb", CubeListBuilder.m_171558_().m_171514_(1, 44).m_171488_(-3.0f, 0.0f, -1.5f, 3.0f, 8.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-1.0f, (float)11.0f, (float)-3.5f));
        PartDefinition Head = Body.m_171599_("Head", CubeListBuilder.m_171558_().m_171514_(0, 76).m_171488_(-6.0f, -7.0f, -12.0f, 12.0f, 14.0f, 12.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-17.0f, (float)1.0f, (float)5.0f));
        PartDefinition LEar = Head.m_171599_("LEar", CubeListBuilder.m_171558_().m_171514_(37, 77).m_171488_(0.0f, -3.0f, -1.0f, 6.0f, 7.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)6.0f, (float)-3.0f, (float)-7.0f));
        PartDefinition Mouth = Head.m_171599_("Mouth", CubeListBuilder.m_171558_().m_171514_(49, 91).m_171488_(-10.0f, -3.0f, -4.0f, 20.0f, 7.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)5.0f, (float)-10.0f));
        PartDefinition REar = Head.m_171599_("REar", CubeListBuilder.m_171558_().m_171514_(37, 77).m_171480_().m_171488_(-6.0f, -3.0f, -1.0f, 6.0f, 7.0f, 3.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)-6.0f, (float)-3.0f, (float)-7.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)250, (int)128);
    }

    public void setupAnim(Henos entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        float f = ageInTicks - (float)entity.f_19797_;
        this.RLeg.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
        this.LLeg.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
        float attackRight = entity.getMeleeProgress(false, f) / 5.0f;
        float attackLeft = entity.getMeleeProgress(true, f) / 5.0f;
        float attack = Math.max(attackLeft, attackRight);
        float rightFingerCurl = attackRight * (float)Math.toRadians(80.0);
        float leftFingerCurl = attackLeft * (float)Math.toRadians(80.0);
        float bodyYaw = attack * (float)Math.toRadians(20.0);
        this.LArm.f_104203_ = attackLeft * (float)Math.toRadians(-100.0) + Mth.m_14089_((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount * (1.0f - attack);
        this.LArm.f_104204_ = leftFingerCurl * 0.25f;
        this.LArm.f_104205_ = leftFingerCurl * 0.15f;
        this.RArm.f_104203_ = attackRight * (float)Math.toRadians(-100.0) + Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount * (1.0f - attack);
        this.RArm.f_104204_ = rightFingerCurl * -0.25f;
        this.RArm.f_104205_ = rightFingerCurl * -0.15f;
        this.RIFinger.f_104203_ = rightFingerCurl;
        this.ROFinger.f_104203_ = rightFingerCurl;
        this.RMFinger.f_104203_ = rightFingerCurl;
        this.RThumb.f_104203_ = rightFingerCurl;
        this.LIFinger.f_104203_ = leftFingerCurl;
        this.LOFinger.f_104203_ = leftFingerCurl;
        this.LMFinger.f_104203_ = leftFingerCurl;
        this.LThumb.f_104203_ = leftFingerCurl;
        this.RArm.f_104200_ = -36.0f + attackRight * 5.0f;
        this.RArm.f_104202_ = 11.0f + attackRight * -16.0f;
        this.RThumb.f_104200_ = 1.0f + attackRight * 1.0f;
        this.RThumb.f_104201_ = 11.0f + attackRight * 2.0f;
        this.LArm.f_104200_ = 2.0f - attackLeft * 5.0f;
        this.LArm.f_104202_ = 11.0f + attackLeft * -16.0f;
        this.LThumb.f_104200_ = -1.0f - attackLeft * 1.0f;
        this.LThumb.f_104201_ = 11.0f + attackLeft * 2.0f;
        this.Body.f_104201_ = -20.0f + attack * 5.0f;
        this.Body.f_104202_ = -11.0f - attack * 8.0f;
        this.Body.f_104203_ = bodyYaw;
        this.Hips.f_104203_ = -bodyYaw;
        this.Head.f_104203_ = headPitch * ((float)Math.PI / 180) - bodyYaw;
        this.Head.f_104204_ = netHeadYaw * ((float)Math.PI / 180) - this.Body.f_104204_;
        this.Body.f_104204_ = attackLeft * (float)Math.toRadians(20.0) + attackRight * (float)Math.toRadians(-20.0);
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.Body.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
    }
}

