/*
 * Decompiled with CFR 0.152.
 */
package superlord.prehistoricfauna.client.model.cretaceous.yixian;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import superlord.prehistoricfauna.common.entity.DinosaurEntity;
import superlord.prehistoricfauna.common.entity.cretaceous.yixian.Zhenyuanlong;

public class ZhenyuanlongModel
extends EntityModel<Zhenyuanlong> {
    private final ModelPart Body;
    private final ModelPart Neck;
    private final ModelPart Head;
    private final ModelPart FeatherDisplay;
    private final ModelPart Tail;
    private final ModelPart LeftThigh;
    private final ModelPart LeftLeg;
    private final ModelPart LeftFoot;
    private final ModelPart LeftWing;
    private final ModelPart RightWing;
    private final ModelPart RightThigh;
    private final ModelPart RightLeg;
    private final ModelPart RightFoot;

    public ZhenyuanlongModel(ModelPart root) {
        this.Body = root.m_171324_("Body");
        this.Neck = this.Body.m_171324_("Neck");
        this.Head = this.Neck.m_171324_("Head");
        this.FeatherDisplay = this.Head.m_171324_("FeatherDisplay");
        this.Tail = this.Body.m_171324_("Tail");
        this.LeftThigh = this.Body.m_171324_("LeftThigh");
        this.LeftLeg = this.LeftThigh.m_171324_("LeftLeg");
        this.LeftFoot = this.LeftLeg.m_171324_("LeftFoot");
        this.LeftWing = this.Body.m_171324_("LeftWing");
        this.RightWing = this.Body.m_171324_("RightWing");
        this.RightThigh = this.Body.m_171324_("RightThigh");
        this.RightLeg = this.RightThigh.m_171324_("RightLeg");
        this.RightFoot = this.RightLeg.m_171324_("RightFoot");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition Body = partdefinition.m_171599_("Body", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-2.0f, -2.5f, -7.5f, 4.0f, 5.0f, 9.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)14.5f, (float)3.5f));
        PartDefinition Neck = Body.m_171599_("Neck", CubeListBuilder.m_171558_().m_171514_(0, 14).m_171488_(-1.0f, -5.0f, -2.0f, 2.0f, 6.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-1.0f, (float)-7.5f));
        PartDefinition Head = Neck.m_171599_("Head", CubeListBuilder.m_171558_().m_171514_(0, 23).m_171488_(-1.5f, -0.6f, -6.0f, 3.0f, 3.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-4.5f, (float)0.0f));
        PartDefinition FeatherDisplay = Head.m_171599_("FeatherDisplay", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition feather_display_right_r1 = FeatherDisplay.m_171599_("feather_display_right_r1", CubeListBuilder.m_171558_().m_171514_(0, 30).m_171480_().m_171488_(0.0f, -2.0f, 0.0f, 0.0f, 2.0f, 4.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)-1.5f, (float)-0.5f, (float)-2.0f, (float)0.3054f, (float)-0.2618f, (float)0.0f));
        PartDefinition feather_display_left_r1 = FeatherDisplay.m_171599_("feather_display_left_r1", CubeListBuilder.m_171558_().m_171514_(0, 30).m_171488_(0.0f, -2.0f, 0.0f, 0.0f, 2.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)1.5f, (float)-0.5f, (float)-2.0f, (float)0.3054f, (float)0.2618f, (float)0.0f));
        PartDefinition Tail = Body.m_171599_("Tail", CubeListBuilder.m_171558_().m_171514_(27, 5).m_171488_(-1.0f, -0.99f, -1.0f, 2.0f, 2.0f, 4.0f, new CubeDeformation(0.0f)).m_171514_(28, 0).m_171488_(-2.0f, -1.0f, 3.0f, 4.0f, 4.0f, 14.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-1.5f, (float)1.5f));
        PartDefinition LeftThigh = Body.m_171599_("LeftThigh", CubeListBuilder.m_171558_().m_171514_(54, 18).m_171488_(-1.0f, -1.0f, -1.5f, 2.0f, 4.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)2.0f, (float)0.5f, (float)-1.0f));
        PartDefinition LeftLeg = LeftThigh.m_171599_("LeftLeg", CubeListBuilder.m_171558_().m_171514_(57, 26).m_171488_(-0.5f, 0.0f, 0.0f, 1.0f, 6.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)3.0f, (float)0.5f));
        PartDefinition LeftFoot = LeftLeg.m_171599_("LeftFoot", CubeListBuilder.m_171558_().m_171514_(52, 34).m_171488_(-0.5f, -2.0f, -3.0f, 2.0f, 2.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)6.0f, (float)0.0f));
        PartDefinition LeftWing = Body.m_171599_("LeftWing", CubeListBuilder.m_171558_().m_171514_(37, 18).m_171488_(0.0f, -1.0f, -1.0f, 1.0f, 7.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)2.0f, (float)0.5f, (float)-6.5f));
        PartDefinition RightWing = Body.m_171599_("RightWing", CubeListBuilder.m_171558_().m_171514_(37, 18).m_171480_().m_171488_(-1.0f, -1.0f, -1.0f, 1.0f, 7.0f, 5.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)-2.0f, (float)0.5f, (float)-6.5f));
        PartDefinition RightThigh = Body.m_171599_("RightThigh", CubeListBuilder.m_171558_().m_171514_(54, 18).m_171480_().m_171488_(-1.0f, -1.0f, -1.5f, 2.0f, 4.0f, 3.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)-2.0f, (float)0.5f, (float)-1.0f));
        PartDefinition RightLeg = RightThigh.m_171599_("RightLeg", CubeListBuilder.m_171558_().m_171514_(57, 26).m_171480_().m_171488_(-0.5f, 0.0f, 0.0f, 1.0f, 6.0f, 0.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)0.0f, (float)3.0f, (float)0.5f));
        PartDefinition RightFoot = RightLeg.m_171599_("RightFoot", CubeListBuilder.m_171558_().m_171514_(52, 34).m_171480_().m_171488_(-0.5f, -2.0f, -3.0f, 2.0f, 2.0f, 3.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)-1.0f, (float)6.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)48);
    }

    public void setupAnim(Zhenyuanlong entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        float partialTick = ageInTicks - (float)entity.f_19797_;
        float attackProgress = entity.getMeleeProgress(partialTick);
        float speed = 1.0f;
        float degree = 1.0f;
        float sleepProgress = entity.getSleepProgress(partialTick);
        this.resetModel();
        if (entity.isAsleep()) {
            if (sleepProgress != 0.0f && (Integer)entity.m_20088_().m_135370_(DinosaurEntity.SLEEP_TICK) > 0) {
                this.Body.f_104201_ = Mth.m_14179_((float)sleepProgress, (float)14.5f, (float)21.4f);
                this.Body.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-0.17463292f);
                this.LeftWing.f_104205_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-0.9f);
                this.RightWing.f_104205_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)0.9f);
                this.RightThigh.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-0.8134f);
                this.RightThigh.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)0.2176f);
                this.RightLeg.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-0.6f);
                this.Tail.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-0.13962634f);
                this.Tail.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)1.0471976f);
                this.Neck.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-2.268928f);
                this.Neck.f_104205_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)0.83774805f);
                this.LeftThigh.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-0.8134f);
                this.LeftThigh.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-0.2176f);
                this.LeftLeg.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-0.6f);
                this.LeftFoot.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)1.6f);
                this.RightFoot.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)1.6f);
            } else {
                this.sleepPose();
            }
            this.Body.f_104203_ = Math.abs(-0.025f * Mth.m_14031_((float)(0.1f * ageInTicks / 3.0f))) - 0.17463292f;
            this.Head.f_104203_ = headPitch * ((float)Math.PI / 180) + Math.abs(-0.025f * Mth.m_14031_((float)(0.1f * ageInTicks / 3.0f)));
            this.RightWing.f_104205_ = -Math.abs(-0.05f * Mth.m_14031_((float)(0.15f * ageInTicks / 3.0f))) + 0.9f;
            this.LeftWing.f_104205_ = Math.abs(-0.05f * Mth.m_14031_((float)(0.15f * ageInTicks / 3.0f))) - 0.9f;
            this.RightThigh.f_104203_ = -0.8134f - Math.abs(-0.025f * Mth.m_14031_((float)(0.1f * ageInTicks / 3.0f)));
            this.LeftThigh.f_104203_ = -0.8134f - Math.abs(-0.025f * Mth.m_14031_((float)(0.1f * ageInTicks / 3.0f)));
        } else if (sleepProgress != 0.0f && (Integer)entity.m_20088_().m_135370_(DinosaurEntity.SLEEP_TICK) > 0) {
            this.Body.f_104201_ = Mth.m_14179_((float)sleepProgress, (float)21.4f, (float)14.5f);
            this.Body.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)-0.17463292f, (float)0.0f);
            this.LeftWing.f_104205_ = Mth.m_14179_((float)sleepProgress, (float)-0.9f, (float)0.0f);
            this.RightWing.f_104205_ = Mth.m_14179_((float)sleepProgress, (float)0.9f, (float)0.0f);
            this.RightThigh.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)-0.8134f, (float)0.0f);
            this.RightThigh.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)0.2176f, (float)0.0f);
            this.RightLeg.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)-0.6f, (float)0.0f);
            this.Tail.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)-0.13962634f, (float)0.0f);
            this.Tail.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)1.0471976f, (float)0.0f);
            this.Neck.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)-2.268928f, (float)0.0f);
            this.Neck.f_104205_ = Mth.m_14179_((float)sleepProgress, (float)0.83774805f, (float)0.0f);
            this.LeftThigh.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)-0.8134f, (float)0.0f);
            this.LeftThigh.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)-0.2176f, (float)0.0f);
            this.LeftLeg.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)-0.6f, (float)0.0f);
            this.LeftFoot.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)1.6f, (float)0.0f);
            this.RightFoot.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)1.6f, (float)0.0f);
        } else {
            this.RightThigh.f_104203_ = Mth.m_14031_((float)(0.4f * limbSwing)) * 0.25f * limbSwingAmount;
            this.RightLeg.f_104203_ = Mth.m_14031_((float)(limbSwing * 0.4f)) * 0.65f * limbSwingAmount - 0.25f * limbSwingAmount * 2.0f;
            this.RightFoot.f_104203_ = Mth.m_14031_((float)(limbSwing * 0.4f)) * 0.325f * limbSwingAmount + 0.35f * limbSwingAmount * 2.0f;
            this.LeftThigh.f_104203_ = Mth.m_14031_((float)(0.4f * limbSwing + (float)Math.PI)) * 0.25f * limbSwingAmount;
            this.LeftLeg.f_104203_ = Mth.m_14031_((float)(limbSwing * 0.4f + (float)Math.PI)) * 0.65f * limbSwingAmount - 0.25f * limbSwingAmount * 2.0f;
            this.LeftFoot.f_104203_ = Mth.m_14031_((float)(limbSwing * 0.4f + (float)Math.PI)) * 0.325f * limbSwingAmount + 0.35f * limbSwingAmount * 2.0f;
            this.Neck.f_104204_ = netHeadYaw * ((float)Math.PI / 180);
            this.Neck.f_104203_ = headPitch * ((float)Math.PI / 180) + Math.abs(-0.025f * Mth.m_14031_((float)(0.1f * ageInTicks / 3.0f))) + 0.25f;
            this.Tail.f_104203_ = -Math.abs(-0.05f * Mth.m_14031_((float)(0.1f * ageInTicks / 5.0f))) + Mth.m_14031_((float)(limbSwing * 0.6f)) * 0.15f * limbSwingAmount - 0.1f;
            this.Tail.f_104204_ = -Math.abs(-0.05f * Mth.m_14031_((float)(0.1f * ageInTicks / 5.0f))) + Mth.m_14031_((float)(limbSwing * 0.6f)) * 0.15f * limbSwingAmount - 0.1f;
            this.LeftWing.f_104203_ = Mth.m_14031_((float)(limbSwing * 0.4f)) * 0.1f * limbSwingAmount + 0.1f;
            this.RightWing.f_104203_ = Mth.m_14031_((float)(limbSwing * 0.4f)) * 0.1f * limbSwingAmount + 0.1f;
            this.RightWing.f_104205_ = Math.abs(-0.05f * Mth.m_14031_((float)(0.15f * ageInTicks / 3.0f)));
            this.LeftWing.f_104205_ = -Math.abs(-0.05f * Mth.m_14031_((float)(0.15f * ageInTicks / 3.0f)));
            if (entity.m_20069_()) {
                this.LeftWing.f_104205_ = -1.5f + Math.abs(-1.0f * Mth.m_14031_((float)(0.15f * ageInTicks / 2.0f)));
                this.RightWing.f_104205_ = 1.5f - Math.abs(-1.0f * Mth.m_14031_((float)(0.15f * ageInTicks / 2.0f)));
                this.LeftThigh.f_104203_ = -0.25f * Mth.m_14031_((float)(0.2f * ageInTicks / 1.5f));
                this.RightThigh.f_104203_ = 0.25f * Mth.m_14031_((float)(0.2f * ageInTicks / 1.5f));
                this.Tail.f_104204_ = Mth.m_14089_((float)(limbSwing * 2.6662f)) * 1.4f * limbSwingAmount;
                this.LeftLeg.f_104203_ = -0.3f * Mth.m_14031_((float)(0.2f * ageInTicks / 1.5f));
                this.RightLeg.f_104203_ = 0.3f * Mth.m_14031_((float)(0.2f * ageInTicks / 1.5f));
                this.Body.f_104201_ = 20.0f;
            }
        }
    }

    public void resetModel() {
        this.Body.f_104201_ = 14.5f;
        this.Body.f_104203_ = 0.0f;
        this.LeftWing.f_104205_ = 0.0f;
        this.RightWing.f_104205_ = 0.0f;
        this.RightThigh.f_104203_ = 0.0f;
        this.RightThigh.f_104204_ = 0.0f;
        this.RightLeg.f_104203_ = 0.0f;
        this.Tail.f_104203_ = 0.0f;
        this.Tail.f_104204_ = 0.0f;
        this.Neck.f_104204_ = 0.0f;
        this.Neck.f_104205_ = 0.0f;
        this.LeftThigh.f_104203_ = 0.0f;
        this.LeftThigh.f_104204_ = 0.0f;
        this.LeftLeg.f_104203_ = 0.0f;
        this.LeftFoot.f_104203_ = 0.0f;
        this.RightFoot.f_104203_ = 0.0f;
        this.Tail.f_104201_ = -1.35f;
    }

    public void sleepPose() {
        this.Body.f_104201_ = 21.4f;
        this.Body.f_104203_ = -0.17463292f;
        this.LeftWing.f_104205_ = -0.9f;
        this.RightWing.f_104205_ = 0.9f;
        this.RightThigh.f_104203_ = -0.8134f;
        this.RightThigh.f_104204_ = 0.2176f;
        this.RightLeg.f_104203_ = -0.6f;
        this.Tail.f_104203_ = -0.13962634f;
        this.Tail.f_104204_ = 1.0471976f;
        this.Neck.f_104204_ = -2.268928f;
        this.Neck.f_104205_ = 0.83774805f;
        this.LeftThigh.f_104203_ = -0.8134f;
        this.LeftThigh.f_104204_ = -0.2176f;
        this.LeftLeg.f_104203_ = -0.6f;
        this.LeftFoot.f_104203_ = 1.6f;
        this.RightFoot.f_104203_ = 1.6f;
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.Body.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
    }
}

