/*
 * Decompiled with CFR 0.152.
 */
package superlord.prehistoricfauna.client.model.cretaceous.yixian;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import superlord.prehistoricfauna.common.entity.DinosaurEntity;
import superlord.prehistoricfauna.common.entity.cretaceous.yixian.Incisivosaurus;

public class IncisivosaurusModel
extends EntityModel<Incisivosaurus> {
    private final ModelPart Body;
    private final ModelPart Head;
    private final ModelPart Tail1;
    private final ModelPart LeftWing;
    private final ModelPart RightWing;
    private final ModelPart RightThigh;
    private final ModelPart RightLeg;
    private final ModelPart RightFoot;
    private final ModelPart LeftThigh;
    private final ModelPart LeftLeg;
    private final ModelPart LeftFoot;

    public IncisivosaurusModel(ModelPart root) {
        this.Body = root.m_171324_("Body");
        this.Head = this.Body.m_171324_("Head");
        this.Tail1 = this.Body.m_171324_("Tail1");
        this.RightWing = this.Body.m_171324_("RightWing");
        this.LeftWing = this.Body.m_171324_("LeftWing");
        this.RightThigh = this.Body.m_171324_("RightThigh");
        this.RightLeg = this.RightThigh.m_171324_("RightLeg");
        this.RightFoot = this.RightLeg.m_171324_("RightFoot");
        this.LeftThigh = this.Body.m_171324_("LeftThigh");
        this.LeftLeg = this.LeftThigh.m_171324_("LeftLeg");
        this.LeftFoot = this.LeftLeg.m_171324_("LeftFoot");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition Body = partdefinition.m_171599_("Body", CubeListBuilder.m_171558_().m_171514_(15, 7).m_171488_(-3.0f, 0.0f, 0.0f, 3.0f, 4.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)2.0f, (float)16.0f, (float)-5.0f, (float)0.0f, (float)0.0f, (float)-0.0087f));
        PartDefinition Tail1 = Body.m_171599_("Tail1", CubeListBuilder.m_171558_().m_171514_(8, 0).m_171488_(-1.0f, -1.0f, 0.0f, 2.0f, 2.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-1.5f, (float)1.0f, (float)7.0f));
        PartDefinition TailFan = Tail1.m_171599_("TailFan", CubeListBuilder.m_171558_().m_171514_(2, 7).m_171488_(-2.0f, 0.0f, 0.0f, 4.0f, 1.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-0.99f, (float)3.0f));
        PartDefinition Head = Body.m_171599_("Head", CubeListBuilder.m_171558_().m_171514_(0, 6).m_171488_(-1.0f, -3.0f, -1.0f, 2.0f, 5.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-1.5f, (float)0.0f, (float)0.0f));
        PartDefinition Snout = Head.m_171599_("Snout", CubeListBuilder.m_171558_().m_171514_(18, 2).m_171488_(-2.0f, 0.0f, 0.0f, 2.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)1.0f, (float)-3.0f, (float)-2.0f));
        PartDefinition Teeth = Snout.m_171599_("Teeth", CubeListBuilder.m_171558_().m_171514_(26, 0).m_171488_(-1.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-0.5f, (float)1.5f, (float)0.05f, (float)-0.0017f, (float)0.0f, (float)0.0f));
        PartDefinition HeadFeathers = Head.m_171599_("HeadFeathers", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(0.0f, -0.5f, -0.5f, 0.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-3.0f, (float)0.0f, (float)0.6255f, (float)0.0f, (float)0.0f));
        PartDefinition RightWing = Body.m_171599_("RightWing", CubeListBuilder.m_171558_().m_171514_(28, 6).m_171480_().m_171488_(-1.0f, -1.0f, -1.0f, 1.0f, 5.0f, 3.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)-2.5f, (float)2.0f, (float)1.1f));
        PartDefinition LeftWing = Body.m_171599_("LeftWing", CubeListBuilder.m_171558_().m_171514_(28, 6).m_171488_(0.0f, -1.0f, -1.0f, 1.0f, 5.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-0.5f, (float)2.0f, (float)1.1f));
        PartDefinition RightThigh = Body.m_171599_("RightThigh", CubeListBuilder.m_171558_().m_171514_(16, 7).m_171480_().m_171488_(-1.0f, -1.0f, -1.0f, 1.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)-2.5f, (float)2.0f, (float)5.9f));
        PartDefinition RightLeg = RightThigh.m_171599_("RightLeg", CubeListBuilder.m_171558_().m_171514_(30, 3).m_171488_(-1.0f, 0.0f, 0.0f, 1.0f, 3.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)3.0f, (float)1.0f));
        PartDefinition RightFoot = RightLeg.m_171599_("RightFoot", CubeListBuilder.m_171558_().m_171514_(5, 0).m_171488_(-2.0f, 0.0f, -2.0f, 2.0f, 0.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)3.0f, (float)0.0f));
        PartDefinition LeftThigh = Body.m_171599_("LeftThigh", CubeListBuilder.m_171558_().m_171514_(16, 7).m_171488_(0.0f, -1.0f, -1.0f, 1.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-0.5f, (float)2.0f, (float)5.9f));
        PartDefinition LeftLeg = LeftThigh.m_171599_("LeftLeg", CubeListBuilder.m_171558_().m_171514_(30, 3).m_171488_(-1.0f, 0.0f, 0.0f, 1.0f, 3.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)1.0f, (float)3.0f, (float)1.0f));
        PartDefinition LeftFoot = LeftLeg.m_171599_("LeftFoot", CubeListBuilder.m_171558_().m_171514_(5, 0).m_171480_().m_171488_(-2.0f, 0.0f, -2.0f, 2.0f, 0.0f, 2.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)1.0f, (float)3.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)36, (int)18);
    }

    public void setupAnim(Incisivosaurus entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        float partialTick = ageInTicks - (float)entity.f_19797_;
        float sleepProgress = entity.getSleepProgress(partialTick);
        this.resetModel();
        if (entity.isAsleep()) {
            if (sleepProgress != 0.0f && (Integer)entity.m_20088_().m_135370_(DinosaurEntity.SLEEP_TICK) > 0) {
                this.Body.f_104201_ = Mth.m_14179_((float)sleepProgress, (float)16.0f, (float)19.5f);
                this.Body.f_104205_ = Mth.m_14179_((float)sleepProgress, (float)-0.0087f, (float)0.0f);
                this.LeftLeg.f_104200_ = Mth.m_14179_((float)sleepProgress, (float)1.0f, (float)0.5f);
                this.LeftLeg.f_104201_ = Mth.m_14179_((float)sleepProgress, (float)3.0f, (float)3.6f);
                this.LeftLeg.f_104202_ = Mth.m_14179_((float)sleepProgress, (float)1.0f, (float)0.5f);
                this.LeftLeg.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)0.07836528f);
                this.LeftLeg.f_104205_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)0.009250244f);
                this.LeftWing.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-1.6030849f);
                this.LeftWing.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-0.03647738f);
                this.LeftWing.f_104205_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-0.6003933f);
                this.LeftThigh.f_104201_ = Mth.m_14179_((float)sleepProgress, (float)2.0f, (float)3.0f);
                this.LeftThigh.f_104202_ = Mth.m_14179_((float)sleepProgress, (float)5.9f, (float)5.0f);
                this.LeftThigh.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-1.6041322f);
                this.LeftThigh.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-0.35185838f);
                this.RightThigh.f_104201_ = Mth.m_14179_((float)sleepProgress, (float)2.0f, (float)3.0f);
                this.RightThigh.f_104202_ = Mth.m_14179_((float)sleepProgress, (float)5.9f, (float)5.0f);
                this.RightThigh.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-1.5653858f);
                this.RightThigh.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)0.312763f);
                this.RightLeg.f_104200_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)0.5f);
                this.RightLeg.f_104201_ = Mth.m_14179_((float)sleepProgress, (float)3.0f, (float)3.6f);
                this.RightLeg.f_104202_ = Mth.m_14179_((float)sleepProgress, (float)1.0f, (float)0.9f);
                this.RightLeg.f_104205_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-0.15620697f);
                this.RightWing.f_104200_ = Mth.m_14179_((float)sleepProgress, (float)-2.5f, (float)-3.5f);
                this.RightWing.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-1.4866714f);
                this.RightWing.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)0.002617994f);
                this.RightWing.f_104205_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)0.2401573f);
                this.Head.f_104202_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-0.1f);
                this.Head.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)0.23177972f);
                this.Head.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-0.39357173f);
                this.Head.f_104205_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)0.3726278f);
                this.Tail1.f_104201_ = Mth.m_14179_((float)sleepProgress, (float)1.0f, (float)0.9f);
                this.Tail1.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-0.1563815f);
                this.Tail1.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)0.312763f);
                this.Tail1.f_104205_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)0.11903146f);
            } else {
                this.sleepPose();
            }
        } else if (sleepProgress != 0.0f && (Integer)entity.m_20088_().m_135370_(DinosaurEntity.SLEEP_TICK) > 0) {
            this.Body.f_104201_ = Mth.m_14179_((float)sleepProgress, (float)19.5f, (float)16.0f);
            this.Body.f_104205_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-0.0087f);
            this.LeftLeg.f_104200_ = Mth.m_14179_((float)sleepProgress, (float)0.5f, (float)1.0f);
            this.LeftLeg.f_104201_ = Mth.m_14179_((float)sleepProgress, (float)3.6f, (float)3.0f);
            this.LeftLeg.f_104202_ = Mth.m_14179_((float)sleepProgress, (float)0.5f, (float)1.0f);
            this.LeftLeg.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.07836528f, (float)0.0f);
            this.LeftLeg.f_104205_ = Mth.m_14179_((float)sleepProgress, (float)0.009250244f, (float)0.0f);
            this.LeftWing.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)-1.6030849f, (float)0.0f);
            this.LeftWing.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)-0.03647738f, (float)0.0f);
            this.LeftWing.f_104205_ = Mth.m_14179_((float)sleepProgress, (float)-0.6003933f, (float)0.0f);
            this.LeftThigh.f_104201_ = Mth.m_14179_((float)sleepProgress, (float)3.0f, (float)2.0f);
            this.LeftThigh.f_104202_ = Mth.m_14179_((float)sleepProgress, (float)5.0f, (float)5.9f);
            this.LeftThigh.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)-1.6041322f, (float)0.0f);
            this.LeftThigh.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)-0.35185838f, (float)0.0f);
            this.RightThigh.f_104201_ = Mth.m_14179_((float)sleepProgress, (float)3.0f, (float)2.0f);
            this.RightThigh.f_104202_ = Mth.m_14179_((float)sleepProgress, (float)5.0f, (float)5.9f);
            this.RightThigh.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)-1.5653858f, (float)0.0f);
            this.RightThigh.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)0.312763f, (float)0.0f);
            this.RightLeg.f_104200_ = Mth.m_14179_((float)sleepProgress, (float)0.5f, (float)0.0f);
            this.RightLeg.f_104201_ = Mth.m_14179_((float)sleepProgress, (float)3.6f, (float)3.0f);
            this.RightLeg.f_104202_ = Mth.m_14179_((float)sleepProgress, (float)0.9f, (float)1.0f);
            this.RightLeg.f_104205_ = Mth.m_14179_((float)sleepProgress, (float)-0.15620697f, (float)0.0f);
            this.RightWing.f_104200_ = Mth.m_14179_((float)sleepProgress, (float)-3.5f, (float)-2.5f);
            this.RightWing.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)-1.4866714f, (float)0.0f);
            this.RightWing.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)0.002617994f, (float)0.0f);
            this.RightWing.f_104205_ = Mth.m_14179_((float)sleepProgress, (float)0.2401573f, (float)0.0f);
            this.Head.f_104202_ = Mth.m_14179_((float)sleepProgress, (float)-0.1f, (float)0.0f);
            this.Head.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.23177972f, (float)0.0f);
            this.Head.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)-0.39357173f, (float)0.0f);
            this.Head.f_104205_ = Mth.m_14179_((float)sleepProgress, (float)0.3726278f, (float)0.0f);
            this.Tail1.f_104201_ = Mth.m_14179_((float)sleepProgress, (float)0.9f, (float)1.0f);
            this.Tail1.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)-0.1563815f, (float)0.0f);
            this.Tail1.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)0.312763f, (float)0.0f);
            this.Tail1.f_104205_ = Mth.m_14179_((float)sleepProgress, (float)0.11903146f, (float)0.0f);
        } else {
            this.Head.f_104203_ = headPitch * ((float)Math.PI / 180);
            this.Head.f_104204_ = netHeadYaw * ((float)Math.PI / 180);
            this.LeftThigh.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
            this.RightThigh.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
            this.RightWing.f_104205_ = -Mth.m_14089_((float)(0.05f * ageInTicks)) * 0.05f;
            this.LeftWing.f_104205_ = Mth.m_14089_((float)(0.05f * ageInTicks)) * 0.05f;
            this.Tail1.f_104204_ = -Mth.m_14089_((float)(0.05f * ageInTicks)) * 0.05f;
            this.Tail1.f_104203_ = -Mth.m_14089_((float)(0.1f * ageInTicks)) * 0.1f;
            if (entity.isEating()) {
                this.Body.f_104203_ = 0.2f;
                this.Head.f_104203_ = Math.abs(Mth.m_14031_((float)(0.05f * ageInTicks)) * 0.75f) + 0.5f;
            }
            if (entity.m_20069_()) {
                this.Body.f_104201_ = 16.0f;
                this.Body.f_104203_ = -0.125f;
                this.Tail1.f_104203_ = 0.125f;
                this.Head.f_104203_ = 0.125f;
                this.RightLeg.f_104203_ = -0.25f * Mth.m_14031_((float)(0.2f * ageInTicks / 1.5f));
                this.RightThigh.f_104203_ = 0.25f * Mth.m_14031_((float)(0.2f * ageInTicks / 1.5f));
                this.LeftLeg.f_104203_ = -0.3f * Mth.m_14031_((float)(0.2f * ageInTicks / 1.5f));
                this.RightLeg.f_104203_ = 0.3f * Mth.m_14031_((float)(0.2f * ageInTicks / 1.5f));
                this.LeftWing.f_104203_ = 0.25f;
                this.RightWing.f_104203_ = 0.25f;
                this.Tail1.f_104204_ = Mth.m_14089_((float)(limbSwing * 2.6662f)) * 1.4f * limbSwingAmount + 0.0625f * Mth.m_14031_((float)(0.15f * ageInTicks / 1.5f));
            }
        }
    }

    public void resetModel() {
        this.Body.f_104203_ = 0.0f;
        this.Body.f_104205_ = 0.0f;
        this.LeftLeg.f_104203_ = 0.0f;
        this.LeftLeg.f_104204_ = 0.0f;
        this.LeftLeg.f_104205_ = 0.0f;
        this.LeftWing.f_104203_ = 0.0f;
        this.LeftWing.f_104204_ = 0.0f;
        this.LeftWing.f_104205_ = 0.0f;
        this.LeftThigh.f_104203_ = 0.0f;
        this.LeftThigh.f_104204_ = 0.0f;
        this.LeftThigh.f_104205_ = 0.0f;
        this.RightThigh.f_104203_ = 0.0f;
        this.RightThigh.f_104204_ = 0.0f;
        this.RightThigh.f_104205_ = 0.0f;
        this.RightLeg.f_104203_ = 0.0f;
        this.RightLeg.f_104204_ = 0.0f;
        this.RightLeg.f_104205_ = 0.0f;
        this.RightWing.f_104203_ = 0.0f;
        this.RightWing.f_104204_ = 0.0f;
        this.RightWing.f_104205_ = 0.0f;
        this.Head.f_104203_ = 0.0f;
        this.Head.f_104204_ = 0.0f;
        this.Head.f_104205_ = 0.0f;
        this.Tail1.f_104203_ = 0.0f;
        this.Tail1.f_104204_ = 0.0f;
        this.Tail1.f_104205_ = 0.0f;
        this.Body.f_104201_ = 16.0f;
        this.LeftThigh.f_104200_ = 0.0f;
        this.LeftThigh.f_104201_ = 2.0f;
        this.LeftThigh.f_104202_ = 5.9f;
        this.LeftLeg.f_104200_ = 1.0f;
        this.LeftLeg.f_104201_ = 3.0f;
        this.LeftLeg.f_104202_ = 1.0f;
        this.RightThigh.f_104200_ = -3.0f;
        this.RightThigh.f_104201_ = 2.0f;
        this.RightThigh.f_104202_ = 5.9f;
        this.RightLeg.f_104200_ = 0.0f;
        this.RightLeg.f_104201_ = 3.0f;
        this.RightLeg.f_104202_ = 1.0f;
        this.LeftWing.f_104200_ = -0.5f;
        this.LeftWing.f_104201_ = 2.0f;
        this.LeftWing.f_104202_ = 1.1f;
        this.RightWing.f_104200_ = -2.5f;
        this.RightWing.f_104201_ = 2.0f;
        this.RightWing.f_104202_ = 1.1f;
        this.Head.f_104202_ = 0.0f;
        this.Tail1.f_104201_ = 1.0f;
    }

    public void sleepPose() {
        this.Body.f_104201_ = 19.5f;
        this.Body.f_104205_ = 0.0f;
        this.LeftLeg.f_104200_ = 0.5f;
        this.LeftLeg.f_104201_ = 3.6f;
        this.LeftLeg.f_104202_ = 0.5f;
        this.LeftLeg.f_104203_ = 0.07836528f;
        this.LeftLeg.f_104205_ = 0.009250244f;
        this.LeftWing.f_104200_ = 0.5f;
        this.LeftWing.f_104201_ = 2.0f;
        this.LeftWing.f_104202_ = 1.1f;
        this.RightWing.f_104200_ = -0.5f;
        this.RightWing.f_104201_ = 2.0f;
        this.RightWing.f_104202_ = 1.1f;
        this.LeftWing.f_104203_ = -1.6030849f;
        this.LeftWing.f_104204_ = -0.03647738f;
        this.LeftWing.f_104205_ = -0.6003933f;
        this.LeftThigh.f_104201_ = 3.0f;
        this.LeftThigh.f_104202_ = 5.0f;
        this.LeftThigh.f_104203_ = -1.6041322f;
        this.LeftThigh.f_104204_ = -0.35185838f;
        this.RightThigh.f_104201_ = 3.0f;
        this.RightThigh.f_104202_ = 5.0f;
        this.RightThigh.f_104203_ = -1.5653858f;
        this.RightThigh.f_104204_ = 0.312763f;
        this.RightLeg.f_104200_ = 0.5f;
        this.RightLeg.f_104201_ = 3.6f;
        this.RightLeg.f_104202_ = 0.9f;
        this.RightLeg.f_104205_ = -0.15620697f;
        this.RightWing.f_104200_ = -3.5f;
        this.RightWing.f_104201_ = 2.0f;
        this.RightWing.f_104202_ = 1.1f;
        this.RightWing.f_104203_ = -1.4866714f;
        this.RightWing.f_104204_ = 0.002617994f;
        this.RightWing.f_104205_ = 0.2401573f;
        this.Head.f_104202_ = -0.1f;
        this.Head.f_104203_ = 0.23177972f;
        this.Head.f_104204_ = -0.39357173f;
        this.Head.f_104205_ = 0.3726278f;
        this.Tail1.f_104201_ = 0.9f;
        this.Tail1.f_104203_ = -0.1563815f;
        this.Tail1.f_104204_ = 0.312763f;
        this.Tail1.f_104205_ = 0.11903146f;
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.Body.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
    }
}

