/*
 * Decompiled with CFR 0.152.
 */
package superlord.prehistoricfauna.client.model.cretaceous.hellcreek;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import superlord.prehistoricfauna.common.entity.DinosaurEntity;
import superlord.prehistoricfauna.common.entity.cretaceous.hellcreek.Tyrannosaurus;

public class TyrannosaurusModel
extends EntityModel<Tyrannosaurus> {
    private final ModelPart LeftLeg1;
    private final ModelPart LeftLeg2;
    private final ModelPart LeftFeet;
    private final ModelPart RightLeg1;
    private final ModelPart RightLeg2;
    private final ModelPart RightFeet;
    private final ModelPart Body1;
    private final ModelPart Body2;
    private final ModelPart Tail1;
    private final ModelPart Tail2;
    private final ModelPart Neck;
    private final ModelPart Head1;
    private final ModelPart Jaw1;
    private final ModelPart LeftArm;
    private final ModelPart RightArm;

    public TyrannosaurusModel(ModelPart root) {
        this.LeftLeg1 = root.m_171324_("LeftLeg1");
        this.LeftLeg2 = this.LeftLeg1.m_171324_("LeftLeg2");
        this.LeftFeet = this.LeftLeg2.m_171324_("LeftFeet");
        this.RightLeg1 = root.m_171324_("RightLeg1");
        this.RightLeg2 = this.RightLeg1.m_171324_("RightLeg2");
        this.RightFeet = this.RightLeg2.m_171324_("RightFeet");
        this.Body1 = root.m_171324_("Body1");
        this.Body2 = this.Body1.m_171324_("Body2");
        this.Tail1 = this.Body1.m_171324_("Tail1");
        this.Tail2 = this.Tail1.m_171324_("Tail2");
        this.Neck = this.Body2.m_171324_("Neck");
        this.Head1 = this.Neck.m_171324_("Head1");
        this.Jaw1 = this.Head1.m_171324_("Jaw1");
        this.LeftArm = this.Body2.m_171324_("LeftArm");
        this.RightArm = this.Body2.m_171324_("RightArm");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition LeftLeg1 = partdefinition.m_171599_("LeftLeg1", CubeListBuilder.m_171558_().m_171514_(0, 69).m_171488_(-7.0f, -6.0f, -9.0f, 10.0f, 34.0f, 20.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-6.0f, (float)-26.0f, (float)-1.0f, (float)-0.05f, (float)0.0f, (float)0.0f));
        PartDefinition LeftLeg2 = LeftLeg1.m_171599_("LeftLeg2", CubeListBuilder.m_171558_().m_171514_(96, 72).m_171480_().m_171488_(-3.0f, -8.0f, -1.0f, 6.0f, 30.0f, 8.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)-2.0f, (float)26.0f, (float)9.0f, (float)0.05f, (float)0.0f, (float)0.0f));
        PartDefinition LeftFeet = LeftLeg2.m_171599_("LeftFeet", CubeListBuilder.m_171558_().m_171514_(98, 50).m_171488_(-4.0f, -1.0f, -13.0f, 8.0f, 3.0f, 14.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)22.0f, (float)5.0f));
        PartDefinition RightLeg1 = partdefinition.m_171599_("RightLeg1", CubeListBuilder.m_171558_().m_171514_(0, 69).m_171488_(-3.0f, -6.0f, -9.0f, 10.0f, 34.0f, 20.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)6.0f, (float)-26.0f, (float)-1.0f, (float)-0.05f, (float)0.0f, (float)0.0f));
        PartDefinition RightLeg2 = RightLeg1.m_171599_("RightLeg2", CubeListBuilder.m_171558_().m_171514_(96, 72).m_171488_(-3.0f, -8.0f, -1.0f, 6.0f, 30.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)2.0f, (float)26.0f, (float)9.0f, (float)0.05f, (float)0.0f, (float)0.0f));
        PartDefinition RightFeet = RightLeg2.m_171599_("RightFeet", CubeListBuilder.m_171558_().m_171514_(98, 50).m_171488_(-4.0f, -1.0f, -13.0f, 8.0f, 3.0f, 14.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)22.0f, (float)5.0f));
        PartDefinition Body1 = partdefinition.m_171599_("Body1", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-7.5f, -10.0f, -16.0f, 15.0f, 33.0f, 33.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-29.0f, (float)0.0f, (float)0.0f, (float)-0.0063f, (float)0.0f));
        PartDefinition Tail1 = Body1.m_171599_("Tail1", CubeListBuilder.m_171558_().m_171514_(8, 69).m_171488_(-5.0f, -5.0f, -8.0f, 10.0f, 18.0f, 58.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-3.0f, (float)17.0f, (float)-0.15f, (float)0.0f, (float)0.0f));
        PartDefinition Tail2 = Tail1.m_171599_("Tail2", CubeListBuilder.m_171558_().m_171514_(92, 61).m_171488_(-3.0f, -1.0f, -7.0f, 6.0f, 11.0f, 54.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-2.0f, (float)50.0f, (float)0.1f, (float)0.0f, (float)0.0f));
        PartDefinition Body2 = Body1.m_171599_("Body2", CubeListBuilder.m_171558_().m_171514_(146, 0).m_171488_(-11.0f, -5.0f, -23.0f, 22.0f, 28.0f, 31.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-3.0f, (float)-16.0f));
        PartDefinition RightArm = Body2.m_171599_("RightArm", CubeListBuilder.m_171558_().m_171514_(69, 0).m_171488_(-2.0f, -2.0f, -2.0f, 3.0f, 14.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)10.1f, (float)19.0f, (float)-13.0f, (float)0.25f, (float)0.0f, (float)0.0f));
        PartDefinition LeftArm = Body2.m_171599_("LeftArm", CubeListBuilder.m_171558_().m_171514_(69, 0).m_171480_().m_171488_(-1.0f, -2.0f, -2.0f, 3.0f, 14.0f, 4.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)-10.1f, (float)19.0f, (float)-13.0f, (float)0.25f, (float)0.0f, (float)0.0f));
        PartDefinition Neck = Body2.m_171599_("Neck", CubeListBuilder.m_171558_().m_171514_(167, 66).m_171488_(-5.0f, -21.0f, -13.0f, 10.0f, 29.0f, 16.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)6.0f, (float)-22.0f, (float)0.25f, (float)0.0f, (float)0.0f));
        PartDefinition Head1 = Neck.m_171599_("Head1", CubeListBuilder.m_171558_().m_171514_(0, 157).m_171488_(-7.0f, -4.0f, -11.0f, 14.0f, 11.0f, 11.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-17.1f, (float)-7.0f, (float)-0.1f, (float)0.0f, (float)0.0f));
        PartDefinition Snout = Head1.m_171599_("Snout", CubeListBuilder.m_171558_().m_171514_(57, 150).m_171488_(-4.0f, 0.0f, -16.0f, 8.0f, 10.0f, 16.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-2.0f, (float)-11.0f));
        PartDefinition UpperTeeth = Snout.m_171599_("UpperTeeth", CubeListBuilder.m_171558_().m_171514_(106, 150).m_171488_(-3.5f, 0.0f, -15.99f, 7.0f, 12.0f, 16.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition Jaw1 = Head1.m_171599_("Jaw1", CubeListBuilder.m_171558_().m_171514_(0, 186).m_171488_(-7.0f, 0.0f, -11.0f, 14.0f, 7.0f, 11.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)7.0f, (float)0.0f));
        PartDefinition Jaw3 = Jaw1.m_171599_("Jaw3", CubeListBuilder.m_171558_().m_171514_(47, 181).m_171488_(-5.5f, -5.0f, 0.0f, 11.0f, 5.0f, 9.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)-9.0f));
        PartDefinition Jaw2 = Jaw1.m_171599_("Jaw2", CubeListBuilder.m_171558_().m_171514_(5, 212).m_171488_(-4.0f, 0.0f, -16.0f, 8.0f, 5.0f, 17.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)1.0f, (float)-11.0f));
        PartDefinition LowerTeeth = Jaw2.m_171599_("LowerTeeth", CubeListBuilder.m_171558_().m_171514_(45, 201).m_171488_(-3.0f, -3.0f, -15.0f, 6.0f, 7.0f, 15.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)1.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)256, (int)256);
    }

    public void setupAnim(Tyrannosaurus entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        float speed = 0.8f;
        float degree = 1.0f;
        float partialTick = ageInTicks - (float)entity.f_19797_;
        float attackProgress = entity.getMeleeProgress(partialTick);
        float sleepProgress = entity.getSleepProgress(partialTick);
        this.resetModel();
        if (entity.isAsleep()) {
            if (sleepProgress != 0.0f && (Integer)entity.m_20088_().m_135370_(DinosaurEntity.SLEEP_TICK) > 0) {
                this.Body2.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)0.41887903f);
                this.Body2.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-0.5235988f);
                this.Neck.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.22759093f, (float)0.82030475f);
                this.Neck.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-0.34906584f);
                this.Neck.f_104205_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-0.10471976f);
                this.RightFeet.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)1.5707964f);
                this.RightLeg2.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-0.87266463f);
                this.Tail2.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)0.2443461f);
                this.Tail2.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)0.41887903f);
                this.LeftLeg2.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-0.87266463f);
                this.LeftLeg1.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-0.6981317f);
                this.LeftLeg1.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)0.5235988f);
                this.Body1.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-0.17453292f);
                this.Tail1.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)-0.045553092f, (float)-0.2443461f);
                this.Tail1.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)0.5934119f);
                this.Head1.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-0.9075712f);
                this.Head1.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-0.06981317f);
                this.Head1.f_104205_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)0.34906584f);
                this.LeftArm.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.273144f, (float)1.3264502f);
                this.LeftArm.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-0.13962634f);
                this.RightArm.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.273144f, (float)1.0878638f);
                this.RightArm.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)0.29670596f);
                this.RightArm.f_104205_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-0.13962634f);
                this.RightLeg1.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-0.6981317f);
                this.RightLeg1.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-0.27925268f);
                this.LeftFeet.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)1.5707964f);
                this.Body1.f_104201_ = Mth.m_14179_((float)sleepProgress, (float)-29.0f, (float)-1.6f);
                this.Body2.f_104200_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)4.0f);
                this.Body2.f_104201_ = Mth.m_14179_((float)sleepProgress, (float)-3.0f, (float)-1.0f);
                this.Body2.f_104202_ = Mth.m_14179_((float)sleepProgress, (float)-16.0f, (float)-20.0f);
                this.RightArm.f_104200_ = Mth.m_14179_((float)sleepProgress, (float)10.1f, (float)11.0f);
                this.RightArm.f_104202_ = Mth.m_14179_((float)sleepProgress, (float)-13.0f, (float)-14.0f);
                this.Neck.f_104201_ = Mth.m_14179_((float)sleepProgress, (float)6.0f, (float)10.0f);
                this.Neck.f_104202_ = Mth.m_14179_((float)sleepProgress, (float)-22.0f, (float)-20.0f);
                this.Head1.f_104200_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-1.0f);
                this.Head1.f_104201_ = Mth.m_14179_((float)sleepProgress, (float)-17.1f, (float)-15.0f);
                this.Head1.f_104202_ = Mth.m_14179_((float)sleepProgress, (float)-7.0f, (float)-6.0f);
                this.Tail1.f_104200_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)3.0f);
                this.Tail1.f_104202_ = Mth.m_14179_((float)sleepProgress, (float)17.0f, (float)19.5f);
                this.Tail2.f_104200_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)0.6f);
                this.LeftLeg1.f_104201_ = Mth.m_14179_((float)sleepProgress, (float)-26.0f, (float)-5.0f);
                this.LeftLeg1.f_104202_ = Mth.m_14179_((float)sleepProgress, (float)-1.0f, (float)3.0f);
                this.LeftLeg2.f_104201_ = Mth.m_14179_((float)sleepProgress, (float)26.0f, (float)22.0f);
                this.LeftLeg2.f_104202_ = Mth.m_14179_((float)sleepProgress, (float)9.0f, (float)8.0f);
                this.RightLeg1.f_104200_ = Mth.m_14179_((float)sleepProgress, (float)6.0f, (float)7.0f);
                this.RightLeg1.f_104201_ = Mth.m_14179_((float)sleepProgress, (float)-26.0f, (float)-5.0f);
                this.RightLeg1.f_104202_ = Mth.m_14179_((float)sleepProgress, (float)-1.0f, (float)2.0f);
                this.RightLeg2.f_104201_ = Mth.m_14179_((float)sleepProgress, (float)26.0f, (float)22.0f);
                this.RightLeg2.f_104202_ = Mth.m_14179_((float)sleepProgress, (float)9.0f, (float)8.0f);
            } else {
                this.sleepPose();
            }
        } else if (sleepProgress != 0.0f && (Integer)entity.m_20088_().m_135370_(DinosaurEntity.SLEEP_TICK) > 0) {
            this.Body2.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.41887903f, (float)0.0f);
            this.Body2.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)-0.5235988f, (float)0.0f);
            this.Neck.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.82030475f, (float)0.22759093f);
            this.Neck.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)-0.34906584f, (float)0.0f);
            this.Neck.f_104205_ = Mth.m_14179_((float)sleepProgress, (float)-0.10471976f, (float)0.0f);
            this.RightFeet.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)1.5707964f, (float)0.0f);
            this.RightLeg2.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)-0.87266463f, (float)0.0f);
            this.Tail2.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.2443461f, (float)0.0f);
            this.Tail2.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)0.41887903f, (float)0.0f);
            this.LeftLeg2.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)-0.87266463f, (float)0.0f);
            this.LeftLeg1.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)-0.6981317f, (float)0.0f);
            this.LeftLeg1.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)0.5235988f, (float)0.0f);
            this.Body1.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)-0.17453292f, (float)0.0f);
            this.Tail1.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)-0.2443461f, (float)-0.045553092f);
            this.Tail1.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)0.5934119f, (float)0.0f);
            this.Head1.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)-0.9075712f, (float)0.0f);
            this.Head1.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)-0.06981317f, (float)0.0f);
            this.Head1.f_104205_ = Mth.m_14179_((float)sleepProgress, (float)0.34906584f, (float)0.0f);
            this.LeftArm.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)1.3264502f, (float)0.273144f);
            this.LeftArm.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)-0.13962634f, (float)0.0f);
            this.RightArm.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)1.0878638f, (float)0.273144f);
            this.RightArm.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)0.29670596f, (float)0.0f);
            this.RightArm.f_104205_ = Mth.m_14179_((float)sleepProgress, (float)-0.13962634f, (float)0.0f);
            this.RightLeg1.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)-0.6981317f, (float)0.0f);
            this.RightLeg1.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)-0.27925268f, (float)0.0f);
            this.LeftFeet.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)1.5707964f, (float)0.0f);
            this.Body1.f_104201_ = Mth.m_14179_((float)sleepProgress, (float)-1.6f, (float)-29.0f);
            this.Body2.f_104200_ = Mth.m_14179_((float)sleepProgress, (float)4.0f, (float)1.0f);
            this.Body2.f_104201_ = Mth.m_14179_((float)sleepProgress, (float)-1.0f, (float)-3.0f);
            this.Body2.f_104202_ = Mth.m_14179_((float)sleepProgress, (float)-20.0f, (float)-16.0f);
            this.RightArm.f_104200_ = Mth.m_14179_((float)sleepProgress, (float)11.0f, (float)10.1f);
            this.RightArm.f_104202_ = Mth.m_14179_((float)sleepProgress, (float)-14.0f, (float)-13.0f);
            this.Neck.f_104201_ = Mth.m_14179_((float)sleepProgress, (float)10.0f, (float)6.0f);
            this.Neck.f_104202_ = Mth.m_14179_((float)sleepProgress, (float)-20.0f, (float)-22.0f);
            this.Head1.f_104200_ = Mth.m_14179_((float)sleepProgress, (float)-1.0f, (float)0.0f);
            this.Head1.f_104201_ = Mth.m_14179_((float)sleepProgress, (float)-15.0f, (float)-17.1f);
            this.Head1.f_104202_ = Mth.m_14179_((float)sleepProgress, (float)-6.0f, (float)-7.0f);
            this.Tail1.f_104200_ = Mth.m_14179_((float)sleepProgress, (float)3.0f, (float)0.0f);
            this.Tail1.f_104202_ = Mth.m_14179_((float)sleepProgress, (float)19.5f, (float)17.0f);
            this.Tail2.f_104200_ = Mth.m_14179_((float)sleepProgress, (float)0.6f, (float)0.0f);
            this.LeftLeg1.f_104201_ = Mth.m_14179_((float)sleepProgress, (float)-5.0f, (float)-26.0f);
            this.LeftLeg1.f_104202_ = Mth.m_14179_((float)sleepProgress, (float)3.0f, (float)-1.0f);
            this.LeftLeg2.f_104201_ = Mth.m_14179_((float)sleepProgress, (float)22.0f, (float)26.0f);
            this.LeftLeg2.f_104202_ = Mth.m_14179_((float)sleepProgress, (float)8.0f, (float)9.0f);
            this.RightLeg1.f_104200_ = Mth.m_14179_((float)sleepProgress, (float)7.0f, (float)6.0f);
            this.RightLeg1.f_104201_ = Mth.m_14179_((float)sleepProgress, (float)-5.0f, (float)-26.0f);
            this.RightLeg1.f_104202_ = Mth.m_14179_((float)sleepProgress, (float)2.0f, (float)-1.0f);
            this.RightLeg2.f_104201_ = Mth.m_14179_((float)sleepProgress, (float)27.0f, (float)26.0f);
            this.RightLeg2.f_104202_ = Mth.m_14179_((float)sleepProgress, (float)8.0f, (float)9.0f);
        } else {
            this.LeftLeg1.f_104203_ = Mth.m_14089_((float)(1.0f + limbSwing * speed * 0.3f)) * degree * 0.6f * limbSwingAmount - 0.05f;
            this.LeftLeg2.f_104203_ = Mth.m_14089_((float)(1.0f + limbSwing * speed * 0.3f)) * degree * 0.4f * limbSwingAmount + 0.05f;
            this.LeftFeet.f_104203_ = Mth.m_14089_((float)(2.0f + limbSwing * speed * 0.3f)) * degree * 0.3f * limbSwingAmount;
            this.RightLeg1.f_104203_ = Mth.m_14089_((float)(1.0f + limbSwing * speed * 0.3f)) * degree * -0.6f * limbSwingAmount - 0.05f;
            this.RightLeg2.f_104203_ = Mth.m_14089_((float)(1.0f + limbSwing * speed * 0.3f)) * degree * -0.4f * limbSwingAmount + 0.05f;
            this.RightFeet.f_104203_ = Mth.m_14089_((float)(2.0f + limbSwing * speed * 0.3f)) * degree * -0.3f * limbSwingAmount;
            this.Tail1.f_104204_ = -0.12f * Mth.m_14031_((float)(0.2f * ageInTicks / 5.0f)) + Mth.m_14089_((float)(limbSwing * speed * 0.15f)) * degree * 0.2f * limbSwingAmount;
            this.Tail2.f_104204_ = Mth.m_14089_((float)(limbSwing * speed * 0.15f)) * degree * 0.25f * limbSwingAmount;
            this.Tail2.f_104204_ = -0.12f * Mth.m_14031_((float)(0.2f * ageInTicks / 5.0f)) + this.Tail2.f_104204_;
            this.Tail1.f_104203_ = -Math.abs(-0.05f * Mth.m_14031_((float)(0.1f * ageInTicks / 5.0f))) + (Mth.m_14089_((float)(limbSwing * speed * 0.3f)) * degree * 0.1f * limbSwingAmount - 0.15f);
            this.Tail2.f_104203_ = -Math.abs(-0.05f * Mth.m_14031_((float)(0.1f * ageInTicks / 5.0f))) + (Mth.m_14089_((float)(-1.0f + limbSwing * speed * 0.3f)) * degree * 0.15f * limbSwingAmount + 0.1f);
            this.Body1.f_104203_ = Math.abs(-0.025f * Mth.m_14089_((float)(0.1f * ageInTicks / 3.0f))) + Mth.m_14089_((float)(1.0f + limbSwing * speed * 0.3f)) * degree * 0.1f * limbSwingAmount;
            this.Neck.f_104203_ = Math.abs(-0.025f * Mth.m_14031_((float)(0.1f * ageInTicks / 3.0f))) + (Mth.m_14089_((float)(-1.0f + limbSwing * speed * 0.3f)) * degree * 0.1f * limbSwingAmount + 0.25f) + headPitch * ((float)Math.PI / 180) + attackProgress * (float)Math.toRadians(70.0);
            this.Head1.f_104203_ = -Math.abs(-0.025f * Mth.m_14031_((float)(0.1f * ageInTicks / 3.0f))) + (Mth.m_14089_((float)(1.0f + limbSwing * speed * 0.3f)) * degree * 0.15f * limbSwingAmount - 0.1f) + attackProgress * (float)Math.toRadians(-80.0);
            this.Jaw1.f_104203_ = -0.025f * Mth.m_14089_((float)(0.15f * ageInTicks / 3.0f)) + 0.025f + attackProgress * (float)Math.toRadians(30.0);
            this.LeftArm.f_104205_ = Math.abs(-0.05f * Mth.m_14031_((float)(0.15f * ageInTicks / 3.0f)));
            this.RightArm.f_104205_ = -Math.abs(-0.05f * Mth.m_14031_((float)(0.15f * ageInTicks / 3.0f)));
            this.LeftArm.f_104203_ = Mth.m_14089_((float)(limbSwing * speed * 0.3f)) * degree * 0.4f * limbSwingAmount + 0.25f;
            this.RightArm.f_104203_ = Mth.m_14089_((float)(2.0f + limbSwing * speed * 0.3f)) * degree * 0.4f * limbSwingAmount + 0.25f;
            this.Neck.f_104204_ = netHeadYaw * ((float)Math.PI / 180);
            this.Body2.f_104203_ = Mth.m_14089_((float)(1.0f + limbSwing * speed * 0.3f)) * degree * 0.01f * limbSwingAmount;
            this.Head1.f_104201_ = -17.1f + attackProgress * -3.0f;
            this.Head1.f_104202_ = -7.0f + attackProgress * 5.0f;
            if (entity.attackTick < 0) {
                this.Body1.f_104203_ = Math.abs(-0.25f * Mth.m_14031_((float)(0.15f * ageInTicks)));
                this.Tail1.f_104203_ = -Math.abs(-0.2f * Mth.m_14031_((float)(0.15f * ageInTicks)));
                this.Neck.f_104203_ = Math.abs(-0.25f * Mth.m_14031_((float)(0.15f * ageInTicks)));
                this.Jaw1.f_104203_ = Math.abs(-0.45f * Mth.m_14031_((float)(0.15f * ageInTicks)));
                this.LeftArm.f_104203_ = Math.abs(-0.35f * Mth.m_14031_((float)(0.15f * ageInTicks)));
                this.RightArm.f_104203_ = Math.abs(-0.35f * Mth.m_14031_((float)(0.15f * ageInTicks)));
            }
            if (entity.m_20069_()) {
                this.LeftLeg1.f_104201_ = 20.0f;
                this.RightLeg1.f_104201_ = 20.0f;
                this.Body1.f_104201_ = 20.0f;
                this.Body1.f_104203_ = -0.125f;
                this.Tail1.f_104203_ = 0.0625f;
                this.Tail2.f_104203_ = 0.06125f;
                this.Neck.f_104203_ = 0.125f;
                this.LeftLeg1.f_104203_ = -0.3f * Mth.m_14031_((float)(0.2f * ageInTicks / 1.5f));
                this.RightLeg1.f_104203_ = 0.3f * Mth.m_14031_((float)(0.2f * ageInTicks / 1.5f));
                this.LeftLeg2.f_104203_ = -0.3f * Mth.m_14031_((float)(0.2f * ageInTicks / 1.5f));
                this.RightLeg2.f_104203_ = 0.3f * Mth.m_14031_((float)(0.2f * ageInTicks / 1.5f));
                this.LeftFeet.f_104203_ = 0.5f - 0.3f * Mth.m_14031_((float)(0.2f * ageInTicks / 1.5f));
                this.RightFeet.f_104203_ = 0.5f + 0.3f * Mth.m_14031_((float)(0.2f * ageInTicks / 1.5f));
                this.RightArm.f_104203_ = 0.125f;
                this.LeftArm.f_104203_ = 0.125f;
                this.Tail1.f_104204_ = Mth.m_14089_((float)(limbSwing * 2.6662f)) * 1.4f * limbSwingAmount + 0.0625f * Mth.m_14031_((float)(0.15f * ageInTicks / 1.5f));
                this.Tail2.f_104204_ = Mth.m_14089_((float)(limbSwing * 2.6662f)) * 1.4f * limbSwingAmount + 0.0625f * Mth.m_14031_((float)(0.15f * ageInTicks / 1.5f));
            }
        }
    }

    public void resetModel() {
        this.Body2.f_104203_ = 0.0f;
        this.Body2.f_104204_ = 0.0f;
        this.Neck.f_104203_ = 0.22759093f;
        this.Neck.f_104204_ = 0.0f;
        this.Neck.f_104205_ = 0.0f;
        this.RightFeet.f_104203_ = 0.0f;
        this.RightLeg2.f_104203_ = 0.0f;
        this.Tail2.f_104203_ = 0.0f;
        this.Tail2.f_104204_ = 0.0f;
        this.LeftLeg2.f_104203_ = 0.0f;
        this.LeftLeg1.f_104203_ = 0.0f;
        this.LeftLeg1.f_104204_ = 0.0f;
        this.Body1.f_104203_ = 0.0f;
        this.Tail1.f_104203_ = -0.045553092f;
        this.Tail1.f_104204_ = 0.0f;
        this.Head1.f_104203_ = 0.0f;
        this.Head1.f_104204_ = 0.0f;
        this.Head1.f_104205_ = 0.0f;
        this.LeftArm.f_104203_ = 0.273144f;
        this.LeftArm.f_104204_ = 0.0f;
        this.RightArm.f_104203_ = 0.273144f;
        this.RightArm.f_104204_ = 0.0f;
        this.RightArm.f_104205_ = 0.0f;
        this.RightLeg1.f_104203_ = 0.0f;
        this.RightLeg1.f_104204_ = 0.0f;
        this.LeftFeet.f_104203_ = 0.0f;
        this.Body1.f_104201_ = -29.0f;
        this.Body2.f_104200_ = 0.0f;
        this.Body2.f_104201_ = -3.0f;
        this.Body2.f_104202_ = -16.0f;
        this.RightArm.f_104200_ = 10.1f;
        this.RightArm.f_104202_ = -13.0f;
        this.Neck.f_104201_ = 6.0f;
        this.Neck.f_104202_ = -22.0f;
        this.Head1.f_104200_ = 0.0f;
        this.Head1.f_104201_ = -17.1f;
        this.Head1.f_104202_ = -7.0f;
        this.Tail1.f_104200_ = 0.0f;
        this.Tail1.f_104202_ = 17.0f;
        this.Tail2.f_104200_ = 0.0f;
        this.LeftLeg1.f_104201_ = -26.0f;
        this.LeftLeg1.f_104202_ = -1.0f;
        this.LeftLeg2.f_104201_ = 26.0f;
        this.LeftLeg2.f_104202_ = 9.0f;
        this.RightLeg1.f_104200_ = 6.0f;
        this.RightLeg1.f_104201_ = -26.0f;
        this.RightLeg1.f_104202_ = -1.0f;
        this.RightLeg2.f_104201_ = 26.0f;
        this.RightLeg2.f_104202_ = 9.0f;
    }

    public void sleepPose() {
        this.Body2.f_104203_ = 0.41887903f;
        this.Body2.f_104204_ = -0.5235988f;
        this.Neck.f_104203_ = 0.82030475f;
        this.Neck.f_104204_ = -0.34906584f;
        this.Neck.f_104205_ = -0.10471976f;
        this.RightFeet.f_104203_ = 1.5707964f;
        this.RightLeg2.f_104203_ = -0.87266463f;
        this.Tail2.f_104203_ = 0.2443461f;
        this.Tail2.f_104204_ = 0.41887903f;
        this.LeftLeg2.f_104203_ = -0.87266463f;
        this.LeftLeg1.f_104203_ = -0.6981317f;
        this.LeftLeg1.f_104204_ = 0.5235988f;
        this.Body1.f_104203_ = -0.17453292f;
        this.Tail1.f_104203_ = -0.2443461f;
        this.Tail1.f_104204_ = 0.5934119f;
        this.Head1.f_104203_ = -0.9075712f;
        this.Head1.f_104204_ = -0.06981317f;
        this.Head1.f_104205_ = 0.34906584f;
        this.LeftArm.f_104203_ = 1.3264502f;
        this.LeftArm.f_104204_ = -0.13962634f;
        this.RightArm.f_104203_ = 1.0878638f;
        this.RightArm.f_104204_ = 0.29670596f;
        this.RightArm.f_104205_ = -0.13962634f;
        this.RightLeg1.f_104203_ = -0.6981317f;
        this.RightLeg1.f_104204_ = -0.27925268f;
        this.LeftFeet.f_104203_ = 1.5707964f;
        this.Body1.f_104201_ = -1.6f;
        this.Body2.f_104200_ = 4.0f;
        this.Body2.f_104201_ = -1.0f;
        this.Body2.f_104202_ = -20.0f;
        this.RightArm.f_104200_ = 11.0f;
        this.RightArm.f_104202_ = -14.0f;
        this.Neck.f_104201_ = 10.0f;
        this.Neck.f_104202_ = -20.0f;
        this.Head1.f_104200_ = -1.0f;
        this.Head1.f_104201_ = -15.0f;
        this.Head1.f_104202_ = -6.0f;
        this.Tail1.f_104200_ = 3.0f;
        this.Tail1.f_104202_ = 19.5f;
        this.Tail2.f_104200_ = 0.6f;
        this.LeftLeg1.f_104201_ = -5.0f;
        this.LeftLeg1.f_104202_ = 3.0f;
        this.LeftLeg2.f_104201_ = 22.0f;
        this.LeftLeg2.f_104202_ = 8.0f;
        this.RightLeg1.f_104200_ = 7.0f;
        this.RightLeg1.f_104201_ = -5.0f;
        this.RightLeg1.f_104202_ = 2.0f;
        this.RightLeg2.f_104201_ = 22.0f;
        this.RightLeg2.f_104202_ = 8.0f;
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.LeftLeg1.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.RightLeg1.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.Body1.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
    }
}

