/*
 * Decompiled with CFR 0.152.
 */
package superlord.prehistoricfauna.client.model.cretaceous.hellcreek;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import superlord.prehistoricfauna.common.entity.DinosaurEntity;
import superlord.prehistoricfauna.common.entity.cretaceous.hellcreek.Tyrannosaurus;

public class TyrannosaurusJuvenileModel
extends EntityModel<Tyrannosaurus> {
    private final ModelPart LeftLeg1;
    private final ModelPart LeftLeg2;
    private final ModelPart LeftFeet;
    private final ModelPart RightLeg1;
    private final ModelPart RightLeg2;
    private final ModelPart RightFeet;
    private final ModelPart Body1;
    private final ModelPart Body2;
    private final ModelPart Neck;
    private final ModelPart Head1;
    private final ModelPart Tail1;
    private final ModelPart Tail2;
    private final ModelPart LeftArm;
    private final ModelPart RightArm;

    public TyrannosaurusJuvenileModel(ModelPart root) {
        this.LeftLeg1 = root.m_171324_("LeftLeg1");
        this.LeftLeg2 = this.LeftLeg1.m_171324_("LeftLeg2");
        this.LeftFeet = this.LeftLeg2.m_171324_("LeftFeet");
        this.RightLeg1 = root.m_171324_("RightLeg1");
        this.RightLeg2 = this.RightLeg1.m_171324_("RightLeg2");
        this.RightFeet = this.RightLeg2.m_171324_("RightFeet");
        this.Body1 = root.m_171324_("Body1");
        this.Body2 = this.Body1.m_171324_("Body2");
        this.Neck = this.Body2.m_171324_("Neck");
        this.Head1 = this.Neck.m_171324_("Head1");
        this.Tail1 = this.Body1.m_171324_("Tail1");
        this.Tail2 = this.Tail1.m_171324_("Tail2");
        this.LeftArm = this.Body2.m_171324_("LeftArm");
        this.RightArm = this.Body2.m_171324_("RightArm");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition LeftLeg1 = partdefinition.m_171599_("LeftLeg1", CubeListBuilder.m_171558_().m_171514_(0, 43).m_171488_(-3.0f, -6.0f, -5.0f, 6.0f, 20.0f, 12.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-4.0f, (float)-7.0f, (float)-1.0f, (float)-0.05f, (float)0.0f, (float)0.0f));
        PartDefinition LeftLeg2 = LeftLeg1.m_171599_("LeftLeg2", CubeListBuilder.m_171558_().m_171514_(42, 38).m_171480_().m_171488_(-2.0f, -4.0f, -1.0f, 4.0f, 20.0f, 5.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)0.0f, (float)14.0f, (float)5.0f, (float)0.05f, (float)0.0f, (float)0.0f));
        PartDefinition LeftFeet = LeftLeg2.m_171599_("LeftFeet", CubeListBuilder.m_171558_().m_171514_(69, 41).m_171488_(-3.0f, -1.0f, -8.0f, 6.0f, 2.0f, 9.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)16.0f, (float)2.0f));
        PartDefinition RightLeg1 = partdefinition.m_171599_("RightLeg1", CubeListBuilder.m_171558_().m_171514_(0, 43).m_171488_(-3.0f, -6.0f, -5.0f, 6.0f, 20.0f, 12.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)4.0f, (float)-7.0f, (float)-1.0f, (float)-0.05f, (float)0.0f, (float)0.0f));
        PartDefinition RightLeg2 = RightLeg1.m_171599_("RightLeg2", CubeListBuilder.m_171558_().m_171514_(42, 38).m_171488_(-2.0f, -4.0f, -1.0f, 4.0f, 20.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)14.0f, (float)5.0f, (float)0.05f, (float)0.0f, (float)0.0f));
        PartDefinition RightFeet = RightLeg2.m_171599_("RightFeet", CubeListBuilder.m_171558_().m_171514_(69, 41).m_171488_(-3.0f, -1.0f, -8.0f, 6.0f, 2.0f, 9.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)16.0f, (float)2.0f));
        PartDefinition Body1 = partdefinition.m_171599_("Body1", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-4.0f, -7.0f, -11.0f, 8.0f, 17.0f, 20.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-10.0f, (float)-1.0f, (float)0.0f, (float)-0.0063f, (float)0.0f));
        PartDefinition Tail1 = Body1.m_171599_("Tail1", CubeListBuilder.m_171558_().m_171514_(8, 69).m_171488_(-3.0f, -3.0f, 0.0f, 6.0f, 11.0f, 33.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-3.0f, (float)6.0f, (float)-0.15f, (float)0.0f, (float)0.0f));
        PartDefinition Tail2 = Tail1.m_171599_("Tail2", CubeListBuilder.m_171558_().m_171514_(56, 61).m_171488_(-2.0f, -1.0f, -2.0f, 4.0f, 6.0f, 31.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-1.0f, (float)33.0f, (float)0.1f, (float)0.0f, (float)0.0f));
        PartDefinition Body2 = Body1.m_171599_("Body2", CubeListBuilder.m_171558_().m_171514_(63, 0).m_171488_(-5.0f, -5.0f, -19.0f, 10.0f, 15.0f, 19.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-1.0f, (float)-5.0f));
        PartDefinition Neck = Body2.m_171599_("Neck", CubeListBuilder.m_171558_().m_171514_(104, 59).m_171488_(-2.0f, -15.0f, -7.0f, 4.0f, 20.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)1.0f, (float)-17.0f, (float)0.25f, (float)0.0f, (float)0.0f));
        PartDefinition Head1 = Neck.m_171599_("Head1", CubeListBuilder.m_171558_().m_171514_(0, 81).m_171488_(-3.0f, -4.0f, -8.0f, 6.0f, 9.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-11.1f, (float)-4.0f, (float)-0.1f, (float)0.0f, (float)0.0f));
        PartDefinition Snout = Head1.m_171599_("Snout", CubeListBuilder.m_171558_().m_171514_(58, 67).m_171488_(-2.0f, 0.0f, -9.0f, 4.0f, 7.0f, 9.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-3.0f, (float)-8.0f));
        PartDefinition LeftArm = Body2.m_171599_("LeftArm", CubeListBuilder.m_171558_().m_171514_(59, 0).m_171480_().m_171488_(-1.0f, -2.0f, -1.0f, 2.0f, 9.0f, 3.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)-4.1f, (float)8.0f, (float)-14.0f, (float)0.25f, (float)0.0f, (float)0.0f));
        PartDefinition RightArm = Body2.m_171599_("RightArm", CubeListBuilder.m_171558_().m_171514_(59, 0).m_171488_(-1.0f, -2.0f, -1.0f, 2.0f, 9.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)4.1f, (float)8.0f, (float)-14.0f, (float)0.25f, (float)0.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)128, (int)128);
    }

    public void setupAnim(Tyrannosaurus entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        float partialTick = ageInTicks - (float)entity.f_19797_;
        float sleepProgress = entity.getSleepProgress(partialTick);
        this.resetModel();
        if (entity.isAsleep()) {
            if (sleepProgress != 0.0f && (Integer)entity.m_20088_().m_135370_(DinosaurEntity.SLEEP_TICK) > 0) {
                this.LeftLeg2.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-0.8761553f);
                this.LeftFeet.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)1.5707964f);
                this.RightFeet.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)1.5707964f);
                this.Head1.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)0.41887903f);
                this.Head1.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-1.0471976f);
                this.RightLeg2.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-0.863938f);
                this.RightLeg2.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-0.17453292f);
                this.RightLeg2.f_104205_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-0.17453292f);
                this.Neck.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.22759093f, (float)0.41887903f);
                this.Neck.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-1.0471976f);
                this.RightLeg1.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-0.6981317f);
                this.RightLeg1.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)0.34906584f);
                this.Body2.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)0.17453292f);
                this.Body2.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-0.5235988f);
                this.Body1.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-0.17453292f);
                this.Tail2.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)0.2443461f);
                this.Tail2.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)0.41887903f);
                this.Tail2.f_104205_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)0.17453292f);
                this.LeftLeg1.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-0.6981317f);
                this.LeftLeg1.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-0.5235988f);
                this.RightArm.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.273144f, (float)0.7330383f);
                this.RightArm.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)0.2443461f);
                this.RightArm.f_104205_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)0.2443461f);
                this.Tail1.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)-0.045553092f, (float)-0.17453292f);
                this.Tail1.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)0.5934119f);
                this.LeftArm.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.62831855f, (float)0.62831855f);
                this.LeftArm.f_104205_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-0.2443461f);
                this.Body1.f_104201_ = Mth.m_14179_((float)sleepProgress, (float)-10.0f, (float)12.6f);
                this.Tail2.f_104200_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-1.0f);
                this.Body2.f_104200_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-2.0f);
                this.Body2.f_104201_ = Mth.m_14179_((float)sleepProgress, (float)-1.0f, (float)-3.0f);
                this.Body2.f_104202_ = Mth.m_14179_((float)sleepProgress, (float)-5.0f, (float)-6.0f);
                this.Neck.f_104200_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-2.0f);
                this.Head1.f_104200_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-2.0f);
                this.Head1.f_104201_ = Mth.m_14179_((float)sleepProgress, (float)-11.1f, (float)-11.0f);
                this.Head1.f_104202_ = Mth.m_14179_((float)sleepProgress, (float)-4.0f, (float)-6.7f);
                this.LeftArm.f_104200_ = Mth.m_14179_((float)sleepProgress, (float)4.1f, (float)4.5f);
                this.RightArm.f_104200_ = Mth.m_14179_((float)sleepProgress, (float)-4.1f, (float)-5.0f);
                this.RightArm.f_104202_ = Mth.m_14179_((float)sleepProgress, (float)-14.0f, (float)-14.5f);
                this.LeftLeg1.f_104200_ = Mth.m_14179_((float)sleepProgress, (float)4.0f, (float)6.0f);
                this.LeftLeg1.f_104201_ = Mth.m_14179_((float)sleepProgress, (float)-7.0f, (float)8.8f);
                this.LeftLeg2.f_104202_ = Mth.m_14179_((float)sleepProgress, (float)5.0f, (float)4.0f);
                this.LeftFeet.f_104202_ = Mth.m_14179_((float)sleepProgress, (float)2.0f, (float)1.0f);
                this.RightLeg1.f_104200_ = Mth.m_14179_((float)sleepProgress, (float)-4.0f, (float)-6.0f);
                this.RightLeg1.f_104201_ = Mth.m_14179_((float)sleepProgress, (float)-7.0f, (float)8.8f);
                this.RightLeg2.f_104202_ = Mth.m_14179_((float)sleepProgress, (float)5.0f, (float)4.0f);
                this.RightFeet.f_104202_ = Mth.m_14179_((float)sleepProgress, (float)2.0f, (float)1.0f);
            } else {
                this.sleepPose();
            }
        } else if (sleepProgress != 0.0f && (Integer)entity.m_20088_().m_135370_(DinosaurEntity.SLEEP_TICK) > 0) {
            this.LeftLeg2.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)-0.8761553f, (float)0.0f);
            this.LeftFeet.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)1.5707964f, (float)0.0f);
            this.RightFeet.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)1.5707964f, (float)0.0f);
            this.Head1.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.41887903f, (float)0.0f);
            this.Head1.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)-1.0471976f, (float)0.0f);
            this.RightLeg2.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)-0.863938f, (float)0.0f);
            this.RightLeg2.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)-0.17453292f, (float)0.0f);
            this.RightLeg2.f_104205_ = Mth.m_14179_((float)sleepProgress, (float)-0.17453292f, (float)0.0f);
            this.Neck.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.41887903f, (float)0.22759093f);
            this.Neck.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)-1.0471976f, (float)0.0f);
            this.RightLeg1.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)-0.6981317f, (float)0.0f);
            this.RightLeg1.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)0.34906584f, (float)0.0f);
            this.Body2.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.17453292f, (float)0.0f);
            this.Body2.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)-0.5235988f, (float)0.0f);
            this.Body1.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)-0.17453292f, (float)0.0f);
            this.Tail2.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.2443461f, (float)0.0f);
            this.Tail2.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)0.41887903f, (float)0.0f);
            this.Tail2.f_104205_ = Mth.m_14179_((float)sleepProgress, (float)0.17453292f, (float)0.0f);
            this.LeftLeg1.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)-0.6981317f, (float)0.0f);
            this.LeftLeg1.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)-0.5235988f, (float)0.0f);
            this.RightArm.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.7330383f, (float)0.273144f);
            this.RightArm.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)0.2443461f, (float)0.0f);
            this.RightArm.f_104205_ = Mth.m_14179_((float)sleepProgress, (float)0.2443461f, (float)0.0f);
            this.Tail1.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)-0.17453292f, (float)-0.045553092f);
            this.Tail1.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)0.5934119f, (float)0.0f);
            this.LeftArm.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.62831855f, (float)0.62831855f);
            this.LeftArm.f_104205_ = Mth.m_14179_((float)sleepProgress, (float)-0.2443461f, (float)0.0f);
            this.Body1.f_104201_ = Mth.m_14179_((float)sleepProgress, (float)12.6f, (float)-10.0f);
            this.Tail2.f_104200_ = Mth.m_14179_((float)sleepProgress, (float)-1.0f, (float)0.0f);
            this.Body2.f_104200_ = Mth.m_14179_((float)sleepProgress, (float)-2.0f, (float)0.0f);
            this.Body2.f_104201_ = Mth.m_14179_((float)sleepProgress, (float)-3.0f, (float)-1.0f);
            this.Body2.f_104202_ = Mth.m_14179_((float)sleepProgress, (float)-6.0f, (float)-5.0f);
            this.Neck.f_104200_ = Mth.m_14179_((float)sleepProgress, (float)-2.0f, (float)0.0f);
            this.Head1.f_104200_ = Mth.m_14179_((float)sleepProgress, (float)-2.0f, (float)0.0f);
            this.Head1.f_104201_ = Mth.m_14179_((float)sleepProgress, (float)-11.0f, (float)-11.1f);
            this.Head1.f_104202_ = Mth.m_14179_((float)sleepProgress, (float)-6.7f, (float)-4.0f);
            this.LeftArm.f_104200_ = Mth.m_14179_((float)sleepProgress, (float)4.5f, (float)4.1f);
            this.RightArm.f_104200_ = Mth.m_14179_((float)sleepProgress, (float)-5.0f, (float)-4.1f);
            this.RightArm.f_104202_ = Mth.m_14179_((float)sleepProgress, (float)-14.5f, (float)-14.0f);
            this.LeftLeg1.f_104200_ = Mth.m_14179_((float)sleepProgress, (float)6.0f, (float)4.0f);
            this.LeftLeg1.f_104201_ = Mth.m_14179_((float)sleepProgress, (float)8.8f, (float)-7.0f);
            this.LeftLeg2.f_104202_ = Mth.m_14179_((float)sleepProgress, (float)4.0f, (float)5.0f);
            this.LeftFeet.f_104202_ = Mth.m_14179_((float)sleepProgress, (float)1.0f, (float)2.0f);
            this.RightLeg1.f_104200_ = Mth.m_14179_((float)sleepProgress, (float)-6.0f, (float)-4.0f);
            this.RightLeg1.f_104201_ = Mth.m_14179_((float)sleepProgress, (float)8.8f, (float)-7.0f);
            this.RightLeg2.f_104202_ = Mth.m_14179_((float)sleepProgress, (float)4.0f, (float)5.0f);
            this.RightFeet.f_104202_ = Mth.m_14179_((float)sleepProgress, (float)1.0f, (float)2.0f);
        } else {
            float speed = 0.8f;
            float degree = 1.0f;
            this.Neck.f_104203_ = Mth.m_14089_((float)(-1.0f + limbSwing / 3.0f * speed * 0.3f)) * degree * 0.1f * limbSwingAmount + 0.25f;
            this.Body2.f_104203_ = Mth.m_14089_((float)(1.0f + limbSwing / 3.0f * speed * 0.3f)) * degree * 0.01f * limbSwingAmount;
            this.Body1.f_104203_ = Mth.m_14089_((float)(1.0f + limbSwing / 3.0f * speed * 0.3f)) * degree * 0.1f * limbSwingAmount;
            this.Tail1.f_104203_ = Mth.m_14089_((float)(limbSwing / 3.0f * speed * 0.3f)) * degree * 0.1f * limbSwingAmount - 0.15f;
            this.Tail2.f_104203_ = Mth.m_14089_((float)(-1.0f + limbSwing / 3.0f * speed * 0.3f)) * degree * 0.15f * limbSwingAmount + 0.1f;
            this.Tail1.f_104204_ = Mth.m_14089_((float)(limbSwing / 3.0f * speed * 0.15f)) * degree * 0.2f * limbSwingAmount;
            this.Tail2.f_104204_ = Mth.m_14089_((float)(limbSwing / 3.0f * speed * 0.15f)) * degree * 0.25f * limbSwingAmount;
            this.Head1.f_104203_ = Mth.m_14089_((float)(1.0f + limbSwing / 3.0f * speed * 0.3f)) * degree * 0.15f * limbSwingAmount - 0.1f;
            this.LeftArm.f_104203_ = Mth.m_14089_((float)(limbSwing / 3.0f * speed * 0.3f)) * degree * 0.4f * limbSwingAmount + 0.25f;
            this.RightArm.f_104203_ = Mth.m_14089_((float)(2.0f + limbSwing / 3.0f * speed * 0.3f)) * degree * 0.4f * limbSwingAmount + 0.25f;
            this.LeftLeg1.f_104203_ = Mth.m_14089_((float)(1.0f + limbSwing / 3.0f * speed * 0.3f)) * degree * 0.6f * limbSwingAmount - 0.05f;
            this.LeftLeg2.f_104203_ = Mth.m_14089_((float)(1.0f + limbSwing / 3.0f * speed * 0.3f)) * degree * 0.4f * limbSwingAmount + 0.05f;
            this.LeftFeet.f_104203_ = Mth.m_14089_((float)(2.0f + limbSwing / 3.0f * speed * 0.3f)) * degree * 0.3f * limbSwingAmount;
            this.RightLeg1.f_104203_ = Mth.m_14089_((float)(1.0f + limbSwing / 3.0f * speed * 0.3f)) * degree * -0.6f * limbSwingAmount - 0.05f;
            this.RightLeg2.f_104203_ = Mth.m_14089_((float)(1.0f + limbSwing / 3.0f * speed * 0.3f)) * degree * -0.4f * limbSwingAmount + 0.05f;
            this.RightFeet.f_104203_ = Mth.m_14089_((float)(2.0f + limbSwing / 3.0f * speed * 0.3f)) * degree * -0.3f * limbSwingAmount;
            if (entity.m_20069_()) {
                this.LeftLeg1.f_104201_ = 20.0f;
                this.RightLeg1.f_104201_ = 20.0f;
                this.Body1.f_104201_ = 20.0f;
                this.Body1.f_104203_ = -0.25f;
                this.Tail1.f_104203_ = 0.125f;
                this.Tail2.f_104203_ = 0.125f;
                this.Neck.f_104203_ = 0.25f;
                this.LeftLeg1.f_104203_ = -0.25f * Mth.m_14031_((float)(0.15f * ageInTicks / 1.5f));
                this.RightLeg1.f_104203_ = 0.25f * Mth.m_14031_((float)(0.15f * ageInTicks / 1.5f));
                this.RightArm.f_104203_ = 0.25f;
                this.LeftArm.f_104203_ = 0.25f;
                this.Tail1.f_104204_ = Mth.m_14089_((float)(limbSwing / 3.0f * 2.6662f)) * 1.4f * limbSwingAmount + 0.0625f * Mth.m_14031_((float)(0.15f * ageInTicks / 1.5f));
                this.Tail2.f_104204_ = Mth.m_14089_((float)(limbSwing / 3.0f * 2.6662f)) * 1.4f * limbSwingAmount + 0.0625f * Mth.m_14031_((float)(0.15f * ageInTicks / 1.5f));
                this.LeftLeg2.f_104203_ = -0.3f * Mth.m_14031_((float)(0.2f * ageInTicks / 1.5f));
                this.RightLeg2.f_104203_ = 0.3f * Mth.m_14031_((float)(0.2f * ageInTicks / 1.5f));
                this.LeftFeet.f_104203_ = 0.5f - 0.3f * Mth.m_14031_((float)(0.2f * ageInTicks / 1.5f));
                this.RightFeet.f_104203_ = 0.5f + 0.3f * Mth.m_14031_((float)(0.2f * ageInTicks / 1.5f));
            }
        }
    }

    public void resetModel() {
        this.LeftLeg2.f_104203_ = 0.0f;
        this.LeftFeet.f_104203_ = 0.0f;
        this.RightFeet.f_104203_ = 0.0f;
        this.Head1.f_104203_ = 0.0f;
        this.Head1.f_104204_ = 0.0f;
        this.RightLeg2.f_104203_ = 0.0f;
        this.RightLeg2.f_104204_ = 0.0f;
        this.RightLeg2.f_104205_ = 0.0f;
        this.Neck.f_104203_ = 0.22759093f;
        this.Neck.f_104204_ = 0.0f;
        this.RightLeg1.f_104203_ = 0.0f;
        this.RightLeg1.f_104204_ = 0.0f;
        this.Body2.f_104203_ = 0.0f;
        this.Body2.f_104204_ = 0.0f;
        this.Body1.f_104203_ = 0.0f;
        this.Tail2.f_104203_ = 0.0f;
        this.Tail2.f_104204_ = 0.0f;
        this.Tail2.f_104205_ = 0.0f;
        this.LeftLeg1.f_104203_ = 0.0f;
        this.LeftLeg1.f_104204_ = 0.0f;
        this.RightArm.f_104203_ = 0.273144f;
        this.RightArm.f_104204_ = 0.0f;
        this.RightArm.f_104205_ = 0.0f;
        this.Tail1.f_104203_ = -0.045553092f;
        this.Tail1.f_104204_ = 0.0f;
        this.LeftArm.f_104203_ = 0.62831855f;
        this.LeftArm.f_104205_ = 0.0f;
        this.Body1.f_104201_ = -10.0f;
        this.Tail2.f_104200_ = 0.0f;
        this.Body2.f_104200_ = 0.0f;
        this.Body2.f_104201_ = -1.0f;
        this.Body2.f_104202_ = -5.0f;
        this.Neck.f_104200_ = 0.0f;
        this.Head1.f_104200_ = 0.0f;
        this.Head1.f_104201_ = -11.1f;
        this.Head1.f_104202_ = -4.0f;
        this.LeftArm.f_104200_ = 4.1f;
        this.RightArm.f_104200_ = -4.1f;
        this.RightArm.f_104202_ = -14.0f;
        this.LeftLeg1.f_104200_ = 4.0f;
        this.LeftLeg1.f_104201_ = -7.0f;
        this.LeftLeg2.f_104202_ = 5.0f;
        this.LeftFeet.f_104202_ = 2.0f;
        this.RightLeg1.f_104200_ = -4.0f;
        this.RightLeg1.f_104201_ = -7.0f;
        this.RightLeg2.f_104202_ = 5.0f;
        this.RightFeet.f_104202_ = 2.0f;
    }

    public void sleepPose() {
        this.LeftLeg2.f_104203_ = -0.8761553f;
        this.LeftFeet.f_104203_ = 1.5707964f;
        this.RightFeet.f_104203_ = 1.5707964f;
        this.Head1.f_104203_ = 0.41887903f;
        this.Head1.f_104204_ = -1.0471976f;
        this.RightLeg2.f_104203_ = -0.863938f;
        this.RightLeg2.f_104204_ = -0.17453292f;
        this.RightLeg2.f_104205_ = -0.17453292f;
        this.Neck.f_104203_ = 0.41887903f;
        this.Neck.f_104204_ = -1.0471976f;
        this.RightLeg1.f_104203_ = -0.6981317f;
        this.RightLeg1.f_104204_ = 0.34906584f;
        this.Body2.f_104203_ = 0.17453292f;
        this.Body2.f_104204_ = -0.5235988f;
        this.Body1.f_104203_ = -0.17453292f;
        this.Tail2.f_104203_ = 0.2443461f;
        this.Tail2.f_104204_ = 0.41887903f;
        this.Tail2.f_104205_ = 0.17453292f;
        this.LeftLeg1.f_104203_ = -0.6981317f;
        this.LeftLeg1.f_104204_ = -0.5235988f;
        this.RightArm.f_104203_ = 0.7330383f;
        this.RightArm.f_104204_ = 0.2443461f;
        this.RightArm.f_104205_ = 0.2443461f;
        this.Tail1.f_104203_ = -0.17453292f;
        this.Tail1.f_104204_ = 0.5934119f;
        this.LeftArm.f_104203_ = 0.62831855f;
        this.LeftArm.f_104205_ = -0.2443461f;
        this.Body1.f_104201_ = 12.6f;
        this.Tail2.f_104200_ = -1.0f;
        this.Body2.f_104200_ = -2.0f;
        this.Body2.f_104201_ = -3.0f;
        this.Body2.f_104202_ = -6.0f;
        this.Neck.f_104200_ = -2.0f;
        this.Head1.f_104200_ = -2.0f;
        this.Head1.f_104201_ = -11.0f;
        this.Head1.f_104202_ = -6.7f;
        this.LeftArm.f_104200_ = 4.5f;
        this.RightArm.f_104200_ = -5.0f;
        this.RightArm.f_104202_ = -14.5f;
        this.LeftLeg1.f_104200_ = 6.0f;
        this.LeftLeg1.f_104201_ = 8.8f;
        this.LeftLeg2.f_104202_ = 4.0f;
        this.LeftFeet.f_104202_ = 1.0f;
        this.RightLeg1.f_104200_ = -6.0f;
        this.RightLeg1.f_104201_ = 8.8f;
        this.RightLeg2.f_104202_ = 4.0f;
        this.RightFeet.f_104202_ = 1.0f;
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.LeftLeg1.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.RightLeg1.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.Body1.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
    }
}

