/*
 * Decompiled with CFR 0.152.
 */
package superlord.prehistoricfauna.client.model.cretaceous.hellcreek;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import superlord.prehistoricfauna.common.entity.DinosaurEntity;
import superlord.prehistoricfauna.common.entity.cretaceous.hellcreek.Thescelosaurus;

public class ThescelosaurusModel
extends EntityModel<Thescelosaurus> {
    private final ModelPart RightLeg1;
    private final ModelPart LeftLeg1;
    private final ModelPart Body;
    private final ModelPart LeftArm;
    private final ModelPart RightArm;
    private final ModelPart Tail1;
    private final ModelPart Tail2;
    private final ModelPart RightLeg2;
    private final ModelPart LeftLeg2;
    private final ModelPart Head;
    private final ModelPart Snout;

    public ThescelosaurusModel(ModelPart root) {
        this.RightLeg1 = root.m_171324_("RightLeg1");
        this.LeftLeg1 = root.m_171324_("LeftLeg1");
        this.RightLeg2 = this.RightLeg1.m_171324_("RightLeg2");
        this.LeftLeg2 = this.LeftLeg1.m_171324_("LeftLeg2");
        this.Body = root.m_171324_("Body");
        this.LeftArm = this.Body.m_171324_("LeftArm");
        this.RightArm = this.Body.m_171324_("RightArm");
        this.Tail1 = this.Body.m_171324_("Tail1");
        this.Tail2 = this.Tail1.m_171324_("Tail2");
        this.Head = this.Body.m_171324_("Head");
        this.Snout = this.Head.m_171324_("Snout");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition RightLeg1 = partdefinition.m_171599_("RightLeg1", CubeListBuilder.m_171558_().m_171514_(43, 0).m_171488_(-2.0f, -2.0f, -3.0f, 3.0f, 9.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)3.0f, (float)10.9f, (float)0.0f));
        PartDefinition RightLeg2 = RightLeg1.m_171599_("RightLeg2", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-2.0f, 0.0f, -5.0f, 3.0f, 6.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)7.0f, (float)4.0f));
        PartDefinition LeftLeg1 = partdefinition.m_171599_("LeftLeg1", CubeListBuilder.m_171558_().m_171514_(43, 0).m_171488_(-1.0f, -2.0f, -3.0f, 3.0f, 9.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-3.0f, (float)10.9f, (float)0.0f));
        PartDefinition LeftLeg2 = LeftLeg1.m_171599_("LeftLeg2", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-1.0f, 0.0f, -5.0f, 3.0f, 6.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)7.0f, (float)4.0f));
        PartDefinition Body = partdefinition.m_171599_("Body", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-3.0f, -5.0f, -12.0f, 6.0f, 10.0f, 18.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)10.9f, (float)0.0f, (float)0.0169f, (float)0.0f, (float)0.0f));
        PartDefinition Head = Body.m_171599_("Head", CubeListBuilder.m_171558_().m_171514_(0, 29).m_171488_(-2.0f, -8.0f, -4.0f, 4.0f, 11.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-1.0f, (float)-12.0f));
        PartDefinition Snout = Head.m_171599_("Snout", CubeListBuilder.m_171558_().m_171514_(0, 54).m_171488_(-1.0f, 0.0f, -4.0f, 2.0f, 3.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-7.0f, (float)-4.0f));
        PartDefinition RightArm = Body.m_171599_("RightArm", CubeListBuilder.m_171558_().m_171514_(32, 0).m_171488_(0.0f, -1.0f, -1.0f, 1.0f, 8.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)2.1f, (float)3.0f, (float)-9.0f));
        PartDefinition Tail1 = Body.m_171599_("Tail1", CubeListBuilder.m_171558_().m_171514_(3, 30).m_171488_(-2.0f, -1.0f, -2.0f, 4.0f, 5.0f, 16.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-3.0f, (float)6.0f));
        PartDefinition Tail2 = Tail1.m_171599_("Tail2", CubeListBuilder.m_171558_().m_171514_(28, 44).m_171488_(-1.0f, -1.0f, -1.0f, 2.0f, 3.0f, 16.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)1.0f, (float)14.0f));
        PartDefinition LeftArm = Body.m_171599_("LeftArm", CubeListBuilder.m_171558_().m_171514_(32, 0).m_171488_(-1.0f, -1.0f, -1.0f, 1.0f, 8.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-2.1f, (float)3.0f, (float)-9.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void setupAnim(Thescelosaurus entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        float partialTick = ageInTicks - (float)entity.f_19797_;
        float attackProgress = entity.getMeleeProgress(partialTick);
        float sleepProgress = entity.getSleepProgress(partialTick);
        this.resetModel();
        if (entity.isAsleep()) {
            if (sleepProgress != 0.0f && (Integer)entity.m_20088_().m_135370_(DinosaurEntity.SLEEP_TICK) > 0) {
                this.RightLeg1.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-1.407608f);
                this.RightLeg1.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-0.27366763f);
                this.Body.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-0.19547687f);
                this.RightArm.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)0.76881754f);
                this.RightArm.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-0.00418879f);
                this.LeftLeg2.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)0.039095376f);
                this.LeftLeg2.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)((float)Math.PI));
                this.Snout.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)0.05235988f);
                this.Tail2.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)0.23457225f);
                this.Tail2.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-0.039095376f);
                this.Tail2.f_104205_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-0.07819075f);
                this.RightLeg2.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)0.078016214f);
                this.RightLeg2.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)((float)Math.PI));
                this.LeftArm.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)0.65118235f);
                this.LeftArm.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-0.11746066f);
                this.LeftLeg1.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-1.407259f);
                this.LeftLeg1.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)0.35185838f);
                this.Head.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.13665928f, (float)-0.19547687f);
                this.Head.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)0.74281216f);
                this.Head.f_104205_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-0.07819075f);
                this.Tail1.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-0.07819075f);
                this.Tail1.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-0.27401668f);
                this.Tail1.f_104205_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-0.19565141f);
                this.Body.f_104201_ = Mth.m_14179_((float)sleepProgress, (float)10.9f, (float)18.9f);
                this.RightLeg1.f_104201_ = Mth.m_14179_((float)sleepProgress, (float)10.9f, (float)18.9f);
                this.RightLeg1.f_104202_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)3.0f);
                this.RightLeg2.f_104200_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-1.0f);
                this.RightLeg2.f_104201_ = Mth.m_14179_((float)sleepProgress, (float)7.0f, (float)2.8f);
                this.RightLeg2.f_104202_ = Mth.m_14179_((float)sleepProgress, (float)4.0f, (float)3.7f);
                this.LeftLeg1.f_104201_ = Mth.m_14179_((float)sleepProgress, (float)10.9f, (float)18.9f);
                this.LeftLeg1.f_104202_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)3.0f);
                this.LeftLeg2.f_104200_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)1.0f);
                this.LeftLeg2.f_104201_ = Mth.m_14179_((float)sleepProgress, (float)3.0f, (float)3.0f);
                this.LeftLeg2.f_104202_ = Mth.m_14179_((float)sleepProgress, (float)4.0f, (float)3.7f);
                this.Head.f_104202_ = Mth.m_14179_((float)sleepProgress, (float)-12.0f, (float)-11.4f);
                this.LeftArm.f_104200_ = Mth.m_14179_((float)sleepProgress, (float)-2.1f, (float)-3.1f);
                this.LeftArm.f_104201_ = Mth.m_14179_((float)sleepProgress, (float)3.0f, (float)1.0f);
                this.LeftArm.f_104202_ = Mth.m_14179_((float)sleepProgress, (float)-9.0f, (float)-10.0f);
                this.RightArm.f_104200_ = Mth.m_14179_((float)sleepProgress, (float)2.1f, (float)3.1f);
                this.RightArm.f_104201_ = Mth.m_14179_((float)sleepProgress, (float)3.0f, (float)1.0f);
                this.RightArm.f_104202_ = Mth.m_14179_((float)sleepProgress, (float)-9.0f, (float)-10.0f);
            } else {
                this.sleepPose();
            }
        } else if (sleepProgress != 0.0f && (Integer)entity.m_20088_().m_135370_(DinosaurEntity.SLEEP_TICK) > 0) {
            this.RightLeg1.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)-1.407608f, (float)0.0f);
            this.RightLeg1.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)-0.27366763f, (float)0.0f);
            this.Body.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)-0.19547687f, (float)0.0f);
            this.RightArm.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.76881754f, (float)0.0f);
            this.RightArm.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)-0.00418879f, (float)0.0f);
            this.LeftLeg2.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.039095376f, (float)0.0f);
            this.LeftLeg2.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)((float)Math.PI), (float)0.0f);
            this.Snout.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.05235988f, (float)0.0f);
            this.Tail2.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.23457225f, (float)0.0f);
            this.Tail2.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)-0.039095376f, (float)0.0f);
            this.Tail2.f_104205_ = Mth.m_14179_((float)sleepProgress, (float)-0.07819075f, (float)0.0f);
            this.RightLeg2.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.078016214f, (float)0.0f);
            this.RightLeg2.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)((float)Math.PI), (float)0.0f);
            this.LeftArm.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.65118235f, (float)0.0f);
            this.LeftArm.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)-0.11746066f, (float)0.0f);
            this.LeftLeg1.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)-1.407259f, (float)0.0f);
            this.LeftLeg1.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)0.35185838f, (float)0.0f);
            this.Head.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)-0.19547687f, (float)0.13665928f);
            this.Head.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)0.74281216f, (float)0.0f);
            this.Head.f_104205_ = Mth.m_14179_((float)sleepProgress, (float)-0.07819075f, (float)0.0f);
            this.Tail1.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)-0.07819075f, (float)0.0f);
            this.Tail1.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)-0.27401668f, (float)0.0f);
            this.Tail1.f_104205_ = Mth.m_14179_((float)sleepProgress, (float)-0.19565141f, (float)0.0f);
            this.Body.f_104201_ = Mth.m_14179_((float)sleepProgress, (float)18.9f, (float)10.9f);
            this.RightLeg1.f_104201_ = Mth.m_14179_((float)sleepProgress, (float)18.9f, (float)10.9f);
            this.RightLeg1.f_104202_ = Mth.m_14179_((float)sleepProgress, (float)3.0f, (float)0.0f);
            this.RightLeg2.f_104200_ = Mth.m_14179_((float)sleepProgress, (float)-1.0f, (float)0.0f);
            this.RightLeg2.f_104201_ = Mth.m_14179_((float)sleepProgress, (float)2.8f, (float)7.0f);
            this.RightLeg2.f_104202_ = Mth.m_14179_((float)sleepProgress, (float)3.7f, (float)4.0f);
            this.LeftLeg1.f_104201_ = Mth.m_14179_((float)sleepProgress, (float)18.9f, (float)10.9f);
            this.LeftLeg1.f_104202_ = Mth.m_14179_((float)sleepProgress, (float)3.0f, (float)0.0f);
            this.LeftLeg2.f_104200_ = Mth.m_14179_((float)sleepProgress, (float)1.0f, (float)0.0f);
            this.LeftLeg2.f_104201_ = Mth.m_14179_((float)sleepProgress, (float)3.0f, (float)3.0f);
            this.LeftLeg2.f_104202_ = Mth.m_14179_((float)sleepProgress, (float)3.7f, (float)4.0f);
            this.Head.f_104202_ = Mth.m_14179_((float)sleepProgress, (float)-11.4f, (float)-12.0f);
            this.LeftArm.f_104200_ = Mth.m_14179_((float)sleepProgress, (float)-3.1f, (float)-2.1f);
            this.LeftArm.f_104201_ = Mth.m_14179_((float)sleepProgress, (float)1.0f, (float)3.0f);
            this.LeftArm.f_104202_ = Mth.m_14179_((float)sleepProgress, (float)-10.0f, (float)-9.0f);
            this.RightArm.f_104200_ = Mth.m_14179_((float)sleepProgress, (float)3.1f, (float)2.1f);
            this.RightArm.f_104201_ = Mth.m_14179_((float)sleepProgress, (float)1.0f, (float)3.0f);
            this.RightArm.f_104202_ = Mth.m_14179_((float)sleepProgress, (float)-10.0f, (float)-9.0f);
        } else {
            this.Head.f_104204_ = netHeadYaw * ((float)Math.PI / 180);
            this.RightLeg1.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
            this.LeftLeg1.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
            this.Tail1.f_104204_ = -0.12f * Mth.m_14031_((float)(0.2f * ageInTicks / 5.0f));
            this.Tail2.f_104204_ = -0.12f * Mth.m_14031_((float)(0.2f * ageInTicks / 5.0f));
            this.Tail1.f_104203_ = -Math.abs(-0.05f * Mth.m_14031_((float)(0.1f * ageInTicks / 5.0f)));
            this.Tail2.f_104203_ = -Math.abs(-0.05f * Mth.m_14031_((float)(0.1f * ageInTicks / 5.0f)));
            this.Body.f_104203_ = Math.abs(-0.025f * Mth.m_14031_((float)(0.1f * ageInTicks / 3.0f)));
            this.Head.f_104203_ = headPitch * ((float)Math.PI / 180) + Math.abs(-0.025f * Mth.m_14031_((float)(0.1f * ageInTicks / 3.0f))) + attackProgress * (float)Math.toRadians(40.0);
            this.RightArm.f_104205_ = -Math.abs(-0.05f * Mth.m_14031_((float)(0.15f * ageInTicks / 3.0f))) + attackProgress * (float)Math.toRadians(-50.0);
            this.LeftArm.f_104205_ = Math.abs(-0.05f * Mth.m_14031_((float)(0.15f * ageInTicks / 3.0f))) + attackProgress * (float)Math.toRadians(50.0);
            if (entity.isEating()) {
                this.Head.f_104203_ = Math.abs(Mth.m_14031_((float)(0.05f * ageInTicks)) * 0.5f) + 0.25f;
                this.Body.f_104203_ = 0.2f;
            }
            if (entity.m_20069_()) {
                this.LeftLeg1.f_104201_ = 20.0f;
                this.RightLeg1.f_104201_ = 20.0f;
                this.Body.f_104201_ = 20.0f;
                this.Body.f_104203_ = -0.5f;
                this.Tail1.f_104203_ = 0.25f;
                this.Tail2.f_104203_ = 0.25f;
                this.Head.f_104203_ = 0.5f;
                this.LeftLeg1.f_104203_ = -0.5f * Mth.m_14031_((float)(0.2f * ageInTicks / 1.5f));
                this.RightLeg1.f_104203_ = 0.5f * Mth.m_14031_((float)(0.2f * ageInTicks / 1.5f));
                this.LeftLeg2.f_104203_ = -0.3f * Mth.m_14031_((float)(0.2f * ageInTicks / 1.5f));
                this.RightLeg2.f_104203_ = 0.3f * Mth.m_14031_((float)(0.2f * ageInTicks / 1.5f));
                this.LeftArm.f_104203_ = 0.5f;
                this.RightArm.f_104203_ = 0.5f;
                this.Tail1.f_104204_ = Mth.m_14089_((float)(limbSwing * 2.6662f)) * 1.4f * limbSwingAmount + 0.0625f * Mth.m_14031_((float)(0.15f * ageInTicks / 1.5f));
                this.Tail2.f_104204_ = Mth.m_14089_((float)(limbSwing * 2.6662f)) * 1.4f * limbSwingAmount + 0.0625f * Mth.m_14031_((float)(0.15f * ageInTicks / 1.5f));
            }
        }
    }

    public void resetModel() {
        this.RightLeg1.f_104203_ = 0.0f;
        this.RightLeg1.f_104204_ = 0.0f;
        this.Body.f_104203_ = 0.0f;
        this.RightArm.f_104203_ = 0.0f;
        this.RightArm.f_104204_ = 0.0f;
        this.RightArm.f_104205_ = 0.0f;
        this.LeftLeg2.f_104203_ = 0.0f;
        this.LeftLeg2.f_104204_ = 0.0f;
        this.Snout.f_104203_ = 0.0f;
        this.Tail2.f_104203_ = 0.0f;
        this.Tail2.f_104204_ = 0.0f;
        this.Tail2.f_104205_ = 0.0f;
        this.RightLeg2.f_104203_ = 0.0f;
        this.RightLeg2.f_104204_ = 0.0f;
        this.LeftArm.f_104205_ = 0.0f;
        this.LeftArm.f_104203_ = 0.0f;
        this.LeftArm.f_104204_ = 0.0f;
        this.LeftLeg1.f_104203_ = 0.0f;
        this.LeftLeg1.f_104204_ = 0.0f;
        this.Head.f_104203_ = 0.13665928f;
        this.Head.f_104204_ = 0.0f;
        this.Head.f_104205_ = 0.0f;
        this.Tail1.f_104203_ = 0.0f;
        this.Tail1.f_104204_ = 0.0f;
        this.Tail1.f_104205_ = 0.0f;
        this.Body.f_104201_ = 10.9f;
        this.RightLeg1.f_104201_ = 10.9f;
        this.RightLeg1.f_104202_ = 0.0f;
        this.RightLeg2.f_104200_ = 0.0f;
        this.RightLeg2.f_104201_ = 7.0f;
        this.RightLeg2.f_104202_ = 4.0f;
        this.LeftLeg1.f_104201_ = 10.9f;
        this.LeftLeg1.f_104202_ = 0.0f;
        this.LeftLeg2.f_104200_ = 0.0f;
        this.LeftLeg2.f_104201_ = 7.0f;
        this.LeftLeg2.f_104202_ = 4.0f;
        this.Head.f_104202_ = -12.0f;
        this.LeftArm.f_104200_ = -2.1f;
        this.LeftArm.f_104201_ = 3.0f;
        this.LeftArm.f_104202_ = -9.0f;
        this.RightArm.f_104200_ = 2.1f;
        this.RightArm.f_104201_ = 3.0f;
        this.RightArm.f_104202_ = -9.0f;
    }

    public void sleepPose() {
        this.RightLeg1.f_104203_ = -1.407608f;
        this.RightLeg1.f_104204_ = -0.27366763f;
        this.Body.f_104203_ = -0.19547687f;
        this.RightArm.f_104203_ = 0.76881754f;
        this.RightArm.f_104204_ = -0.00418879f;
        this.LeftLeg2.f_104203_ = 0.039095376f;
        this.LeftLeg2.f_104204_ = (float)Math.PI;
        this.Snout.f_104203_ = 0.05235988f;
        this.Tail2.f_104203_ = 0.23457225f;
        this.Tail2.f_104204_ = -0.039095376f;
        this.Tail2.f_104205_ = -0.07819075f;
        this.RightLeg2.f_104203_ = 0.078016214f;
        this.RightLeg2.f_104204_ = (float)Math.PI;
        this.LeftArm.f_104203_ = 0.65118235f;
        this.LeftArm.f_104204_ = -0.11746066f;
        this.LeftLeg1.f_104203_ = -1.407259f;
        this.LeftLeg1.f_104204_ = 0.35185838f;
        this.Head.f_104203_ = -0.19547687f;
        this.Head.f_104204_ = 0.74281216f;
        this.Head.f_104205_ = -0.07819075f;
        this.Tail1.f_104203_ = -0.07819075f;
        this.Tail1.f_104204_ = -0.27401668f;
        this.Tail1.f_104205_ = -0.19565141f;
        this.Body.f_104201_ = 18.9f;
        this.RightLeg1.f_104201_ = 18.9f;
        this.RightLeg1.f_104202_ = 3.0f;
        this.RightLeg2.f_104200_ = -1.0f;
        this.RightLeg2.f_104201_ = 2.8f;
        this.RightLeg2.f_104202_ = 3.7f;
        this.LeftLeg1.f_104201_ = 18.9f;
        this.LeftLeg1.f_104202_ = 3.0f;
        this.LeftLeg2.f_104200_ = 1.0f;
        this.LeftLeg2.f_104201_ = 3.0f;
        this.LeftLeg2.f_104202_ = 3.7f;
        this.Head.f_104202_ = -11.4f;
        this.LeftArm.f_104200_ = -3.1f;
        this.LeftArm.f_104201_ = 1.0f;
        this.LeftArm.f_104202_ = -10.0f;
        this.RightArm.f_104200_ = 3.1f;
        this.RightArm.f_104201_ = 1.0f;
        this.RightArm.f_104202_ = -10.0f;
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.RightLeg1.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.LeftLeg1.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.Body.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
    }
}

