/*
 * Decompiled with CFR 0.152.
 */
package superlord.prehistoricfauna.client.model.cretaceous.hellcreek;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import superlord.prehistoricfauna.common.entity.DinosaurEntity;
import superlord.prehistoricfauna.common.entity.cretaceous.hellcreek.Pachycephalosaurus;

public class PachycephalosaurusModel
extends EntityModel<Pachycephalosaurus> {
    private final ModelPart Body;
    private final ModelPart RightThigh;
    private final ModelPart RightLeg;
    private final ModelPart LeftThigh;
    private final ModelPart LeftLeg;
    private final ModelPart LeftArm;
    private final ModelPart RightArm;
    private final ModelPart Neck;
    private final ModelPart Tail1;
    private final ModelPart Tail2;

    public PachycephalosaurusModel(ModelPart root) {
        this.Body = root.m_171324_("Body");
        this.RightThigh = this.Body.m_171324_("RightThigh");
        this.RightLeg = this.RightThigh.m_171324_("RightLeg");
        this.LeftThigh = this.Body.m_171324_("LeftThigh");
        this.LeftLeg = this.LeftThigh.m_171324_("LeftLeg");
        this.LeftArm = this.Body.m_171324_("LeftArm");
        this.RightArm = this.Body.m_171324_("RightArm");
        this.Neck = this.Body.m_171324_("Neck");
        this.Tail1 = this.Body.m_171324_("Tail1");
        this.Tail2 = this.Tail1.m_171324_("Tail2");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition Body = partdefinition.m_171599_("Body", CubeListBuilder.m_171558_().m_171514_(0, 35).m_171488_(-5.0f, 0.0f, 0.0f, 10.0f, 10.0f, 21.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)2.0f, (float)-10.0f));
        PartDefinition Tail1 = Body.m_171599_("Tail1", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-3.0f, -3.0f, -1.0f, 6.0f, 6.0f, 9.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)3.05f, (float)21.0f));
        PartDefinition Tail2 = Tail1.m_171599_("Tail2", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-1.0f, -1.0f, -1.0f, 2.0f, 3.0f, 32.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-1.95f, (float)8.0f));
        PartDefinition LeftArm = Body.m_171599_("LeftArm", CubeListBuilder.m_171558_().m_171514_(58, 0).m_171488_(-1.0f, -1.0f, -1.5f, 2.0f, 7.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-5.0f, (float)8.0f, (float)2.5f));
        PartDefinition RightArm = Body.m_171599_("RightArm", CubeListBuilder.m_171558_().m_171514_(20, 20).m_171488_(-1.0f, -1.0f, -1.5f, 2.0f, 7.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)5.0f, (float)8.0f, (float)2.5f));
        PartDefinition LeftThigh = Body.m_171599_("LeftThigh", CubeListBuilder.m_171558_().m_171514_(41, 35).m_171488_(-4.0f, -2.0f, -3.5f, 4.0f, 11.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-3.0f, (float)5.0f, (float)14.5f));
        PartDefinition LeftLeg = LeftThigh.m_171599_("LeftLeg", CubeListBuilder.m_171558_().m_171514_(25, 0).m_171488_(-1.0f, 0.0f, 0.0f, 2.0f, 8.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-2.0f, (float)9.0f, (float)3.5f));
        PartDefinition LeftFoot = LeftLeg.m_171599_("LeftFoot", CubeListBuilder.m_171558_().m_171514_(0, 3).m_171488_(-1.0f, 0.0f, -3.0f, 2.0f, 0.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)8.0f, (float)0.0f));
        PartDefinition RightThigh = Body.m_171599_("RightThigh", CubeListBuilder.m_171558_().m_171514_(36, 0).m_171488_(0.0f, -2.0f, -3.5f, 4.0f, 11.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)3.0f, (float)5.0f, (float)14.5f));
        PartDefinition RightLeg = RightThigh.m_171599_("RightLeg", CubeListBuilder.m_171558_().m_171514_(21, 0).m_171488_(-1.0f, 0.0f, 0.0f, 2.0f, 8.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)2.0f, (float)9.0f, (float)3.5f));
        PartDefinition RightFoot = RightLeg.m_171599_("RightFoot", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-1.0f, 0.0f, -3.0f, 2.0f, 0.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)8.0f, (float)0.0f));
        PartDefinition Neck = Body.m_171599_("Neck", CubeListBuilder.m_171558_().m_171514_(0, 15).m_171488_(-2.0f, -7.0f, -5.0f, 4.0f, 10.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)4.0f, (float)0.0f));
        PartDefinition Head = Neck.m_171599_("Head", CubeListBuilder.m_171558_().m_171514_(36, 18).m_171488_(-2.5f, -2.0f, -6.0f, 5.0f, 5.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-7.0f, (float)-1.0f));
        PartDefinition Snout = Head.m_171599_("Snout", CubeListBuilder.m_171558_().m_171514_(0, 35).m_171488_(-1.5f, 0.0f, -3.0f, 3.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-1.0f, (float)-7.0f));
        PartDefinition NoseBumps1 = Snout.m_171599_("NoseBumps1", CubeListBuilder.m_171558_().m_171514_(0, 48).m_171488_(-3.0f, 0.0f, 0.0f, 3.0f, 1.0f, 3.0f, new CubeDeformation(0.01f)), PartPose.m_171419_((float)1.5f, (float)-0.7f, (float)-2.5f));
        PartDefinition InnerNoseBump = Snout.m_171599_("InnerNoseBump", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-1.0f, (float)-1.5f));
        PartDefinition BackCrest = Head.m_171599_("BackCrest", CubeListBuilder.m_171558_().m_171514_(14, 15).m_171488_(-3.0f, 0.0f, -1.0f, 6.0f, 3.0f, 2.0f, new CubeDeformation(0.01f)), PartPose.m_171419_((float)0.0f, (float)-2.0f, (float)0.0f));
        PartDefinition Horns = BackCrest.m_171599_("Horns", CubeListBuilder.m_171558_().m_171514_(0, 43).m_171488_(-3.0f, 0.0f, 0.0f, 6.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)1.0f));
        PartDefinition Helmet = Head.m_171599_("Helmet", CubeListBuilder.m_171558_().m_171514_(52, 12).m_171488_(-2.5f, 0.0f, -6.0f, 5.0f, 2.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-4.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)128, (int)128);
    }

    public void setupAnim(Pachycephalosaurus entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        float partialTick = ageInTicks - (float)entity.f_19797_;
        float sleepProgress = entity.getSleepProgress(partialTick);
        float attackProgress = entity.getMeleeProgress(partialTick) * 2.0f;
        this.resetModel();
        if (entity.isAsleep()) {
            if (sleepProgress != 0.0f && (Integer)entity.m_20088_().m_135370_(DinosaurEntity.SLEEP_TICK) > 0) {
                this.LeftLeg.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-0.4537856f);
                this.LeftThigh.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-0.87266463f);
                this.LeftThigh.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)0.29670596f);
                this.LeftThigh.f_104201_ = Mth.m_14179_((float)sleepProgress, (float)6.0f, (float)3.2f);
                this.LeftArm.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)0.87266463f);
                this.Body.f_104201_ = Mth.m_14179_((float)sleepProgress, (float)2.0f, (float)10.0f);
                this.Body.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-0.2443461f);
                this.RightThigh.f_104201_ = Mth.m_14179_((float)sleepProgress, (float)5.0f, (float)3.2f);
                this.RightThigh.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-0.87266463f);
                this.RightThigh.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-0.29670596f);
                this.Neck.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)0.87266463f);
                this.Neck.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)0.9773844f);
                this.RightLeg.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-0.4537856f);
                this.RightArm.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)0.87266463f);
                this.Tail1.f_104202_ = Mth.m_14179_((float)sleepProgress, (float)21.0f, (float)20.0f);
                this.Tail1.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)0.07853982f);
                this.Tail1.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-0.5934119f);
                this.Tail1.f_104205_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-0.10471976f);
                this.Tail2.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)0.07853982f);
                this.Tail2.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-0.5934119f);
                this.Tail2.f_104205_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-0.10471976f);
            } else {
                this.sleepPose();
            }
        } else if (sleepProgress != 0.0f && (Integer)entity.m_20088_().m_135370_(DinosaurEntity.SLEEP_TICK) > 0) {
            this.LeftLeg.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)-0.4537856f, (float)0.0f);
            this.LeftThigh.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)-0.87266463f, (float)0.0f);
            this.LeftThigh.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)0.29670596f, (float)0.0f);
            this.LeftThigh.f_104201_ = Mth.m_14179_((float)sleepProgress, (float)3.2f, (float)6.0f);
            this.LeftArm.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.87266463f, (float)0.0f);
            this.Body.f_104201_ = Mth.m_14179_((float)sleepProgress, (float)10.0f, (float)2.0f);
            this.Body.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)-0.2443461f, (float)0.0f);
            this.RightThigh.f_104201_ = Mth.m_14179_((float)sleepProgress, (float)3.2f, (float)5.0f);
            this.RightThigh.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)-0.87266463f, (float)0.0f);
            this.RightThigh.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)-0.29670596f, (float)0.0f);
            this.Neck.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.87266463f, (float)0.0f);
            this.Neck.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)0.9773844f, (float)0.0f);
            this.RightLeg.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)-0.4537856f, (float)0.0f);
            this.RightArm.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.87266463f, (float)0.0f);
            this.Tail1.f_104202_ = Mth.m_14179_((float)sleepProgress, (float)20.0f, (float)21.0f);
            this.Tail1.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.07853982f, (float)0.0f);
            this.Tail1.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)-0.5934119f, (float)0.0f);
            this.Tail1.f_104205_ = Mth.m_14179_((float)sleepProgress, (float)-0.10471976f, (float)0.0f);
            this.Tail2.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.07853982f, (float)0.0f);
            this.Tail2.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)-0.5934119f, (float)0.0f);
            this.Tail2.f_104205_ = Mth.m_14179_((float)sleepProgress, (float)-0.5934119f, (float)0.0f);
        } else {
            this.LeftThigh.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
            this.RightThigh.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
            this.Tail1.f_104204_ = -0.12f * Mth.m_14031_((float)(0.2f * ageInTicks / 5.0f));
            this.Tail2.f_104204_ = -0.12f * Mth.m_14031_((float)(0.2f * ageInTicks / 5.0f));
            this.Tail1.f_104203_ = -Math.abs(-0.05f * Mth.m_14031_((float)(0.1f * ageInTicks / 5.0f)));
            this.Tail2.f_104203_ = -Math.abs(-0.05f * Mth.m_14031_((float)(0.1f * ageInTicks / 5.0f)));
            this.Neck.f_104203_ = headPitch * ((float)Math.PI / 180) + Math.abs(-0.025f * Mth.m_14031_((float)(0.1f * ageInTicks / 3.0f))) + attackProgress * (float)Math.toRadians(25.0);
            this.RightArm.f_104205_ = Math.abs(-0.05f * Mth.m_14031_((float)(0.15f * ageInTicks / 3.0f)));
            this.LeftArm.f_104205_ = -Math.abs(-0.05f * Mth.m_14031_((float)(0.15f * ageInTicks / 3.0f)));
            this.Neck.f_104204_ = netHeadYaw * ((float)Math.PI / 180);
            this.Body.f_104202_ = attackProgress * -5.0f - 10.0f;
            if (entity.isEating()) {
                this.Neck.f_104203_ = Math.abs(Mth.m_14031_((float)(0.05f * ageInTicks)) * 0.75f) + 0.5f;
            }
            if (entity.m_20069_()) {
                this.Body.f_104201_ = 10.0f;
                this.Body.f_104203_ = -0.5f;
                this.Tail1.f_104203_ = 0.25f;
                this.Tail2.f_104203_ = 0.25f;
                this.Neck.f_104203_ = 0.5f;
                this.RightThigh.f_104203_ = -0.5f * Mth.m_14031_((float)(0.2f * ageInTicks / 1.5f));
                this.LeftThigh.f_104203_ = 0.5f * Mth.m_14031_((float)(0.2f * ageInTicks / 1.5f));
                this.RightLeg.f_104203_ = -0.3f * Mth.m_14031_((float)(0.2f * ageInTicks / 1.5f));
                this.LeftLeg.f_104203_ = 0.3f * Mth.m_14031_((float)(0.2f * ageInTicks / 1.5f));
                this.LeftArm.f_104203_ = 0.5f;
                this.RightArm.f_104203_ = 0.5f;
                this.Tail1.f_104204_ = Mth.m_14089_((float)(limbSwing * 2.6662f)) * 1.4f * limbSwingAmount + 0.0625f * Mth.m_14031_((float)(0.15f * ageInTicks / 1.5f));
                this.Tail2.f_104204_ = Mth.m_14089_((float)(limbSwing * 2.6662f)) * 1.4f * limbSwingAmount + 0.0625f * Mth.m_14031_((float)(0.15f * ageInTicks / 1.5f));
            }
        }
    }

    public void resetModel() {
        this.LeftLeg.f_104203_ = 0.0f;
        this.LeftThigh.f_104201_ = 5.0f;
        this.LeftThigh.f_104203_ = 0.0f;
        this.LeftThigh.f_104204_ = 0.0f;
        this.LeftArm.f_104202_ = 2.5f;
        this.LeftArm.f_104203_ = 0.0f;
        this.Body.f_104201_ = 2.0f;
        this.Body.f_104203_ = 0.0f;
        this.RightThigh.f_104201_ = 5.0f;
        this.RightThigh.f_104203_ = 0.0f;
        this.RightThigh.f_104204_ = 0.0f;
        this.Neck.f_104203_ = 0.0f;
        this.Neck.f_104204_ = 0.0f;
        this.RightLeg.f_104203_ = 0.0f;
        this.RightArm.f_104202_ = 2.5f;
        this.RightArm.f_104203_ = 0.0f;
        this.Tail1.f_104200_ = 0.0f;
        this.Tail1.f_104202_ = 21.0f;
        this.Tail1.f_104203_ = 0.0f;
        this.Tail1.f_104204_ = 0.0f;
        this.Tail1.f_104205_ = 0.0f;
        this.Tail2.f_104203_ = 0.0f;
        this.Tail2.f_104204_ = 0.0f;
        this.Tail2.f_104205_ = 0.0f;
    }

    public void sleepPose() {
        this.LeftLeg.f_104203_ = -0.4537856f;
        this.LeftThigh.f_104203_ = -0.87266463f;
        this.LeftThigh.f_104204_ = 0.29670596f;
        this.LeftThigh.f_104201_ = 3.2f;
        this.LeftArm.f_104202_ = 2.5f;
        this.LeftArm.f_104203_ = 0.87266463f;
        this.Body.f_104201_ = 10.0f;
        this.Body.f_104203_ = -0.2443461f;
        this.RightThigh.f_104201_ = 3.2f;
        this.RightThigh.f_104203_ = -0.87266463f;
        this.RightThigh.f_104204_ = -0.29670596f;
        this.Neck.f_104203_ = 0.87266463f;
        this.Neck.f_104204_ = 0.9773844f;
        this.RightLeg.f_104203_ = -0.4537856f;
        this.RightArm.f_104203_ = 0.87266463f;
        this.RightArm.f_104202_ = 2.5f;
        this.Tail1.f_104202_ = 20.0f;
        this.Tail1.f_104203_ = 0.07853982f;
        this.Tail1.f_104204_ = -0.5934119f;
        this.Tail1.f_104205_ = -0.10471976f;
        this.Tail2.f_104203_ = 0.07853982f;
        this.Tail2.f_104204_ = -0.5934119f;
        this.Tail2.f_104205_ = -0.10471976f;
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.Body.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
    }
}

