/*
 * Decompiled with CFR 0.152.
 */
package superlord.prehistoricfauna.client.model.cretaceous.hellcreek;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import superlord.prehistoricfauna.common.entity.DinosaurEntity;
import superlord.prehistoricfauna.common.entity.cretaceous.hellcreek.Ornithomimus;

public class OrnithomimusModel
extends EntityModel<Ornithomimus> {
    private final ModelPart Body;
    private final ModelPart Neck1;
    private final ModelPart Neck2;
    private final ModelPart Tail1;
    private final ModelPart Tail2;
    private final ModelPart LeftWing;
    private final ModelPart RightWing;
    private final ModelPart LeftThigh;
    private final ModelPart LeftLeg;
    private final ModelPart LeftFoot;
    private final ModelPart RightThigh;
    private final ModelPart RightLeg;
    private final ModelPart RightFoot;

    public OrnithomimusModel(ModelPart root) {
        this.Body = root.m_171324_("Body");
        this.Neck1 = this.Body.m_171324_("Neck1");
        this.Neck2 = this.Neck1.m_171324_("Neck2");
        this.Tail1 = this.Body.m_171324_("Tail1");
        this.Tail2 = this.Tail1.m_171324_("Tail2");
        this.LeftWing = this.Body.m_171324_("LeftWing");
        this.RightWing = this.Body.m_171324_("RightWing");
        this.LeftThigh = this.Body.m_171324_("LeftThigh");
        this.LeftLeg = this.LeftThigh.m_171324_("LeftLeg");
        this.LeftFoot = this.LeftLeg.m_171324_("LeftFoot");
        this.RightThigh = this.Body.m_171324_("RightThigh");
        this.RightLeg = this.RightThigh.m_171324_("RightLeg");
        this.RightFoot = this.RightLeg.m_171324_("RightFoot");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition Body = partdefinition.m_171599_("Body", CubeListBuilder.m_171558_().m_171514_(0, 27).m_171488_(-4.0f, -22.0f, -11.0f, 8.0f, 9.0f, 18.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition Tail1 = Body.m_171599_("Tail1", CubeListBuilder.m_171558_().m_171514_(38, 0).m_171488_(-2.5f, -0.4f, 2.0f, 5.0f, 5.0f, 13.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-21.5f, (float)4.0f, (float)-0.1309f, (float)0.0f, (float)0.0f));
        PartDefinition Tail2 = Tail1.m_171599_("Tail2", CubeListBuilder.m_171558_().m_171514_(30, 60).m_171488_(-1.5f, -1.05f, -1.0f, 3.0f, 2.0f, 20.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.75f, (float)15.0f, (float)0.0873f, (float)0.0f, (float)0.0f));
        PartDefinition TailFan = Tail2.m_171599_("TailFan", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-4.0f, -0.05f, 5.0f, 8.0f, 5.0f, 22.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)-3.0f));
        PartDefinition LeftThigh = Body.m_171599_("LeftThigh", CubeListBuilder.m_171558_().m_171514_(0, 63).m_171488_(-2.5f, -2.5f, -4.5f, 4.0f, 10.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)3.5f, (float)-17.5f, (float)3.5f));
        PartDefinition LeftLeg = LeftThigh.m_171599_("LeftLeg", CubeListBuilder.m_171558_().m_171514_(45, 27).m_171488_(-1.0f, 0.0f, 0.0f, 2.0f, 10.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-0.5f, (float)7.5f, (float)1.5f));
        PartDefinition LeftFoot = LeftLeg.m_171599_("LeftFoot", CubeListBuilder.m_171558_().m_171514_(95, 29).m_171480_().m_171488_(-2.5f, 0.0f, -5.0f, 5.0f, 0.0f, 5.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)0.0f, (float)10.0f, (float)0.0f));
        PartDefinition RightThigh = Body.m_171599_("RightThigh", CubeListBuilder.m_171558_().m_171514_(0, 63).m_171480_().m_171488_(-1.5f, -2.5f, -4.5f, 4.0f, 10.0f, 7.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)-3.5f, (float)-17.5f, (float)3.5f));
        PartDefinition RightLeg = RightThigh.m_171599_("RightLeg", CubeListBuilder.m_171558_().m_171514_(45, 27).m_171480_().m_171488_(-1.0f, 0.0f, 0.0f, 2.0f, 10.0f, 0.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)0.5f, (float)7.5f, (float)1.5f));
        PartDefinition RightFoot = RightLeg.m_171599_("RightFoot", CubeListBuilder.m_171558_().m_171514_(95, 29).m_171488_(-2.5f, 0.0f, -5.0f, 5.0f, 0.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)10.0f, (float)0.0f));
        PartDefinition Neck1 = Body.m_171599_("Neck1", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-2.0f, -7.75f, -4.75f, 4.0f, 10.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-18.25f, (float)-10.25f, (float)0.3491f, (float)0.0f, (float)0.0f));
        PartDefinition Neck2 = Neck1.m_171599_("Neck2", CubeListBuilder.m_171558_().m_171514_(35, 27).m_171488_(-1.0f, -10.0f, -2.75f, 2.0f, 11.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-7.75f, (float)1.0f, (float)-0.3054f, (float)0.0f, (float)0.0f));
        PartDefinition Head = Neck2.m_171599_("Head", CubeListBuilder.m_171558_().m_171514_(7, 16).m_171488_(-1.5f, 0.0f, -3.0f, 3.0f, 2.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-10.0f, (float)-0.75f));
        PartDefinition Beak = Head.m_171599_("Beak", CubeListBuilder.m_171558_().m_171514_(38, 0).m_171488_(-1.0f, 0.0f, -6.0f, 2.0f, 2.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition Neck2Feathers = Neck2.m_171599_("Neck2Feathers", CubeListBuilder.m_171558_().m_171514_(40, 63).m_171488_(0.0f, -7.0f, -6.75f, 0.0f, 9.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition NeckFeathers = Neck1.m_171599_("NeckFeathers", CubeListBuilder.m_171558_().m_171514_(0, 20).m_171488_(0.0f, -7.75f, -7.75f, 0.0f, 13.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition LeftWing = Body.m_171599_("LeftWing", CubeListBuilder.m_171558_().m_171514_(24, 65).m_171488_(-2.0f, -0.5f, -1.0f, 2.0f, 9.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)5.0f, (float)-16.5f, (float)-9.0f));
        PartDefinition RightWing = Body.m_171599_("RightWing", CubeListBuilder.m_171558_().m_171514_(24, 65).m_171480_().m_171488_(-2.0f, -0.5f, -1.0f, 2.0f, 9.0f, 6.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)-3.0f, (float)-16.5f, (float)-9.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)128, (int)128);
    }

    public void setupAnim(Ornithomimus entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        float walkSpeed = 1.0f;
        float walkDegree = 0.5f;
        float idleSpeed = 1.0f;
        float idleDegree = 1.0f;
        float partialTick = ageInTicks - (float)entity.f_19797_;
        float attackProgress = entity.getMeleeProgress(partialTick);
        float sleepProgress = entity.getSleepProgress(partialTick);
        this.resetModel();
        if (entity.isAsleep()) {
            if (sleepProgress != 0.0f && (Integer)entity.m_20088_().m_135370_(DinosaurEntity.SLEEP_TICK) > 0) {
                this.RightWing.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)0.8932595f);
                this.RightWing.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-0.19547687f);
                this.Tail2.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)0.20943952f);
                this.Tail2.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-0.55850536f);
                this.Body.f_104201_ = Mth.m_14179_((float)sleepProgress, (float)24.0f, (float)32.5f);
                this.Body.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-0.10471976f);
                this.LeftFoot.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)1.5079633f);
                this.Neck2.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-0.7864454f);
                this.Neck2.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)0.6658431f);
                this.Neck2.f_104205_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-1.1339405f);
                this.Tail1.f_104202_ = Mth.m_14179_((float)sleepProgress, (float)4.0f, (float)4.5f);
                this.Tail1.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-0.2443461f);
                this.Tail1.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-0.34906584f);
                this.RightFoot.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)1.5079633f);
                this.RightLeg.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-0.687758f);
                this.LeftLeg.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-0.687758f);
                this.Neck1.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)1.0929252f);
                this.Neck1.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)1.2117821f);
                this.Neck1.f_104205_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)0.23509586f);
                this.LeftThigh.f_104200_ = Mth.m_14179_((float)sleepProgress, (float)-3.5f, (float)-4.0f);
                this.LeftThigh.f_104201_ = Mth.m_14179_((float)sleepProgress, (float)-17.6f, (float)-15.6f);
                this.LeftThigh.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-0.7330383f);
                this.LeftThigh.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)0.2443461f);
                this.RightThigh.f_104200_ = Mth.m_14179_((float)sleepProgress, (float)3.5f, (float)4.0f);
                this.RightThigh.f_104201_ = Mth.m_14179_((float)sleepProgress, (float)-17.6f, (float)-15.6f);
                this.RightThigh.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-0.7330383f);
                this.RightThigh.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-0.2443461f);
                this.LeftWing.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)0.6066764f);
                this.LeftWing.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)0.19547687f);
                this.LeftWing.f_104205_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-0.10471976f);
            } else {
                this.sleepPose();
            }
        } else if (sleepProgress != 0.0f && (Integer)entity.m_20088_().m_135370_(DinosaurEntity.SLEEP_TICK) > 0) {
            this.RightWing.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.8932595f, (float)0.0f);
            this.RightWing.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)-0.19547687f, (float)0.0f);
            this.Tail2.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.20943952f, (float)0.0f);
            this.Tail2.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)-0.55850536f, (float)0.0f);
            this.Body.f_104201_ = Mth.m_14179_((float)sleepProgress, (float)32.5f, (float)24.0f);
            this.Body.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)-0.10471976f, (float)0.0f);
            this.LeftFoot.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)1.5079633f, (float)0.0f);
            this.Neck2.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)-0.7864454f, (float)0.0f);
            this.Neck2.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)0.6658431f, (float)0.0f);
            this.Neck2.f_104205_ = Mth.m_14179_((float)sleepProgress, (float)-1.1339405f, (float)0.0f);
            this.Tail1.f_104202_ = Mth.m_14179_((float)sleepProgress, (float)4.5f, (float)4.0f);
            this.Tail1.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)-0.2443461f, (float)0.0f);
            this.Tail1.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)-0.34906584f, (float)0.0f);
            this.RightFoot.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)1.5079633f, (float)0.0f);
            this.RightLeg.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)-0.687758f, (float)0.0f);
            this.LeftLeg.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)-0.687758f, (float)0.0f);
            this.Neck1.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)1.0929252f, (float)0.0f);
            this.Neck1.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)1.2117821f, (float)0.0f);
            this.Neck1.f_104205_ = Mth.m_14179_((float)sleepProgress, (float)0.23509586f, (float)0.0f);
            this.LeftThigh.f_104200_ = Mth.m_14179_((float)sleepProgress, (float)-4.0f, (float)-3.5f);
            this.LeftThigh.f_104201_ = Mth.m_14179_((float)sleepProgress, (float)-15.6f, (float)-17.6f);
            this.LeftThigh.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)-0.7330383f, (float)0.0f);
            this.LeftThigh.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)0.2443461f, (float)0.0f);
            this.RightThigh.f_104200_ = Mth.m_14179_((float)sleepProgress, (float)4.0f, (float)3.5f);
            this.RightThigh.f_104201_ = Mth.m_14179_((float)sleepProgress, (float)-15.6f, (float)-17.6f);
            this.RightThigh.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)-0.7330383f, (float)0.0f);
            this.RightThigh.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)-0.2443461f, (float)0.0f);
            this.LeftWing.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.6066764f, (float)0.0f);
            this.LeftWing.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)0.19547687f, (float)0.0f);
            this.LeftWing.f_104205_ = Mth.m_14179_((float)sleepProgress, (float)-0.10471976f, (float)0.0f);
        } else {
            this.Neck1.f_104203_ = Math.abs(-0.025f * Mth.m_14031_((float)(0.1f * ageInTicks / 3.0f))) + (Mth.m_14089_((float)(-1.0f + limbSwing * walkSpeed * 0.3f)) * walkDegree * 0.3f * limbSwingAmount + 0.35f) + headPitch * ((float)Math.PI / 180) + attackProgress * (float)Math.toRadians(25.0);
            this.Body.f_104203_ = Mth.m_14089_((float)(1.0f + limbSwing * walkSpeed * 0.3f)) * walkDegree * 0.1f * limbSwingAmount;
            this.Tail1.f_104203_ = -Math.abs(-0.05f * Mth.m_14031_((float)(0.1f * ageInTicks / 5.0f))) + Mth.m_14089_((float)(limbSwing * walkSpeed * 0.3f)) * walkDegree * 0.1f * limbSwingAmount - 0.05f;
            this.Tail2.f_104203_ = -Math.abs(-0.05f * Mth.m_14031_((float)(0.1f * ageInTicks / 5.0f))) + Mth.m_14089_((float)(-1.0f + limbSwing * walkSpeed * 0.3f)) * walkDegree * 0.15f * limbSwingAmount + 0.05f;
            this.Tail1.f_104204_ = -0.12f * Mth.m_14031_((float)(0.2f * ageInTicks / 5.0f)) + Mth.m_14089_((float)(limbSwing * walkSpeed * 0.15f)) * walkDegree * 0.6f * limbSwingAmount;
            this.Tail2.f_104204_ = -0.12f * Mth.m_14031_((float)(0.2f * ageInTicks / 5.0f)) + Mth.m_14089_((float)(limbSwing * walkSpeed * 0.15f)) * walkDegree * 1.0f * limbSwingAmount;
            this.Neck2.f_104203_ = Mth.m_14089_((float)(-1.0f + limbSwing * walkSpeed * 0.3f)) * walkDegree * 0.25f * limbSwingAmount - 0.2f + attackProgress * (float)Math.toRadians(-25.0);
            this.RightWing.f_104203_ = -Math.abs(-0.05f * Mth.m_14031_((float)(0.15f * ageInTicks / 3.0f))) + Mth.m_14089_((float)(limbSwing * walkSpeed * 0.3f)) * walkDegree * 0.2f * limbSwingAmount + 0.15f;
            this.LeftWing.f_104203_ = Math.abs(-0.05f * Mth.m_14031_((float)(0.15f * ageInTicks / 3.0f))) + Mth.m_14089_((float)(2.0f + limbSwing * walkSpeed * 0.3f)) * walkDegree * 0.2f * limbSwingAmount + 0.15f;
            this.RightThigh.f_104203_ = Mth.m_14089_((float)(1.0f + limbSwing * idleSpeed * 0.3f)) * idleDegree * 0.6f * limbSwingAmount - 0.05f + Mth.m_14089_((float)(1.0f + limbSwing * walkSpeed * 0.3f)) * walkDegree * 0.6f * limbSwingAmount - 0.05f;
            this.RightLeg.f_104203_ = Mth.m_14089_((float)(1.0f + limbSwing * idleSpeed * 0.3f)) * idleDegree * 0.4f * limbSwingAmount + 0.05f + Mth.m_14089_((float)(1.0f + limbSwing * walkSpeed * 0.3f)) * walkDegree * 0.4f * limbSwingAmount + 0.05f;
            this.RightFoot.f_104203_ = Mth.m_14089_((float)(2.0f + limbSwing * idleSpeed * 0.3f)) * idleDegree * 0.3f * limbSwingAmount + Mth.m_14089_((float)(2.0f + limbSwing * walkSpeed * 0.3f)) * walkDegree * 0.3f * limbSwingAmount;
            this.LeftThigh.f_104203_ = Mth.m_14089_((float)(1.0f + limbSwing * idleSpeed * 0.3f)) * idleDegree * -0.6f * limbSwingAmount - 0.05f + Mth.m_14089_((float)(1.0f + limbSwing * walkSpeed * 0.3f)) * walkDegree * -0.6f * limbSwingAmount - 0.05f;
            this.LeftLeg.f_104203_ = Mth.m_14089_((float)(1.0f + limbSwing * idleSpeed * 0.3f)) * idleDegree * -0.4f * limbSwingAmount + 0.05f + Mth.m_14089_((float)(1.0f + limbSwing * walkSpeed * 0.3f)) * walkDegree * -0.4f * limbSwingAmount + 0.05f;
            this.LeftFoot.f_104203_ = Mth.m_14089_((float)(2.0f + limbSwing * idleSpeed * 0.3f)) * idleDegree * -0.3f * limbSwingAmount + Mth.m_14089_((float)(2.0f + limbSwing * walkSpeed * 0.3f)) * walkDegree * -0.3f * limbSwingAmount;
            this.Neck1.f_104204_ = netHeadYaw * ((float)Math.PI / 180);
            if (entity.m_20069_()) {
                this.Body.f_104201_ = 37.0f;
                this.Body.f_104203_ = -0.25f;
                this.Tail1.f_104203_ = 0.125f;
                this.Tail2.f_104203_ = 0.125f;
                this.Neck1.f_104203_ = 0.5f;
                this.RightThigh.f_104203_ = -0.25f * Mth.m_14031_((float)(0.2f * ageInTicks / 1.5f));
                this.LeftThigh.f_104203_ = 0.25f * Mth.m_14031_((float)(0.2f * ageInTicks / 1.5f));
                this.RightLeg.f_104203_ = -0.3f * Mth.m_14031_((float)(0.2f * ageInTicks / 1.5f));
                this.LeftLeg.f_104203_ = 0.3f * Mth.m_14031_((float)(0.2f * ageInTicks / 1.5f));
                this.RightFoot.f_104203_ = 0.5f - 0.3f * Mth.m_14031_((float)(0.2f * ageInTicks / 1.5f));
                this.LeftFoot.f_104203_ = 0.5f + 0.3f * Mth.m_14031_((float)(0.2f * ageInTicks / 1.5f));
                this.LeftWing.f_104203_ = 0.25f;
                this.RightWing.f_104203_ = 0.25f;
                this.LeftWing.f_104205_ = -1.5f + Math.abs(-1.0f * Mth.m_14031_((float)(0.15f * ageInTicks / 2.0f)));
                this.RightWing.f_104205_ = 1.5f - Math.abs(-1.0f * Mth.m_14031_((float)(0.15f * ageInTicks / 2.0f)));
                this.Tail1.f_104204_ = Mth.m_14089_((float)(limbSwing * 2.6662f)) * 1.4f * limbSwingAmount + 0.0625f * Mth.m_14031_((float)(0.15f * ageInTicks / 1.5f));
                this.Tail2.f_104204_ = Mth.m_14089_((float)(limbSwing * 2.6662f)) * 1.4f * limbSwingAmount + 0.0625f * Mth.m_14031_((float)(0.15f * ageInTicks / 1.5f));
            }
        }
    }

    public void resetModel() {
        this.RightWing.f_104203_ = 0.0f;
        this.LeftWing.f_104204_ = 0.0f;
        this.Tail2.f_104203_ = 0.0f;
        this.Tail2.f_104204_ = 0.0f;
        this.Body.f_104201_ = 24.0f;
        this.Body.f_104203_ = 0.0f;
        this.LeftFoot.f_104202_ = 0.0f;
        this.LeftFoot.f_104203_ = 0.0f;
        this.Neck2.f_104200_ = 0.0f;
        this.Neck2.f_104202_ = 1.0f;
        this.Neck2.f_104203_ = -0.1309f;
        this.Neck2.f_104204_ = 0.0f;
        this.Neck2.f_104205_ = 0.0f;
        this.Tail1.f_104202_ = 4.0f;
        this.Tail1.f_104203_ = -0.1309f;
        this.Tail1.f_104204_ = 0.0f;
        this.RightFoot.f_104202_ = 0.0f;
        this.RightFoot.f_104203_ = 0.0f;
        this.RightLeg.f_104203_ = 0.0f;
        this.LeftLeg.f_104203_ = 0.0f;
        this.Neck1.f_104203_ = 0.0f;
        this.Neck1.f_104204_ = 0.0f;
        this.Neck1.f_104205_ = 0.0f;
        this.LeftThigh.f_104200_ = -3.5f;
        this.LeftThigh.f_104201_ = -17.6f;
        this.LeftThigh.f_104202_ = 3.5f;
        this.LeftThigh.f_104203_ = 0.0f;
        this.LeftThigh.f_104204_ = 0.0f;
        this.RightThigh.f_104200_ = 3.5f;
        this.RightThigh.f_104201_ = -17.6f;
        this.RightThigh.f_104202_ = 3.5f;
        this.RightThigh.f_104203_ = 0.0f;
        this.RightThigh.f_104204_ = 0.0f;
        this.LeftWing.f_104203_ = 0.0f;
        this.LeftWing.f_104204_ = 0.0f;
        this.LeftWing.f_104205_ = 0.0f;
        this.RightWing.f_104203_ = 0.0f;
        this.RightWing.f_104204_ = 0.0f;
        this.RightWing.f_104205_ = 0.0f;
        this.Neck1.f_104202_ = -10.25f;
    }

    public void sleepPose() {
        this.RightWing.f_104203_ = 0.8932595f;
        this.RightWing.f_104204_ = -0.19547687f;
        this.Tail2.f_104203_ = 0.20943952f;
        this.Tail2.f_104204_ = -0.55850536f;
        this.Body.f_104201_ = 32.5f;
        this.Body.f_104203_ = -0.10471976f;
        this.LeftFoot.f_104202_ = -0.0f;
        this.LeftFoot.f_104203_ = 1.5079633f;
        this.Neck2.f_104203_ = -0.7864454f;
        this.Neck2.f_104204_ = 0.6658431f;
        this.Neck2.f_104205_ = -1.1339405f;
        this.Tail1.f_104202_ = 4.5f;
        this.Tail1.f_104203_ = -0.2443461f;
        this.Tail1.f_104204_ = -0.34906584f;
        this.RightFoot.f_104202_ = 0.0f;
        this.RightFoot.f_104203_ = 1.5079633f;
        this.RightLeg.f_104203_ = -0.687758f;
        this.LeftLeg.f_104203_ = -0.687758f;
        this.Neck1.f_104203_ = 1.0929252f;
        this.Neck1.f_104204_ = 1.2117821f;
        this.Neck1.f_104205_ = 0.23509586f;
        this.LeftThigh.f_104200_ = -4.0f;
        this.LeftThigh.f_104201_ = -15.6f;
        this.LeftThigh.f_104203_ = -0.7330383f;
        this.LeftThigh.f_104204_ = 0.2443461f;
        this.RightThigh.f_104200_ = 4.0f;
        this.RightThigh.f_104201_ = -15.6f;
        this.RightThigh.f_104203_ = -0.7330383f;
        this.RightThigh.f_104204_ = -0.2443461f;
        this.LeftWing.f_104203_ = 0.6066764f;
        this.LeftWing.f_104204_ = 0.19547687f;
        this.LeftWing.f_104205_ = -0.10471976f;
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.Body.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
    }
}

