/*
 * Decompiled with CFR 0.152.
 */
package superlord.prehistoricfauna.client.model.cretaceous.hellcreek;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import superlord.prehistoricfauna.common.entity.DinosaurEntity;
import superlord.prehistoricfauna.common.entity.cretaceous.hellcreek.Edmontosaurus;

public class EdmontosaurusBabyModel
extends EntityModel<Edmontosaurus> {
    private final ModelPart Bone;
    private final ModelPart Body;
    private final ModelPart RightArm;
    private final ModelPart LeftArm;
    private final ModelPart Neck;
    private final ModelPart LeftThigh;
    private final ModelPart LeftLeg;
    private final ModelPart LeftFoot;
    private final ModelPart RightThigh;
    private final ModelPart RightLeg;
    private final ModelPart RightFoot;
    private final ModelPart Tail;

    public EdmontosaurusBabyModel(ModelPart root) {
        this.Bone = root.m_171324_("Bone");
        this.Body = this.Bone.m_171324_("Body");
        this.LeftArm = this.Body.m_171324_("LeftArm");
        this.RightArm = this.Body.m_171324_("RightArm");
        this.Neck = this.Body.m_171324_("Neck");
        this.Tail = this.Body.m_171324_("Tail");
        this.LeftThigh = this.Bone.m_171324_("LeftThigh");
        this.LeftLeg = this.LeftThigh.m_171324_("LeftLeg");
        this.LeftFoot = this.LeftLeg.m_171324_("LeftFoot");
        this.RightThigh = this.Bone.m_171324_("RightThigh");
        this.RightLeg = this.RightThigh.m_171324_("RightLeg");
        this.RightFoot = this.RightLeg.m_171324_("RightFoot");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition Bone = partdefinition.m_171599_("Bone", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)24.0f, (float)6.0f));
        PartDefinition Body = Bone.m_171599_("Body", CubeListBuilder.m_171558_().m_171514_(51, 27).m_171488_(-3.0f, -4.5f, -10.0f, 6.0f, 7.0f, 12.0f, new CubeDeformation(0.0f)).m_171514_(24, 44).m_171488_(0.0f, -5.5f, -10.0f, 0.0f, 1.0f, 12.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-7.5f, (float)-1.0f));
        PartDefinition RightArm = Body.m_171599_("RightArm", CubeListBuilder.m_171558_().m_171514_(30, 28).m_171480_().m_171488_(-1.0f, -0.5f, 0.0f, 2.0f, 7.0f, 2.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)-3.0f, (float)1.0f, (float)-9.0f));
        PartDefinition LeftArm = Body.m_171599_("LeftArm", CubeListBuilder.m_171558_().m_171514_(30, 28).m_171488_(-1.0f, -0.5f, 0.0f, 2.0f, 7.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)3.0f, (float)1.0f, (float)-9.0f));
        PartDefinition Neck = Body.m_171599_("Neck", CubeListBuilder.m_171558_().m_171514_(26, 0).m_171488_(-1.5f, -0.5f, -6.0f, 3.0f, 4.0f, 7.0f, new CubeDeformation(0.0f)).m_171514_(56, 6).m_171488_(0.0f, -2.5f, -4.0f, 0.0f, 2.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-3.0f, (float)-10.0f));
        PartDefinition Head = Neck.m_171599_("Head", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-1.5f, -1.0f, -6.5f, 2.0f, 2.0f, 3.0f, new CubeDeformation(0.0f)).m_171514_(8, 9).m_171480_().m_171488_(-2.5f, 0.0f, -6.5f, 1.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)).m_171555_(false).m_171514_(8, 9).m_171488_(0.5f, 0.0f, -6.5f, 1.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(20, 20).m_171488_(-2.5f, -2.0f, -3.5f, 4.0f, 3.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.5f, (float)1.4f, (float)-3.5f));
        PartDefinition Tail = Body.m_171599_("Tail", CubeListBuilder.m_171558_().m_171514_(0, 26).m_171488_(-1.0f, -0.75f, 0.0f, 2.0f, 4.0f, 14.0f, new CubeDeformation(0.0f)).m_171514_(24, 44).m_171488_(0.0f, -1.75f, 0.0f, 0.0f, 1.0f, 12.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-3.75f, (float)2.0f));
        PartDefinition RightThigh = Bone.m_171599_("RightThigh", CubeListBuilder.m_171558_().m_171514_(0, 19).m_171480_().m_171488_(-2.0f, -0.5f, -1.0f, 3.0f, 7.0f, 4.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)-2.0f, (float)-9.5f, (float)-3.0f));
        PartDefinition RightLeg = RightThigh.m_171599_("RightLeg", CubeListBuilder.m_171558_().m_171514_(3, 36).m_171480_().m_171488_(-1.5f, 0.0f, 0.0f, 3.0f, 3.0f, 0.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)-0.5f, (float)6.5f, (float)3.0f));
        PartDefinition RightFoot = RightLeg.m_171599_("RightFoot", CubeListBuilder.m_171558_().m_171514_(-3, 33).m_171480_().m_171488_(-1.5f, 0.0f, -3.0f, 3.0f, 0.0f, 3.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)0.0f, (float)3.0f, (float)0.0f));
        PartDefinition LeftThigh = Bone.m_171599_("LeftThigh", CubeListBuilder.m_171558_().m_171514_(0, 19).m_171488_(-1.0f, -0.5f, -1.0f, 3.0f, 7.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)2.0f, (float)-9.5f, (float)-3.0f));
        PartDefinition LeftLeg = LeftThigh.m_171599_("LeftLeg", CubeListBuilder.m_171558_().m_171514_(3, 36).m_171488_(-1.5f, 0.0f, 0.0f, 3.0f, 3.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.5f, (float)6.5f, (float)3.0f));
        PartDefinition LeftFoot = LeftLeg.m_171599_("LeftFoot", CubeListBuilder.m_171558_().m_171514_(-3, 33).m_171488_(-1.5f, 0.0f, -3.0f, 3.0f, 0.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)3.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)100, (int)100);
    }

    public void setupAnim(Edmontosaurus entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        float speed = 0.9f;
        float degree = 1.0f;
        float partialTick = ageInTicks - (float)entity.f_19797_;
        float attackProgress = entity.getMeleeProgress(partialTick) * 2.0f;
        float sleepProgress = entity.getSleepProgress(partialTick);
        this.resetModel();
        if (entity.isAsleep()) {
            if (sleepProgress != 0.0f && (Integer)entity.m_20088_().m_135370_(DinosaurEntity.SLEEP_TICK) > 0) {
                this.Body.f_104201_ = Mth.m_14179_((float)sleepProgress, (float)-7.5f, (float)-4.5f);
                this.LeftThigh.f_104201_ = Mth.m_14179_((float)sleepProgress, (float)-9.5f, (float)-7.0f);
                this.LeftThigh.f_104202_ = Mth.m_14179_((float)sleepProgress, (float)-3.0f, (float)-2.5f);
                this.RightThigh.f_104201_ = Mth.m_14179_((float)sleepProgress, (float)-9.5f, (float)-7.0f);
                this.RightThigh.f_104202_ = Mth.m_14179_((float)sleepProgress, (float)-3.0f, (float)-2.5f);
                this.LeftArm.f_104201_ = Mth.m_14179_((float)sleepProgress, (float)1.0f, (float)-0.5f);
                this.RightArm.f_104201_ = Mth.m_14179_((float)sleepProgress, (float)1.0f, (float)-0.5f);
                this.Tail.f_104202_ = Mth.m_14179_((float)sleepProgress, (float)2.0f, (float)1.0f);
                this.Neck.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)0.12359878f);
                this.Neck.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-0.34906584f);
                this.RightThigh.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-0.7330383f);
                this.RightThigh.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)0.25850537f);
                this.LeftArm.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-1.4330382f);
                this.LeftArm.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-0.20757121f);
                this.RightArm.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-1.3962634f);
                this.RightArm.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)0.13962634f);
                this.RightArm.f_104205_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-0.13962634f);
                this.RightLeg.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-0.83775806f);
                this.LeftLeg.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-0.83775806f);
                this.Body.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)0.17453292f);
                this.Tail.f_104203_ = -Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)0.55850536f);
                this.Tail.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)0.41887903f);
                this.LeftFoot.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)1.58f);
                this.RightFoot.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)1.58f);
                this.LeftThigh.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-0.7330383f);
                this.LeftThigh.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-0.25850537f);
            } else {
                this.sleepPose();
            }
        } else if (sleepProgress != 0.0f && (Integer)entity.m_20088_().m_135370_(DinosaurEntity.SLEEP_TICK) > 0) {
            this.Body.f_104201_ = Mth.m_14179_((float)sleepProgress, (float)-4.5f, (float)-7.5f);
            this.LeftThigh.f_104201_ = Mth.m_14179_((float)sleepProgress, (float)-7.0f, (float)-9.5f);
            this.LeftThigh.f_104202_ = Mth.m_14179_((float)sleepProgress, (float)-2.5f, (float)-3.0f);
            this.RightThigh.f_104201_ = Mth.m_14179_((float)sleepProgress, (float)-7.0f, (float)-9.5f);
            this.RightThigh.f_104202_ = Mth.m_14179_((float)sleepProgress, (float)-2.5f, (float)-3.0f);
            this.LeftArm.f_104201_ = Mth.m_14179_((float)sleepProgress, (float)-0.5f, (float)1.0f);
            this.RightArm.f_104201_ = Mth.m_14179_((float)sleepProgress, (float)-0.5f, (float)1.0f);
            this.Tail.f_104202_ = Mth.m_14179_((float)sleepProgress, (float)1.0f, (float)2.0f);
            this.Neck.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.12359878f, (float)0.0f);
            this.Neck.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)-0.34906584f, (float)0.0f);
            this.RightThigh.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)-0.7330383f, (float)0.0f);
            this.RightThigh.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)0.25850537f, (float)0.0f);
            this.LeftArm.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)-1.4330382f, (float)0.0f);
            this.LeftArm.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)-0.20757121f, (float)0.0f);
            this.RightArm.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)-1.3962634f, (float)0.0f);
            this.RightArm.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)0.13962634f, (float)0.0f);
            this.RightArm.f_104205_ = Mth.m_14179_((float)sleepProgress, (float)-0.13962634f, (float)0.0f);
            this.RightLeg.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)-0.83775806f, (float)0.0f);
            this.LeftLeg.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)-0.83775806f, (float)0.0f);
            this.Body.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.17453292f, (float)0.0f);
            this.Tail.f_104203_ = -Mth.m_14179_((float)sleepProgress, (float)0.55850536f, (float)0.0f);
            this.Tail.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)0.41887903f, (float)0.0f);
            this.LeftFoot.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)1.58f, (float)0.0f);
            this.RightFoot.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)1.58f, (float)0.0f);
            this.LeftThigh.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)-0.7330383f, (float)0.0f);
            this.LeftThigh.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)-0.25850537f, (float)0.0f);
        } else {
            this.LeftArm.f_104203_ = Mth.m_14089_((float)(limbSwing * speed * 0.3f)) * degree * 0.8f * limbSwingAmount + attackProgress * (float)Math.toRadians(15.0);
            this.RightArm.f_104203_ = Mth.m_14089_((float)(limbSwing * speed * 0.3f)) * degree * -0.8f * limbSwingAmount + attackProgress * (float)Math.toRadians(15.0);
            this.RightThigh.f_104203_ = Mth.m_14089_((float)(1.0f + limbSwing * speed * 0.3f)) * degree * 0.4f * limbSwingAmount + attackProgress * (float)Math.toRadians(7.0);
            this.RightLeg.f_104203_ = Mth.m_14089_((float)(limbSwing * speed * 0.3f)) * degree * 0.3f * limbSwingAmount;
            this.LeftThigh.f_104203_ = Mth.m_14089_((float)(1.0f + limbSwing * speed * 0.3f)) * degree * -0.4f * limbSwingAmount + attackProgress * (float)Math.toRadians(7.0);
            this.LeftLeg.f_104203_ = Mth.m_14089_((float)(limbSwing * speed * 0.3f)) * degree * -0.3f * limbSwingAmount;
            this.Tail.f_104204_ = -0.12f * Mth.m_14031_((float)(0.2f * ageInTicks / 5.0f)) + Mth.m_14089_((float)(limbSwing * speed * 0.15f)) * degree * 0.35f * limbSwingAmount;
            this.Tail.f_104203_ = -Math.abs(-0.05f * Mth.m_14031_((float)(0.1f * ageInTicks / 5.0f))) + (Mth.m_14089_((float)(limbSwing * speed * 0.3f)) * degree * 0.15f * limbSwingAmount - 0.15f);
            this.Neck.f_104203_ = Math.abs(-0.025f * Mth.m_14031_((float)(0.1f * ageInTicks / 3.0f))) + (Mth.m_14089_((float)(limbSwing * speed * 0.3f)) * degree * 0.1f * limbSwingAmount + 0.15f);
            if (entity.isEating()) {
                this.Neck.f_104203_ = Math.abs(Mth.m_14031_((float)(0.05f * ageInTicks)) * 0.45f) + 0.15f;
                this.Body.f_104203_ = 0.2f;
                this.LeftArm.f_104205_ = -0.2f;
                this.RightArm.f_104205_ = 0.2f;
            }
            if (entity.m_20069_()) {
                this.Body.f_104201_ = -5.0f;
                this.LeftThigh.f_104201_ = -7.0f;
                this.RightThigh.f_104201_ = -7.0f;
                this.LeftThigh.f_104203_ = -0.25f * Mth.m_14031_((float)(0.2f * ageInTicks / 1.5f));
                this.RightThigh.f_104203_ = 0.25f * Mth.m_14031_((float)(0.2f * ageInTicks / 1.5f));
                this.LeftLeg.f_104203_ = -0.3f * Mth.m_14031_((float)(0.2f * ageInTicks / 1.5f));
                this.RightLeg.f_104203_ = 0.3f * Mth.m_14031_((float)(0.2f * ageInTicks / 1.5f));
                this.RightArm.f_104203_ = -0.25f * Mth.m_14031_((float)(0.2f * ageInTicks / 1.5f));
                this.LeftArm.f_104203_ = 0.25f * Mth.m_14031_((float)(0.2f * ageInTicks / 1.5f));
                this.Neck.f_104203_ = -0.125f;
                this.Tail.f_104204_ = Mth.m_14089_((float)(limbSwing * 2.6662f)) * 1.4f * limbSwingAmount + 0.0625f * Mth.m_14031_((float)(0.15f * ageInTicks / 1.5f));
            }
        }
    }

    public void resetModel() {
        this.Neck.f_104201_ = -3.0f;
        this.Neck.f_104203_ = 0.0f;
        this.Neck.f_104204_ = 0.0f;
        this.RightThigh.f_104200_ = -2.0f;
        this.RightThigh.f_104201_ = -9.5f;
        this.RightThigh.f_104202_ = -3.0f;
        this.RightThigh.f_104203_ = 0.0f;
        this.RightThigh.f_104204_ = 0.0f;
        this.LeftArm.f_104202_ = -9.0f;
        this.LeftArm.f_104201_ = 1.0f;
        this.LeftArm.f_104203_ = 0.0f;
        this.LeftArm.f_104204_ = 0.0f;
        this.LeftArm.f_104205_ = 0.0f;
        this.LeftLeg.f_104201_ = 6.5f;
        this.LeftLeg.f_104203_ = 0.0f;
        this.RightArm.f_104202_ = -9.0f;
        this.RightArm.f_104201_ = 1.0f;
        this.RightArm.f_104203_ = 0.0f;
        this.RightArm.f_104204_ = 0.0f;
        this.RightArm.f_104205_ = 0.0f;
        this.RightLeg.f_104201_ = 6.5f;
        this.RightLeg.f_104203_ = 0.0f;
        this.Body.f_104201_ = -7.5f;
        this.Body.f_104203_ = 0.0f;
        this.Tail.f_104201_ = -3.75f;
        this.Tail.f_104202_ = 2.0f;
        this.Tail.f_104203_ = 0.0f;
        this.Tail.f_104204_ = 0.0f;
        this.LeftThigh.f_104200_ = 2.0f;
        this.LeftThigh.f_104201_ = -9.5f;
        this.LeftThigh.f_104202_ = -3.0f;
        this.LeftThigh.f_104203_ = 0.0f;
        this.LeftThigh.f_104204_ = 0.0f;
        this.LeftFoot.f_104203_ = 0.0f;
        this.RightFoot.f_104203_ = 0.0f;
    }

    public void sleepPose() {
        this.Body.f_104201_ = -4.5f;
        this.LeftThigh.f_104201_ = -7.0f;
        this.LeftThigh.f_104200_ = 2.0f;
        this.LeftThigh.f_104202_ = -2.5f;
        this.RightThigh.f_104201_ = -7.0f;
        this.RightThigh.f_104200_ = -2.0f;
        this.RightThigh.f_104202_ = -2.5f;
        this.LeftArm.f_104201_ = -0.5f;
        this.RightArm.f_104201_ = -0.5f;
        this.LeftLeg.f_104201_ = 6.5f;
        this.RightLeg.f_104201_ = 6.5f;
        this.Tail.f_104202_ = 1.0f;
        this.Neck.f_104201_ = -3.0f;
        this.Neck.f_104203_ = 0.12359878f;
        this.Neck.f_104204_ = -0.34906584f;
        this.RightThigh.f_104203_ = -0.7330383f;
        this.RightThigh.f_104204_ = 0.25850537f;
        this.LeftArm.f_104203_ = -1.4330382f;
        this.LeftArm.f_104204_ = -0.20757121f;
        this.RightArm.f_104203_ = -1.3962634f;
        this.RightArm.f_104204_ = 0.13962634f;
        this.RightArm.f_104205_ = -0.13962634f;
        this.RightLeg.f_104203_ = -0.83775806f;
        this.LeftLeg.f_104203_ = -0.83775806f;
        this.Body.f_104203_ = 0.17453292f;
        this.Tail.f_104203_ = -0.55850536f;
        this.Tail.f_104204_ = 0.41887903f;
        this.LeftFoot.f_104203_ = 1.58f;
        this.RightFoot.f_104203_ = 1.58f;
        this.LeftThigh.f_104203_ = -0.7330383f;
        this.LeftThigh.f_104204_ = -0.25850537f;
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.Bone.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
    }
}

