/*
 * Decompiled with CFR 0.152.
 */
package superlord.prehistoricfauna.client.model.cretaceous.hellcreek;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import superlord.prehistoricfauna.common.entity.DinosaurEntity;
import superlord.prehistoricfauna.common.entity.cretaceous.hellcreek.Brachychampsa;

public class BrachychampsaModel
extends EntityModel<Brachychampsa> {
    private final ModelPart Body;
    private final ModelPart Neck;
    private final ModelPart Head;
    private final ModelPart Jaw;
    private final ModelPart RightArm;
    private final ModelPart LeftArm;
    private final ModelPart RightLeg;
    private final ModelPart LeftLeg;
    private final ModelPart Tail1;
    private final ModelPart Tail2;

    public BrachychampsaModel(ModelPart root) {
        this.Body = root.m_171324_("Body");
        this.Neck = this.Body.m_171324_("Neck");
        this.Head = this.Neck.m_171324_("Head");
        this.Jaw = this.Head.m_171324_("Jaw");
        this.RightArm = this.Body.m_171324_("RightArm");
        this.LeftArm = this.Body.m_171324_("LeftArm");
        this.RightLeg = this.Body.m_171324_("RightLeg");
        this.LeftLeg = this.Body.m_171324_("LeftLeg");
        this.Tail1 = this.Body.m_171324_("Tail1");
        this.Tail2 = this.Tail1.m_171324_("Tail2");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition Body = partdefinition.m_171599_("Body", CubeListBuilder.m_171558_().m_171514_(1, 7).m_171488_(-4.0f, -3.0f, -3.0f, 8.0f, 6.0f, 15.0f, new CubeDeformation(0.0f)).m_171514_(17, -11).m_171488_(3.0f, -4.0f, -3.0f, 0.0f, 1.0f, 15.0f, new CubeDeformation(0.0f)).m_171514_(17, -11).m_171488_(-3.0f, -4.0f, -3.0f, 0.0f, 1.0f, 15.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)18.0f, (float)-2.5f));
        PartDefinition Neck = Body.m_171599_("Neck", CubeListBuilder.m_171558_().m_171514_(2, 29).m_171488_(-2.5f, -2.5f, -3.0f, 5.0f, 5.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-0.5f, (float)-3.0f));
        PartDefinition Head = Neck.m_171599_("Head", CubeListBuilder.m_171558_().m_171514_(22, 61).m_171488_(-1.5f, 0.5f, -8.025f, 3.0f, 1.0f, 0.0f, new CubeDeformation(0.0f)).m_171514_(1, 50).m_171488_(-3.0f, -0.5f, -4.0f, 6.0f, 1.0f, 4.0f, new CubeDeformation(0.0f)).m_171514_(2, 44).m_171488_(-1.5f, -1.5f, -4.0f, 3.0f, 1.0f, 4.0f, new CubeDeformation(0.0f)).m_171514_(1, 56).m_171488_(-2.0f, -0.5f, -8.0f, 4.0f, 2.0f, 4.0f, new CubeDeformation(0.0f)).m_171514_(22, 39).m_171488_(-2.5f, 0.0f, -3.0f, 5.0f, 2.0f, 3.0f, new CubeDeformation(-0.01f)), PartPose.m_171419_((float)0.0f, (float)-1.025f, (float)-3.0f));
        PartDefinition Jaw = Head.m_171599_("Jaw", CubeListBuilder.m_171558_().m_171514_(23, 45).m_171488_(-3.0f, 0.0f, -4.0f, 6.0f, 2.0f, 4.0f, new CubeDeformation(0.01f)).m_171514_(1, 38).m_171488_(-2.5f, 2.0f, -4.0f, 5.0f, 1.0f, 4.0f, new CubeDeformation(0.01f)).m_171514_(18, 52).m_171488_(-2.0f, 1.0f, -8.0f, 4.0f, 1.0f, 4.0f, new CubeDeformation(0.0f)).m_171514_(0, 0).m_171488_(-1.5f, 0.0f, -7.9f, 3.0f, 1.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.5f, (float)0.0f));
        PartDefinition RightArm = Body.m_171599_("RightArm", CubeListBuilder.m_171558_().m_171514_(67, 13).m_171488_(1.0f, 2.98f, -2.5f, 3.0f, 0.0f, 4.0f, new CubeDeformation(0.0f)).m_171514_(71, 5).m_171488_(-1.0f, -1.0f, -1.5f, 3.0f, 4.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)4.0f, (float)3.0f, (float)-0.5f));
        PartDefinition LeftArm = Body.m_171599_("LeftArm", CubeListBuilder.m_171558_().m_171514_(67, 13).m_171480_().m_171488_(-4.0f, 2.98f, -2.5f, 3.0f, 0.0f, 4.0f, new CubeDeformation(0.0f)).m_171555_(false).m_171514_(71, 5).m_171480_().m_171488_(-2.0f, -1.0f, -1.5f, 3.0f, 4.0f, 3.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)-4.0f, (float)3.0f, (float)-0.5f));
        PartDefinition RightLeg = Body.m_171599_("RightLeg", CubeListBuilder.m_171558_().m_171514_(84, 5).m_171488_(-1.0f, -1.0f, -1.5f, 3.0f, 6.0f, 3.0f, new CubeDeformation(0.0f)).m_171514_(80, 15).m_171488_(-1.0f, 4.98f, -5.5f, 5.0f, 0.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)4.0f, (float)1.0f, (float)9.5f));
        PartDefinition LeftLeg = Body.m_171599_("LeftLeg", CubeListBuilder.m_171558_().m_171514_(80, 15).m_171480_().m_171488_(-4.0f, 4.98f, -5.5f, 5.0f, 0.0f, 6.0f, new CubeDeformation(0.0f)).m_171555_(false).m_171514_(84, 5).m_171480_().m_171488_(-2.0f, -1.0f, -1.5f, 3.0f, 6.0f, 3.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)-4.0f, (float)1.0f, (float)9.5f));
        PartDefinition Tail1 = Body.m_171599_("Tail1", CubeListBuilder.m_171558_().m_171514_(35, 4).m_171488_(-2.0f, -2.0f, -3.0f, 4.0f, 5.0f, 12.0f, new CubeDeformation(0.0f)).m_171514_(36, -6).m_171488_(1.0f, -3.0f, 1.0f, 0.0f, 1.0f, 8.0f, new CubeDeformation(0.0f)).m_171514_(36, -6).m_171488_(-1.0f, -3.0f, 1.0f, 0.0f, 1.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)12.0f, (float)-0.2618f, (float)0.0f, (float)0.0f));
        PartDefinition Tail2 = Tail1.m_171599_("Tail2", CubeListBuilder.m_171558_().m_171514_(52, 7).m_171488_(-1.0f, -1.7f, -0.5f, 2.0f, 3.0f, 15.0f, new CubeDeformation(0.0f)).m_171514_(53, -11).m_171488_(0.0f, -3.7f, 1.5f, 0.0f, 2.0f, 13.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)1.5f, (float)8.0f, (float)0.1745f, (float)0.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)100, (int)64);
    }

    public void setupAnim(Brachychampsa entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float NeckPitch) {
        float speed = 1.0f;
        float degree = 1.0f;
        float partialTick = ageInTicks - (float)entity.f_19797_;
        float attackProgress = entity.getMeleeProgress(partialTick);
        float sleepProgress = entity.getSleepProgress(partialTick);
        this.resetModel();
        if (entity.isAsleep()) {
            if (sleepProgress != 0.0f && (Integer)entity.m_20088_().m_135370_(DinosaurEntity.SLEEP_TICK) > 0) {
                this.Body.f_104201_ = Mth.m_14179_((float)sleepProgress, (float)18.0f, (float)22.0f);
                this.RightArm.f_104201_ = Mth.m_14179_((float)sleepProgress, (float)3.0f, (float)1.0f);
                this.LeftArm.f_104201_ = Mth.m_14179_((float)sleepProgress, (float)3.0f, (float)1.0f);
                this.Tail1.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)-0.2618f, (float)-0.0572468f);
                this.Tail1.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)0.39095375f);
                this.Tail2.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.1745f, (float)-0.0572468f);
                this.Tail2.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)0.39095375f);
                this.LeftArm.f_104205_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)1.0946705f);
                this.Neck.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)0.11728612f);
                this.Neck.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-0.39095375f);
                this.LeftLeg.f_104205_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)0.938289f);
                this.RightLeg.f_104205_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-0.938289f);
                this.RightArm.f_104205_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-1.1728612f);
            } else {
                this.sleepPose();
            }
        } else {
            if (sleepProgress != 0.0f && (Integer)entity.m_20088_().m_135370_(DinosaurEntity.SLEEP_TICK) > 0) {
                this.Body.f_104201_ = Mth.m_14179_((float)sleepProgress, (float)22.0f, (float)18.0f);
                this.RightArm.f_104201_ = Mth.m_14179_((float)sleepProgress, (float)1.0f, (float)3.0f);
                this.LeftArm.f_104201_ = Mth.m_14179_((float)sleepProgress, (float)1.0f, (float)3.0f);
                this.Tail1.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)-0.0572468f, (float)-0.2618f);
                this.Tail1.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)0.39095375f, (float)0.0f);
                this.Tail2.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)-0.0572468f, (float)0.1745f);
                this.Tail2.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)0.39095375f, (float)0.0f);
                this.LeftArm.f_104205_ = Mth.m_14179_((float)sleepProgress, (float)1.0946705f, (float)0.0f);
                this.Neck.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.11728612f, (float)0.0f);
                this.Neck.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)-0.39095375f, (float)0.0f);
                this.LeftLeg.f_104205_ = Mth.m_14179_((float)sleepProgress, (float)0.938289f, (float)0.0f);
                this.RightLeg.f_104205_ = Mth.m_14179_((float)sleepProgress, (float)-0.938289f, (float)0.0f);
                this.RightArm.f_104205_ = Mth.m_14179_((float)sleepProgress, (float)-1.1728612f, (float)0.0f);
            } else {
                this.LeftArm.f_104203_ = Mth.m_14089_((float)(limbSwing * speed * 0.5f)) * degree * 0.75f * limbSwingAmount;
                this.RightArm.f_104203_ = Mth.m_14089_((float)(limbSwing * speed * 0.5f)) * degree * -0.75f * limbSwingAmount;
                this.LeftLeg.f_104203_ = Mth.m_14089_((float)(limbSwing * speed * 0.5f)) * degree * -0.75f * limbSwingAmount;
                this.RightLeg.f_104203_ = Mth.m_14089_((float)(limbSwing * speed * 0.5f)) * degree * 0.75f * limbSwingAmount;
                this.Tail1.f_104203_ = -Math.abs(-0.05f * Mth.m_14031_((float)(0.1f * ageInTicks / 5.0f))) + Mth.m_14089_((float)(limbSwing * speed * 0.3f)) * degree * 0.15f * limbSwingAmount - 0.1818f;
                this.Tail1.f_104204_ = -0.12f * Mth.m_14031_((float)(0.2f * ageInTicks / 5.0f)) + Mth.m_14089_((float)(-1.0f + limbSwing * speed * 0.25f)) * degree * 0.5f * limbSwingAmount;
                this.Tail2.f_104203_ = -Math.abs(-0.05f * Mth.m_14031_((float)(0.1f * ageInTicks / 5.0f))) + Mth.m_14089_((float)(limbSwing * speed * 0.3f)) * degree * 0.15f * limbSwingAmount + 0.1245f;
                this.Tail2.f_104204_ = -0.12f * Mth.m_14031_((float)(0.2f * ageInTicks / 5.0f)) + Mth.m_14089_((float)(-1.0f + limbSwing * speed * 0.25f)) * degree * 0.5f * limbSwingAmount;
                if (entity.m_20069_()) {
                    this.Tail1.f_104203_ = -Math.abs(-0.05f * Mth.m_14031_((float)(0.1f * ageInTicks / 2.0f))) + (Mth.m_14089_((float)(limbSwing * speed * 0.3f)) * degree * 0.15f * limbSwingAmount - 0.15f);
                    this.Tail1.f_104204_ = -0.12f * Mth.m_14031_((float)(0.2f * ageInTicks / 2.0f)) + Mth.m_14089_((float)(-1.0f + limbSwing * speed * 0.25f)) * degree * 0.5f * limbSwingAmount;
                    this.Tail2.f_104203_ = -Math.abs(-0.05f * Mth.m_14031_((float)(0.1f * ageInTicks / 2.0f))) + (Mth.m_14089_((float)(limbSwing * speed * 0.3f)) * degree * 0.15f * limbSwingAmount + 0.15f);
                    this.Tail2.f_104204_ = -0.12f * Mth.m_14031_((float)(0.2f * ageInTicks / 2.0f)) + Mth.m_14089_((float)(-1.0f + limbSwing * speed * 0.25f)) * degree * 0.5f * limbSwingAmount;
                    this.Body.f_104203_ = Math.abs(-0.025f * Mth.m_14031_((float)(0.1f * ageInTicks / 3.0f))) + NeckPitch * ((float)Math.PI / 180);
                    this.Neck.f_104204_ = netHeadYaw * ((float)Math.PI / 180);
                    this.Jaw.f_104203_ = Math.abs(-0.025f * Mth.m_14031_((float)(0.1f * ageInTicks / 3.0f))) + attackProgress * (float)Math.toRadians(30.0);
                    this.RightArm.f_104203_ = 0.8652f;
                    this.LeftArm.f_104203_ = 0.8652f;
                    this.Neck.f_104203_ = -(NeckPitch * ((float)Math.PI / 180));
                    this.LeftLeg.f_104203_ = 1.1855f + NeckPitch * ((float)Math.PI / 180);
                    this.RightLeg.f_104203_ = 1.1855f + NeckPitch * ((float)Math.PI / 180);
                }
            }
            this.Body.f_104204_ = Mth.m_14089_((float)(limbSwing * speed * 0.25f)) * degree * 0.25f * limbSwingAmount;
            this.Jaw.f_104203_ = Math.abs(-0.025f * Mth.m_14031_((float)(0.1f * ageInTicks / 3.0f))) + attackProgress * (float)Math.toRadians(30.0);
            this.Neck.f_104203_ = Math.abs(-0.025f * Mth.m_14031_((float)(0.1f * ageInTicks / 3.0f))) + Mth.m_14089_((float)(-1.0f + limbSwing * speed * 0.3f)) * degree * 0.1f * limbSwingAmount + NeckPitch * ((float)Math.PI / 180);
            this.Neck.f_104204_ = netHeadYaw * ((float)Math.PI / 180);
        }
    }

    public void resetModel() {
        this.Body.f_104201_ = 18.0f;
        this.Body.f_104203_ = 0.0f;
        this.Neck.f_104203_ = 0.0f;
        this.Neck.f_104204_ = 0.0f;
        this.LeftArm.f_104201_ = 3.0f;
        this.LeftArm.f_104202_ = -0.5f;
        this.RightArm.f_104201_ = 3.0f;
        this.RightArm.f_104202_ = -0.5f;
        this.RightLeg.f_104201_ = 1.0f;
        this.RightLeg.f_104202_ = 9.5f;
        this.LeftLeg.f_104201_ = 1.0f;
        this.LeftLeg.f_104202_ = 9.5f;
        this.LeftArm.f_104203_ = 0.0f;
        this.LeftArm.f_104204_ = 0.0f;
        this.LeftArm.f_104205_ = 0.0f;
        this.LeftLeg.f_104203_ = 0.0f;
        this.LeftLeg.f_104204_ = 0.0f;
        this.LeftLeg.f_104205_ = 0.0f;
        this.RightArm.f_104203_ = 0.0f;
        this.RightArm.f_104204_ = 0.0f;
        this.RightArm.f_104205_ = 0.0f;
        this.RightLeg.f_104203_ = 0.0f;
        this.RightLeg.f_104204_ = 0.0f;
        this.RightLeg.f_104205_ = 0.0f;
    }

    private void sleepPose() {
        this.Body.f_104201_ = 22.0f;
        this.RightArm.f_104201_ = 1.0f;
        this.LeftArm.f_104201_ = 1.0f;
        this.Tail1.f_104203_ = -0.0572468f;
        this.Tail1.f_104204_ = 0.39095375f;
        this.Tail2.f_104203_ = -0.0572468f;
        this.Tail2.f_104204_ = 0.39095375f;
        this.LeftArm.f_104205_ = 1.0946705f;
        this.Neck.f_104203_ = 0.11728612f;
        this.Neck.f_104204_ = -0.39095375f;
        this.LeftLeg.f_104205_ = 0.938289f;
        this.RightLeg.f_104205_ = -0.938289f;
        this.RightArm.f_104205_ = -1.1728612f;
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.Body.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
    }
}

