/*
 * Decompiled with CFR 0.152.
 */
package superlord.prehistoricfauna.client.model.cretaceous.hellcreek;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import superlord.prehistoricfauna.common.entity.DinosaurEntity;
import superlord.prehistoricfauna.common.entity.cretaceous.hellcreek.Anzu;

public class AnzuBabyModel
extends EntityModel<Anzu> {
    private final ModelPart Root;
    private final ModelPart Body;
    private final ModelPart LeftArm;
    private final ModelPart RightArm;
    private final ModelPart Neck;
    private final ModelPart Head;
    private final ModelPart Tail;
    private final ModelPart LeftThigh;
    private final ModelPart LeftLeg;
    private final ModelPart LeftFoot;
    private final ModelPart RightThigh;
    private final ModelPart RightLeg;
    private final ModelPart RightFoot;

    public AnzuBabyModel(ModelPart root) {
        this.Root = root.m_171324_("Root");
        this.Body = this.Root.m_171324_("Body");
        this.LeftArm = this.Body.m_171324_("LeftArm");
        this.RightArm = this.Body.m_171324_("RightArm");
        this.Neck = this.Body.m_171324_("Neck");
        this.Head = this.Neck.m_171324_("Head");
        this.Tail = this.Body.m_171324_("Tail");
        this.LeftThigh = this.Root.m_171324_("LeftThigh");
        this.LeftLeg = this.LeftThigh.m_171324_("LeftLeg");
        this.LeftFoot = this.LeftLeg.m_171324_("LeftFoot");
        this.RightThigh = this.Root.m_171324_("RightThigh");
        this.RightLeg = this.RightThigh.m_171324_("RightLeg");
        this.RightFoot = this.RightLeg.m_171324_("RightFoot");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition Root = partdefinition.m_171599_("Root", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)16.0f, (float)0.5f));
        PartDefinition Body = Root.m_171599_("Body", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-2.0f, -2.0f, -5.5f, 4.0f, 4.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition LeftArm = Body.m_171599_("LeftArm", CubeListBuilder.m_171558_().m_171514_(8, 22).m_171480_().m_171488_(0.0f, -0.5f, -1.5f, 0.0f, 5.0f, 4.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)-2.1f, (float)0.5f, (float)-4.0f));
        PartDefinition RightArm = Body.m_171599_("RightArm", CubeListBuilder.m_171558_().m_171514_(8, 22).m_171488_(0.0f, -0.5f, -1.5f, 0.0f, 5.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)2.1f, (float)0.5f, (float)-4.0f));
        PartDefinition Neck = Body.m_171599_("Neck", CubeListBuilder.m_171558_().m_171514_(0, 21).m_171488_(-1.0f, -5.9f, -2.0f, 2.0f, 7.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-0.1f, (float)-5.5f));
        PartDefinition Head = Neck.m_171599_("Head", CubeListBuilder.m_171558_().m_171514_(18, 12).m_171488_(-2.0f, -1.0f, -2.0f, 3.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)).m_171514_(24, 4).m_171488_(-1.5f, 0.0f, -3.0f, 2.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(25, 2).m_171488_(-1.0f, -1.0f, -3.0f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.5f, (float)-5.0f, (float)-2.0f));
        PartDefinition Tail = Body.m_171599_("Tail", CubeListBuilder.m_171558_().m_171514_(0, 12).m_171488_(-1.0f, -0.5f, 0.0f, 2.0f, 2.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-1.5f, (float)2.5f));
        PartDefinition LeftThigh = Root.m_171599_("LeftThigh", CubeListBuilder.m_171558_().m_171514_(18, 18).m_171480_().m_171488_(-1.0f, -1.0f, -1.5f, 2.0f, 4.0f, 3.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)-2.0f, (float)0.0f, (float)0.0f));
        PartDefinition LeftLeg = LeftThigh.m_171599_("LeftLeg", CubeListBuilder.m_171558_().m_171514_(14, 21).m_171480_().m_171488_(-0.5f, 0.0f, 0.0f, 1.0f, 5.0f, 0.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)0.0f, (float)3.0f, (float)1.5f));
        PartDefinition LeftFoot = LeftLeg.m_171599_("LeftFoot", CubeListBuilder.m_171558_().m_171514_(23, 7).m_171480_().m_171488_(-0.5f, 0.0f, -2.0f, 2.0f, 0.0f, 2.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)0.0f, (float)5.0f, (float)0.0f));
        PartDefinition RightThigh = Root.m_171599_("RightThigh", CubeListBuilder.m_171558_().m_171514_(18, 18).m_171488_(-1.0f, -1.0f, -1.5f, 2.0f, 4.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)2.0f, (float)0.0f, (float)0.0f));
        PartDefinition RightLeg = RightThigh.m_171599_("RightLeg", CubeListBuilder.m_171558_().m_171514_(14, 21).m_171488_(-0.5f, 0.0f, 0.0f, 1.0f, 5.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)3.0f, (float)1.5f));
        PartDefinition RightFoot = RightLeg.m_171599_("RightFoot", CubeListBuilder.m_171558_().m_171514_(23, 7).m_171488_(-1.5f, 0.0f, -2.0f, 2.0f, 0.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)5.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)32, (int)32);
    }

    public void setupAnim(Anzu entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        float partialTick = ageInTicks - (float)entity.f_19797_;
        float sleepProgress = entity.getSleepProgress(partialTick);
        this.resetModel();
        if (entity.isAsleep()) {
            if (sleepProgress == 0.0f || (Integer)entity.m_20088_().m_135370_(DinosaurEntity.SLEEP_TICK) <= 0) {
                this.setSleepingPose();
            }
        } else if (sleepProgress == 0.0f || (Integer)entity.m_20088_().m_135370_(DinosaurEntity.SLEEP_TICK) <= 0) {
            this.RightThigh.f_104203_ = Mth.m_14031_((float)(0.4f * limbSwing)) * 0.25f * limbSwingAmount;
            this.RightLeg.f_104203_ = Mth.m_14031_((float)(limbSwing * 0.4f)) * 0.65f * limbSwingAmount - 0.25f * limbSwingAmount * 2.0f;
            this.RightFoot.f_104203_ = Mth.m_14031_((float)(limbSwing * 0.4f)) * 0.325f * limbSwingAmount + 0.35f * limbSwingAmount * 2.0f;
            this.LeftThigh.f_104203_ = Mth.m_14031_((float)(0.4f * limbSwing + (float)Math.PI)) * 0.25f * limbSwingAmount;
            this.LeftLeg.f_104203_ = Mth.m_14031_((float)(limbSwing * 0.4f + (float)Math.PI)) * 0.65f * limbSwingAmount - 0.25f * limbSwingAmount * 2.0f;
            this.LeftFoot.f_104203_ = Mth.m_14031_((float)(limbSwing * 0.4f + (float)Math.PI)) * 0.325f * limbSwingAmount + 0.35f * limbSwingAmount * 2.0f;
            this.Neck.f_104204_ = netHeadYaw * ((float)Math.PI / 180);
            this.Tail.f_104203_ = -Math.abs(-0.05f * Mth.m_14031_((float)(0.1f * ageInTicks / 5.0f))) + Mth.m_14031_((float)(limbSwing * 0.6f)) * 0.15f * limbSwingAmount - 0.1f;
            this.RightArm.f_104203_ = Mth.m_14031_((float)(limbSwing * 0.4f)) * 0.1f * limbSwingAmount + 0.1f;
            this.LeftArm.f_104203_ = Mth.m_14031_((float)(limbSwing * 0.4f)) * 0.1f * limbSwingAmount + 0.1f;
            this.LeftArm.f_104205_ = Math.abs(-0.05f * Mth.m_14031_((float)(0.15f * ageInTicks / 3.0f)));
            this.RightArm.f_104205_ = -Math.abs(-0.05f * Mth.m_14031_((float)(0.15f * ageInTicks / 3.0f)));
            this.Neck.f_104203_ = Mth.m_14154_((float)(Mth.m_14031_((float)(limbSwing * 0.2f)) * 0.25f * limbSwingAmount)) + headPitch * ((float)Math.PI / 180) + Math.abs(-0.025f * Mth.m_14031_((float)(0.1f * ageInTicks / 3.0f)));
            if (entity.m_20069_()) {
                this.RightArm.f_104205_ = -1.5f + Math.abs(-1.0f * Mth.m_14031_((float)(0.15f * ageInTicks / 2.0f)));
                this.LeftArm.f_104205_ = 1.5f - Math.abs(-1.0f * Mth.m_14031_((float)(0.15f * ageInTicks / 2.0f)));
                this.LeftThigh.f_104203_ = -0.25f * Mth.m_14031_((float)(0.2f * ageInTicks / 1.5f));
                this.RightThigh.f_104203_ = 0.25f * Mth.m_14031_((float)(0.2f * ageInTicks / 1.5f));
                this.Tail.f_104204_ = Mth.m_14089_((float)(limbSwing * 2.6662f)) * 1.4f * limbSwingAmount;
                this.LeftLeg.f_104203_ = -0.3f * Mth.m_14031_((float)(0.2f * ageInTicks / 1.5f));
                this.RightLeg.f_104203_ = 0.3f * Mth.m_14031_((float)(0.2f * ageInTicks / 1.5f));
                this.Body.f_104201_ = 2.0f;
                this.RightThigh.f_104201_ = 2.0f;
                this.LeftThigh.f_104201_ = 2.0f;
            }
        }
    }

    public void resetModel() {
        this.Body.f_104201_ = 0.0f;
        this.LeftArm.f_104203_ = 0.0f;
        this.LeftArm.f_104204_ = 0.0f;
        this.LeftArm.f_104205_ = 0.0f;
        this.Neck.f_104202_ = -5.5f;
        this.Neck.f_104203_ = 0.0f;
        this.Neck.f_104204_ = 0.0f;
        this.Neck.f_104205_ = 0.0f;
        this.Head.f_104202_ = -2.0f;
        this.Head.f_104203_ = 0.0f;
        this.RightArm.f_104203_ = 0.0f;
        this.RightArm.f_104204_ = 0.0f;
        this.RightArm.f_104205_ = 0.0f;
        this.Tail.f_104201_ = -1.5f;
        this.Tail.f_104202_ = 2.5f;
        this.Tail.f_104203_ = 0.0f;
        this.Tail.f_104204_ = 0.0f;
        this.Tail.f_104205_ = 0.0f;
        this.RightThigh.f_104201_ = 0.0f;
        this.RightThigh.f_104203_ = 0.0f;
        this.RightThigh.f_104204_ = 0.0f;
        this.RightThigh.f_104205_ = 0.0f;
        this.RightLeg.f_104203_ = 0.0f;
        this.RightFoot.f_104201_ = 5.0f;
        this.RightFoot.f_104203_ = 0.0f;
        this.LeftThigh.f_104201_ = -0.0f;
        this.LeftThigh.f_104203_ = 0.0f;
        this.LeftThigh.f_104204_ = 0.0f;
        this.LeftThigh.f_104205_ = 0.0f;
        this.LeftLeg.f_104203_ = 0.0f;
        this.LeftFoot.f_104201_ = 5.0f;
        this.LeftFoot.f_104203_ = 0.0f;
    }

    public void setSleepingPose() {
        this.Body.f_104201_ = 4.6f;
        this.LeftArm.f_104203_ = 1.0337f;
        this.LeftArm.f_104204_ = -0.2446f;
        this.LeftArm.f_104205_ = 0.0358f;
        this.Neck.f_104202_ = -4.9f;
        this.Neck.f_104203_ = 0.1587f;
        this.Neck.f_104204_ = -0.6506f;
        this.Neck.f_104205_ = 0.1293f;
        this.Head.f_104202_ = -2.15f;
        this.Head.f_104203_ = 0.5672f;
        this.RightArm.f_104203_ = 0.914f;
        this.RightArm.f_104204_ = 0.3535f;
        this.RightArm.f_104205_ = -0.2613f;
        this.Tail.f_104203_ = -0.3103f;
        this.Tail.f_104204_ = 0.1494f;
        this.Tail.f_104205_ = 0.0281f;
        this.RightThigh.f_104201_ = 4.9f;
        this.RightThigh.f_104203_ = -0.0452f;
        this.RightThigh.f_104204_ = -0.2615f;
        this.RightThigh.f_104205_ = 0.0117f;
        this.RightLeg.f_104203_ = -1.5272f;
        this.RightFoot.f_104203_ = 1.5581f;
        this.LeftThigh.f_104201_ = 4.9f;
        this.LeftThigh.f_104203_ = -0.0457f;
        this.LeftThigh.f_104204_ = 0.3051f;
        this.LeftThigh.f_104205_ = -0.0138f;
        this.LeftLeg.f_104203_ = -1.5272f;
        this.LeftFoot.f_104203_ = 1.5144f;
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.Root.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
    }
}

