/*
 * Decompiled with CFR 0.152.
 */
package superlord.prehistoricfauna.client.model.cretaceous.hellcreek;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import superlord.prehistoricfauna.common.entity.DinosaurEntity;
import superlord.prehistoricfauna.common.entity.cretaceous.hellcreek.Ankylosaurus;

public class AnkylosaurusModel
extends EntityModel<Ankylosaurus> {
    private final ModelPart Body;
    private final ModelPart Neck;
    private final ModelPart Head1;
    private final ModelPart Tail1;
    private final ModelPart Tail2;
    private final ModelPart TailClub;
    private final ModelPart LeftFrontLeg;
    private final ModelPart RightFrontLeg;
    private final ModelPart RightHindLeg1;
    private final ModelPart RightHindLeg2;
    private final ModelPart RightHindLeg3;
    private final ModelPart LeftHindLeg1;
    private final ModelPart LeftHindLeg2;
    private final ModelPart LeftHindLeg3;

    public AnkylosaurusModel(ModelPart root) {
        this.Body = root.m_171324_("Body");
        this.Neck = this.Body.m_171324_("Neck");
        this.Head1 = this.Neck.m_171324_("Head1");
        this.Tail1 = this.Body.m_171324_("Tail1");
        this.Tail2 = this.Tail1.m_171324_("Tail2");
        this.TailClub = this.Tail2.m_171324_("TailClub");
        this.RightFrontLeg = this.Body.m_171324_("RightFrontLeg");
        this.LeftFrontLeg = this.Body.m_171324_("LeftFrontLeg");
        this.LeftHindLeg1 = this.Body.m_171324_("LeftHindLeg1");
        this.LeftHindLeg2 = this.LeftHindLeg1.m_171324_("LeftHindLeg2");
        this.LeftHindLeg3 = this.LeftHindLeg2.m_171324_("LeftHindLeg3");
        this.RightHindLeg1 = this.Body.m_171324_("RightHindLeg1");
        this.RightHindLeg2 = this.RightHindLeg1.m_171324_("RightHindLeg2");
        this.RightHindLeg3 = this.RightHindLeg2.m_171324_("RightHindLeg3");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition Body = partdefinition.m_171599_("Body", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-15.5f, -9.0f, -34.0f, 31.0f, 22.0f, 52.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)1.0f, (float)12.0f));
        PartDefinition Tail1 = Body.m_171599_("Tail1", CubeListBuilder.m_171558_().m_171514_(0, 79).m_171488_(-6.0f, -3.0f, -4.0f, 12.0f, 13.0f, 21.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-1.0f, (float)18.0f));
        PartDefinition Tail2 = Tail1.m_171599_("Tail2", CubeListBuilder.m_171558_().m_171514_(45, 87).m_171488_(-2.5f, -3.0f, -5.0f, 5.0f, 6.0f, 30.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)3.0f, (float)17.0f));
        PartDefinition TailClub = Tail2.m_171599_("TailClub", CubeListBuilder.m_171558_().m_171514_(94, 85).m_171488_(-5.5f, -4.0f, 0.0f, 11.0f, 8.0f, 17.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)21.0f));
        PartDefinition Neck = Body.m_171599_("Neck", CubeListBuilder.m_171558_().m_171514_(121, 16).m_171488_(-5.0f, -6.0f, -12.0f, 10.0f, 12.0f, 14.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-1.0f, (float)-34.0f));
        PartDefinition Head1 = Neck.m_171599_("Head1", CubeListBuilder.m_171558_().m_171514_(152, 97).m_171488_(-7.0f, -5.0f, -12.0f, 14.0f, 12.0f, 16.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-1.1f, (float)-12.0f));
        PartDefinition Spike1 = Head1.m_171599_("Spike1", CubeListBuilder.m_171558_().m_171514_(0, 33).m_171488_(-1.0f, -3.0f, 0.0f, 5.0f, 5.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-7.0f, (float)-3.0f, (float)0.0f, (float)0.0911f, (float)-0.2731f, (float)0.0f));
        PartDefinition Spike1_1 = Head1.m_171599_("Spike1_1", CubeListBuilder.m_171558_().m_171514_(0, 33).m_171488_(-4.0f, -3.0f, 0.0f, 5.0f, 5.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)7.0f, (float)-3.0f, (float)0.0f, (float)0.0911f, (float)0.2731f, (float)0.0f));
        PartDefinition Spike4 = Head1.m_171599_("Spike4", CubeListBuilder.m_171558_().m_171514_(29, 32).m_171488_(-4.0f, 0.0f, 0.0f, 4.0f, 4.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)7.0f, (float)2.0f, (float)-2.0f, (float)0.0f, (float)0.9105f, (float)0.0f));
        PartDefinition Head2 = Head1.m_171599_("Head2", CubeListBuilder.m_171558_().m_171514_(200, 93).m_171488_(-5.5f, -3.0f, -3.0f, 11.0f, 9.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)-12.0f));
        PartDefinition Spike3 = Head1.m_171599_("Spike3", CubeListBuilder.m_171558_().m_171514_(29, 32).m_171488_(0.0f, 0.0f, 0.0f, 4.0f, 4.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-7.0f, (float)2.0f, (float)-2.0f, (float)0.0f, (float)-0.9105f, (float)0.0f));
        PartDefinition RightHindLeg1 = Body.m_171599_("RightHindLeg1", CubeListBuilder.m_171558_().m_171514_(190, 33).m_171480_().m_171488_(-5.0f, -4.0f, -8.0f, 10.0f, 19.0f, 16.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)13.0f, (float)0.0f, (float)8.0f));
        PartDefinition RightHindLeg2 = RightHindLeg1.m_171599_("RightHindLeg2", CubeListBuilder.m_171558_().m_171514_(200, 0).m_171488_(-3.5f, -3.0f, -2.0f, 7.0f, 14.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)10.0f, (float)3.0f));
        PartDefinition RightHindLeg3 = RightHindLeg2.m_171599_("RightHindLeg3", CubeListBuilder.m_171558_().m_171514_(157, 0).m_171488_(-4.0f, 0.0f, -6.0f, 8.0f, 3.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)10.0f, (float)3.0f));
        PartDefinition RightFrontLeg = Body.m_171599_("RightFrontLeg", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171480_().m_171488_(-3.0f, -3.0f, -4.0f, 7.0f, 20.0f, 8.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)13.0f, (float)6.0f, (float)-26.0f));
        PartDefinition LeftHindLeg1 = Body.m_171599_("LeftHindLeg1", CubeListBuilder.m_171558_().m_171514_(190, 33).m_171488_(-5.0f, -4.0f, -8.0f, 10.0f, 19.0f, 16.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-13.0f, (float)0.0f, (float)8.0f));
        PartDefinition LeftHindLeg2 = LeftHindLeg1.m_171599_("LeftHindLeg2", CubeListBuilder.m_171558_().m_171514_(200, 0).m_171488_(-3.5f, -3.0f, -2.0f, 7.0f, 14.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)10.0f, (float)3.0f));
        PartDefinition LeftHindLeg3 = LeftHindLeg2.m_171599_("LeftHindLeg3", CubeListBuilder.m_171558_().m_171514_(157, 0).m_171488_(-4.0f, 0.0f, -6.0f, 8.0f, 3.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)10.0f, (float)3.0f));
        PartDefinition LeftFrontLeg = Body.m_171599_("LeftFrontLeg", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-4.0f, -3.0f, -4.0f, 7.0f, 20.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-13.0f, (float)6.0f, (float)-26.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)256, (int)128);
    }

    public void setupAnim(Ankylosaurus entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        float speed = 0.9f;
        float degree = 1.0f;
        float partialTick = ageInTicks - (float)entity.f_19797_;
        float attackProgress = entity.getMeleeProgress(partialTick);
        float leftOrRight = entity.getMeleeDirection() ? 1.0f : -1.0f;
        float sleepProgress = entity.getSleepProgress(partialTick);
        this.resetModel();
        if (entity.isAsleep()) {
            if (sleepProgress != 0.0f && (Integer)entity.m_20088_().m_135370_(DinosaurEntity.SLEEP_TICK) > 0) {
                this.Head1.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)0.028274333f);
                this.Head1.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)0.11728612f);
                this.Head1.f_104205_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-0.11746066f);
                this.RightHindLeg3.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)1.5645131f);
                this.LeftHindLeg1.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-0.15707964f);
                this.RightHindLeg1.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)((float)Math.PI / 180));
                this.RightHindLeg1.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)0.15707964f);
                this.Body.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-0.039095376f);
                this.RightFrontLeg.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-0.8208283f);
                this.RightFrontLeg.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-0.39095375f);
                this.RightFrontLeg.f_104205_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-0.31293753f);
                this.Tail2.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)0.032637656f);
                this.Tail2.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-0.11728612f);
                this.RightHindLeg2.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-1.531701f);
                this.RightHindLeg2.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)0.3302163f);
                this.RightHindLeg2.f_104205_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)((float)Math.PI / 180));
                this.LeftHindLeg3.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)1.5247196f);
                this.LeftFrontLeg.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-0.89901906f);
                this.LeftFrontLeg.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)0.31293753f);
                this.LeftFrontLeg.f_104205_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)0.07644542f);
                this.LeftHindLeg2.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-1.5247196f);
                this.LeftHindLeg2.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-0.27384216f);
                this.Neck.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)0.38624135f);
                this.Neck.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)0.11728612f);
                this.Neck.f_104205_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-0.1563815f);
                this.Tail1.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-0.18901916f);
                this.Tail1.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-0.27366763f);
                this.Body.f_104201_ = Mth.m_14179_((float)sleepProgress, (float)1.0f, (float)9.0f);
                this.Head1.f_104201_ = Mth.m_14179_((float)sleepProgress, (float)-1.0f, (float)-1.5f);
                this.RightFrontLeg.f_104200_ = Mth.m_14179_((float)sleepProgress, (float)-14.0f, (float)-16.75f);
                this.LeftFrontLeg.f_104200_ = Mth.m_14179_((float)sleepProgress, (float)14.0f, (float)14.5f);
            } else {
                this.sleepPose();
            }
        } else if (sleepProgress != 0.0f && (Integer)entity.m_20088_().m_135370_(DinosaurEntity.SLEEP_TICK) > 0) {
            this.Head1.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.028274333f, (float)0.0f);
            this.Head1.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)0.11728612f, (float)0.0f);
            this.Head1.f_104205_ = Mth.m_14179_((float)sleepProgress, (float)0.11728612f, (float)0.0f);
            this.RightHindLeg3.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)1.5645131f, (float)0.0f);
            this.LeftHindLeg1.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)-0.15707964f, (float)0.0f);
            this.RightHindLeg1.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)((float)Math.PI / 180), (float)0.0f);
            this.RightHindLeg1.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)0.15707964f, (float)0.0f);
            this.Body.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)-0.039095376f, (float)0.0f);
            this.RightFrontLeg.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)-0.8208283f, (float)0.0f);
            this.RightFrontLeg.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)-0.39095375f, (float)0.0f);
            this.RightFrontLeg.f_104205_ = Mth.m_14179_((float)sleepProgress, (float)-0.31293753f, (float)0.0f);
            this.Tail2.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.032637656f, (float)0.0f);
            this.Tail2.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)-0.11728612f, (float)0.0f);
            this.RightHindLeg2.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)-1.531701f, (float)0.0f);
            this.RightHindLeg2.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)0.3302163f, (float)0.0f);
            this.RightHindLeg2.f_104205_ = Mth.m_14179_((float)sleepProgress, (float)((float)Math.PI / 180), (float)0.0f);
            this.LeftHindLeg3.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)1.5247196f, (float)0.0f);
            this.LeftFrontLeg.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)-0.89901906f, (float)0.0f);
            this.LeftFrontLeg.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)0.31293753f, (float)0.0f);
            this.LeftFrontLeg.f_104205_ = Mth.m_14179_((float)sleepProgress, (float)0.07644542f, (float)0.0f);
            this.LeftHindLeg2.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)-1.5247196f, (float)0.0f);
            this.LeftHindLeg2.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)-0.27384216f, (float)0.0f);
            this.Neck.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.38624135f, (float)0.0f);
            this.Neck.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)0.11728612f, (float)0.0f);
            this.Neck.f_104205_ = Mth.m_14179_((float)sleepProgress, (float)-0.1563815f, (float)0.0f);
            this.Tail1.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)-0.18901916f, (float)0.0f);
            this.Tail1.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)-0.27366763f, (float)0.0f);
            this.Body.f_104201_ = Mth.m_14179_((float)sleepProgress, (float)9.0f, (float)1.0f);
            this.Head1.f_104201_ = Mth.m_14179_((float)sleepProgress, (float)-1.5f, (float)-1.0f);
            this.RightFrontLeg.f_104200_ = Mth.m_14179_((float)sleepProgress, (float)-16.75f, (float)-14.0f);
            this.LeftFrontLeg.f_104200_ = Mth.m_14179_((float)sleepProgress, (float)14.5f, (float)14.0f);
        } else {
            this.LeftFrontLeg.f_104203_ = -Mth.m_14089_((float)(limbSwing * speed * 0.3f)) * degree * 0.8f * limbSwingAmount;
            this.RightFrontLeg.f_104203_ = Mth.m_14089_((float)(limbSwing * speed * 0.3f)) * degree * 0.8f * limbSwingAmount;
            this.RightHindLeg1.f_104203_ = Mth.m_14089_((float)(limbSwing * speed * 0.3f)) * degree * 0.8f * limbSwingAmount;
            this.RightHindLeg2.f_104203_ = Mth.m_14089_((float)(limbSwing * speed * 0.3f)) * degree * 0.8f * limbSwingAmount;
            this.RightHindLeg3.f_104203_ = Mth.m_14089_((float)(limbSwing * speed * 0.3f)) * degree * 0.4f * limbSwingAmount;
            this.LeftHindLeg1.f_104203_ = Mth.m_14089_((float)(limbSwing * speed * 0.3f)) * degree * -0.8f * limbSwingAmount;
            this.LeftHindLeg2.f_104203_ = Mth.m_14089_((float)(limbSwing * speed * 0.3f)) * degree * -0.8f * limbSwingAmount;
            this.LeftHindLeg3.f_104203_ = Mth.m_14089_((float)(limbSwing * speed * 0.3f)) * degree * -0.4f * limbSwingAmount;
            this.Tail1.f_104204_ = -0.12f * Mth.m_14031_((float)(0.2f * ageInTicks / 5.0f)) + Mth.m_14089_((float)(limbSwing * speed * 0.15f)) * degree * 0.35f * limbSwingAmount + attackProgress * leftOrRight * (float)Math.toRadians(-15.0);
            this.Tail2.f_104204_ = -0.12f * Mth.m_14031_((float)(0.2f * ageInTicks / 5.0f)) + Mth.m_14089_((float)(limbSwing * speed * 0.15f)) * degree * 0.35f * limbSwingAmount + attackProgress * leftOrRight * (float)Math.toRadians(-25.0);
            this.Tail1.f_104203_ = -Math.abs(-0.05f * Mth.m_14031_((float)(0.1f * ageInTicks / 5.0f))) + (Mth.m_14089_((float)(limbSwing * speed * 0.3f)) * degree * 0.15f * limbSwingAmount - 0.15f);
            this.Tail2.f_104203_ = -Math.abs(-0.05f * Mth.m_14031_((float)(0.1f * ageInTicks / 5.0f))) + (Mth.m_14089_((float)(limbSwing * speed * 0.3f)) * degree * 0.15f * limbSwingAmount + 0.15f);
            this.Neck.f_104203_ = Math.abs(-0.025f * Mth.m_14031_((float)(0.1f * ageInTicks / 3.0f))) + (Mth.m_14089_((float)(limbSwing * speed * 0.3f)) * degree * 0.1f * limbSwingAmount + 0.15f);
            this.Head1.f_104203_ = -Math.abs(-0.025f * Mth.m_14031_((float)(0.1f * ageInTicks / 3.0f))) + (Mth.m_14089_((float)(-1.0f + limbSwing * speed * 0.3f)) * degree * 0.15f * limbSwingAmount + 0.05f);
            this.Body.f_104204_ = attackProgress * leftOrRight * (float)Math.toRadians(-200.0);
            this.Tail1.f_104205_ = attackProgress * leftOrRight * (float)Math.toRadians(15.0);
            this.Body.f_104202_ = 12.0f + attackProgress * -22.0f;
            if (entity.isEating() || entity.isTuberDigging()) {
                this.Neck.f_104203_ = Math.abs(Mth.m_14031_((float)(0.05f * ageInTicks)) * 0.5f) + 0.25f;
                this.Body.f_104203_ = 0.1f;
                this.LeftHindLeg1.f_104203_ = -0.1f;
                this.RightHindLeg1.f_104203_ = -0.1f;
                this.RightFrontLeg.f_104203_ = -0.1f;
                this.LeftFrontLeg.f_104203_ = -0.1f;
                this.RightFrontLeg.f_104205_ = 0.3f;
                this.LeftFrontLeg.f_104205_ = -0.3f;
            }
        }
    }

    public void resetModel() {
        this.Head1.f_104203_ = 0.31869712f;
        this.Head1.f_104204_ = 0.0f;
        this.Head1.f_104205_ = 0.0f;
        this.TailClub.f_104203_ = 0.0f;
        this.TailClub.f_104204_ = 0.0f;
        this.RightHindLeg3.f_104203_ = 0.0f;
        this.LeftHindLeg1.f_104204_ = 0.0f;
        this.RightHindLeg1.f_104203_ = 0.0f;
        this.RightHindLeg1.f_104204_ = 0.0f;
        this.Body.f_104203_ = 0.0f;
        this.RightFrontLeg.f_104203_ = 0.0f;
        this.RightFrontLeg.f_104204_ = 0.0f;
        this.RightFrontLeg.f_104205_ = 0.0f;
        this.Tail2.f_104203_ = 0.13665928f;
        this.Tail2.f_104204_ = 0.0f;
        this.RightHindLeg2.f_104203_ = 0.0f;
        this.RightHindLeg2.f_104204_ = 0.0f;
        this.RightHindLeg2.f_104205_ = 0.0f;
        this.LeftHindLeg3.f_104203_ = 0.0f;
        this.LeftFrontLeg.f_104203_ = 0.0f;
        this.LeftFrontLeg.f_104204_ = 0.0f;
        this.LeftFrontLeg.f_104205_ = 0.0f;
        this.LeftHindLeg2.f_104203_ = 0.0f;
        this.LeftHindLeg2.f_104204_ = 0.0f;
        this.Neck.f_104203_ = -0.18203785f;
        this.Neck.f_104204_ = 0.0f;
        this.Neck.f_104205_ = 0.0f;
        this.Tail1.f_104203_ = -0.22759093f;
        this.Tail1.f_104204_ = 0.0f;
        this.Body.f_104201_ = 1.0f;
        this.Head1.f_104201_ = -1.0f;
        this.RightFrontLeg.f_104200_ = -14.0f;
        this.LeftFrontLeg.f_104200_ = 14.0f;
        this.Body.f_104203_ = 0.0f;
        this.LeftHindLeg1.f_104203_ = -0.0f;
        this.RightHindLeg1.f_104203_ = -0.0f;
        this.RightFrontLeg.f_104203_ = -0.0f;
        this.LeftFrontLeg.f_104203_ = -0.0f;
        this.RightFrontLeg.f_104205_ = 0.0f;
        this.LeftFrontLeg.f_104205_ = -0.0f;
    }

    public void sleepPose() {
        this.Body.f_104201_ = 9.0f;
        this.Head1.f_104203_ = 0.028274333f;
        this.Head1.f_104204_ = 0.11728612f;
        this.Head1.f_104205_ = -0.11746066f;
        this.RightHindLeg3.f_104203_ = 1.5645131f;
        this.LeftHindLeg1.f_104204_ = -0.15707964f;
        this.RightHindLeg1.f_104203_ = (float)Math.PI / 180;
        this.RightHindLeg1.f_104204_ = 0.15707964f;
        this.Body.f_104203_ = -0.039095376f;
        this.RightFrontLeg.f_104203_ = -0.8208283f;
        this.RightFrontLeg.f_104204_ = -0.39095375f;
        this.RightFrontLeg.f_104205_ = -0.31293753f;
        this.Tail2.f_104203_ = 0.032637656f;
        this.Tail2.f_104204_ = -0.11728612f;
        this.RightHindLeg2.f_104203_ = -1.531701f;
        this.RightHindLeg2.f_104204_ = 0.3302163f;
        this.RightHindLeg2.f_104205_ = (float)Math.PI / 180;
        this.LeftHindLeg3.f_104203_ = 1.5247196f;
        this.LeftFrontLeg.f_104203_ = -0.89901906f;
        this.LeftFrontLeg.f_104204_ = 0.31293753f;
        this.LeftFrontLeg.f_104205_ = 0.07644542f;
        this.LeftHindLeg2.f_104203_ = -1.5247196f;
        this.LeftHindLeg2.f_104204_ = -0.27384216f;
        this.Neck.f_104203_ = 0.38624135f;
        this.Neck.f_104204_ = 0.11728612f;
        this.Neck.f_104205_ = -0.1563815f;
        this.Tail1.f_104203_ = -0.18901916f;
        this.Tail1.f_104204_ = -0.27366763f;
        this.Head1.f_104201_ = -1.5f;
        this.RightFrontLeg.f_104200_ = -16.75f;
        this.LeftFrontLeg.f_104200_ = 14.5f;
        this.RightHindLeg1.f_104203_ = 0.0f;
        this.LeftHindLeg1.f_104203_ = 0.0f;
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.Body.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
    }
}

