/*
 * Decompiled with CFR 0.152.
 */
package superlord.prehistoricfauna.client.model.cretaceous.hellcreek;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import superlord.prehistoricfauna.common.entity.DinosaurEntity;
import superlord.prehistoricfauna.common.entity.cretaceous.hellcreek.Ankylosaurus;

public class AnkylosaurusBabyModel
extends EntityModel<Ankylosaurus> {
    private final ModelPart Torso;
    private final ModelPart Neck;
    private final ModelPart Head;
    private final ModelPart Tail;
    private final ModelPart Tail2;
    private final ModelPart Club;
    private final ModelPart RArm;
    private final ModelPart LArm;
    private final ModelPart RLeg;
    private final ModelPart RFoot;
    private final ModelPart LLeg;
    private final ModelPart LFoot;

    public AnkylosaurusBabyModel(ModelPart root) {
        this.Torso = root.m_171324_("Torso");
        this.Neck = this.Torso.m_171324_("Neck");
        this.Head = this.Neck.m_171324_("Head");
        this.Tail = this.Torso.m_171324_("Tail");
        this.Tail2 = this.Tail.m_171324_("Tail2");
        this.Club = this.Tail2.m_171324_("Club");
        this.RArm = root.m_171324_("RArm");
        this.LArm = root.m_171324_("LArm");
        this.RLeg = root.m_171324_("RLeg");
        this.RFoot = this.RLeg.m_171324_("RFoot");
        this.LLeg = root.m_171324_("LLeg");
        this.LFoot = this.LLeg.m_171324_("LFoot");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition Torso = partdefinition.m_171599_("Torso", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-5.5f, 0.0f, -8.0f, 11.0f, 8.0f, 17.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)12.0f, (float)-1.0f));
        PartDefinition Neck = Torso.m_171599_("Neck", CubeListBuilder.m_171558_().m_171514_(0, 33).m_171488_(-2.5f, -1.0f, -5.0f, 5.0f, 4.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)2.0f, (float)-8.0f, (float)0.0698f, (float)0.0f, (float)0.0f));
        PartDefinition Head = Neck.m_171599_("Head", CubeListBuilder.m_171558_().m_171514_(39, 0).m_171488_(-2.5f, -1.0f, -5.0f, 5.0f, 4.0f, 7.0f, new CubeDeformation(0.01f, 0.0f, 0.0f)), PartPose.m_171419_((float)0.0f, (float)-1.0f, (float)-3.0f));
        PartDefinition RHorn = Head.m_171599_("RHorn", CubeListBuilder.m_171558_().m_171514_(30, 25).m_171488_(-1.0f, -2.0f, 0.0f, 2.0f, 2.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)2.5f, (float)0.0f, (float)-1.0f));
        PartDefinition LHorn = Head.m_171599_("LHorn", CubeListBuilder.m_171558_().m_171514_(30, 25).m_171488_(-1.0f, -2.0f, 0.0f, 2.0f, 2.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-2.5f, (float)0.0f, (float)-1.0f));
        PartDefinition LHornBottom = Head.m_171599_("LHornBottom", CubeListBuilder.m_171558_().m_171514_(47, 11).m_171488_(-0.5f, -0.5f, 0.0f, 1.0f, 1.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-3.0f, (float)1.5f, (float)-1.0f));
        PartDefinition RHornBottom = Head.m_171599_("RHornBottom", CubeListBuilder.m_171558_().m_171514_(47, 11).m_171488_(-0.5f, -0.5f, 0.0f, 1.0f, 1.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)3.0f, (float)1.5f, (float)-1.0f));
        PartDefinition Beak = Head.m_171599_("Beak", CubeListBuilder.m_171558_().m_171514_(39, 11).m_171488_(-1.5f, 0.0f, -1.0f, 3.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)-5.0f));
        PartDefinition Tail = Torso.m_171599_("Tail", CubeListBuilder.m_171558_().m_171514_(38, 25).m_171488_(-2.5f, -1.5f, -1.0f, 5.0f, 4.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)2.5f, (float)9.0f, (float)-0.0349f, (float)0.0f, (float)0.0f));
        PartDefinition Tail2 = Tail.m_171599_("Tail2", CubeListBuilder.m_171558_().m_171514_(16, 25).m_171488_(-1.5f, -1.5f, -1.0f, 3.0f, 3.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)1.0f, (float)6.0f));
        PartDefinition Club = Tail2.m_171599_("Club", CubeListBuilder.m_171558_().m_171514_(0, 25).m_171488_(-2.5f, -1.5f, 0.0f, 5.0f, 3.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)7.0f));
        PartDefinition RArm = partdefinition.m_171599_("RArm", CubeListBuilder.m_171558_().m_171514_(22, 36).m_171480_().m_171488_(-1.5f, 0.0f, -1.5f, 3.0f, 6.0f, 3.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)5.0f, (float)18.0f, (float)-6.5f));
        PartDefinition LArm = partdefinition.m_171599_("LArm", CubeListBuilder.m_171558_().m_171514_(22, 36).m_171488_(-1.5f, 0.0f, -1.5f, 3.0f, 6.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-5.0f, (float)18.0f, (float)-6.5f));
        PartDefinition RLeg = partdefinition.m_171599_("RLeg", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171480_().m_171488_(-1.5f, 0.0f, -1.5f, 3.0f, 7.0f, 5.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)5.0f, (float)14.0f, (float)3.5f));
        PartDefinition RFoot = RLeg.m_171599_("RFoot", CubeListBuilder.m_171558_().m_171514_(37, 37).m_171488_(-1.5f, 0.0f, -3.0f, 3.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)7.0f, (float)3.5f));
        PartDefinition LLeg = partdefinition.m_171599_("LLeg", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-1.5f, 0.0f, -2.0f, 3.0f, 7.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-5.0f, (float)14.0f, (float)4.0f));
        PartDefinition LFoot = LLeg.m_171599_("LFoot", CubeListBuilder.m_171558_().m_171514_(37, 37).m_171488_(-1.5f, 0.0f, -3.0f, 3.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)7.0f, (float)3.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)63, (int)45);
    }

    public void setupAnim(Ankylosaurus entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        float speed = 0.9f;
        float degree = 1.0f;
        float partialTick = ageInTicks - (float)entity.f_19797_;
        float attackProgress = entity.getMeleeProgress(partialTick);
        float leftOrRight = entity.getMeleeDirection() ? 1.0f : -1.0f;
        float sleepProgress = entity.getSleepProgress(partialTick);
        this.resetModel();
        if (entity.isAsleep()) {
            if (sleepProgress != 0.0f && (Integer)entity.m_20088_().m_135370_(DinosaurEntity.SLEEP_TICK) > 0) {
                this.Torso.f_104201_ = Mth.m_14179_((float)sleepProgress, (float)12.0f, (float)15.0f);
                this.RArm.f_104201_ = Mth.m_14179_((float)sleepProgress, (float)18.0f, (float)20.0f);
                this.LArm.f_104201_ = Mth.m_14179_((float)sleepProgress, (float)18.0f, (float)20.0f);
                this.LLeg.f_104201_ = Mth.m_14179_((float)sleepProgress, (float)14.0f, (float)17.0f);
                this.RLeg.f_104201_ = Mth.m_14179_((float)sleepProgress, (float)14.0f, (float)17.0f);
                this.Head.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)0.028274333f);
                this.Head.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)0.11728612f);
                this.Head.f_104205_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-0.11746066f);
                this.LLeg.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-0.15707964f);
                this.RLeg.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)((float)Math.PI / 180));
                this.RLeg.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)0.15707964f);
                this.Torso.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-0.039095376f);
                this.RArm.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-0.8208283f);
                this.RArm.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-0.39095375f);
                this.RArm.f_104205_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-0.31293753f);
                this.Tail2.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)0.032637656f);
                this.Tail2.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-0.11728612f);
                this.RFoot.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-1.531701f);
                this.RFoot.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)0.3302163f);
                this.RFoot.f_104205_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)((float)Math.PI / 180));
                this.LArm.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-0.89901906f);
                this.LArm.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)0.31293753f);
                this.LArm.f_104205_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)0.07644542f);
                this.LFoot.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-1.5247196f);
                this.LFoot.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-0.27384216f);
                this.Neck.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)0.38624135f);
                this.Neck.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)0.11728612f);
                this.Neck.f_104205_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-0.1563815f);
                this.Tail.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-0.18901916f);
                this.Tail.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-0.27366763f);
                this.Head.f_104201_ = Mth.m_14179_((float)sleepProgress, (float)-1.0f, (float)-1.5f);
            } else {
                this.sleepPose();
            }
        } else if (sleepProgress != 0.0f && (Integer)entity.m_20088_().m_135370_(DinosaurEntity.SLEEP_TICK) > 0) {
            this.Torso.f_104201_ = Mth.m_14179_((float)sleepProgress, (float)15.0f, (float)12.0f);
            this.RArm.f_104201_ = Mth.m_14179_((float)sleepProgress, (float)20.0f, (float)18.0f);
            this.LArm.f_104201_ = Mth.m_14179_((float)sleepProgress, (float)20.0f, (float)18.0f);
            this.LLeg.f_104201_ = Mth.m_14179_((float)sleepProgress, (float)17.0f, (float)14.0f);
            this.RLeg.f_104201_ = Mth.m_14179_((float)sleepProgress, (float)17.0f, (float)14.0f);
            this.Head.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.028274333f, (float)0.0f);
            this.Head.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)0.11728612f, (float)0.0f);
            this.Head.f_104205_ = Mth.m_14179_((float)sleepProgress, (float)-0.11746066f, (float)0.0f);
            this.LLeg.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)-0.15707964f, (float)0.0f);
            this.RLeg.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)((float)Math.PI / 180), (float)0.0f);
            this.RLeg.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)0.15707964f, (float)0.0f);
            this.Torso.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)-0.039095376f, (float)0.0f);
            this.RArm.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)-0.39095375f, (float)0.0f);
            this.RArm.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)-0.39095375f, (float)0.0f);
            this.RArm.f_104205_ = Mth.m_14179_((float)sleepProgress, (float)-0.31293753f, (float)0.0f);
            this.Tail2.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.032637656f, (float)0.0f);
            this.Tail2.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)-0.11728612f, (float)0.0f);
            this.RFoot.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)-1.531701f, (float)0.0f);
            this.RFoot.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)0.3302163f, (float)0.0f);
            this.RFoot.f_104205_ = Mth.m_14179_((float)sleepProgress, (float)((float)Math.PI / 180), (float)0.0f);
            this.LArm.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)-0.89901906f, (float)0.0f);
            this.LArm.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)0.31293753f, (float)0.0f);
            this.LArm.f_104205_ = Mth.m_14179_((float)sleepProgress, (float)0.07644542f, (float)0.0f);
            this.LFoot.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)-1.5247196f, (float)0.0f);
            this.LFoot.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)-0.27384216f, (float)0.0f);
            this.Neck.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.38624135f, (float)0.0f);
            this.Neck.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)0.11728612f, (float)0.0f);
            this.Neck.f_104205_ = Mth.m_14179_((float)sleepProgress, (float)-0.1563815f, (float)0.0f);
            this.Tail.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)-0.18901916f, (float)0.0f);
            this.Tail.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)-0.27366763f, (float)0.0f);
            this.Head.f_104201_ = Mth.m_14179_((float)sleepProgress, (float)-1.5f, (float)-1.0f);
        } else {
            this.Torso.f_104203_ = 0.0f;
            this.RLeg.f_104203_ = -0.0f;
            this.RArm.f_104203_ = -0.0f;
            this.LArm.f_104203_ = -0.0f;
            this.RArm.f_104205_ = 0.0f;
            this.LArm.f_104205_ = -0.0f;
            this.LArm.f_104203_ = -Mth.m_14089_((float)(limbSwing * speed * 0.3f)) * degree * 0.8f * limbSwingAmount;
            this.RArm.f_104203_ = Mth.m_14089_((float)(limbSwing * speed * 0.3f)) * degree * 0.8f * limbSwingAmount;
            this.RLeg.f_104203_ = Mth.m_14089_((float)(limbSwing * speed * 0.3f)) * degree * 0.8f * limbSwingAmount;
            this.RFoot.f_104203_ = Mth.m_14089_((float)(limbSwing * speed * 0.3f)) * degree * 0.8f * limbSwingAmount;
            this.LLeg.f_104203_ = Mth.m_14089_((float)(limbSwing * speed * 0.3f)) * degree * -0.8f * limbSwingAmount;
            this.LFoot.f_104203_ = Mth.m_14089_((float)(limbSwing * speed * 0.3f)) * degree * -0.8f * limbSwingAmount;
            this.Tail.f_104204_ = -0.12f * Mth.m_14031_((float)(0.2f * ageInTicks / 5.0f)) + Mth.m_14089_((float)(limbSwing * speed * 0.15f)) * degree * 0.35f * limbSwingAmount + attackProgress * leftOrRight * (float)Math.toRadians(-15.0);
            this.Tail2.f_104204_ = -0.12f * Mth.m_14031_((float)(0.2f * ageInTicks / 5.0f)) + Mth.m_14089_((float)(limbSwing * speed * 0.15f)) * degree * 0.35f * limbSwingAmount + attackProgress * leftOrRight * (float)Math.toRadians(-25.0);
            this.Tail.f_104203_ = -Math.abs(-0.05f * Mth.m_14031_((float)(0.1f * ageInTicks / 5.0f))) + (Mth.m_14089_((float)(limbSwing * speed * 0.3f)) * degree * 0.15f * limbSwingAmount - 0.15f);
            this.Tail2.f_104203_ = -Math.abs(-0.05f * Mth.m_14031_((float)(0.1f * ageInTicks / 5.0f))) + (Mth.m_14089_((float)(limbSwing * speed * 0.3f)) * degree * 0.15f * limbSwingAmount + 0.15f);
            this.Neck.f_104203_ = Math.abs(-0.025f * Mth.m_14031_((float)(0.1f * ageInTicks / 3.0f))) + (Mth.m_14089_((float)(limbSwing * speed * 0.3f)) * degree * 0.1f * limbSwingAmount + 0.15f);
            this.Head.f_104203_ = -Math.abs(-0.025f * Mth.m_14031_((float)(0.1f * ageInTicks / 3.0f))) + (Mth.m_14089_((float)(-1.0f + limbSwing * speed * 0.3f)) * degree * 0.15f * limbSwingAmount + 0.05f);
            this.Torso.f_104204_ = attackProgress * leftOrRight * (float)Math.toRadians(-200.0);
            this.Tail.f_104205_ = attackProgress * leftOrRight * (float)Math.toRadians(15.0);
            this.Torso.f_104202_ = -1.0f + attackProgress * -22.0f;
            if (entity.isEating() || entity.isTuberDigging()) {
                this.Neck.f_104203_ = Math.abs(Mth.m_14031_((float)(0.05f * ageInTicks)) * 0.5f) + 0.25f;
                this.Torso.f_104203_ = 0.1f;
                this.LLeg.f_104203_ = -0.1f;
                this.RLeg.f_104203_ = -0.1f;
                this.RArm.f_104203_ = -0.1f;
                this.LArm.f_104203_ = -0.1f;
                this.RArm.f_104205_ = 0.3f;
                this.LArm.f_104205_ = -0.3f;
            }
        }
    }

    public void resetModel() {
        this.Head.f_104203_ = 0.31869712f;
        this.Head.f_104204_ = 0.0f;
        this.Head.f_104205_ = 0.0f;
        this.Club.f_104203_ = 0.0f;
        this.Club.f_104204_ = 0.0f;
        this.LLeg.f_104204_ = 0.0f;
        this.RLeg.f_104203_ = 0.0f;
        this.RLeg.f_104204_ = 0.0f;
        this.Torso.f_104203_ = 0.0f;
        this.RArm.f_104203_ = 0.0f;
        this.RArm.f_104204_ = 0.0f;
        this.RArm.f_104205_ = 0.0f;
        this.Tail2.f_104203_ = 0.13665928f;
        this.Tail2.f_104204_ = 0.0f;
        this.RFoot.f_104203_ = 0.0f;
        this.RFoot.f_104204_ = 0.0f;
        this.RFoot.f_104205_ = 0.0f;
        this.LArm.f_104203_ = 0.0f;
        this.LArm.f_104204_ = 0.0f;
        this.LArm.f_104205_ = 0.0f;
        this.LFoot.f_104203_ = 0.0f;
        this.LFoot.f_104204_ = 0.0f;
        this.Neck.f_104203_ = -0.18203785f;
        this.Neck.f_104204_ = 0.0f;
        this.Neck.f_104205_ = 0.0f;
        this.Tail.f_104203_ = -0.22759093f;
        this.Tail.f_104204_ = 0.0f;
        this.Torso.f_104201_ = 12.0f;
        this.Head.f_104201_ = -1.0f;
        this.RArm.f_104201_ = 18.0f;
        this.LArm.f_104201_ = 18.0f;
        this.LLeg.f_104201_ = 14.0f;
        this.RLeg.f_104201_ = 14.0f;
    }

    public void sleepPose() {
        this.Torso.f_104201_ = 15.0f;
        this.RArm.f_104201_ = 20.0f;
        this.LArm.f_104201_ = 20.0f;
        this.LLeg.f_104201_ = 17.0f;
        this.RLeg.f_104201_ = 17.0f;
        this.Head.f_104203_ = 0.028274333f;
        this.Head.f_104204_ = 0.11728612f;
        this.Head.f_104205_ = -0.11746066f;
        this.LLeg.f_104204_ = -0.15707964f;
        this.RLeg.f_104203_ = (float)Math.PI / 180;
        this.RLeg.f_104204_ = 0.15707964f;
        this.Torso.f_104203_ = -0.039095376f;
        this.RArm.f_104203_ = -0.8208283f;
        this.RArm.f_104204_ = -0.39095375f;
        this.RArm.f_104205_ = -0.31293753f;
        this.Tail2.f_104203_ = 0.032637656f;
        this.Tail2.f_104204_ = -0.11728612f;
        this.RFoot.f_104203_ = -1.531701f;
        this.RFoot.f_104204_ = 0.3302163f;
        this.RFoot.f_104205_ = (float)Math.PI / 180;
        this.LArm.f_104203_ = -0.89901906f;
        this.LArm.f_104204_ = 0.31293753f;
        this.LArm.f_104205_ = 0.07644542f;
        this.LFoot.f_104203_ = -1.5247196f;
        this.LFoot.f_104204_ = -0.27384216f;
        this.Neck.f_104203_ = 0.38624135f;
        this.Neck.f_104204_ = 0.11728612f;
        this.Neck.f_104205_ = -0.1563815f;
        this.Tail.f_104203_ = -0.18901916f;
        this.Tail.f_104204_ = -0.27366763f;
        this.Head.f_104201_ = -1.5f;
        this.RLeg.f_104203_ = 0.0f;
        this.LLeg.f_104203_ = 0.0f;
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.Torso.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.RArm.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.LArm.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.RLeg.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.LLeg.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
    }
}

