/*
 * Decompiled with CFR 0.152.
 */
package superlord.prehistoricfauna.client.model.cretaceous.djadochta;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import superlord.prehistoricfauna.common.entity.DinosaurEntity;
import superlord.prehistoricfauna.common.entity.cretaceous.djadochta.Velociraptor;

public class VelociraptorModel
extends EntityModel<Velociraptor> {
    private final ModelPart ThighLeft;
    private final ModelPart LegLeft;
    private final ModelPart FootLeft;
    private final ModelPart ThighRight;
    private final ModelPart LegRight;
    private final ModelPart FootRight;
    private final ModelPart Body;
    private final ModelPart WingLeft;
    private final ModelPart WingRight;
    private final ModelPart Tail;
    private final ModelPart Neck;
    private final ModelPart Head;

    public VelociraptorModel(ModelPart root) {
        this.ThighLeft = root.m_171324_("ThighLeft");
        this.LegLeft = this.ThighLeft.m_171324_("LegLeft");
        this.FootLeft = this.LegLeft.m_171324_("FootLeft");
        this.ThighRight = root.m_171324_("ThighRight");
        this.LegRight = this.ThighRight.m_171324_("LegRight");
        this.FootRight = this.LegRight.m_171324_("FootRight");
        this.Body = root.m_171324_("Body");
        this.WingLeft = this.Body.m_171324_("WingLeft");
        this.WingRight = this.Body.m_171324_("WingRight");
        this.Tail = this.Body.m_171324_("Tail");
        this.Neck = this.Body.m_171324_("Neck");
        this.Head = this.Neck.m_171324_("Head");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition ThighLeft = partdefinition.m_171599_("ThighLeft", CubeListBuilder.m_171558_().m_171514_(46, 0).m_171480_().m_171488_(-2.0f, -1.0f, -1.0f, 2.0f, 5.0f, 3.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)-0.5f, (float)15.75f, (float)2.0f));
        PartDefinition LegLeft = ThighLeft.m_171599_("LegLeft", CubeListBuilder.m_171558_().m_171514_(55, 11).m_171488_(-0.5f, 0.0f, 0.0f, 1.0f, 4.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-1.0f, (float)4.0f, (float)2.0f));
        PartDefinition FootLeft = LegLeft.m_171599_("FootLeft", CubeListBuilder.m_171558_().m_171514_(46, 10).m_171480_().m_171488_(-1.5f, -2.0f, -3.0f, 2.0f, 2.0f, 3.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)0.0f, (float)4.0f, (float)0.0f));
        PartDefinition ThighRight = partdefinition.m_171599_("ThighRight", CubeListBuilder.m_171558_().m_171514_(46, 0).m_171488_(0.0f, -1.0f, -1.0f, 2.0f, 5.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.5f, (float)15.75f, (float)2.0f));
        PartDefinition LegRight = ThighRight.m_171599_("LegRight", CubeListBuilder.m_171558_().m_171514_(55, 11).m_171480_().m_171488_(-0.5f, 0.0f, 0.0f, 1.0f, 4.0f, 0.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)1.0f, (float)4.0f, (float)2.0f));
        PartDefinition FootRight = LegRight.m_171599_("FootRight", CubeListBuilder.m_171558_().m_171514_(46, 10).m_171488_(-0.5f, -2.0f, -3.0f, 2.0f, 2.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)4.0f, (float)0.0f));
        PartDefinition Body = partdefinition.m_171599_("Body", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-1.5f, -2.0f, -5.0f, 3.0f, 5.0f, 10.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)15.75f, (float)0.0f));
        PartDefinition Neck = Body.m_171599_("Neck", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-1.0f, -6.0f, -3.0f, 2.0f, 7.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)-4.5f, (float)0.1f, (float)0.0f, (float)0.0f));
        PartDefinition Head = Neck.m_171599_("Head", CubeListBuilder.m_171558_().m_171514_(16, 0).m_171488_(-1.5f, -2.0f, -3.0f, 3.0f, 3.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-0.1f, (float)-4.3f, (float)-2.0f));
        PartDefinition Mouth = Head.m_171599_("Mouth", CubeListBuilder.m_171558_().m_171514_(31, 1).m_171488_(-1.0f, -1.0f, -3.0f, 2.0f, 2.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)-3.0f));
        PartDefinition Tail = Body.m_171599_("Tail", CubeListBuilder.m_171558_().m_171514_(23, 7).m_171488_(-1.0f, -1.0f, -1.0f, 2.0f, 2.0f, 15.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-0.5f, (float)5.0f));
        PartDefinition TailFan = Tail.m_171599_("TailFan", CubeListBuilder.m_171558_().m_171514_(0, 15).m_171488_(-2.0f, 0.0f, 0.0f, 4.0f, 2.0f, 13.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)3.0f));
        PartDefinition WingLeft = Body.m_171599_("WingLeft", CubeListBuilder.m_171558_().m_171514_(0, 15).m_171480_().m_171488_(-1.0f, -1.0f, -1.0f, 1.0f, 5.0f, 4.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)-1.5f, (float)1.0f, (float)-3.0f));
        PartDefinition WingRight = Body.m_171599_("WingRight", CubeListBuilder.m_171558_().m_171514_(0, 15).m_171488_(0.0f, -1.0f, -1.0f, 1.0f, 5.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)1.5f, (float)1.0f, (float)-3.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void setupAnim(Velociraptor entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        float partialTick = ageInTicks - (float)entity.f_19797_;
        float attackProgress = entity.getMeleeProgress(partialTick);
        float speed = 1.0f;
        float degree = 1.0f;
        float sleepProgress = entity.getSleepProgress(partialTick);
        float sitProgress = entity.getSitProgress(partialTick);
        this.resetModel();
        if (entity.isAsleep()) {
            if (sleepProgress != 0.0f && (Integer)entity.m_20088_().m_135370_(DinosaurEntity.SLEEP_TICK) > 0) {
                this.Body.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-0.17463292f);
                this.LegLeft.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-0.87266463f);
                this.ThighLeft.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-0.6981316f);
                this.ThighLeft.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)0.2443461f);
                this.Tail.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-0.13962634f);
                this.Tail.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)1.0471976f);
                this.Neck.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-2.268928f);
                this.Neck.f_104205_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)0.83774805f);
                this.ThighRight.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-0.6981317f);
                this.ThighRight.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-0.2443461f);
                this.LegRight.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-0.87266463f);
                this.FootRight.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)1.5707964f);
                this.FootRight.f_104205_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-0.2443461f);
                this.FootLeft.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)1.5707964f);
                this.FootLeft.f_104205_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)0.24609143f);
                this.Body.f_104201_ = Mth.m_14179_((float)sleepProgress, (float)15.75f, (float)19.5f);
                this.ThighLeft.f_104201_ = Mth.m_14179_((float)sleepProgress, (float)15.75f, (float)19.5f);
                this.ThighRight.f_104201_ = Mth.m_14179_((float)sleepProgress, (float)15.75f, (float)19.5f);
            } else {
                this.sleepPose();
            }
        } else if (entity.isSitting() || entity.isTameSitting()) {
            if (sitProgress != 0.0f && (Integer)entity.m_20088_().m_135370_(Velociraptor.SIT_TICK) > 0) {
                this.Body.f_104201_ = Mth.m_14179_((float)sitProgress, (float)15.75f, (float)19.5f);
                this.ThighLeft.f_104201_ = Mth.m_14179_((float)sitProgress, (float)15.75f, (float)19.5f);
                this.ThighRight.f_104201_ = Mth.m_14179_((float)sitProgress, (float)15.75f, (float)19.5f);
                this.ThighRight.f_104203_ = Mth.m_14179_((float)sitProgress, (float)0.0f, (float)-0.6981317f);
                this.ThighLeft.f_104203_ = Mth.m_14179_((float)sitProgress, (float)0.0f, (float)-0.6981317f);
                this.WingLeft.f_104203_ = Mth.m_14179_((float)sitProgress, (float)0.0f, (float)0.43633232f);
                this.WingLeft.f_104205_ = Mth.m_14179_((float)sitProgress, (float)0.0f, (float)-1.0471976f);
                this.Tail.f_104203_ = Mth.m_14179_((float)sitProgress, (float)0.0f, (float)-0.17453292f);
            } else {
                this.sittingPose();
            }
            this.Body.f_104203_ = Math.abs(-0.025f * Mth.m_14031_((float)(0.1f * ageInTicks / 3.0f)));
            this.Head.f_104203_ = headPitch * ((float)Math.PI / 180) + Math.abs(-0.025f * Mth.m_14031_((float)(0.1f * ageInTicks / 3.0f)));
            this.WingLeft.f_104205_ = Math.abs(-0.05f * Mth.m_14031_((float)(0.15f * ageInTicks / 3.0f)));
            this.WingRight.f_104205_ = -Math.abs(-0.05f * Mth.m_14031_((float)(0.15f * ageInTicks / 3.0f)));
        } else if (sleepProgress != 0.0f && (Integer)entity.m_20088_().m_135370_(DinosaurEntity.SLEEP_TICK) > 0) {
            this.Body.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)-0.17463292f, (float)0.0f);
            this.LegLeft.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)-0.87266463f, (float)0.0f);
            this.ThighLeft.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)-0.6981316f, (float)0.0f);
            this.ThighLeft.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)0.2443461f, (float)0.0f);
            this.Tail.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)-0.13962634f, (float)0.0f);
            this.Tail.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)1.0471976f, (float)0.0f);
            this.Neck.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)-2.268928f, (float)0.0f);
            this.Neck.f_104205_ = Mth.m_14179_((float)sleepProgress, (float)0.83774805f, (float)0.0f);
            this.ThighRight.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)-0.6981317f, (float)0.0f);
            this.ThighRight.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)-0.2443461f, (float)0.0f);
            this.LegRight.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)-0.87266463f, (float)0.0f);
            this.FootRight.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)1.5707964f, (float)0.0f);
            this.FootRight.f_104205_ = Mth.m_14179_((float)sleepProgress, (float)-0.2443461f, (float)0.0f);
            this.FootLeft.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)1.5707964f, (float)0.0f);
            this.FootLeft.f_104205_ = Mth.m_14179_((float)sleepProgress, (float)0.24609143f, (float)0.0f);
            this.Body.f_104201_ = Mth.m_14179_((float)sleepProgress, (float)19.5f, (float)15.75f);
            this.ThighLeft.f_104201_ = Mth.m_14179_((float)sleepProgress, (float)19.5f, (float)15.75f);
            this.ThighRight.f_104201_ = Mth.m_14179_((float)sleepProgress, (float)19.5f, (float)15.75f);
        } else if (sitProgress != 0.0f && (Integer)entity.m_20088_().m_135370_(Velociraptor.SIT_TICK) > 0) {
            this.Body.f_104201_ = Mth.m_14179_((float)sitProgress, (float)19.5f, (float)15.75f);
            this.ThighLeft.f_104201_ = Mth.m_14179_((float)sitProgress, (float)19.5f, (float)15.75f);
            this.ThighRight.f_104201_ = Mth.m_14179_((float)sitProgress, (float)19.5f, (float)15.75f);
            this.ThighRight.f_104203_ = Mth.m_14179_((float)sitProgress, (float)-0.6981317f, (float)0.0f);
            this.ThighLeft.f_104203_ = Mth.m_14179_((float)sitProgress, (float)-0.6981317f, (float)0.0f);
            this.WingLeft.f_104203_ = Mth.m_14179_((float)sitProgress, (float)0.43633232f, (float)0.0f);
            this.WingLeft.f_104205_ = Mth.m_14179_((float)sitProgress, (float)-1.0471976f, (float)0.0f);
            this.Tail.f_104203_ = Mth.m_14179_((float)sitProgress, (float)-0.17453292f, (float)0.0f);
        } else {
            this.Head.f_104204_ = netHeadYaw * ((float)Math.PI / 180);
            this.ThighLeft.f_104203_ = Mth.m_14089_((float)(limbSwing * speed * 0.4f)) * degree * 1.0f * limbSwingAmount + attackProgress * (float)Math.toRadians(-65.0);
            this.ThighRight.f_104203_ = Mth.m_14089_((float)(3.0f + limbSwing * speed * 0.4f)) * degree * 1.0f * limbSwingAmount + attackProgress * (float)Math.toRadians(-65.0);
            this.Tail.f_104204_ = -0.12f * Mth.m_14031_((float)(0.2f * ageInTicks / 5.0f));
            this.Tail.f_104203_ = -Math.abs(-0.05f * Mth.m_14031_((float)(0.1f * ageInTicks / 5.0f)));
            this.Neck.f_104203_ = Math.abs(-0.025f * Mth.m_14031_((float)(0.1f * ageInTicks / 3.0f))) + (Mth.m_14089_((float)(limbSwing * speed * 0.1f)) * (degree / 2.0f) * 0.3f * limbSwingAmount + 0.1f) + headPitch * ((float)Math.PI / 180) + attackProgress * (float)Math.toRadians(25.0);
            this.Body.f_104203_ = Math.abs(-0.025f * Mth.m_14031_((float)(0.1f * ageInTicks / 3.0f))) + Mth.m_14089_((float)(limbSwing * speed * 0.1f)) * (degree / 2.0f) * 0.2f * limbSwingAmount + attackProgress * (float)Math.toRadians(-30.0);
            this.Head.f_104203_ = headPitch * ((float)Math.PI / 180) + Math.abs(-0.025f * Mth.m_14031_((float)(0.1f * ageInTicks / 3.0f)));
            this.WingLeft.f_104205_ = Math.abs(-0.05f * Mth.m_14031_((float)(0.15f * ageInTicks / 3.0f))) + Mth.m_14089_((float)(limbSwing * speed * 0.4f)) * degree * 0.1f * limbSwingAmount + attackProgress * (float)Math.toRadians(-85.0);
            this.WingRight.f_104205_ = -Math.abs(-0.05f * Mth.m_14031_((float)(0.15f * ageInTicks / 3.0f))) + Mth.m_14089_((float)(3.0f + limbSwing * speed * 0.4f)) * degree * 0.1f * limbSwingAmount + attackProgress * (float)Math.toRadians(85.0);
        }
        if (entity.m_20069_()) {
            this.Body.f_104201_ = 18.0f;
            this.ThighLeft.f_104201_ = 17.0f;
            this.ThighRight.f_104201_ = 17.0f;
            this.Body.f_104203_ = -0.25f;
            this.Tail.f_104203_ = 0.25f;
            this.Neck.f_104203_ = 0.25f;
            this.WingRight.f_104205_ = -1.5f + Math.abs(-1.0f * Mth.m_14031_((float)(0.15f * ageInTicks / 2.0f)));
            this.WingLeft.f_104205_ = 1.5f - Math.abs(-1.0f * Mth.m_14031_((float)(0.15f * ageInTicks / 2.0f)));
            this.ThighLeft.f_104203_ = -0.25f * Mth.m_14031_((float)(0.2f * ageInTicks / 1.5f));
            this.ThighRight.f_104203_ = 0.25f * Mth.m_14031_((float)(0.2f * ageInTicks / 1.5f));
            this.Tail.f_104204_ = Mth.m_14089_((float)(limbSwing * 2.6662f)) * 1.4f * limbSwingAmount;
            this.LegLeft.f_104203_ = -0.3f * Mth.m_14031_((float)(0.2f * ageInTicks / 1.5f));
            this.LegRight.f_104203_ = 0.3f * Mth.m_14031_((float)(0.2f * ageInTicks / 1.5f));
        }
    }

    public void resetModel() {
        this.Body.f_104201_ = 15.75f;
        this.ThighLeft.f_104201_ = 15.75f;
        this.ThighRight.f_104201_ = 15.75f;
        this.Body.f_104203_ = 0.0f;
        this.LegLeft.f_104203_ = 0.0f;
        this.WingLeft.f_104205_ = 0.0f;
        this.WingRight.f_104205_ = 0.0f;
        this.WingLeft.f_104203_ = 0.0f;
        this.WingRight.f_104203_ = 0.0f;
        this.WingLeft.f_104204_ = 0.0f;
        this.WingRight.f_104204_ = 0.0f;
        this.ThighLeft.f_104203_ = 0.0f;
        this.ThighLeft.f_104204_ = 0.0f;
        this.Tail.f_104203_ = 0.0f;
        this.Tail.f_104204_ = 0.0f;
        this.Neck.f_104203_ = 0.0f;
        this.Neck.f_104204_ = 0.0f;
        this.Neck.f_104205_ = 0.0f;
        this.Head.f_104203_ = 0.0f;
        this.Head.f_104204_ = 0.0f;
        this.Head.f_104205_ = 0.0f;
        this.ThighRight.f_104203_ = 0.0f;
        this.ThighRight.f_104204_ = 0.0f;
        this.LegRight.f_104203_ = 0.0f;
        this.FootRight.f_104203_ = 0.0f;
        this.FootRight.f_104205_ = 0.0f;
        this.FootLeft.f_104203_ = 0.0f;
        this.FootLeft.f_104205_ = 0.0f;
    }

    public void sleepPose() {
        this.Body.f_104203_ = -0.17463292f;
        this.LegLeft.f_104203_ = -0.87266463f;
        this.ThighLeft.f_104203_ = -0.6981316f;
        this.ThighLeft.f_104204_ = 0.2443461f;
        this.Tail.f_104203_ = -0.13962634f;
        this.Tail.f_104204_ = 1.0471976f;
        this.Neck.f_104204_ = -2.268928f;
        this.Neck.f_104205_ = 0.83774805f;
        this.ThighRight.f_104203_ = -0.6981317f;
        this.ThighRight.f_104204_ = -0.2443461f;
        this.LegRight.f_104203_ = -0.87266463f;
        this.FootRight.f_104203_ = 1.5707964f;
        this.FootRight.f_104205_ = -0.2443461f;
        this.FootLeft.f_104203_ = 1.5707964f;
        this.FootLeft.f_104205_ = 0.24609143f;
        this.Body.f_104201_ = 19.5f;
        this.ThighLeft.f_104201_ = 19.5f;
        this.ThighRight.f_104201_ = 19.5f;
    }

    public void sittingPose() {
        this.Body.f_104201_ = 19.5f;
        this.ThighLeft.f_104201_ = 19.5f;
        this.ThighRight.f_104201_ = 19.5f;
        this.ThighRight.f_104203_ = -0.6981317f;
        this.ThighLeft.f_104203_ = -0.6981317f;
        this.WingLeft.f_104203_ = 0.43633232f;
        this.WingLeft.f_104205_ = -1.0471976f;
        this.Tail.f_104203_ = -0.17453292f;
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.ThighLeft.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.ThighRight.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.Body.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
    }
}

