/*
 * Decompiled with CFR 0.152.
 */
package superlord.prehistoricfauna.client.model.cretaceous.djadochta;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import superlord.prehistoricfauna.common.entity.DinosaurEntity;
import superlord.prehistoricfauna.common.entity.cretaceous.djadochta.Udanoceratops;

public class UdanoceratopsModel
extends EntityModel<Udanoceratops> {
    private final ModelPart Body;
    private final ModelPart Tail1;
    private final ModelPart Tail2;
    private final ModelPart Neck;
    private final ModelPart LeftArm;
    private final ModelPart RightArm;
    private final ModelPart LeftThigh;
    private final ModelPart LeftLeg;
    private final ModelPart LeftFoot;
    private final ModelPart RightThigh;
    private final ModelPart RightLeg;
    private final ModelPart RightFoot;

    public UdanoceratopsModel(ModelPart root) {
        this.Body = root.m_171324_("Body");
        this.Neck = this.Body.m_171324_("Neck");
        this.Tail1 = this.Body.m_171324_("Tail1");
        this.Tail2 = this.Tail1.m_171324_("Tail2");
        this.LeftArm = root.m_171324_("LeftArm");
        this.RightArm = root.m_171324_("RightArm");
        this.LeftThigh = root.m_171324_("LeftThigh");
        this.LeftLeg = this.LeftThigh.m_171324_("LeftLeg");
        this.LeftFoot = this.LeftLeg.m_171324_("LeftFoot");
        this.RightThigh = root.m_171324_("RightThigh");
        this.RightLeg = this.RightThigh.m_171324_("RightLeg");
        this.RightFoot = this.RightLeg.m_171324_("RightFoot");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition Body = partdefinition.m_171599_("Body", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-10.0f, 0.0f, 0.0f, 10.0f, 13.0f, 26.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)5.0f, (float)2.0f, (float)-11.0f));
        PartDefinition Neck = Body.m_171599_("Neck", CubeListBuilder.m_171558_().m_171514_(46, 0).m_171488_(-3.0f, -5.0f, -6.0f, 6.0f, 11.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-5.0f, (float)5.0f, (float)0.0f));
        PartDefinition HeadTop = Neck.m_171599_("HeadTop", CubeListBuilder.m_171558_().m_171514_(0, 39).m_171488_(-3.5f, -3.0f, -6.0f, 7.0f, 6.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-3.0f, (float)-4.0f));
        PartDefinition HeadBottom = HeadTop.m_171599_("HeadBottom", CubeListBuilder.m_171558_().m_171514_(26, 39).m_171488_(-3.5f, 0.0f, -6.0f, 7.0f, 5.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)3.0f, (float)1.0f));
        PartDefinition SnoutBottom = HeadBottom.m_171599_("SnoutBottom", CubeListBuilder.m_171558_().m_171514_(46, 17).m_171488_(-1.0f, 0.0f, -4.0f, 2.0f, 5.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-1.0f, (float)-6.0f));
        PartDefinition Cheeks = HeadBottom.m_171599_("Cheeks", CubeListBuilder.m_171558_().m_171514_(0, 51).m_171488_(-3.0f, -3.0f, -3.0f, 6.0f, 3.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)-1.01f));
        PartDefinition HeadSpikes = HeadBottom.m_171599_("HeadSpikes", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(0.0f, 0.0f, 0.0f, 0.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)5.0f, (float)-5.0f));
        PartDefinition SnoutTop = HeadTop.m_171599_("SnoutTop", CubeListBuilder.m_171558_().m_171514_(70, 0).m_171488_(-1.5f, 0.0f, -5.0f, 3.0f, 6.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-2.0f, (float)-5.0f));
        PartDefinition JugalHorns = HeadTop.m_171599_("JugalHorns", CubeListBuilder.m_171558_().m_171514_(46, 39).m_171488_(-4.5f, -1.5f, -1.5f, 9.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)1.49f, (float)-0.51f));
        PartDefinition Crest = HeadTop.m_171599_("Crest", CubeListBuilder.m_171558_().m_171514_(22, 50).m_171488_(-4.0f, -2.0f, -2.0f, 8.0f, 5.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-1.5f, (float)1.0f, (float)-0.3491f, (float)0.0f, (float)0.0f));
        PartDefinition NeckSpikes = Neck.m_171599_("NeckSpikes", CubeListBuilder.m_171558_().m_171514_(54, 11).m_171488_(0.0f, 0.0f, 0.0f, 0.0f, 2.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)6.0f, (float)-6.0f));
        PartDefinition Tail1 = Body.m_171599_("Tail1", CubeListBuilder.m_171558_().m_171514_(38, 45).m_171488_(-3.0f, -5.0f, -1.0f, 6.0f, 10.0f, 14.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-5.0f, (float)5.01f, (float)26.0f));
        PartDefinition Tail2 = Tail1.m_171599_("Tail2", CubeListBuilder.m_171558_().m_171514_(64, 34).m_171488_(-2.0f, -3.0f, -1.0f, 4.0f, 6.0f, 11.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)1.0f, (float)13.0f));
        PartDefinition Tail2Spikes = Tail2.m_171599_("Tail2Spikes", CubeListBuilder.m_171558_().m_171514_(0, -3).m_171488_(0.0f, -1.0f, 0.0f, 0.0f, 1.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-3.0f, (float)0.0f));
        PartDefinition Tail1Spikes = Tail1.m_171599_("Tail1Spikes", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(0.0f, -2.0f, 0.0f, 0.0f, 2.0f, 11.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-5.0f, (float)1.0f));
        PartDefinition BodySpikes = Body.m_171599_("BodySpikes", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(0.0f, -1.0f, 0.0f, 0.0f, 1.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-5.0f, (float)0.0f, (float)20.0f));
        PartDefinition LeftArm = partdefinition.m_171599_("LeftArm", CubeListBuilder.m_171558_().m_171514_(72, 16).m_171488_(-3.0f, -2.0f, -2.0f, 3.0f, 13.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-3.0f, (float)13.0f, (float)-8.0f));
        PartDefinition LeftHand = LeftArm.m_171599_("LeftHand", CubeListBuilder.m_171558_().m_171514_(62, 51).m_171488_(-2.5f, 0.0f, -3.0f, 5.0f, 0.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-1.5f, (float)11.0f, (float)-2.0f));
        PartDefinition RightArm = partdefinition.m_171599_("RightArm", CubeListBuilder.m_171558_().m_171514_(72, 16).m_171488_(0.0f, -2.0f, -2.0f, 3.0f, 13.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)3.0f, (float)13.0f, (float)-8.0f));
        PartDefinition RightHand = RightArm.m_171599_("RightHand", CubeListBuilder.m_171558_().m_171514_(62, 51).m_171480_().m_171488_(-2.5f, 0.0f, -3.0f, 5.0f, 0.0f, 6.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)1.5f, (float)11.0f, (float)-2.0f));
        PartDefinition LeftThigh = partdefinition.m_171599_("LeftThigh", CubeListBuilder.m_171558_().m_171514_(86, 0).m_171488_(-5.0f, -3.0f, -5.0f, 5.0f, 12.0f, 9.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-2.0f, (float)9.0f, (float)9.0f));
        PartDefinition LeftLeg = LeftThigh.m_171599_("LeftLeg", CubeListBuilder.m_171558_().m_171514_(83, 30).m_171488_(-3.0f, 0.0f, 0.0f, 3.0f, 10.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-1.0f, (float)5.0f, (float)0.0f));
        PartDefinition LeftFoot = LeftLeg.m_171599_("LeftFoot", CubeListBuilder.m_171558_().m_171514_(88, 58).m_171480_().m_171488_(-4.0f, 8.0f, -2.0f, 5.0f, 2.0f, 6.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition RightThigh = partdefinition.m_171599_("RightThigh", CubeListBuilder.m_171558_().m_171514_(86, 0).m_171488_(-5.0f, -3.0f, -5.0f, 5.0f, 12.0f, 9.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)7.0f, (float)9.0f, (float)9.0f));
        PartDefinition RightLeg = RightThigh.m_171599_("RightLeg", CubeListBuilder.m_171558_().m_171514_(83, 30).m_171488_(-3.0f, 0.0f, 0.0f, 3.0f, 10.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-1.0f, (float)5.0f, (float)0.0f));
        PartDefinition RightFoot = RightLeg.m_171599_("RightFoot", CubeListBuilder.m_171558_().m_171514_(88, 58).m_171488_(-4.0f, 8.0f, -2.0f, 5.0f, 2.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)114, (int)69);
    }

    public void setupAnim(Udanoceratops entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        float speed = 0.9f;
        float degree = 1.0f;
        float partialTick = ageInTicks - (float)entity.f_19797_;
        float attackProgress = entity.getMeleeProgress(partialTick) * 2.0f;
        float sleepProgress = entity.getSleepProgress(partialTick);
        this.resetModel();
        if (entity.isAsleep()) {
            if (sleepProgress != 0.0f && (Integer)entity.m_20088_().m_135370_(DinosaurEntity.SLEEP_TICK) > 0) {
                this.Body.f_104201_ = Mth.m_14179_((float)sleepProgress, (float)2.0f, (float)10.0f);
                this.RightThigh.f_104201_ = Mth.m_14179_((float)sleepProgress, (float)9.0f, (float)17.0f);
                this.LeftThigh.f_104201_ = Mth.m_14179_((float)sleepProgress, (float)9.0f, (float)17.0f);
                this.LeftArm.f_104201_ = Mth.m_14179_((float)sleepProgress, (float)13.0f, (float)21.0f);
                this.RightArm.f_104201_ = Mth.m_14179_((float)sleepProgress, (float)13.0f, (float)21.0f);
                this.Tail1.f_104202_ = Mth.m_14179_((float)sleepProgress, (float)26.0f, (float)23.0f);
                this.Tail2.f_104201_ = Mth.m_14179_((float)sleepProgress, (float)1.0f, (float)0.0f);
                this.Neck.f_104202_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)1.5f);
                this.Neck.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)0.15235987f);
                this.Neck.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-0.34906584f);
                this.LeftThigh.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-0.9330383f);
                this.LeftThigh.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)0.25850537f);
                this.LeftArm.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-1.2330383f);
                this.LeftArm.f_104205_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-0.4575712f);
                this.LeftLeg.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-0.637758f);
                this.RightArm.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-1.3962634f);
                this.RightArm.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)0.13962634f);
                this.RightArm.f_104205_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-0.13962634f);
                this.RightLeg.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-0.637758f);
                this.Body.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)0.057453293f);
                this.Tail1.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-0.55850536f);
                this.Tail1.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)0.41887903f);
                this.Tail2.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)0.41887903f);
                this.Tail2.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)0.5934119f);
                this.Tail2.f_104205_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)0.10471976f);
                this.RightThigh.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-0.9330383f);
                this.RightThigh.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-0.25850537f);
            } else {
                this.sleepPose();
            }
        } else if (sleepProgress != 0.0f && (Integer)entity.m_20088_().m_135370_(DinosaurEntity.SLEEP_TICK) > 0) {
            this.Body.f_104201_ = Mth.m_14179_((float)sleepProgress, (float)10.0f, (float)2.0f);
            this.RightThigh.f_104201_ = Mth.m_14179_((float)sleepProgress, (float)17.0f, (float)9.0f);
            this.LeftThigh.f_104201_ = Mth.m_14179_((float)sleepProgress, (float)17.0f, (float)9.0f);
            this.LeftArm.f_104201_ = Mth.m_14179_((float)sleepProgress, (float)21.0f, (float)13.0f);
            this.RightArm.f_104201_ = Mth.m_14179_((float)sleepProgress, (float)21.0f, (float)13.0f);
            this.Tail1.f_104202_ = Mth.m_14179_((float)sleepProgress, (float)23.0f, (float)26.0f);
            this.Tail2.f_104201_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)1.0f);
            this.Neck.f_104202_ = Mth.m_14179_((float)sleepProgress, (float)1.5f, (float)0.0f);
            this.Neck.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.15235987f, (float)0.0f);
            this.Neck.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)-0.34906584f, (float)0.0f);
            this.LeftThigh.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)-0.9330383f, (float)0.0f);
            this.LeftThigh.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)0.25850537f, (float)0.0f);
            this.LeftArm.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)-1.2330383f, (float)0.0f);
            this.LeftArm.f_104205_ = Mth.m_14179_((float)sleepProgress, (float)-0.4575712f, (float)0.0f);
            this.LeftLeg.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)-0.637758f, (float)0.0f);
            this.RightArm.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)-1.3962634f, (float)0.0f);
            this.RightArm.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)0.13962634f, (float)0.0f);
            this.RightArm.f_104205_ = Mth.m_14179_((float)sleepProgress, (float)-0.13962634f, (float)0.0f);
            this.RightLeg.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)-0.637758f, (float)0.0f);
            this.Body.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.057453293f, (float)0.0f);
            this.Tail1.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)-0.55850536f, (float)0.0f);
            this.Tail1.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)0.41887903f, (float)0.0f);
            this.Tail2.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.41887903f, (float)0.0f);
            this.Tail2.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)0.5934119f, (float)0.0f);
            this.Tail2.f_104205_ = Mth.m_14179_((float)sleepProgress, (float)0.10471976f, (float)0.0f);
            this.RightThigh.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)-0.9330383f, (float)0.0f);
            this.RightThigh.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)-0.9330383f, (float)0.0f);
        } else {
            this.Neck.f_104203_ = 0.0f;
            this.Neck.f_104204_ = netHeadYaw * ((float)Math.PI / 180);
            this.RightThigh.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
            this.LeftThigh.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
            this.LeftArm.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
            this.RightArm.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
            this.Tail1.f_104204_ = -0.12f * Mth.m_14031_((float)(0.2f * ageInTicks / 5.0f));
            this.Tail2.f_104204_ = -0.12f * Mth.m_14031_((float)(0.2f * ageInTicks / 5.0f));
            this.Tail1.f_104203_ = -Math.abs(-0.05f * Mth.m_14031_((float)(0.1f * ageInTicks / 5.0f)));
            this.Tail2.f_104203_ = -Math.abs(-0.05f * Mth.m_14031_((float)(0.1f * ageInTicks / 5.0f)));
            this.Body.f_104203_ = Math.abs(-0.025f * Mth.m_14031_((float)(0.1f * ageInTicks / 3.0f)));
            this.Neck.f_104203_ = -Math.abs(-0.025f * Mth.m_14031_((float)(0.1f * ageInTicks / 3.0f))) + Mth.m_14089_((float)(-1.0f + limbSwing * speed * 0.3f)) * degree * 0.05f * limbSwingAmount + attackProgress * (float)Math.toRadians(25.0);
            if (entity.isEating()) {
                this.Neck.f_104203_ = Math.abs(Mth.m_14031_((float)(0.05f * ageInTicks)) * 0.45f) + 0.15f;
            }
            if (entity.m_20069_()) {
                this.Body.f_104201_ = 9.0f;
                this.LeftArm.f_104201_ = 20.0f;
                this.RightArm.f_104201_ = 20.0f;
                this.RightThigh.f_104201_ = 19.0f;
                this.LeftThigh.f_104201_ = 19.0f;
                this.Body.f_104203_ = -0.125f;
                this.Tail1.f_104203_ = 0.0625f;
                this.Tail2.f_104203_ = 0.0625f;
                this.LeftThigh.f_104203_ = -0.25f * Mth.m_14031_((float)(0.2f * ageInTicks / 1.5f));
                this.RightThigh.f_104203_ = 0.25f * Mth.m_14031_((float)(0.2f * ageInTicks / 1.5f));
                this.LeftArm.f_104203_ = -0.25f * Mth.m_14031_((float)(0.2f * ageInTicks / 1.5f));
                this.RightArm.f_104203_ = 0.25f * Mth.m_14031_((float)(0.2f * ageInTicks / 1.5f));
                this.LeftLeg.f_104203_ = -0.3f * Mth.m_14031_((float)(0.2f * ageInTicks / 1.5f));
                this.RightLeg.f_104203_ = 0.3f * Mth.m_14031_((float)(0.2f * ageInTicks / 1.5f));
                this.Neck.f_104203_ = 0.125f;
                this.Tail1.f_104204_ = Mth.m_14089_((float)(limbSwing * 2.6662f)) * 1.4f * limbSwingAmount + 0.0625f * Mth.m_14031_((float)(0.15f * ageInTicks / 1.5f));
                this.Tail2.f_104204_ = Mth.m_14089_((float)(limbSwing * 2.6662f)) * 1.4f * limbSwingAmount + 0.0625f * Mth.m_14031_((float)(0.15f * ageInTicks / 1.5f));
            }
        }
    }

    public void resetModel() {
        this.Body.f_104201_ = 2.0f;
        this.RightThigh.f_104200_ = 7.0f;
        this.RightThigh.f_104201_ = 9.0f;
        this.RightThigh.f_104202_ = 9.0f;
        this.LeftThigh.f_104200_ = -2.0f;
        this.LeftThigh.f_104201_ = 9.0f;
        this.LeftThigh.f_104202_ = 9.0f;
        this.LeftArm.f_104201_ = 13.0f;
        this.RightArm.f_104201_ = 13.0f;
        this.LeftLeg.f_104201_ = 5.0f;
        this.RightLeg.f_104201_ = 5.0f;
        this.LeftFoot.f_104202_ = 0.0f;
        this.RightFoot.f_104202_ = 0.0f;
        this.Tail1.f_104202_ = 26.0f;
        this.Tail2.f_104201_ = 1.0f;
        this.Neck.f_104202_ = 0.0f;
        this.Neck.f_104203_ = 0.0f;
        this.Neck.f_104204_ = 0.0f;
        this.LeftThigh.f_104203_ = 0.0f;
        this.LeftThigh.f_104204_ = 0.0f;
        this.LeftArm.f_104203_ = 0.0f;
        this.LeftArm.f_104205_ = 0.0f;
        this.LeftLeg.f_104203_ = 0.0f;
        this.RightArm.f_104203_ = 0.0f;
        this.RightArm.f_104204_ = 0.0f;
        this.RightArm.f_104205_ = 0.0f;
        this.RightLeg.f_104203_ = 0.0f;
        this.Body.f_104203_ = 0.0f;
        this.Tail1.f_104203_ = 0.0f;
        this.Tail1.f_104204_ = 0.0f;
        this.Tail2.f_104203_ = 0.0f;
        this.Tail2.f_104204_ = 0.0f;
        this.Tail2.f_104205_ = 0.0f;
        this.RightThigh.f_104203_ = 0.0f;
        this.RightThigh.f_104204_ = 0.0f;
        this.LeftFoot.f_104203_ = 0.0f;
        this.RightFoot.f_104203_ = 0.0f;
    }

    public void sleepPose() {
        this.Body.f_104201_ = 10.0f;
        this.RightThigh.f_104201_ = 17.0f;
        this.LeftThigh.f_104201_ = 17.0f;
        this.LeftArm.f_104201_ = 21.0f;
        this.RightArm.f_104201_ = 21.0f;
        this.LeftLeg.f_104201_ = 5.0f;
        this.RightLeg.f_104201_ = 5.0f;
        this.Tail1.f_104202_ = 23.0f;
        this.Tail2.f_104201_ = 0.0f;
        this.Neck.f_104202_ = 1.5f;
        this.Neck.f_104203_ = 0.15235987f;
        this.Neck.f_104204_ = -0.34906584f;
        this.LeftThigh.f_104203_ = -0.9330383f;
        this.LeftThigh.f_104204_ = 0.25850537f;
        this.LeftArm.f_104203_ = -1.2330383f;
        this.LeftArm.f_104205_ = -0.4575712f;
        this.LeftLeg.f_104203_ = -0.637758f;
        this.RightArm.f_104203_ = -1.3962634f;
        this.RightArm.f_104204_ = 0.13962634f;
        this.RightArm.f_104205_ = -0.13962634f;
        this.RightLeg.f_104203_ = -0.637758f;
        this.Body.f_104203_ = 0.057453293f;
        this.Tail1.f_104203_ = -0.55850536f;
        this.Tail1.f_104204_ = 0.41887903f;
        this.Tail2.f_104203_ = 0.41887903f;
        this.Tail2.f_104204_ = 0.5934119f;
        this.Tail2.f_104205_ = 0.10471976f;
        this.RightThigh.f_104203_ = -0.9330383f;
        this.RightThigh.f_104204_ = -0.25850537f;
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.Body.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.LeftArm.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.RightArm.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.LeftThigh.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.RightThigh.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
    }
}

