/*
 * Decompiled with CFR 0.152.
 */
package superlord.prehistoricfauna.client.model.cretaceous.djadochta;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import superlord.prehistoricfauna.common.entity.DinosaurEntity;
import superlord.prehistoricfauna.common.entity.cretaceous.djadochta.Udanoceratops;

public class UdanoceratopsBabyModel
extends EntityModel<Udanoceratops> {
    private final ModelPart Body;
    private final ModelPart Head;
    private final ModelPart Tail;
    private final ModelPart LeftArm;
    private final ModelPart RightArm;
    private final ModelPart LeftThigh;
    private final ModelPart LeftLeg;
    private final ModelPart LeftFoot;
    private final ModelPart RightThigh;
    private final ModelPart RightLeg;
    private final ModelPart RightFoot;

    public UdanoceratopsBabyModel(ModelPart root) {
        this.Body = root.m_171324_("Body");
        this.Head = this.Body.m_171324_("Head");
        this.Tail = this.Body.m_171324_("Tail");
        this.LeftArm = this.Body.m_171324_("LeftArm");
        this.RightArm = this.Body.m_171324_("RightArm");
        this.LeftThigh = this.Body.m_171324_("LeftThigh");
        this.LeftLeg = this.LeftThigh.m_171324_("LeftLeg");
        this.LeftFoot = this.LeftLeg.m_171324_("LeftFoot");
        this.RightThigh = this.Body.m_171324_("RightThigh");
        this.RightLeg = this.RightThigh.m_171324_("RightLeg");
        this.RightFoot = this.RightLeg.m_171324_("RightFoot");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition Body = partdefinition.m_171599_("Body", CubeListBuilder.m_171558_().m_171514_(0, 10).m_171488_(-2.0f, -6.0f, -5.0f, 4.0f, 6.0f, 10.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)21.0f, (float)0.0f));
        PartDefinition Head = Body.m_171599_("Head", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-2.5f, -3.0f, -4.0f, 5.0f, 6.0f, 4.0f, new CubeDeformation(0.0f)).m_171514_(0, 10).m_171488_(-1.5f, -2.0f, -6.0f, 3.0f, 5.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-4.0f, (float)-5.0f));
        PartDefinition Tail = Body.m_171599_("Tail", CubeListBuilder.m_171558_().m_171514_(0, 26).m_171488_(-1.0f, -1.0f, 0.0f, 2.0f, 4.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-5.0f, (float)5.0f));
        PartDefinition LeftArm = Body.m_171599_("LeftArm", CubeListBuilder.m_171558_().m_171514_(18, 0).m_171488_(-1.0f, -1.0f, -1.0f, 2.0f, 5.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(24, 0).m_171480_().m_171488_(-1.0f, 4.0f, -3.0f, 3.0f, 0.0f, 3.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)-2.0f, (float)-1.0f, (float)-3.0f));
        PartDefinition RightArm = Body.m_171599_("RightArm", CubeListBuilder.m_171558_().m_171514_(18, 0).m_171488_(-1.0f, -1.0f, -1.0f, 2.0f, 5.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(24, 0).m_171488_(-2.0f, 4.0f, -3.0f, 3.0f, 0.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)2.0f, (float)-1.0f, (float)-3.0f));
        PartDefinition LeftThigh = Body.m_171599_("LeftThigh", CubeListBuilder.m_171558_().m_171514_(18, 7).m_171488_(0.0f, -1.0f, -1.5f, 1.0f, 4.0f, 3.0f, new CubeDeformation(0.0f)).m_171514_(18, 7).m_171488_(-1.0f, -1.0f, -1.5f, 1.0f, 4.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-2.0f, (float)-2.0f, (float)2.5f));
        PartDefinition LeftLeg = LeftThigh.m_171599_("LeftLeg", CubeListBuilder.m_171558_().m_171514_(38, 3).m_171488_(-0.5f, 0.0f, 0.0f, 1.0f, 2.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)3.0f, (float)1.5f));
        PartDefinition LeftFoot = LeftLeg.m_171599_("LeftFoot", CubeListBuilder.m_171558_().m_171514_(32, 0).m_171488_(-1.5f, 0.0f, -3.0f, 3.0f, 0.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)2.0f, (float)0.0f));
        PartDefinition RightThigh = Body.m_171599_("RightThigh", CubeListBuilder.m_171558_().m_171514_(18, 7).m_171480_().m_171488_(-1.0f, -1.0f, -1.5f, 1.0f, 4.0f, 3.0f, new CubeDeformation(0.0f)).m_171555_(false).m_171514_(18, 7).m_171480_().m_171488_(0.0f, -1.0f, -1.5f, 1.0f, 4.0f, 3.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)2.0f, (float)-2.0f, (float)2.5f));
        PartDefinition RightLeg = RightThigh.m_171599_("RightLeg", CubeListBuilder.m_171558_().m_171514_(38, 3).m_171480_().m_171488_(-0.5f, 0.0f, 0.0f, 1.0f, 2.0f, 0.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)0.0f, (float)3.0f, (float)1.5f));
        PartDefinition RightFoot = RightLeg.m_171599_("RightFoot", CubeListBuilder.m_171558_().m_171514_(32, 0).m_171480_().m_171488_(-1.5f, 0.0f, -3.0f, 3.0f, 0.0f, 3.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)0.0f, (float)2.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)57, (int)36);
    }

    public void setupAnim(Udanoceratops entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        float speed = 0.9f;
        float degree = 1.0f;
        float partialTick = ageInTicks - (float)entity.f_19797_;
        float attackProgress = entity.getMeleeProgress(partialTick) * 2.0f;
        float sleepProgress = entity.getSleepProgress(partialTick);
        this.resetModel();
        if (entity.isAsleep()) {
            if (sleepProgress != 0.0f && (Integer)entity.m_20088_().m_135370_(DinosaurEntity.SLEEP_TICK) > 0) {
                this.Body.f_104201_ = Mth.m_14179_((float)sleepProgress, (float)21.0f, (float)23.0f);
                this.Tail.f_104201_ = Mth.m_14179_((float)sleepProgress, (float)-5.0f, (float)-4.5f);
                this.Head.f_104202_ = Mth.m_14179_((float)sleepProgress, (float)-5.0f, (float)-4.0f);
                this.Head.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)0.15235987f);
                this.Head.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-0.34906584f);
                this.LeftThigh.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-0.9330383f);
                this.LeftThigh.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)0.25850537f);
                this.LeftArm.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-1.2330383f);
                this.LeftArm.f_104205_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-0.4575712f);
                this.LeftLeg.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-0.687758f);
                this.LeftFoot.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)1.5877581f);
                this.RightArm.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-1.3962634f);
                this.RightArm.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)0.13962634f);
                this.RightArm.f_104205_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-0.13962634f);
                this.RightLeg.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-0.687758f);
                this.RightFoot.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)1.5877581f);
                this.Body.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)0.057453293f);
                this.Tail.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-0.55850536f);
                this.Tail.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)0.41887903f);
                this.RightThigh.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-0.9330383f);
                this.RightThigh.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-0.25850537f);
            } else {
                this.sleepPose();
            }
        } else if (sleepProgress != 0.0f && (Integer)entity.m_20088_().m_135370_(DinosaurEntity.SLEEP_TICK) > 0) {
            this.Body.f_104201_ = Mth.m_14179_((float)sleepProgress, (float)23.0f, (float)21.0f);
            this.Tail.f_104201_ = Mth.m_14179_((float)sleepProgress, (float)-4.5f, (float)-5.0f);
            this.Head.f_104202_ = Mth.m_14179_((float)sleepProgress, (float)-4.0f, (float)-5.0f);
            this.Head.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.15235987f, (float)0.0f);
            this.Head.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)-0.34906584f, (float)0.0f);
            this.LeftThigh.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)-0.9330383f, (float)0.0f);
            this.LeftThigh.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)0.25850537f, (float)0.0f);
            this.LeftArm.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)-1.2330383f, (float)0.0f);
            this.LeftArm.f_104205_ = Mth.m_14179_((float)sleepProgress, (float)-0.4575712f, (float)0.0f);
            this.LeftLeg.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)-0.687758f, (float)0.0f);
            this.LeftFoot.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)1.5877581f, (float)0.0f);
            this.RightArm.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)-1.3962634f, (float)0.0f);
            this.RightArm.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)0.13962634f, (float)0.0f);
            this.RightArm.f_104205_ = Mth.m_14179_((float)sleepProgress, (float)-0.13962634f, (float)0.0f);
            this.RightLeg.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)-0.687758f, (float)0.0f);
            this.RightFoot.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)1.5877581f, (float)0.0f);
            this.Body.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.057453293f, (float)0.0f);
            this.Tail.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)-0.55850536f, (float)0.0f);
            this.Tail.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)0.41887903f, (float)0.0f);
            this.RightThigh.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)-0.9330383f, (float)0.0f);
            this.RightThigh.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)-0.25850537f, (float)0.0f);
        } else {
            this.Head.f_104203_ = 0.0f;
            this.Head.f_104204_ = netHeadYaw * ((float)Math.PI / 180);
            this.RightThigh.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
            this.LeftThigh.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
            this.LeftArm.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
            this.RightArm.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
            this.Tail.f_104204_ = -0.12f * Mth.m_14031_((float)(0.2f * ageInTicks / 5.0f));
            this.Tail.f_104203_ = -Math.abs(-0.05f * Mth.m_14031_((float)(0.1f * ageInTicks / 5.0f)));
            this.Body.f_104203_ = Math.abs(-0.025f * Mth.m_14031_((float)(0.1f * ageInTicks / 3.0f)));
            this.Head.f_104203_ = -Math.abs(-0.025f * Mth.m_14031_((float)(0.1f * ageInTicks / 3.0f))) + Mth.m_14089_((float)(-1.0f + limbSwing * speed * 0.3f)) * degree * 0.05f * limbSwingAmount + attackProgress * (float)Math.toRadians(25.0);
            if (entity.isEating()) {
                this.Head.f_104203_ = Math.abs(Mth.m_14031_((float)(0.05f * ageInTicks)) * 0.45f) + 0.15f;
            }
            if (entity.m_20069_()) {
                this.Body.f_104201_ = 20.0f;
                this.Body.f_104203_ = -0.125f;
                this.Tail.f_104203_ = 0.0625f;
                this.LeftThigh.f_104203_ = -0.25f * Mth.m_14031_((float)(0.2f * ageInTicks / 1.5f));
                this.RightThigh.f_104203_ = 0.25f * Mth.m_14031_((float)(0.2f * ageInTicks / 1.5f));
                this.LeftArm.f_104203_ = -0.25f * Mth.m_14031_((float)(0.2f * ageInTicks / 1.5f));
                this.RightArm.f_104203_ = 0.25f * Mth.m_14031_((float)(0.2f * ageInTicks / 1.5f));
                this.LeftLeg.f_104203_ = -0.3f * Mth.m_14031_((float)(0.2f * ageInTicks / 1.5f));
                this.RightLeg.f_104203_ = 0.3f * Mth.m_14031_((float)(0.2f * ageInTicks / 1.5f));
                this.Head.f_104203_ = 0.125f;
                this.Tail.f_104204_ = Mth.m_14089_((float)(limbSwing * 2.6662f)) * 1.4f * limbSwingAmount + 0.0625f * Mth.m_14031_((float)(0.15f * ageInTicks / 1.5f));
            }
        }
    }

    public void resetModel() {
        this.Body.f_104201_ = 21.0f;
        this.Tail.f_104201_ = -5.0f;
        this.Head.f_104202_ = -5.0f;
        this.Head.f_104203_ = 0.0f;
        this.Head.f_104204_ = 0.0f;
        this.LeftThigh.f_104203_ = 0.0f;
        this.LeftThigh.f_104204_ = 0.0f;
        this.LeftArm.f_104203_ = 0.0f;
        this.LeftArm.f_104205_ = 0.0f;
        this.LeftLeg.f_104203_ = 0.0f;
        this.RightArm.f_104203_ = 0.0f;
        this.RightArm.f_104204_ = 0.0f;
        this.RightArm.f_104205_ = 0.0f;
        this.RightLeg.f_104203_ = 0.0f;
        this.Body.f_104203_ = 0.0f;
        this.Tail.f_104203_ = 0.0f;
        this.Tail.f_104204_ = 0.0f;
        this.RightThigh.f_104203_ = 0.0f;
        this.RightThigh.f_104204_ = 0.0f;
        this.LeftFoot.f_104203_ = 0.0f;
        this.RightFoot.f_104203_ = 0.0f;
    }

    public void sleepPose() {
        this.Body.f_104201_ = 23.0f;
        this.Tail.f_104201_ = -4.5f;
        this.Head.f_104202_ = -4.0f;
        this.Head.f_104203_ = 0.15235987f;
        this.Head.f_104204_ = -0.34906584f;
        this.LeftThigh.f_104203_ = -0.9330383f;
        this.LeftThigh.f_104204_ = 0.25850537f;
        this.LeftArm.f_104203_ = -1.2330383f;
        this.LeftArm.f_104205_ = -0.4575712f;
        this.LeftLeg.f_104203_ = -0.687758f;
        this.LeftFoot.f_104203_ = 1.5877581f;
        this.RightArm.f_104203_ = -1.3962634f;
        this.RightArm.f_104204_ = 0.13962634f;
        this.RightArm.f_104205_ = -0.13962634f;
        this.RightLeg.f_104203_ = -0.687758f;
        this.RightFoot.f_104203_ = 1.5877581f;
        this.Body.f_104203_ = 0.057453293f;
        this.Tail.f_104203_ = -0.55850536f;
        this.Tail.f_104204_ = 0.41887903f;
        this.RightThigh.f_104203_ = -0.9330383f;
        this.RightThigh.f_104204_ = -0.25850537f;
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.Body.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
    }
}

