/*
 * Decompiled with CFR 0.152.
 */
package superlord.prehistoricfauna.client.model.cretaceous.djadochta;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import superlord.prehistoricfauna.common.entity.DinosaurEntity;
import superlord.prehistoricfauna.common.entity.cretaceous.djadochta.Pinacosaurus;

public class PinacosaurusBabyModel
extends EntityModel<Pinacosaurus> {
    private final ModelPart Torso;
    private final ModelPart RArm;
    private final ModelPart LArm;
    private final ModelPart RLeg;
    private final ModelPart LLeg;
    private final ModelPart Tail;
    private final ModelPart Head;

    public PinacosaurusBabyModel(ModelPart root) {
        this.Torso = root.m_171324_("Torso");
        this.RArm = this.Torso.m_171324_("RArm");
        this.LArm = this.Torso.m_171324_("LArm");
        this.RLeg = this.Torso.m_171324_("RLeg");
        this.LLeg = this.Torso.m_171324_("LLeg");
        this.Tail = this.Torso.m_171324_("Tail");
        this.Head = this.Torso.m_171324_("Head");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition Torso = partdefinition.m_171599_("Torso", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-6.5f, 0.0f, -8.0f, 13.0f, 6.0f, 16.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)15.0f, (float)0.0f));
        PartDefinition Head = Torso.m_171599_("Head", CubeListBuilder.m_171558_().m_171514_(42, 0).m_171488_(-2.5f, -1.0f, -9.0f, 5.0f, 3.0f, 10.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)2.0f, (float)-8.0f, (float)0.0698f, (float)0.0f, (float)0.0f));
        PartDefinition LHorn = Head.m_171599_("LHorn", CubeListBuilder.m_171558_().m_171514_(45, 0).m_171488_(-0.5f, -2.0f, -1.0f, 1.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-2.5f, (float)0.0f, (float)-5.0f));
        PartDefinition RHorn = Head.m_171599_("RHorn", CubeListBuilder.m_171558_().m_171514_(45, 0).m_171488_(-0.5f, -2.0f, -1.0f, 1.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)2.5f, (float)0.0f, (float)-5.0f));
        PartDefinition HeadHorns = Head.m_171599_("HeadHorns", CubeListBuilder.m_171558_().m_171514_(3, 62).m_171488_(-4.5f, 0.0f, 0.0f, 9.0f, 0.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)-3.0f));
        PartDefinition Tail = Torso.m_171599_("Tail", CubeListBuilder.m_171558_().m_171514_(0, 22).m_171488_(-1.5f, 0.0f, -1.0f, 3.0f, 2.0f, 12.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)1.0f, (float)8.0f, (float)-0.0349f, (float)0.0f, (float)0.0f));
        PartDefinition Club = Tail.m_171599_("Club", CubeListBuilder.m_171558_().m_171514_(18, 22).m_171488_(-2.5f, 0.0f, -1.0f, 5.0f, 2.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)11.0f));
        PartDefinition TailSpines = Tail.m_171599_("TailSpines", CubeListBuilder.m_171558_().m_171514_(-2, 36).m_171488_(-3.5f, 0.0f, 0.0f, 7.0f, 0.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)1.0f, (float)1.0f));
        PartDefinition TorsoSpines = Torso.m_171599_("TorsoSpines", CubeListBuilder.m_171558_().m_171514_(-16, 44).m_171488_(-9.5f, 0.0f, -7.0f, 19.0f, 0.0f, 16.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)1.0f, (float)0.0f));
        PartDefinition RArm = Torso.m_171599_("RArm", CubeListBuilder.m_171558_().m_171514_(36, 22).m_171488_(-1.5f, 0.0f, -1.5f, 3.0f, 5.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)6.0f, (float)4.0f, (float)-4.5f));
        PartDefinition LArm = Torso.m_171599_("LArm", CubeListBuilder.m_171558_().m_171514_(36, 22).m_171488_(-1.5f, 0.0f, -1.5f, 3.0f, 5.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-6.0f, (float)4.0f, (float)-4.5f));
        PartDefinition RLeg = Torso.m_171599_("RLeg", CubeListBuilder.m_171558_().m_171514_(48, 22).m_171488_(-1.5f, 0.0f, -1.5f, 3.0f, 5.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)6.0f, (float)2.0f, (float)4.5f));
        PartDefinition RLeg2 = RLeg.m_171599_("RLeg2", CubeListBuilder.m_171558_().m_171514_(58, 13).m_171488_(-1.5f, 0.0f, -4.0f, 3.0f, 2.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)5.0f, (float)2.5f));
        PartDefinition LLeg = Torso.m_171599_("LLeg", CubeListBuilder.m_171558_().m_171514_(48, 22).m_171480_().m_171488_(-1.5f, 0.0f, -1.5f, 3.0f, 5.0f, 4.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)-6.0f, (float)2.0f, (float)4.5f));
        PartDefinition LLeg2 = LLeg.m_171599_("LLeg2", CubeListBuilder.m_171558_().m_171514_(58, 13).m_171480_().m_171488_(-1.5f, 0.0f, -4.0f, 3.0f, 2.0f, 4.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)0.0f, (float)5.0f, (float)2.5f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)72, (int)64);
    }

    public void setupAnim(Pinacosaurus entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        float speed = 0.9f;
        float degree = 1.0f;
        this.resetModel();
        float partialTick = ageInTicks - (float)entity.f_19797_;
        float attackProgress = entity.getMeleeProgress(partialTick);
        float leftOrRight = entity.getMeleeDirection() ? 1.0f : -1.0f;
        float sleepProgress = entity.getSleepProgress(partialTick);
        if (entity.isAsleep()) {
            if (sleepProgress != 0.0f && (Integer)entity.m_20088_().m_135370_(DinosaurEntity.SLEEP_TICK) > 0) {
                this.LLeg.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)0.03473205f);
                this.LLeg.f_104205_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)0.29181904f);
                this.RLeg.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-0.03647738f);
                this.RLeg.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-5.2359875E-4f);
                this.RLeg.f_104205_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-0.2919936f);
                this.Head.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)0.22287856f);
                this.Tail.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-0.40543997f);
                this.Tail.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-0.14608406f);
                this.RArm.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-1.3891075f);
                this.RArm.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-0.10995574f);
                this.LArm.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-1.2407545f);
                this.LArm.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)0.25534168f);
                this.Torso.f_104201_ = Mth.m_14179_((float)sleepProgress, (float)15.0f, (float)17.0f);
                this.Torso.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)0.14590952f);
            } else {
                this.setSleepingPose();
            }
        } else if (sleepProgress != 0.0f && (Integer)entity.m_20088_().m_135370_(DinosaurEntity.SLEEP_TICK) > 0) {
            this.LLeg.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.03473205f, (float)0.0f);
            this.LLeg.f_104205_ = Mth.m_14179_((float)sleepProgress, (float)0.29181904f, (float)0.0f);
            this.RLeg.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)-0.03647738f, (float)0.0f);
            this.RLeg.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)-5.2359875E-4f, (float)0.0f);
            this.RLeg.f_104205_ = Mth.m_14179_((float)sleepProgress, (float)-0.2919936f, (float)0.0f);
            this.Head.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.22287856f, (float)0.0f);
            this.Tail.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)-0.40543997f, (float)0.0f);
            this.Tail.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)-0.14608406f, (float)0.0f);
            this.RArm.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)-1.3891075f, (float)0.0f);
            this.RArm.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)-0.10995574f, (float)0.0f);
            this.LArm.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)-1.2407545f, (float)0.0f);
            this.LArm.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)0.25534168f, (float)0.0f);
            this.Torso.f_104201_ = Mth.m_14179_((float)sleepProgress, (float)17.0f, (float)15.0f);
            this.Torso.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.14590952f, (float)0.0f);
        } else {
            this.LArm.f_104203_ = Mth.m_14089_((float)(limbSwing / 3.0f * speed * 0.3f)) * degree * 0.8f * limbSwingAmount;
            this.RArm.f_104203_ = Mth.m_14089_((float)(limbSwing / 3.0f * speed * 0.3f)) * degree * -0.8f * limbSwingAmount;
            this.RLeg.f_104203_ = Mth.m_14089_((float)(limbSwing / 3.0f * speed * 0.3f)) * degree * 0.8f * limbSwingAmount;
            this.LLeg.f_104203_ = Mth.m_14089_((float)(limbSwing / 3.0f * speed * 0.3f)) * degree * -0.8f * limbSwingAmount;
            this.Tail.f_104204_ = -0.12f * Mth.m_14031_((float)(0.2f * ageInTicks / 5.0f)) + Mth.m_14089_((float)(limbSwing / 3.0f * speed * 0.15f)) * degree * 0.35f * limbSwingAmount + attackProgress * leftOrRight * (float)Math.toRadians(-15.0);
            this.Head.f_104203_ = Math.abs(-0.025f * Mth.m_14031_((float)(0.1f * ageInTicks / 3.0f))) + (Mth.m_14089_((float)(limbSwing / 3.0f * speed * 0.3f)) * degree * 0.1f * limbSwingAmount + 0.15f) + headPitch * ((float)Math.PI / 180);
            this.Head.f_104204_ = netHeadYaw * ((float)Math.PI / 180);
            this.Torso.f_104204_ = attackProgress * leftOrRight * (float)Math.toRadians(-200.0);
            this.Tail.f_104205_ = attackProgress * leftOrRight * (float)Math.toRadians(15.0);
            this.Torso.f_104202_ = 0.0f + attackProgress * -22.0f;
            if (entity.m_20069_()) {
                this.Head.f_104203_ = -0.1f;
            }
            if (entity.isEating()) {
                this.Head.f_104203_ = Math.abs(Mth.m_14031_((float)(0.05f * ageInTicks)) * 0.5f) + 0.25f;
                this.Torso.f_104203_ = 0.1f;
                this.LLeg.f_104203_ = -0.1f;
                this.RLeg.f_104203_ = -0.1f;
                this.RArm.f_104203_ = -0.1f;
                this.LArm.f_104203_ = -0.1f;
                this.RArm.f_104205_ = 0.3f;
                this.LArm.f_104205_ = -0.3f;
            }
        }
    }

    public void resetModel() {
        this.LLeg.f_104203_ = 0.0f;
        this.LLeg.f_104204_ = 0.0f;
        this.LLeg.f_104205_ = 0.0f;
        this.RLeg.f_104203_ = 0.0f;
        this.RLeg.f_104204_ = 0.0f;
        this.RLeg.f_104205_ = 0.0f;
        this.Head.f_104203_ = 0.0f;
        this.Tail.f_104203_ = 0.0f;
        this.Tail.f_104204_ = 0.0f;
        this.RArm.f_104203_ = 0.0f;
        this.RArm.f_104204_ = 0.0f;
        this.RArm.f_104205_ = 0.0f;
        this.LArm.f_104203_ = 0.0f;
        this.LArm.f_104204_ = 0.0f;
        this.LArm.f_104205_ = 0.0f;
        this.Torso.f_104203_ = 0.0f;
        this.Torso.f_104201_ = 15.0f;
    }

    public void setSleepingPose() {
        this.Torso.f_104201_ = 17.0f;
        this.LLeg.f_104203_ = 0.03473205f;
        this.LLeg.f_104205_ = 0.29181904f;
        this.Head.f_104203_ = -0.35116026f;
        this.Tail.f_104203_ = -0.40543997f;
        this.Tail.f_104204_ = -0.14608406f;
        this.RArm.f_104203_ = -1.3891075f;
        this.RArm.f_104204_ = -0.10995574f;
        this.LArm.f_104203_ = -1.2407545f;
        this.LArm.f_104204_ = 0.25534168f;
        this.Torso.f_104203_ = 0.14590952f;
        this.RLeg.f_104203_ = -0.03647738f;
        this.RLeg.f_104204_ = -5.2359875E-4f;
        this.RLeg.f_104205_ = -0.2919936f;
        this.Head.f_104203_ = 0.22287856f;
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.Torso.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
    }
}

