/*
 * Decompiled with CFR 0.152.
 */
package superlord.prehistoricfauna.client.model.cretaceous.djadochta;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import superlord.prehistoricfauna.common.entity.DinosaurEntity;
import superlord.prehistoricfauna.common.entity.cretaceous.djadochta.Oviraptor;

public class OviraptorModel
extends EntityModel<Oviraptor> {
    private final ModelPart Body;
    private final ModelPart Neck1;
    private final ModelPart LeftWing;
    private final ModelPart RightWing;
    private final ModelPart LeftThigh;
    private final ModelPart LeftLeg;
    private final ModelPart LeftFoot;
    private final ModelPart RightThigh;
    private final ModelPart RightLeg;
    private final ModelPart RightFoot;
    private final ModelPart Tail;

    public OviraptorModel(ModelPart root) {
        this.Body = root.m_171324_("Body");
        this.Neck1 = this.Body.m_171324_("Neck1");
        this.LeftWing = this.Body.m_171324_("LeftWing");
        this.RightWing = this.Body.m_171324_("RightWing");
        this.LeftThigh = this.Body.m_171324_("LeftThigh");
        this.LeftLeg = this.LeftThigh.m_171324_("LeftLeg");
        this.LeftFoot = this.LeftLeg.m_171324_("LeftFoot");
        this.RightThigh = this.Body.m_171324_("RightThigh");
        this.RightLeg = this.RightThigh.m_171324_("RightLeg");
        this.RightFoot = this.RightLeg.m_171324_("RightFoot");
        this.Tail = this.Body.m_171324_("Tail");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition Body = partdefinition.m_171599_("Body", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-2.0f, -3.0f, 0.0f, 4.0f, 6.0f, 10.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)16.0f, (float)-5.0f));
        PartDefinition Neck1 = Body.m_171599_("Neck1", CubeListBuilder.m_171558_().m_171514_(40, 1).m_171488_(-1.0f, -1.5f, -5.0f, 2.0f, 3.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-0.5f, (float)0.0f));
        PartDefinition Neck2 = Neck1.m_171599_("Neck2", CubeListBuilder.m_171558_().m_171514_(25, 19).m_171488_(-1.0f, -2.0f, -2.0f, 2.0f, 2.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-1.5f, (float)-3.0f));
        PartDefinition Head = Neck2.m_171599_("Head", CubeListBuilder.m_171558_().m_171514_(43, 11).m_171488_(-1.0f, -3.0f, -4.0f, 2.0f, 3.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-2.0f, (float)0.0f));
        PartDefinition RightWing = Body.m_171599_("RightWing", CubeListBuilder.m_171558_().m_171514_(18, 0).m_171480_().m_171488_(0.0f, -1.0f, -1.9f, 1.0f, 6.0f, 4.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)1.5f, (float)1.0f, (float)2.0f));
        PartDefinition LeftWing = Body.m_171599_("LeftWing", CubeListBuilder.m_171558_().m_171514_(18, 0).m_171488_(-1.0f, -1.0f, -1.9f, 1.0f, 6.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-1.5f, (float)1.0f, (float)2.0f));
        PartDefinition Tail = Body.m_171599_("Tail", CubeListBuilder.m_171558_().m_171514_(17, 5).m_171488_(-1.0f, -1.0f, -1.0f, 2.0f, 3.0f, 11.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-1.0f, (float)10.0f));
        PartDefinition TailFeathers = Tail.m_171599_("TailFeathers", CubeListBuilder.m_171558_().m_171514_(6, 16).m_171488_(-1.0f, 0.0f, 0.0f, 2.0f, 2.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)2.0f, (float)3.0f));
        PartDefinition LeftThigh = Body.m_171599_("LeftThigh", CubeListBuilder.m_171558_().m_171514_(32, 6).m_171488_(-2.0f, -1.0f, -2.0f, 2.0f, 6.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-1.0f, (float)-1.0f, (float)7.0f));
        PartDefinition LeftLeg = LeftThigh.m_171599_("LeftLeg", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-0.5f, 0.0f, 0.0f, 1.0f, 4.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-1.0f, (float)5.0f, (float)2.0f));
        PartDefinition LeftFoot = LeftLeg.m_171599_("LeftFoot", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171480_().m_171488_(-1.5f, 0.0f, -2.0f, 3.0f, 0.0f, 2.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)0.0f, (float)4.0f, (float)0.0f));
        PartDefinition RightThigh = Body.m_171599_("RightThigh", CubeListBuilder.m_171558_().m_171514_(32, 6).m_171488_(0.0f, -1.0f, -2.0f, 2.0f, 6.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)1.0f, (float)-1.0f, (float)7.0f));
        PartDefinition RightLeg = RightThigh.m_171599_("RightLeg", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-0.5f, 0.0f, 0.0f, 1.0f, 4.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)1.0f, (float)5.0f, (float)2.0f));
        PartDefinition RightFoot = RightLeg.m_171599_("RightFoot", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-1.5f, 0.0f, -2.0f, 3.0f, 0.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)4.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)58, (int)25);
    }

    public void setupAnim(Oviraptor entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        float partialTick = ageInTicks - (float)entity.f_19797_;
        float sleepProgress = entity.getSleepProgress(partialTick);
        this.resetModel();
        if (entity.isAsleep()) {
            if (sleepProgress != 0.0f && (Integer)entity.m_20088_().m_135370_(DinosaurEntity.SLEEP_TICK) > 0) {
                this.Body.f_104201_ = Mth.m_14179_((float)sleepProgress, (float)16.0f, (float)19.5f);
                this.Neck1.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)0.3491f);
                this.Neck1.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)0.5672f);
                this.RightWing.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)0.0873f);
                this.RightWing.f_104205_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-0.7854f);
                this.LeftWing.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)0.0873f);
                this.LeftWing.f_104205_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)0.7854f);
                this.Tail.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-0.3054f);
                this.Tail.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-0.3491f);
                this.LeftThigh.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-0.4363f);
                this.LeftThigh.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)0.1745f);
                this.LeftLeg.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-1.1345f);
                this.LeftFoot.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)1.5708f);
                this.RightThigh.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-0.4363f);
                this.RightThigh.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-0.1745f);
                this.RightLeg.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-1.1345f);
                this.RightFoot.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)1.5708f);
            } else {
                this.setSleepingPose();
            }
        } else if (sleepProgress != 0.0f && (Integer)entity.m_20088_().m_135370_(DinosaurEntity.SLEEP_TICK) > 0) {
            this.Body.f_104201_ = Mth.m_14179_((float)sleepProgress, (float)19.5f, (float)16.0f);
            this.Neck1.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.3491f, (float)0.0f);
            this.Neck1.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)0.5672f, (float)0.0f);
            this.RightWing.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.0873f, (float)0.0f);
            this.RightWing.f_104205_ = Mth.m_14179_((float)sleepProgress, (float)-0.7854f, (float)0.0f);
            this.LeftWing.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.0873f, (float)0.0f);
            this.LeftWing.f_104205_ = Mth.m_14179_((float)sleepProgress, (float)0.7854f, (float)0.0f);
            this.Tail.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)-0.3054f, (float)0.0f);
            this.Tail.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)-0.3491f, (float)0.0f);
            this.LeftThigh.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)-0.4363f, (float)0.0f);
            this.LeftThigh.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)0.1745f, (float)0.0f);
            this.LeftLeg.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)-1.1345f, (float)0.0f);
            this.LeftFoot.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)1.5708f, (float)0.0f);
            this.RightThigh.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)-0.4363f, (float)0.0f);
            this.RightThigh.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)-0.1745f, (float)0.0f);
            this.RightLeg.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)-1.1345f, (float)0.0f);
            this.RightFoot.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)1.5708f, (float)0.0f);
        } else {
            float attackProgress = entity.getMeleeProgress(partialTick);
            this.Neck1.f_104204_ = netHeadYaw * ((float)Math.PI / 180);
            this.RightThigh.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
            this.LeftThigh.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
            this.Tail.f_104204_ = -0.12f * Mth.m_14031_((float)(0.2f * ageInTicks / 5.0f));
            this.Tail.f_104203_ = -Math.abs(-0.05f * Mth.m_14031_((float)(0.1f * ageInTicks / 5.0f)));
            this.Body.f_104203_ = Math.abs(-0.025f * Mth.m_14031_((float)(0.1f * ageInTicks / 3.0f)));
            this.Neck1.f_104203_ = headPitch * ((float)Math.PI / 180) + Math.abs(-0.025f * Mth.m_14031_((float)(0.1f * ageInTicks / 3.0f))) + attackProgress * (float)Math.toRadians(40.0);
            this.LeftWing.f_104205_ = -Math.abs(-0.05f * Mth.m_14031_((float)(0.15f * ageInTicks / 3.0f))) + attackProgress * (float)Math.toRadians(-50.0);
            this.RightWing.f_104205_ = Math.abs(-0.05f * Mth.m_14031_((float)(0.15f * ageInTicks / 3.0f))) + attackProgress * (float)Math.toRadians(50.0);
            if (entity.isEating()) {
                this.Body.f_104203_ = 0.5f;
                this.LeftThigh.f_104203_ = -0.5f;
                this.RightThigh.f_104203_ = -0.5f;
                this.Neck1.f_104203_ = Math.abs(Mth.m_14031_((float)(0.05f * ageInTicks)) * 0.75f) + 0.5f;
            }
            if (entity.m_20069_()) {
                this.Body.f_104201_ = 17.0f;
                this.Body.f_104203_ = -0.25f;
                this.Tail.f_104203_ = 0.25f;
                this.Neck1.f_104203_ = 0.25f + headPitch * ((float)Math.PI / 180) + Math.abs(-0.025f * Mth.m_14031_((float)(0.1f * ageInTicks / 3.0f))) + attackProgress * (float)Math.toRadians(40.0);
                this.LeftWing.f_104205_ = 0.5f + Math.abs(-1.0f * Mth.m_14031_((float)(0.15f * ageInTicks / 2.0f)));
                this.RightWing.f_104205_ = -0.5f - Math.abs(-1.0f * Mth.m_14031_((float)(0.15f * ageInTicks / 2.0f)));
                this.LeftThigh.f_104203_ = -0.25f * Mth.m_14031_((float)(0.2f * ageInTicks / 1.5f));
                this.RightThigh.f_104203_ = 0.25f * Mth.m_14031_((float)(0.2f * ageInTicks / 1.5f));
                this.Tail.f_104204_ = Mth.m_14089_((float)(limbSwing * 2.6662f)) * 1.4f * limbSwingAmount;
                this.LeftLeg.f_104203_ = -0.3f * Mth.m_14031_((float)(0.2f * ageInTicks / 1.5f));
                this.RightLeg.f_104203_ = 0.3f * Mth.m_14031_((float)(0.2f * ageInTicks / 1.5f));
            }
        }
    }

    public void resetModel() {
        this.Body.f_104201_ = 16.0f;
        this.Body.f_104203_ = 0.0f;
        this.Neck1.f_104203_ = 0.0f;
        this.Neck1.f_104204_ = 0.0f;
        this.RightWing.f_104203_ = 0.0f;
        this.RightWing.f_104205_ = 0.0f;
        this.LeftWing.f_104203_ = 0.0f;
        this.LeftWing.f_104205_ = 0.0f;
        this.Tail.f_104203_ = 0.0f;
        this.Tail.f_104204_ = 0.0f;
        this.LeftThigh.f_104203_ = 0.0f;
        this.LeftThigh.f_104204_ = 0.0f;
        this.LeftLeg.f_104203_ = 0.0f;
        this.LeftFoot.f_104203_ = 0.0f;
        this.RightThigh.f_104203_ = 0.0f;
        this.RightThigh.f_104204_ = 0.0f;
        this.RightLeg.f_104203_ = 0.0f;
        this.RightFoot.f_104203_ = 0.0f;
    }

    public void setSleepingPose() {
        this.Body.f_104201_ = 19.5f;
        this.Neck1.f_104203_ = 0.3491f;
        this.Neck1.f_104204_ = 0.5672f;
        this.RightWing.f_104203_ = 0.0873f;
        this.RightWing.f_104205_ = -0.7854f;
        this.LeftWing.f_104203_ = 0.0873f;
        this.LeftWing.f_104205_ = 0.7854f;
        this.Tail.f_104203_ = -0.3054f;
        this.Tail.f_104204_ = -0.3491f;
        this.LeftThigh.f_104203_ = -0.4363f;
        this.LeftThigh.f_104204_ = 0.1745f;
        this.LeftLeg.f_104203_ = -1.1345f;
        this.LeftFoot.f_104203_ = 1.5708f;
        this.RightThigh.f_104203_ = -0.4363f;
        this.RightThigh.f_104204_ = -0.1745f;
        this.RightLeg.f_104203_ = -1.1345f;
        this.RightFoot.f_104203_ = 1.5708f;
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.Body.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
    }
}

