/*
 * Decompiled with CFR 0.152.
 */
package superlord.prehistoricfauna.client.model.cretaceous.djadochta;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.ArmedModel;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.HumanoidArm;
import superlord.prehistoricfauna.common.entity.DinosaurEntity;
import superlord.prehistoricfauna.common.entity.cretaceous.djadochta.Halszkaraptor;

public class HalszkaraptorModel
extends EntityModel<Halszkaraptor>
implements ArmedModel {
    private final ModelPart Body;
    private final ModelPart RLeg;
    private final ModelPart LLeg;
    private final ModelPart RWing;
    private final ModelPart LWing;
    private final ModelPart Neck;
    private final ModelPart Head;
    private final ModelPart Tail;

    public HalszkaraptorModel(ModelPart root) {
        this.Body = root.m_171324_("Body");
        this.Neck = this.Body.m_171324_("Neck");
        this.RLeg = this.Body.m_171324_("RLeg");
        this.LLeg = this.Body.m_171324_("LLeg");
        this.Tail = this.Body.m_171324_("Tail");
        this.RWing = this.Body.m_171324_("RWing");
        this.LWing = this.Body.m_171324_("LWing");
        this.Head = this.Neck.m_171324_("Head");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition Body = partdefinition.m_171599_("Body", CubeListBuilder.m_171558_().m_171514_(1, 15).m_171488_(-2.5f, 0.0f, 0.0f, 3.0f, 3.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)1.0f, (float)17.0f, (float)-4.0f));
        PartDefinition Neck = Body.m_171599_("Neck", CubeListBuilder.m_171558_().m_171514_(2, 3).m_171488_(-1.0f, -4.0f, -1.0f, 2.0f, 6.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-1.0f, (float)0.0f, (float)0.0f));
        PartDefinition Head = Neck.m_171599_("Head", CubeListBuilder.m_171558_().m_171514_(12, 2).m_171488_(-1.0f, -2.0f, -1.0f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.01f)), PartPose.m_171419_((float)0.0f, (float)-3.0f, (float)-1.0f));
        PartDefinition Mouth = Head.m_171599_("Mouth", CubeListBuilder.m_171558_().m_171514_(22, 3).m_171488_(-1.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.5f, (float)-1.0f, (float)-2.0f));
        PartDefinition LWing = Body.m_171599_("LWing", CubeListBuilder.m_171558_().m_171514_(14, 13).m_171488_(0.0f, -1.0f, -1.0f, 1.0f, 2.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.5f, (float)1.0f, (float)2.0f));
        PartDefinition RWing = Body.m_171599_("RWing", CubeListBuilder.m_171558_().m_171514_(14, 13).m_171480_().m_171488_(-1.0f, -1.0f, -1.0f, 1.0f, 2.0f, 4.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)-2.5f, (float)1.0f, (float)2.0f));
        PartDefinition Tail = Body.m_171599_("Tail", CubeListBuilder.m_171558_().m_171514_(16, 21).m_171488_(-1.0f, -1.0f, 0.0f, 2.0f, 2.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-1.0f, (float)1.0f, (float)5.0f));
        PartDefinition RLeg = Body.m_171599_("RLeg", CubeListBuilder.m_171558_().m_171514_(3, 25).m_171480_().m_171488_(-0.5f, 0.0f, 0.0f, 1.0f, 4.0f, 1.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)-2.0f, (float)3.0f, (float)3.0f));
        PartDefinition LLeg = Body.m_171599_("LLeg", CubeListBuilder.m_171558_().m_171514_(3, 25).m_171488_(-0.5f, 0.0f, 0.0f, 1.0f, 4.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)3.0f, (float)3.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)32, (int)32);
    }

    public void setupAnim(Halszkaraptor entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        float partialTick = ageInTicks - (float)entity.f_19797_;
        float attackProgress = entity.getMeleeProgress(partialTick);
        float sleepProgress = entity.getSleepProgress(partialTick);
        this.resetModel();
        if (entity.isAsleep()) {
            if (sleepProgress != 0.0f && (Integer)entity.m_20088_().m_135370_(DinosaurEntity.SLEEP_TICK) > 0) {
                this.RLeg.f_104201_ = Mth.m_14179_((float)sleepProgress, (float)3.0f, (float)0.0f);
                this.LLeg.f_104201_ = Mth.m_14179_((float)sleepProgress, (float)3.0f, (float)0.0f);
                this.RWing.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-0.33004177f);
                this.RWing.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-0.21537364f);
                this.LWing.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-0.33004177f);
                this.LWing.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)0.21537364f);
                this.Neck.f_104201_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)2.4f);
                this.Neck.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-0.18221237f);
                this.Tail.f_104201_ = Mth.m_14179_((float)sleepProgress, (float)1.0f, (float)0.6f);
                this.Tail.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-0.21938789f);
                this.Tail.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-0.10960668f);
                this.Tail.f_104205_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-0.07295476f);
                this.Body.f_104201_ = Mth.m_14179_((float)sleepProgress, (float)17.0f, (float)20.8f);
                this.Body.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)0.07278023f);
            } else {
                this.sleepPose();
            }
        } else if (sleepProgress != 0.0f && (Integer)entity.m_20088_().m_135370_(DinosaurEntity.SLEEP_TICK) > 0) {
            this.RLeg.f_104201_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)3.0f);
            this.LLeg.f_104201_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)3.0f);
            this.RWing.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)-0.33004177f, (float)0.0f);
            this.RWing.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)-0.21537364f, (float)0.0f);
            this.LWing.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)-0.33004177f, (float)0.0f);
            this.LWing.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)0.21537364f, (float)0.0f);
            this.Neck.f_104201_ = Mth.m_14179_((float)sleepProgress, (float)2.4f, (float)0.0f);
            this.Neck.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)-0.18221237f, (float)0.0f);
            this.Tail.f_104201_ = Mth.m_14179_((float)sleepProgress, (float)0.6f, (float)1.0f);
            this.Tail.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)-0.21938789f, (float)0.0f);
            this.Tail.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)-0.10960668f, (float)0.0f);
            this.Tail.f_104205_ = Mth.m_14179_((float)sleepProgress, (float)-0.07295476f, (float)0.0f);
            this.Body.f_104201_ = Mth.m_14179_((float)sleepProgress, (float)20.8f, (float)17.0f);
            this.Body.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.07278023f, (float)0.0f);
        } else {
            this.Neck.f_104203_ = headPitch * ((float)Math.PI / 180) + Math.abs(-0.025f * Mth.m_14031_((float)(0.1f * ageInTicks / 3.0f))) + attackProgress * (float)Math.toRadians(40.0);
            this.RWing.f_104205_ = -Math.abs(-0.05f * Mth.m_14031_((float)(0.15f * ageInTicks / 3.0f))) + attackProgress * (float)Math.toRadians(-50.0);
            this.LWing.f_104205_ = Math.abs(-0.05f * Mth.m_14031_((float)(0.15f * ageInTicks / 3.0f))) + attackProgress * (float)Math.toRadians(50.0);
            this.Neck.f_104204_ = netHeadYaw * ((float)Math.PI / 180);
            this.LLeg.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
            this.RLeg.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
            this.Tail.f_104204_ = -0.12f * Mth.m_14031_((float)(0.2f * ageInTicks / 5.0f));
            this.Tail.f_104203_ = -Math.abs(-0.05f * Mth.m_14031_((float)(0.1f * ageInTicks / 5.0f)));
            this.RWing.f_104204_ = Math.abs(-0.05f * Mth.m_14031_((float)(0.15f * ageInTicks / 3.0f)));
            this.LWing.f_104204_ = -Math.abs(-0.05f * Mth.m_14031_((float)(0.15f * ageInTicks / 3.0f)));
            if (entity.m_20069_()) {
                this.Body.f_104201_ = 17.0f;
                this.Body.f_104203_ = -0.25f;
                this.Tail.f_104203_ = 0.25f;
                this.Neck.f_104203_ = 0.25f;
                this.LWing.f_104205_ = -1.5f + Math.abs(-1.0f * Mth.m_14031_((float)(0.15f * ageInTicks / 2.0f)));
                this.RWing.f_104205_ = 1.5f - Math.abs(-1.0f * Mth.m_14031_((float)(0.15f * ageInTicks / 2.0f)));
                this.RLeg.f_104203_ = -0.25f * Mth.m_14031_((float)(0.2f * ageInTicks / 1.5f));
                this.LLeg.f_104203_ = 0.25f * Mth.m_14031_((float)(0.2f * ageInTicks / 1.5f));
                this.Tail.f_104204_ = Mth.m_14089_((float)(limbSwing * 2.6662f)) * 1.4f * limbSwingAmount;
            }
        }
    }

    public void resetModel() {
        this.RLeg.f_104201_ = 3.0f;
        this.LLeg.f_104201_ = 3.0f;
        this.RWing.f_104201_ = 1.0f;
        this.RWing.f_104203_ = 0.0f;
        this.RWing.f_104204_ = 0.0f;
        this.RWing.f_104205_ = 0.0f;
        this.LWing.f_104201_ = 1.0f;
        this.LWing.f_104203_ = 0.0f;
        this.LWing.f_104204_ = 0.0f;
        this.LWing.f_104205_ = 0.0f;
        this.Neck.f_104201_ = 0.0f;
        this.Neck.f_104203_ = 0.0f;
        this.Neck.f_104204_ = 0.0f;
        this.Tail.f_104201_ = 1.0f;
        this.Tail.f_104203_ = 0.0f;
        this.Tail.f_104204_ = 0.0f;
        this.Tail.f_104205_ = 0.0f;
        this.Body.f_104201_ = 17.0f;
        this.Body.f_104203_ = 0.0f;
    }

    public void sleepPose() {
        this.RLeg.f_104201_ = 0.0f;
        this.LLeg.f_104201_ = 0.0f;
        this.RWing.f_104203_ = -0.33004177f;
        this.RWing.f_104204_ = -0.21537364f;
        this.LWing.f_104203_ = -0.33004177f;
        this.LWing.f_104204_ = 0.21537364f;
        this.Neck.f_104201_ = 2.4f;
        this.Neck.f_104203_ = -0.18221237f;
        this.Tail.f_104201_ = 0.6f;
        this.Tail.f_104203_ = -0.21938789f;
        this.Tail.f_104204_ = -0.10960668f;
        this.Tail.f_104205_ = -0.07295476f;
        this.Body.f_104201_ = 20.8f;
        this.Body.f_104203_ = 0.07278023f;
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.Body.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
    }

    public void m_6002_(HumanoidArm sideIn, PoseStack matrixStackIn) {
        float f = sideIn == HumanoidArm.RIGHT ? 1.0f : -1.0f;
        ModelPart modelrenderer = this.getArmForSide(sideIn);
        modelrenderer.f_104200_ += f;
        modelrenderer.m_104299_(matrixStackIn);
        modelrenderer.f_104200_ -= f;
        matrixStackIn.m_85837_(0.0, 0.7, 0.0);
    }

    protected ModelPart getArmForSide(HumanoidArm side) {
        return side == HumanoidArm.LEFT ? this.Head : this.Head;
    }
}

