/*
 * Decompiled with CFR 0.152.
 */
package superlord.prehistoricfauna.client.model.cretaceous.djadochta;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import superlord.prehistoricfauna.common.entity.DinosaurEntity;
import superlord.prehistoricfauna.common.entity.cretaceous.djadochta.Goyocephale;

public class GoyocephaleModel
extends EntityModel<Goyocephale> {
    private final ModelPart Hip;
    private final ModelPart Tail;
    private final ModelPart Chest;
    private final ModelPart Neck;
    private final ModelPart Head;
    private final ModelPart RightArm;
    private final ModelPart LeftArm;
    private final ModelPart LeftThigh;
    private final ModelPart LeftLeg;
    private final ModelPart LeftFoot;
    private final ModelPart RightThigh;
    private final ModelPart RightLeg;
    private final ModelPart RightFoot;

    public GoyocephaleModel(ModelPart root) {
        this.Hip = root.m_171324_("Hip");
        this.Tail = this.Hip.m_171324_("Tail");
        this.Chest = this.Hip.m_171324_("Chest");
        this.Neck = this.Chest.m_171324_("Neck");
        this.Head = this.Neck.m_171324_("Head");
        this.LeftArm = this.Chest.m_171324_("LeftArm");
        this.RightArm = this.Chest.m_171324_("RightArm");
        this.LeftThigh = this.Hip.m_171324_("LeftThigh");
        this.LeftLeg = this.LeftThigh.m_171324_("LeftLeg");
        this.LeftFoot = this.LeftLeg.m_171324_("LeftFoot");
        this.RightThigh = this.Hip.m_171324_("RightThigh");
        this.RightLeg = this.RightThigh.m_171324_("RightLeg");
        this.RightFoot = this.RightLeg.m_171324_("RightFoot");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition Hip = partdefinition.m_171599_("Hip", CubeListBuilder.m_171558_().m_171514_(21, 0).m_171488_(-2.5f, -2.0f, 0.0f, 5.0f, 4.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)15.0f, (float)0.0f));
        PartDefinition Chest = Hip.m_171599_("Chest", CubeListBuilder.m_171558_().m_171514_(0, 2).m_171488_(-3.0f, -2.0f, -8.0f, 6.0f, 5.0f, 8.0f, new CubeDeformation(0.0f)).m_171514_(41, 45).m_171488_(-1.0f, 3.0f, -8.0f, 2.0f, 3.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition LeftArm = Chest.m_171599_("LeftArm", CubeListBuilder.m_171558_().m_171514_(1, 2).m_171488_(-0.5f, 0.0f, -1.0f, 1.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)3.0f, (float)2.0f, (float)-6.0f));
        PartDefinition RightArm = Chest.m_171599_("RightArm", CubeListBuilder.m_171558_().m_171514_(1, 2).m_171480_().m_171488_(-0.5f, 0.0f, -1.0f, 1.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)-3.0f, (float)2.0f, (float)-6.0f));
        PartDefinition Neck = Chest.m_171599_("Neck", CubeListBuilder.m_171558_().m_171514_(1, 16).m_171488_(-1.0f, -4.5f, -2.5f, 2.0f, 5.0f, 3.0f, new CubeDeformation(0.0f)).m_171514_(14, 15).m_171488_(-0.5f, 0.5f, -2.5f, 1.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.5f, (float)-7.5f));
        PartDefinition Head = Neck.m_171599_("Head", CubeListBuilder.m_171558_().m_171514_(1, 30).m_171488_(-1.5f, -1.999f, -4.0f, 3.0f, 2.0f, 4.0f, new CubeDeformation(0.0f)).m_171514_(1, 25).m_171488_(-2.5f, -2.0f, -1.0f, 5.0f, 1.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-3.5f, (float)-0.5f));
        PartDefinition LeftThigh = Hip.m_171599_("LeftThigh", CubeListBuilder.m_171558_().m_171514_(29, 10).m_171488_(-1.0f, -1.0f, -2.0f, 2.0f, 6.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)2.5f, (float)0.0f, (float)2.0f));
        PartDefinition LeftLeg = LeftThigh.m_171599_("LeftLeg", CubeListBuilder.m_171558_().m_171514_(38, 25).m_171488_(-0.5f, 0.0f, 0.0f, 1.0f, 4.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)5.0f, (float)2.0f));
        PartDefinition LeftFoot = LeftLeg.m_171599_("LeftFoot", CubeListBuilder.m_171558_().m_171514_(33, 23).m_171488_(-1.5f, 0.0f, -2.0f, 3.0f, 0.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)4.0f, (float)0.0f));
        PartDefinition RightThigh = Hip.m_171599_("RightThigh", CubeListBuilder.m_171558_().m_171514_(29, 10).m_171480_().m_171488_(-1.0f, -1.0f, -2.0f, 2.0f, 6.0f, 4.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)-2.5f, (float)0.0f, (float)2.0f));
        PartDefinition RightLeg = RightThigh.m_171599_("RightLeg", CubeListBuilder.m_171558_().m_171514_(38, 25).m_171480_().m_171488_(-0.5f, 0.0f, 0.0f, 1.0f, 4.0f, 0.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)0.0f, (float)5.0f, (float)2.0f));
        PartDefinition RightFoot = RightLeg.m_171599_("RightFoot", CubeListBuilder.m_171558_().m_171514_(33, 23).m_171480_().m_171488_(-1.5f, 0.0f, -2.0f, 3.0f, 0.0f, 2.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)0.0f, (float)4.0f, (float)0.0f));
        PartDefinition Tail = Hip.m_171599_("Tail", CubeListBuilder.m_171558_().m_171514_(12, 18).m_171488_(-1.0f, -1.0f, -1.0f, 2.0f, 2.0f, 12.0f, new CubeDeformation(0.0f)).m_171514_(41, 0).m_171488_(-2.0f, -2.0f, 0.0f, 1.0f, 1.0f, 10.0f, new CubeDeformation(0.0f)).m_171514_(41, 22).m_171488_(-2.0f, 1.0f, 0.0f, 1.0f, 1.0f, 10.0f, new CubeDeformation(0.0f)).m_171514_(41, 11).m_171488_(1.0f, -2.0f, 0.0f, 1.0f, 1.0f, 10.0f, new CubeDeformation(0.0f)).m_171514_(41, 33).m_171488_(1.0f, 1.0f, 0.0f, 1.0f, 1.0f, 10.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)5.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)56);
    }

    public void setupAnim(Goyocephale entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        float partialTick = ageInTicks - (float)entity.f_19797_;
        float sleepProgress = entity.getSleepProgress(partialTick);
        this.resetModel();
        if (entity.isAsleep()) {
            if (sleepProgress != 0.0f && (Integer)entity.m_20088_().m_135370_(DinosaurEntity.SLEEP_TICK) > 0) {
                this.LeftLeg.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-0.4537856f);
                this.LeftThigh.f_104201_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)0.2f);
                this.LeftThigh.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-0.87266463f);
                this.LeftThigh.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-0.29670596f);
                this.LeftArm.f_104202_ = Mth.m_14179_((float)sleepProgress, (float)-6.0f, (float)-6.5f);
                this.LeftArm.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)0.87266463f);
                this.LeftFoot.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)1.5707964f);
                this.RightFoot.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)1.5707964f);
                this.Hip.f_104201_ = Mth.m_14179_((float)sleepProgress, (float)15.0f, (float)19.0f);
                this.Hip.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-0.2443461f);
                this.RightThigh.f_104201_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)0.2f);
                this.RightThigh.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-0.87266463f);
                this.RightThigh.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)0.29670596f);
                this.Neck.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)0.87266463f);
                this.Neck.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)0.9773844f);
                this.Head.f_104200_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)0.5f);
                this.Head.f_104202_ = Mth.m_14179_((float)sleepProgress, (float)-0.5f, (float)-1.5f);
                this.Head.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)0.55850536f);
                this.Head.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)1.3962634f);
                this.RightLeg.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-0.4537856f);
                this.RightArm.f_104202_ = Mth.m_14179_((float)sleepProgress, (float)-6.0f, (float)-6.5f);
                this.RightArm.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)0.87266463f);
                this.Tail.f_104200_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-0.5f);
                this.Tail.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)0.07853982f);
                this.Tail.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-0.5934119f);
                this.Tail.f_104205_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-0.10471976f);
            } else {
                this.sleepPose();
            }
        } else if (sleepProgress != 0.0f && (Integer)entity.m_20088_().m_135370_(DinosaurEntity.SLEEP_TICK) > 0) {
            this.LeftLeg.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)-0.4537856f, (float)0.0f);
            this.LeftThigh.f_104201_ = Mth.m_14179_((float)sleepProgress, (float)0.2f, (float)0.0f);
            this.LeftThigh.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)-0.87266463f, (float)0.0f);
            this.LeftThigh.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)-0.29670596f, (float)0.0f);
            this.LeftArm.f_104202_ = Mth.m_14179_((float)sleepProgress, (float)-6.5f, (float)-6.0f);
            this.LeftArm.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.87266463f, (float)0.0f);
            this.LeftFoot.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)1.5707964f, (float)0.0f);
            this.RightFoot.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)1.5707964f, (float)0.0f);
            this.Hip.f_104201_ = Mth.m_14179_((float)sleepProgress, (float)19.0f, (float)15.0f);
            this.Hip.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)-0.2443461f, (float)0.0f);
            this.RightThigh.f_104201_ = Mth.m_14179_((float)sleepProgress, (float)0.2f, (float)0.0f);
            this.RightThigh.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)-0.87266463f, (float)0.0f);
            this.RightThigh.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)0.29670596f, (float)0.0f);
            this.Neck.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.87266463f, (float)0.0f);
            this.Neck.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)0.9773844f, (float)0.0f);
            this.Head.f_104200_ = Mth.m_14179_((float)sleepProgress, (float)0.5f, (float)0.0f);
            this.Head.f_104202_ = Mth.m_14179_((float)sleepProgress, (float)-1.5f, (float)-0.5f);
            this.Head.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.55850536f, (float)0.0f);
            this.Head.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)1.3962634f, (float)0.0f);
            this.RightLeg.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)-0.4537856f, (float)0.0f);
            this.RightArm.f_104202_ = Mth.m_14179_((float)sleepProgress, (float)-6.5f, (float)-6.0f);
            this.RightArm.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.87266463f, (float)0.0f);
            this.Tail.f_104200_ = Mth.m_14179_((float)sleepProgress, (float)-0.5f, (float)-0.0f);
            this.Tail.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.07853982f, (float)0.0f);
            this.Tail.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)-0.5934119f, (float)0.0f);
            this.Tail.f_104205_ = Mth.m_14179_((float)sleepProgress, (float)-0.10471976f, (float)0.0f);
        } else {
            this.LeftThigh.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
            this.RightThigh.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
            this.Tail.f_104204_ = -0.12f * Mth.m_14031_((float)(0.2f * ageInTicks / 5.0f));
            this.Tail.f_104203_ = -Math.abs(-0.05f * Mth.m_14031_((float)(0.1f * ageInTicks / 5.0f)));
            this.Neck.f_104203_ = headPitch * ((float)Math.PI / 180) + Math.abs(-0.025f * Mth.m_14031_((float)(0.1f * ageInTicks / 3.0f)));
            this.RightArm.f_104205_ = Math.abs(-0.05f * Mth.m_14031_((float)(0.15f * ageInTicks / 3.0f)));
            this.LeftArm.f_104205_ = -Math.abs(-0.05f * Mth.m_14031_((float)(0.15f * ageInTicks / 3.0f)));
            this.Neck.f_104204_ = netHeadYaw * ((float)Math.PI / 180);
            if (entity.isEating()) {
                this.Neck.f_104203_ = Math.abs(Mth.m_14031_((float)(0.05f * ageInTicks)) * 0.75f) + 0.5f;
            }
            if (entity.m_20069_()) {
                this.Hip.f_104201_ = 18.0f;
                this.Hip.f_104203_ = -0.5f;
                this.Tail.f_104203_ = 0.25f;
                this.Neck.f_104203_ = 0.5f;
                this.RightThigh.f_104203_ = -0.5f * Mth.m_14031_((float)(0.2f * ageInTicks / 1.5f));
                this.LeftThigh.f_104203_ = 0.5f * Mth.m_14031_((float)(0.2f * ageInTicks / 1.5f));
                this.RightLeg.f_104203_ = -0.3f * Mth.m_14031_((float)(0.2f * ageInTicks / 1.5f));
                this.LeftLeg.f_104203_ = 0.3f * Mth.m_14031_((float)(0.2f * ageInTicks / 1.5f));
                this.LeftArm.f_104203_ = 0.5f;
                this.RightArm.f_104203_ = 0.5f;
                this.Tail.f_104204_ = Mth.m_14089_((float)(limbSwing * 2.6662f)) * 1.4f * limbSwingAmount + 0.0625f * Mth.m_14031_((float)(0.15f * ageInTicks / 1.5f));
            }
        }
    }

    public void resetModel() {
        this.LeftLeg.f_104203_ = 0.0f;
        this.LeftThigh.f_104201_ = 0.0f;
        this.LeftThigh.f_104203_ = 0.0f;
        this.LeftThigh.f_104204_ = 0.0f;
        this.LeftArm.f_104202_ = -6.0f;
        this.LeftArm.f_104203_ = 0.0f;
        this.LeftFoot.f_104203_ = 0.0f;
        this.RightFoot.f_104203_ = 0.0f;
        this.Hip.f_104201_ = 15.0f;
        this.Hip.f_104203_ = 0.0f;
        this.RightThigh.f_104201_ = 0.0f;
        this.RightThigh.f_104203_ = 0.0f;
        this.RightThigh.f_104204_ = 0.0f;
        this.Neck.f_104203_ = 0.0f;
        this.Neck.f_104204_ = 0.0f;
        this.Head.f_104200_ = 0.0f;
        this.Head.f_104202_ = -0.5f;
        this.Head.f_104203_ = 0.0f;
        this.Head.f_104204_ = 0.0f;
        this.RightLeg.f_104203_ = 0.0f;
        this.RightArm.f_104202_ = -6.0f;
        this.RightArm.f_104203_ = 0.0f;
        this.Tail.f_104200_ = 0.0f;
        this.Tail.f_104202_ = 5.0f;
        this.Tail.f_104203_ = 0.0f;
        this.Tail.f_104204_ = 0.0f;
        this.Tail.f_104205_ = 0.0f;
    }

    public void sleepPose() {
        this.LeftLeg.f_104203_ = -0.4537856f;
        this.LeftThigh.f_104203_ = -0.87266463f;
        this.LeftThigh.f_104204_ = -0.29670596f;
        this.LeftThigh.f_104201_ = 0.2f;
        this.LeftArm.f_104202_ = -6.5f;
        this.LeftArm.f_104203_ = 0.87266463f;
        this.LeftFoot.f_104203_ = 1.5707964f;
        this.RightFoot.f_104203_ = 1.5707964f;
        this.Hip.f_104201_ = 19.0f;
        this.Hip.f_104203_ = -0.2443461f;
        this.RightThigh.f_104201_ = 0.2f;
        this.RightThigh.f_104203_ = -0.87266463f;
        this.RightThigh.f_104204_ = 0.29670596f;
        this.Neck.f_104203_ = 0.87266463f;
        this.Neck.f_104204_ = 0.9773844f;
        this.Head.f_104200_ = 0.5f;
        this.Head.f_104202_ = -1.5f;
        this.Head.f_104203_ = 0.55850536f;
        this.Head.f_104204_ = 1.3962634f;
        this.RightLeg.f_104203_ = -0.4537856f;
        this.RightArm.f_104203_ = 0.87266463f;
        this.RightArm.f_104202_ = -6.5f;
        this.Tail.f_104200_ = -0.5f;
        this.Tail.f_104202_ = 5.0f;
        this.Tail.f_104203_ = 0.07853982f;
        this.Tail.f_104204_ = -0.5934119f;
        this.Tail.f_104205_ = -0.10471976f;
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.Hip.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
    }
}

