/*
 * Decompiled with CFR 0.152.
 */
package superlord.prehistoricfauna.client.model.cretaceous.djadochta;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import superlord.prehistoricfauna.common.entity.DinosaurEntity;
import superlord.prehistoricfauna.common.entity.cretaceous.djadochta.Citipati;

public class CitipatiModel
extends EntityModel<Citipati> {
    private final ModelPart Body;
    private final ModelPart ThighLeft;
    private final ModelPart ThighRight;
    private final ModelPart LegLeft;
    private final ModelPart LegRight;
    private final ModelPart Neck;
    private final ModelPart Head;
    private final ModelPart WingLeft;
    private final ModelPart WingRight;
    private final ModelPart Tail;
    private final ModelPart TailFan;

    public CitipatiModel(ModelPart root) {
        this.Body = root.m_171324_("Body");
        this.ThighLeft = this.Body.m_171324_("ThighLeft");
        this.ThighRight = this.Body.m_171324_("ThighRight");
        this.LegLeft = this.ThighLeft.m_171324_("LegLeft");
        this.LegRight = this.ThighRight.m_171324_("LegRight");
        this.Neck = this.Body.m_171324_("Neck");
        this.Head = this.Neck.m_171324_("Head");
        this.WingLeft = this.Body.m_171324_("WingLeft");
        this.WingRight = this.Body.m_171324_("WingRight");
        this.Tail = this.Body.m_171324_("Tail");
        this.TailFan = this.Tail.m_171324_("TailFan");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition Body = partdefinition.m_171599_("Body", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-2.5f, -3.0f, -7.0f, 5.0f, 8.0f, 19.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)6.0f, (float)-4.0f));
        PartDefinition WingLeft = Body.m_171599_("WingLeft", CubeListBuilder.m_171558_().m_171514_(42, 21).m_171488_(-2.0f, -1.0f, -2.0f, 2.0f, 11.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-2.0f, (float)0.9f, (float)-3.0f));
        PartDefinition ThighLeft = Body.m_171599_("ThighLeft", CubeListBuilder.m_171558_().m_171514_(0, 44).m_171488_(-3.0f, -1.0f, -2.0f, 3.0f, 9.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-1.0f, (float)1.0f, (float)6.0f));
        PartDefinition LegLeft = ThighLeft.m_171599_("LegLeft", CubeListBuilder.m_171558_().m_171514_(0, 60).m_171480_().m_171488_(-1.0f, 0.0f, -4.0f, 3.0f, 9.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-1.5f, (float)8.0f, (float)4.0f));
        PartDefinition ThighRight = Body.m_171599_("ThighRight", CubeListBuilder.m_171558_().m_171514_(0, 44).m_171480_().m_171488_(0.0f, -1.0f, -2.0f, 3.0f, 9.0f, 6.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)1.0f, (float)1.0f, (float)6.0f));
        PartDefinition LegRight = ThighRight.m_171599_("LegRight", CubeListBuilder.m_171558_().m_171514_(0, 60).m_171488_(-2.0f, 0.0f, -4.0f, 3.0f, 9.0f, 4.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)1.5f, (float)8.0f, (float)4.0f));
        PartDefinition WingRight = Body.m_171599_("WingRight", CubeListBuilder.m_171558_().m_171514_(42, 21).m_171480_().m_171488_(0.0f, -1.0f, -2.0f, 2.0f, 11.0f, 6.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)2.0f, (float)1.0f, (float)-3.0f));
        PartDefinition Tail = Body.m_171599_("Tail", CubeListBuilder.m_171558_().m_171514_(40, 6).m_171488_(-2.0f, -2.0f, -1.0f, 4.0f, 5.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-0.5f, (float)12.0f));
        PartDefinition TailFan = Tail.m_171599_("TailFan", CubeListBuilder.m_171558_().m_171514_(0, 27).m_171488_(-2.5f, -1.0f, -1.0f, 5.0f, 3.0f, 14.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-0.5f, (float)7.5f));
        PartDefinition Neck = Body.m_171599_("Neck", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-1.5f, -11.0f, -2.0f, 3.0f, 15.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-1.0f, (float)-7.0f));
        PartDefinition Head = Neck.m_171599_("Head", CubeListBuilder.m_171558_().m_171514_(29, 0).m_171488_(-1.0f, -2.0f, -6.0f, 2.0f, 4.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-11.0f, (float)0.0f));
        PartDefinition Crest = Head.m_171599_("Crest", CubeListBuilder.m_171558_().m_171514_(41, 2).m_171488_(-1.0f, -2.0f, -2.0f, 2.0f, 1.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-1.0f, (float)-4.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)80);
    }

    public void setupAnim(Citipati entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        float partialTick = ageInTicks - (float)entity.f_19797_;
        float sleepProgress = entity.getSleepProgress(partialTick);
        this.resetModel();
        if (entity.isAsleep() || entity.isSitting()) {
            if (sleepProgress != 0.0f && (Integer)entity.m_20088_().m_135370_(DinosaurEntity.SLEEP_TICK) > 0) {
                this.WingRight.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)0.39025563f);
                this.WingRight.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)0.5866052f);
                this.WingRight.f_104205_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-0.74281216f);
                this.Head.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)0.9773844f);
                this.Head.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)0.11728612f);
                this.ThighLeft.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-1.0950196f);
                this.ThighLeft.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)0.35185838f);
                this.TailFan.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)0.07819075f);
                this.TailFan.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-0.27366763f);
                this.TailFan.f_104205_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-0.11728612f);
                this.ThighRight.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-1.1730357f);
                this.ThighRight.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-0.43004912f);
                this.WingLeft.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)0.1569051f);
                this.WingLeft.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-0.7429867f);
                this.WingLeft.f_104205_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)0.89901906f);
                this.Neck.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-0.35185838f);
                this.Neck.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)0.23457225f);
                this.Neck.f_104205_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-0.07819075f);
                this.LegLeft.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)0.16580628f);
                this.LegLeft.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)3.1398473f);
                this.LegLeft.f_104205_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)0.060737457f);
                this.LegRight.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)0.03874631f);
                this.LegRight.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)((float)Math.PI));
                this.Tail.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)0.23457225f);
                this.Tail.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-0.19547687f);
                this.Body.f_104201_ = Mth.m_14179_((float)sleepProgress, (float)6.0f, (float)16.9f);
                this.Body.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.0f, (float)-0.39095375f);
            } else {
                this.setSleepingPose();
            }
        } else if (sleepProgress != 0.0f && (Integer)entity.m_20088_().m_135370_(DinosaurEntity.SLEEP_TICK) > 0) {
            this.WingRight.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.39025563f, (float)0.0f);
            this.WingRight.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)0.5866052f, (float)0.0f);
            this.WingRight.f_104205_ = Mth.m_14179_((float)sleepProgress, (float)-0.74281216f, (float)0.0f);
            this.Head.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.9773844f, (float)0.0f);
            this.Head.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)0.11728612f, (float)0.0f);
            this.ThighLeft.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)-1.0950196f, (float)0.0f);
            this.ThighLeft.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)0.35185838f, (float)0.0f);
            this.TailFan.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.07819075f, (float)0.0f);
            this.TailFan.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)-0.27366763f, (float)0.0f);
            this.TailFan.f_104205_ = Mth.m_14179_((float)sleepProgress, (float)-0.11728612f, (float)0.0f);
            this.ThighRight.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)-1.1730357f, (float)0.0f);
            this.ThighRight.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)-0.43004912f, (float)0.0f);
            this.WingLeft.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.1569051f, (float)0.0f);
            this.WingLeft.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)-0.7429867f, (float)0.0f);
            this.WingLeft.f_104205_ = Mth.m_14179_((float)sleepProgress, (float)0.89901906f, (float)0.0f);
            this.Neck.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)-0.35185838f, (float)0.0f);
            this.Neck.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)0.23457225f, (float)0.0f);
            this.Neck.f_104205_ = Mth.m_14179_((float)sleepProgress, (float)-0.07819075f, (float)0.0f);
            this.LegLeft.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.16580628f, (float)0.0f);
            this.LegLeft.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)3.1398473f, (float)0.0f);
            this.LegLeft.f_104205_ = Mth.m_14179_((float)sleepProgress, (float)0.060737457f, (float)0.0f);
            this.LegRight.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.03874631f, (float)0.0f);
            this.LegRight.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)((float)Math.PI), (float)0.0f);
            this.Tail.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)0.23457225f, (float)0.0f);
            this.Tail.f_104204_ = Mth.m_14179_((float)sleepProgress, (float)-0.19547687f, (float)0.0f);
            this.Body.f_104201_ = Mth.m_14179_((float)sleepProgress, (float)16.9f, (float)6.0f);
            this.Body.f_104203_ = Mth.m_14179_((float)sleepProgress, (float)-0.39095375f, (float)0.0f);
        } else {
            float attackProgress = entity.getMeleeProgress(partialTick);
            this.Head.f_104204_ = netHeadYaw * ((float)Math.PI / 180);
            this.ThighRight.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
            this.ThighLeft.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
            this.Tail.f_104204_ = -0.12f * Mth.m_14031_((float)(0.2f * ageInTicks / 5.0f));
            this.TailFan.f_104204_ = -0.12f * Mth.m_14031_((float)(0.2f * ageInTicks / 5.0f));
            this.Tail.f_104203_ = -Math.abs(-0.05f * Mth.m_14031_((float)(0.1f * ageInTicks / 5.0f)));
            this.TailFan.f_104203_ = -Math.abs(-0.05f * Mth.m_14031_((float)(0.1f * ageInTicks / 5.0f)));
            this.Body.f_104203_ = Math.abs(-0.025f * Mth.m_14031_((float)(0.1f * ageInTicks / 3.0f)));
            this.Head.f_104203_ = headPitch * ((float)Math.PI / 180) + Math.abs(-0.025f * Mth.m_14031_((float)(0.1f * ageInTicks / 3.0f))) + attackProgress * (float)Math.toRadians(40.0);
            this.WingLeft.f_104205_ = -Math.abs(-0.05f * Mth.m_14031_((float)(0.15f * ageInTicks / 3.0f))) + attackProgress * (float)Math.toRadians(-50.0);
            this.WingRight.f_104205_ = Math.abs(-0.05f * Mth.m_14031_((float)(0.15f * ageInTicks / 3.0f))) + attackProgress * (float)Math.toRadians(50.0);
            if (entity.isEating()) {
                this.Body.f_104203_ = 0.5f;
                this.ThighLeft.f_104203_ = -0.5f;
                this.ThighRight.f_104203_ = -0.5f;
                this.ThighLeft.f_104201_ = 4.0f;
                this.ThighRight.f_104201_ = 4.0f;
                this.Neck.f_104203_ = Math.abs(Mth.m_14031_((float)(0.05f * ageInTicks)) * 0.75f) + 0.5f;
            }
            if (entity.m_20069_()) {
                this.Body.f_104201_ = 17.0f;
                this.Body.f_104203_ = -0.25f;
                this.Tail.f_104203_ = 0.25f;
                this.Neck.f_104203_ = 0.25f;
                this.WingRight.f_104205_ = -1.5f + Math.abs(-1.0f * Mth.m_14031_((float)(0.15f * ageInTicks / 2.0f)));
                this.WingLeft.f_104205_ = 1.5f - Math.abs(-1.0f * Mth.m_14031_((float)(0.15f * ageInTicks / 2.0f)));
                this.ThighLeft.f_104203_ = -0.25f * Mth.m_14031_((float)(0.2f * ageInTicks / 1.5f));
                this.ThighRight.f_104203_ = 0.25f * Mth.m_14031_((float)(0.2f * ageInTicks / 1.5f));
                this.Tail.f_104204_ = Mth.m_14089_((float)(limbSwing * 2.6662f)) * 1.4f * limbSwingAmount;
                this.TailFan.f_104204_ = Mth.m_14089_((float)(limbSwing * 2.6662f)) * 1.4f * limbSwingAmount;
                this.LegLeft.f_104203_ = -0.3f * Mth.m_14031_((float)(0.2f * ageInTicks / 1.5f));
                this.LegRight.f_104203_ = 0.3f * Mth.m_14031_((float)(0.2f * ageInTicks / 1.5f));
            }
        }
    }

    public void resetModel() {
        this.ThighLeft.f_104201_ = 1.0f;
        this.ThighRight.f_104201_ = 1.0f;
        this.Neck.f_104203_ = 0.0f;
        this.Body.f_104203_ = 0.0f;
        this.WingRight.f_104203_ = 0.0f;
        this.WingRight.f_104204_ = 0.0f;
        this.WingRight.f_104205_ = 0.0f;
        this.Head.f_104203_ = 0.0f;
        this.Head.f_104204_ = 0.0f;
        this.ThighLeft.f_104203_ = 0.0f;
        this.ThighLeft.f_104204_ = 0.0f;
        this.TailFan.f_104203_ = 0.0f;
        this.TailFan.f_104204_ = 0.0f;
        this.TailFan.f_104205_ = 0.0f;
        this.ThighRight.f_104203_ = 0.0f;
        this.ThighRight.f_104204_ = 0.0f;
        this.WingLeft.f_104203_ = 0.0f;
        this.WingLeft.f_104204_ = 0.0f;
        this.WingLeft.f_104205_ = 0.0f;
        this.Neck.f_104203_ = 0.0f;
        this.Neck.f_104204_ = 0.0f;
        this.Neck.f_104205_ = 0.0f;
        this.LegLeft.f_104203_ = 0.0f;
        this.LegLeft.f_104204_ = 0.0f;
        this.LegLeft.f_104205_ = 0.0f;
        this.LegRight.f_104203_ = 0.0f;
        this.LegRight.f_104204_ = 0.0f;
        this.Tail.f_104203_ = 0.0f;
        this.Tail.f_104204_ = 0.0f;
        this.Body.f_104201_ = 6.0f;
    }

    public void setSleepingPose() {
        this.Body.f_104201_ = 16.9f;
        this.WingRight.f_104203_ = 0.39025563f;
        this.WingRight.f_104204_ = 0.5866052f;
        this.WingRight.f_104205_ = -0.74281216f;
        this.Head.f_104203_ = 0.9773844f;
        this.Head.f_104204_ = 0.11728612f;
        this.ThighLeft.f_104203_ = -1.0950196f;
        this.ThighLeft.f_104204_ = 0.35185838f;
        this.TailFan.f_104203_ = 0.07819075f;
        this.TailFan.f_104204_ = -0.27366763f;
        this.TailFan.f_104205_ = -0.11728612f;
        this.ThighRight.f_104203_ = -1.1730357f;
        this.ThighRight.f_104204_ = -0.43004912f;
        this.Body.f_104203_ = -0.39095375f;
        this.WingLeft.f_104203_ = 0.1569051f;
        this.WingLeft.f_104204_ = -0.7429867f;
        this.WingLeft.f_104205_ = 0.89901906f;
        this.Neck.f_104203_ = -0.35185838f;
        this.Neck.f_104204_ = 0.23457225f;
        this.Neck.f_104205_ = -0.07819075f;
        this.LegLeft.f_104203_ = 0.16580628f;
        this.LegLeft.f_104204_ = 3.1398473f;
        this.LegLeft.f_104205_ = 0.060737457f;
        this.LegRight.f_104203_ = 0.03874631f;
        this.LegRight.f_104204_ = (float)Math.PI;
        this.Tail.f_104203_ = 0.23457225f;
        this.Tail.f_104204_ = -0.19547687f;
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.Body.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
    }
}

