/*
 * Decompiled with CFR 0.152.
 */
package superlord.prehistoricfauna.client.gui;

import com.google.common.collect.Maps;
import com.google.common.primitives.Ints;
import com.mojang.blaze3d.systems.RenderSystem;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.io.IOUtils;
import org.jetbrains.annotations.NotNull;
import superlord.prehistoricfauna.client.gui.ChangePageButton;
import superlord.prehistoricfauna.client.gui.IndexPageButton;
import superlord.prehistoricfauna.common.util.EnumPaleoPages;
import superlord.prehistoricfauna.init.PFItems;

public class GuiPaleopedia
extends Screen {
    protected static final int X = 390;
    protected static final int Y = 245;
    private static final ResourceLocation TEXTURE = new ResourceLocation("prehistoricfauna:textures/gui/paleopedia/paleopedia.png");
    private static final ResourceLocation DRAWINGS_0 = new ResourceLocation("prehistoricfauna:textures/gui/paleopedia/drawings_0.png");
    private static final Map<String, ResourceLocation> PICTURE_LOCATION_CACHE = Maps.newHashMap();
    public List<EnumPaleoPages> allPageTypes = new ArrayList<EnumPaleoPages>();
    public EnumPaleoPages pageType;
    public List<IndexPageButton> indexButtons = new ArrayList<IndexPageButton>();
    public ChangePageButton previousPage;
    public ChangePageButton nextPage;
    public int bookPages;
    public int bookPagesTotal = 1;
    public int indexPages;
    public int indexPagesTotal = 1;
    protected ItemStack book;
    protected boolean index;
    protected Font font = GuiPaleopedia.getFont();

    public GuiPaleopedia(ItemStack book) {
        super((Component)Component.m_237115_((String)"paleopedia_gui"));
        this.book = book;
        if (!book.m_41619_() && book.m_41720_() != null && book.m_41720_() == PFItems.PALEOPEDIA.get() && book.m_41783_() != null) {
            Set<EnumPaleoPages> pages = EnumPaleoPages.containedPages(Ints.asList((int[])book.m_41783_().m_128465_("Pages")));
            this.allPageTypes.addAll(pages);
            this.allPageTypes.sort(Comparator.comparingInt(Enum::ordinal));
            this.indexPagesTotal = (int)Math.ceil((double)pages.size() / 10.0);
        }
        this.index = true;
    }

    private static Font getFont() {
        return Minecraft.m_91087_().f_91062_;
    }

    private static Item getItemByRegistryName(String registryName) {
        return (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(registryName));
    }

    protected void m_7856_() {
        super.m_7856_();
        int centerX = (this.f_96543_ - 390) / 2;
        int centerY = (this.f_96544_ - 245) / 2;
        this.previousPage = new ChangePageButton(centerX + 25, centerY + 215, false, 0, p_214132_1_ -> {
            if (this.index ? this.indexPages > 0 : this.pageType != null) {
                if (this.index) {
                    --this.indexPages;
                    Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)SoundEvents.f_11713_, (float)1.0f));
                } else if (this.bookPages > 0) {
                    --this.bookPages;
                    Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)SoundEvents.f_11713_, (float)1.0f));
                } else {
                    this.index = true;
                }
            }
        });
        this.m_142416_((GuiEventListener)this.previousPage);
        this.nextPage = new ChangePageButton(centerX + 347, centerY + 215, true, 0, p_214132_1_ -> {
            if (this.index ? this.indexPages < this.indexPagesTotal - 1 : this.pageType != null && this.bookPages < this.pageType.pages) {
                if (this.index) {
                    ++this.indexPages;
                    Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)SoundEvents.f_11713_, (float)1.0f));
                } else {
                    ++this.bookPages;
                    Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)SoundEvents.f_11713_, (float)1.0f));
                }
            }
        });
        this.m_142416_((GuiEventListener)this.nextPage);
        if (!this.allPageTypes.isEmpty()) {
            for (int i = 0; i < this.allPageTypes.size(); ++i) {
                int xIndex = i % -2;
                int yIndex = i % 10;
                int id = 2 + i;
                IndexPageButton button = new IndexPageButton(centerX + 15 + xIndex * 200, centerY + 10 + yIndex * 20 - (xIndex == 1 ? 20 : 0), (Component)Component.m_237115_((String)("paleopedia." + EnumPaleoPages.values()[this.allPageTypes.get(i).ordinal()].toString().toLowerCase())), p_214132_1_ -> {
                    if (this.indexButtons.get(id - 2) != null && this.allPageTypes.get(id - 2) != null) {
                        Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)SoundEvents.f_11713_, (float)1.0f));
                        this.index = false;
                        this.bookPages = 0;
                        this.pageType = this.allPageTypes.get(id - 2);
                    }
                });
                this.indexButtons.add(button);
                this.m_142416_((GuiEventListener)button);
            }
        }
    }

    public void m_88315_(@NotNull GuiGraphics ms, int mouseX, int mouseY, float partialTicks) {
        this.m_280273_(ms);
        for (Renderable widget2 : this.f_169369_) {
            if (!(widget2 instanceof IndexPageButton)) continue;
            IndexPageButton button = (IndexPageButton)widget2;
            button.f_93623_ = this.index;
            button.f_93624_ = this.index;
        }
        for (int i = 0; i < this.indexButtons.size(); ++i) {
            this.indexButtons.get((int)i).f_93623_ = i < 10 * (this.indexPages + 1) && i >= 10 * this.indexPages && this.index;
        }
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)TEXTURE);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int cornerX = (this.f_96543_ - 390) / 2;
        int cornerY = (this.f_96544_ - 245) / 2;
        ms.m_280163_(TEXTURE, cornerX, cornerY, 0.0f, 0.0f, 390, 245, 390, 390);
        RenderSystem.disableDepthTest();
        super.m_88315_(ms, mouseX, mouseY, partialTicks);
        ms.m_280168_().m_85836_();
        ms.m_280168_().m_252880_((float)cornerX, (float)cornerY, 0.0f);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int centerX = (this.f_96543_ - 390) / 2;
        int centerY = (this.f_96544_ - 245) / 2;
        if (!this.index) {
            this.drawPerPage(ms, this.bookPages);
            int pageLeft = this.bookPages * 2 + 1;
            int pageRight = pageLeft + 1;
            this.font.m_271703_("" + pageLeft, (float)(centerX - 19), (float)(centerY - -203), 0x303030, false, ms.m_280168_().m_85850_().m_252922_(), (MultiBufferSource)ms.m_280091_(), Font.DisplayMode.NORMAL, 0, 0xF000F0);
            this.font.m_271703_("" + pageRight, (float)(centerX - -315), (float)(centerY - -203), 0x303030, false, ms.m_280168_().m_85850_().m_252922_(), (MultiBufferSource)ms.m_280091_(), Font.DisplayMode.NORMAL, 0, 0xF000F0);
        }
        ms.m_280168_().m_85849_();
        this.f_169369_.forEach(widget -> widget.m_88315_(ms, mouseX, mouseY, partialTicks));
        RenderSystem.enableDepthTest();
    }

    public void drawPerPage(GuiGraphics ms, int bookPages) {
        this.imageFromTxt(ms);
        this.writeFromTxt(ms);
    }

    public void imageFromTxt(GuiGraphics ms) {
        String fileName = this.pageType.toString().toLowerCase(Locale.ROOT) + "_" + this.bookPages + ".txt";
        String languageName = Minecraft.m_91087_().f_91066_.f_92075_.toLowerCase(Locale.ROOT);
        ResourceLocation fileLoc = new ResourceLocation("prehistoricfauna:lang/paleopedia/" + languageName + "_0/" + fileName);
        ResourceLocation backupLoc = new ResourceLocation("prehistoricfauna:lang/paleopedia/en_us_0/" + fileName);
        Optional resource = Minecraft.m_91087_().m_91098_().m_213713_(fileLoc);
        if (resource.isEmpty()) {
            resource = Minecraft.m_91087_().m_91098_().m_213713_(backupLoc);
        }
        try {
            if (resource.isPresent()) {
                List lines = IOUtils.readLines((InputStream)((Resource)resource.get()).m_215507_(), (Charset)StandardCharsets.UTF_8);
                int zLevelAdd = 0;
                for (String line : lines) {
                    String[] split;
                    if (((line = line.trim()).contains("<") || line.contains(">")) && line.contains("<image>")) {
                        split = (line = line.substring(8, line.length() - 1)).split(" ");
                        String texture = "prehistoricfauna:textures/gui/paleopedia/" + split[0];
                        ResourceLocation resourcelocation = PICTURE_LOCATION_CACHE.get(texture);
                        if (resourcelocation == null) {
                            resourcelocation = new ResourceLocation(texture);
                            PICTURE_LOCATION_CACHE.put(texture, resourcelocation);
                        }
                        ms.m_280168_().m_85836_();
                        this.drawImage(ms, resourcelocation, Integer.parseInt(split[1]), Integer.parseInt(split[2]), Integer.parseInt(split[3]), Integer.parseInt(split[4]), Integer.parseInt(split[5]), Integer.parseInt(split[6]), Float.parseFloat(split[7]) * 512.0f);
                        ms.m_280168_().m_85849_();
                    }
                    if (line.contains("<item>")) {
                        line = line.substring(7, line.length() - 1);
                        split = line.split(" ");
                        RenderSystem.enableDepthTest();
                        this.drawItemStack(ms, new ItemStack((ItemLike)GuiPaleopedia.getItemByRegistryName(split[0]), 1), Integer.parseInt(split[2]), Integer.parseInt(split[3]), Float.parseFloat(split[4]) * 2.0f);
                    }
                    if (line.contains("<block>")) {
                        line = line.substring(8, line.length() - 1);
                        split = line.split(" ");
                        RenderSystem.enableDepthTest();
                        this.drawBlockStack(ms, new ItemStack((ItemLike)GuiPaleopedia.getItemByRegistryName(split[0]), 1), Integer.parseInt(split[2]), Integer.parseInt(split[3]), Float.parseFloat(split[4]) * 2.0f, ++zLevelAdd);
                    }
                    if (!line.contains("<recipe>")) continue;
                    line = line.substring(9, line.length() - 1);
                    split = line.split(" ");
                    RenderSystem.enableDepthTest();
                    float scale = Float.parseFloat(split[split.length - 1]);
                    int x = Integer.parseInt(split[split.length - 3]);
                    int y = Integer.parseInt(split[split.length - 2]);
                    ItemStack result = new ItemStack((ItemLike)GuiPaleopedia.getItemByRegistryName(split[0]), 1);
                    ItemStack[] ingredients = new ItemStack[]{ItemStack.f_41583_, ItemStack.f_41583_, ItemStack.f_41583_, ItemStack.f_41583_, ItemStack.f_41583_, ItemStack.f_41583_, ItemStack.f_41583_, ItemStack.f_41583_, ItemStack.f_41583_};
                    int j = 8;
                    for (int i = split.length - 5; i >= 2; i -= 2) {
                        ingredients[j] = new ItemStack((ItemLike)GuiPaleopedia.getItemByRegistryName(split[i]), 1);
                        --j;
                    }
                    RenderSystem.enableDepthTest();
                    ms.m_280168_().m_85836_();
                    this.drawRecipe(ms, result, ingredients, x, y, scale);
                    ms.m_280168_().m_85849_();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void drawRecipe(GuiGraphics ms, ItemStack result, ItemStack[] ingredients, int x, int y, float scale) {
        ms.m_280168_().m_85836_();
        ms.m_280168_().m_85837_((double)x, (double)y, 0.0);
        ms.m_280168_().m_85841_(scale, scale, scale);
        ms.m_280168_().m_85849_();
        for (int i = 0; i < 9; ++i) {
            ms.m_280168_().m_85836_();
            ms.m_280168_().m_85837_(44.0, 20.0, 32.0);
            ms.m_280168_().m_85837_((double)((float)x + (float)(i % 3 * 22) * scale), (double)((float)y + (float)(i / 3 * 22) * scale), 0.0);
            ms.m_280168_().m_85841_(scale, scale, scale);
            ms.m_280480_(ingredients[i], 0, 0);
            ms.m_280168_().m_85849_();
        }
        ms.m_280168_().m_85836_();
        ms.m_280168_().m_85837_(40.0, 20.0, 32.0);
        float finScale = scale * 1.5f;
        ms.m_280168_().m_85837_((double)((float)x + 70.0f * finScale), (double)((float)y + 10.0f * finScale), 0.0);
        ms.m_280168_().m_85841_(finScale, finScale, finScale);
        ms.m_280480_(result, 0, 0);
        ms.m_280168_().m_85849_();
        ms.m_280168_().m_85836_();
        ms.m_280168_().m_252880_((float)x, (float)y, 0.0f);
        ms.m_280168_().m_85841_(scale, scale, 0.0f);
        ms.m_280168_().m_252880_(37.0f, 13.0f, 1.0f);
        ms.m_280168_().m_85841_(1.5f, 1.5f, 1.0f);
        this.drawImage(ms, DRAWINGS_0, 0, 0, 389, 1, 50, 50, 512.0f);
        ms.m_280168_().m_85849_();
    }

    public void writeFromTxt(GuiGraphics ms) {
        String fileName = this.pageType.toString().toLowerCase(Locale.ROOT) + "_" + this.bookPages + ".txt";
        String languageName = Minecraft.m_91087_().f_91066_.f_92075_.toLowerCase(Locale.ROOT);
        ResourceLocation fileLoc = new ResourceLocation("prehistoricfauna:lang/paleopedia/" + languageName + "_0/" + fileName);
        ResourceLocation backupLoc = new ResourceLocation("prehistoricfauna:lang/paleopedia/en_us_0/" + fileName);
        Optional resource = Minecraft.m_91087_().m_91098_().m_213713_(fileLoc);
        if (resource.isEmpty()) {
            resource = Minecraft.m_91087_().m_91098_().m_213713_(backupLoc);
        }
        try {
            List lines = IOUtils.readLines((InputStream)((Resource)resource.get()).m_215507_(), (String)"UTF-8");
            int linenumber = 0;
            for (String line : lines) {
                if ((line = line.trim()).contains("<") || line.contains(">")) continue;
                ms.m_280168_().m_85836_();
                if (this.usingVanillaFont()) {
                    ms.m_280168_().m_85841_(0.945f, 0.945f, 0.945f);
                    ms.m_280168_().m_252880_(0.0f, 5.5f, 0.0f);
                }
                if (linenumber <= 19) {
                    this.font.m_271703_(line, 23.0f, (float)(20 + linenumber * 10), 0x303030, false, ms.m_280168_().m_85850_().m_252922_(), (MultiBufferSource)ms.m_280091_(), Font.DisplayMode.NORMAL, 0, 0xF000F0);
                } else {
                    this.font.m_271703_(line, 220.0f, (float)((linenumber - 19) * 10), 0x303030, false, ms.m_280168_().m_85850_().m_252922_(), (MultiBufferSource)ms.m_280091_(), Font.DisplayMode.NORMAL, 0, 0xF000F0);
                }
                ++linenumber;
                ms.m_280168_().m_85849_();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ms.m_280168_().m_85836_();
        String s = StatCollector.translateToLocal("paleopedia." + this.pageType.toString().toLowerCase(Locale.ROOT));
        float scale = this.font.m_92895_(s) <= 100 ? 1.5f : (float)this.font.m_92895_(s) * 0.0125f;
        ms.m_280168_().m_85841_(scale, scale, scale);
        if (this.pageType == EnumPaleoPages.DJADOCHTA) {
            this.font.m_271703_(s, 30.0f, 8.0f, 8025450, false, ms.m_280168_().m_85850_().m_252922_(), (MultiBufferSource)ms.m_280091_(), Font.DisplayMode.NORMAL, 0, 0xF000F0);
        } else if (this.pageType == EnumPaleoPages.SCIENTIFIC_NOTES) {
            this.font.m_271703_(s, 33.0f, 8.0f, 8025450, false, ms.m_280168_().m_85850_().m_252922_(), (MultiBufferSource)ms.m_280091_(), Font.DisplayMode.NORMAL, 0, 0xF000F0);
        } else if (this.pageType == EnumPaleoPages.OVIRAPTOR) {
            this.font.m_271703_(s, 50.0f, 8.0f, 8025450, false, ms.m_280168_().m_85850_().m_252922_(), (MultiBufferSource)ms.m_280091_(), Font.DisplayMode.NORMAL, 0, 0xF000F0);
        } else if (this.pageType == EnumPaleoPages.PROTOCERATOPS) {
            this.font.m_271703_(s, 35.0f, 8.0f, 8025450, false, ms.m_280168_().m_85850_().m_252922_(), (MultiBufferSource)ms.m_280091_(), Font.DisplayMode.NORMAL, 0, 0xF000F0);
        } else if (this.pageType == EnumPaleoPages.UDANOCERATOPS) {
            this.font.m_271703_(s, 35.0f, 8.0f, 8025450, false, ms.m_280168_().m_85850_().m_252922_(), (MultiBufferSource)ms.m_280091_(), Font.DisplayMode.NORMAL, 0, 0xF000F0);
        } else if (this.pageType == EnumPaleoPages.HELL_CREEK) {
            this.font.m_271703_(s, 33.0f, 8.0f, 8025450, false, ms.m_280168_().m_85850_().m_252922_(), (MultiBufferSource)ms.m_280091_(), Font.DisplayMode.NORMAL, 0, 0xF000F0);
        } else if (this.pageType == EnumPaleoPages.ANZU) {
            this.font.m_271703_(s, 57.0f, 8.0f, 8025450, false, ms.m_280168_().m_85850_().m_252922_(), (MultiBufferSource)ms.m_280091_(), Font.DisplayMode.NORMAL, 0, 0xF000F0);
        } else if (this.pageType == EnumPaleoPages.BASILEMYS) {
            this.font.m_271703_(s, 50.0f, 8.0f, 8025450, false, ms.m_280168_().m_85850_().m_252922_(), (MultiBufferSource)ms.m_280091_(), Font.DisplayMode.NORMAL, 0, 0xF000F0);
        } else if (this.pageType == EnumPaleoPages.BRACHYCHAMPSA) {
            this.font.m_271703_(s, 34.0f, 8.0f, 8025450, false, ms.m_280168_().m_85850_().m_252922_(), (MultiBufferSource)ms.m_280091_(), Font.DisplayMode.NORMAL, 0, 0xF000F0);
        } else if (this.pageType == EnumPaleoPages.EDMONTOSAURUS) {
            this.font.m_271703_(s, 33.0f, 8.0f, 8025450, false, ms.m_280168_().m_85850_().m_252922_(), (MultiBufferSource)ms.m_280091_(), Font.DisplayMode.NORMAL, 0, 0xF000F0);
        } else if (this.pageType == EnumPaleoPages.PACHYCEPHALOSAURUS) {
            this.font.m_271703_(s, 28.0f, 8.0f, 8025450, false, ms.m_280168_().m_85850_().m_252922_(), (MultiBufferSource)ms.m_280091_(), Font.DisplayMode.NORMAL, 0, 0xF000F0);
        } else if (this.pageType == EnumPaleoPages.THESCELOSAURUS) {
            this.font.m_271703_(s, 30.0f, 8.0f, 8025450, false, ms.m_280168_().m_85850_().m_252922_(), (MultiBufferSource)ms.m_280091_(), Font.DisplayMode.NORMAL, 0, 0xF000F0);
        } else if (this.pageType == EnumPaleoPages.TYRANNOSAURUS) {
            this.font.m_271703_(s, 33.0f, 8.0f, 8025450, false, ms.m_280168_().m_85850_().m_252922_(), (MultiBufferSource)ms.m_280091_(), Font.DisplayMode.NORMAL, 0, 0xF000F0);
        } else if (this.pageType == EnumPaleoPages.YIXIAN) {
            this.font.m_271703_(s, 33.0f, 8.0f, 8025450, false, ms.m_280168_().m_85850_().m_252922_(), (MultiBufferSource)ms.m_280091_(), Font.DisplayMode.NORMAL, 0, 0xF000F0);
        } else if (this.pageType == EnumPaleoPages.BEIPIAOSAURUS) {
            this.font.m_271703_(s, 35.0f, 8.0f, 8025450, false, ms.m_280168_().m_85850_().m_252922_(), (MultiBufferSource)ms.m_280091_(), Font.DisplayMode.NORMAL, 0, 0xF000F0);
        } else if (this.pageType == EnumPaleoPages.CHANGYURAPTOR) {
            this.font.m_271703_(s, 34.0f, 8.0f, 8025450, false, ms.m_280168_().m_85850_().m_252922_(), (MultiBufferSource)ms.m_280091_(), Font.DisplayMode.NORMAL, 0, 0xF000F0);
        } else if (this.pageType == EnumPaleoPages.DILONG) {
            this.font.m_271703_(s, 55.0f, 8.0f, 8025450, false, ms.m_280168_().m_85850_().m_252922_(), (MultiBufferSource)ms.m_280091_(), Font.DisplayMode.NORMAL, 0, 0xF000F0);
        } else if (this.pageType == EnumPaleoPages.INCISIVOSAURUS) {
            this.font.m_271703_(s, 35.0f, 8.0f, 8025450, false, ms.m_280168_().m_85850_().m_252922_(), (MultiBufferSource)ms.m_280091_(), Font.DisplayMode.NORMAL, 0, 0xF000F0);
        } else if (this.pageType == EnumPaleoPages.JINZHOUSAURUS) {
            this.font.m_271703_(s, 35.0f, 8.0f, 8025450, false, ms.m_280168_().m_85850_().m_252922_(), (MultiBufferSource)ms.m_280091_(), Font.DisplayMode.NORMAL, 0, 0xF000F0);
        } else if (this.pageType == EnumPaleoPages.LIAONINGOSAURUS) {
            this.font.m_271703_(s, 32.0f, 8.0f, 8025450, false, ms.m_280168_().m_85850_().m_252922_(), (MultiBufferSource)ms.m_280091_(), Font.DisplayMode.NORMAL, 0, 0xF000F0);
        } else if (this.pageType == EnumPaleoPages.PSITTACOSAURUS) {
            this.font.m_271703_(s, 34.0f, 8.0f, 8025450, false, ms.m_280168_().m_85850_().m_252922_(), (MultiBufferSource)ms.m_280091_(), Font.DisplayMode.NORMAL, 0, 0xF000F0);
        } else if (this.pageType == EnumPaleoPages.RUIXINIA) {
            this.font.m_271703_(s, 52.0f, 8.0f, 8025450, false, ms.m_280168_().m_85850_().m_252922_(), (MultiBufferSource)ms.m_280091_(), Font.DisplayMode.NORMAL, 0, 0xF000F0);
        } else if (this.pageType == EnumPaleoPages.SINOSAUROPTERYX) {
            this.font.m_271703_(s, 30.0f, 8.0f, 8025450, false, ms.m_280168_().m_85850_().m_252922_(), (MultiBufferSource)ms.m_280091_(), Font.DisplayMode.NORMAL, 0, 0xF000F0);
        } else if (this.pageType == EnumPaleoPages.ZHENYUANLONG) {
            this.font.m_271703_(s, 37.0f, 8.0f, 8025450, false, ms.m_280168_().m_85850_().m_252922_(), (MultiBufferSource)ms.m_280091_(), Font.DisplayMode.NORMAL, 0, 0xF000F0);
        } else if (this.pageType == EnumPaleoPages.KAYENTA) {
            this.font.m_271703_(s, 27.0f, 8.0f, 8025450, false, ms.m_280168_().m_85850_().m_252922_(), (MultiBufferSource)ms.m_280091_(), Font.DisplayMode.NORMAL, 0, 0xF000F0);
        } else if (this.pageType == EnumPaleoPages.CALSOYASUCHUS) {
            this.font.m_271703_(s, 33.0f, 8.0f, 8025450, false, ms.m_280168_().m_85850_().m_252922_(), (MultiBufferSource)ms.m_280091_(), Font.DisplayMode.NORMAL, 0, 0xF000F0);
        } else if (this.pageType == EnumPaleoPages.DILOPHOSAURUS) {
            this.font.m_271703_(s, 33.0f, 8.0f, 8025450, false, ms.m_280168_().m_85850_().m_252922_(), (MultiBufferSource)ms.m_280091_(), Font.DisplayMode.NORMAL, 0, 0xF000F0);
        } else if (this.pageType == EnumPaleoPages.KAYENTATHERIUM) {
            this.font.m_271703_(s, 33.0f, 8.0f, 8025450, false, ms.m_280168_().m_85850_().m_252922_(), (MultiBufferSource)ms.m_280091_(), Font.DisplayMode.NORMAL, 0, 0xF000F0);
        } else if (this.pageType == EnumPaleoPages.MEGAPNOSAURUS) {
            this.font.m_271703_(s, 33.0f, 8.0f, 8025450, false, ms.m_280168_().m_85850_().m_252922_(), (MultiBufferSource)ms.m_280091_(), Font.DisplayMode.NORMAL, 0, 0xF000F0);
        } else if (this.pageType == EnumPaleoPages.SCELIDOSAURUS) {
            this.font.m_271703_(s, 33.0f, 8.0f, 8025450, false, ms.m_280168_().m_85850_().m_252922_(), (MultiBufferSource)ms.m_280091_(), Font.DisplayMode.NORMAL, 0, 0xF000F0);
        } else if (this.pageType == EnumPaleoPages.SCUTELLOSAURUS) {
            this.font.m_271703_(s, 33.0f, 8.0f, 8025450, false, ms.m_280168_().m_85850_().m_252922_(), (MultiBufferSource)ms.m_280091_(), Font.DisplayMode.NORMAL, 0, 0xF000F0);
        } else if (this.pageType == EnumPaleoPages.MORRISON) {
            this.font.m_271703_(s, 24.0f, 8.0f, 8025450, false, ms.m_280168_().m_85850_().m_252922_(), (MultiBufferSource)ms.m_280091_(), Font.DisplayMode.NORMAL, 0, 0xF000F0);
        } else if (this.pageType == EnumPaleoPages.ALLOSAURUS) {
            this.font.m_271703_(s, 43.0f, 8.0f, 8025450, false, ms.m_280168_().m_85850_().m_252922_(), (MultiBufferSource)ms.m_280091_(), Font.DisplayMode.NORMAL, 0, 0xF000F0);
        } else if (this.pageType == EnumPaleoPages.CAMARASAURUS) {
            this.font.m_271703_(s, 35.0f, 8.0f, 8025450, false, ms.m_280168_().m_85850_().m_252922_(), (MultiBufferSource)ms.m_280091_(), Font.DisplayMode.NORMAL, 0, 0xF000F0);
        } else if (this.pageType == EnumPaleoPages.CERATOSAURUS) {
            this.font.m_271703_(s, 35.0f, 8.0f, 8025450, false, ms.m_280168_().m_85850_().m_252922_(), (MultiBufferSource)ms.m_280091_(), Font.DisplayMode.NORMAL, 0, 0xF000F0);
        } else if (this.pageType == EnumPaleoPages.EILENODON) {
            this.font.m_271703_(s, 45.0f, 8.0f, 8025450, false, ms.m_280168_().m_85850_().m_252922_(), (MultiBufferSource)ms.m_280091_(), Font.DisplayMode.NORMAL, 0, 0xF000F0);
        } else if (this.pageType == EnumPaleoPages.HESPERORNITHOIDES) {
            this.font.m_271703_(s, 27.0f, 8.0f, 8025450, false, ms.m_280168_().m_85850_().m_252922_(), (MultiBufferSource)ms.m_280091_(), Font.DisplayMode.NORMAL, 0, 0xF000F0);
        } else if (this.pageType == EnumPaleoPages.CHINLE) {
            this.font.m_271703_(s, 33.0f, 8.0f, 8025450, false, ms.m_280168_().m_85850_().m_252922_(), (MultiBufferSource)ms.m_280091_(), Font.DisplayMode.NORMAL, 0, 0xF000F0);
        } else if (this.pageType == EnumPaleoPages.DESMATOSUCHUS) {
            this.font.m_271703_(s, 33.0f, 8.0f, 8025450, false, ms.m_280168_().m_85850_().m_252922_(), (MultiBufferSource)ms.m_280091_(), Font.DisplayMode.NORMAL, 0, 0xF000F0);
        } else if (this.pageType == EnumPaleoPages.PLACERIAS) {
            this.font.m_271703_(s, 46.0f, 8.0f, 8025450, false, ms.m_280168_().m_85850_().m_252922_(), (MultiBufferSource)ms.m_280091_(), Font.DisplayMode.NORMAL, 0, 0xF000F0);
        } else if (this.pageType == EnumPaleoPages.TRILOPHOSAURUS) {
            this.font.m_271703_(s, 33.0f, 8.0f, 8025450, false, ms.m_280168_().m_85850_().m_252922_(), (MultiBufferSource)ms.m_280091_(), Font.DisplayMode.NORMAL, 0, 0xF000F0);
        } else if (this.pageType == EnumPaleoPages.ISCHIGUALASTO) {
            float scale1 = this.font.m_92895_(s) <= 100 ? 1.5f : (float)this.font.m_92895_(s) * 0.007f;
            ms.m_280168_().m_85841_(scale1, scale1, scale1);
            this.font.m_271703_(s, 23.0f, 10.0f, 8025450, false, ms.m_280168_().m_85850_().m_252922_(), (MultiBufferSource)ms.m_280091_(), Font.DisplayMode.NORMAL, 0, 0xF000F0);
        } else if (this.pageType == EnumPaleoPages.HYPERODAPEDON) {
            this.font.m_271703_(s, 33.0f, 8.0f, 8025450, false, ms.m_280168_().m_85850_().m_252922_(), (MultiBufferSource)ms.m_280091_(), Font.DisplayMode.NORMAL, 0, 0xF000F0);
        } else if (this.pageType == EnumPaleoPages.ISCHIGUALASTIA) {
            this.font.m_271703_(s, 35.0f, 8.0f, 8025450, false, ms.m_280168_().m_85850_().m_252922_(), (MultiBufferSource)ms.m_280091_(), Font.DisplayMode.NORMAL, 0, 0xF000F0);
        } else if (this.pageType == EnumPaleoPages.CHROMOGISAURUS) {
            this.font.m_271703_(s, 33.0f, 8.0f, 8025450, false, ms.m_280168_().m_85850_().m_252922_(), (MultiBufferSource)ms.m_280091_(), Font.DisplayMode.NORMAL, 0, 0xF000F0);
        } else if (this.pageType == EnumPaleoPages.HERRERASAURUS) {
            this.font.m_271703_(s, 33.0f, 8.0f, 8025450, false, ms.m_280168_().m_85850_().m_252922_(), (MultiBufferSource)ms.m_280091_(), Font.DisplayMode.NORMAL, 0, 0xF000F0);
        } else if (this.pageType == EnumPaleoPages.AEPYORNITHOMIMUS) {
            this.font.m_271703_(s, 27.0f, 8.0f, 8025450, false, ms.m_280168_().m_85850_().m_252922_(), (MultiBufferSource)ms.m_280091_(), Font.DisplayMode.NORMAL, 0, 0xF000F0);
        } else if (this.pageType == EnumPaleoPages.BYRONOSAURUS) {
            this.font.m_271703_(s, 35.0f, 8.0f, 8025450, false, ms.m_280168_().m_85850_().m_252922_(), (MultiBufferSource)ms.m_280091_(), Font.DisplayMode.NORMAL, 0, 0xF000F0);
        } else if (this.pageType == EnumPaleoPages.CITIPATI || this.pageType == EnumPaleoPages.KOL) {
            this.font.m_271703_(s, 55.0f, 8.0f, 8025450, false, ms.m_280168_().m_85850_().m_252922_(), (MultiBufferSource)ms.m_280091_(), Font.DisplayMode.NORMAL, 0, 0xF000F0);
        } else {
            this.font.m_271703_(s, 40.0f, 8.0f, 8025450, false, ms.m_280168_().m_85850_().m_252922_(), (MultiBufferSource)ms.m_280091_(), Font.DisplayMode.NORMAL, 0, 0xF000F0);
        }
        ms.m_280168_().m_85849_();
    }

    private boolean usingVanillaFont() {
        return this.font == Minecraft.m_91087_().f_91062_;
    }

    public void drawImage(GuiGraphics ms, ResourceLocation texture, int x, int y, int u, int v, int width, int height, float scale) {
        ms.m_280168_().m_85836_();
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)texture);
        ms.m_280168_().m_85841_(scale / 512.0f, scale / 512.0f, scale / 512.0f);
        ms.m_280163_(texture, x, y, (float)u, (float)v, width, height, 512, 512);
        ms.m_280168_().m_85849_();
    }

    private void drawItemStack(GuiGraphics ms, ItemStack stack, int x, int y, float scale) {
        ms.m_280168_().m_85836_();
        ms.m_280168_().m_85841_(scale, scale, scale);
        ms.m_280480_(stack, x, y);
        ms.m_280168_().m_85849_();
    }

    private void drawBlockStack(GuiGraphics ms, ItemStack stack, int x, int y, float scale, int zScale) {
        ms.m_280168_().m_85836_();
        ms.m_280168_().m_85841_(scale, scale, scale);
        ms.m_280168_().m_252880_(0.0f, 0.0f, (float)(zScale * 10));
        ms.m_280480_(stack, x, y);
        ms.m_280168_().m_85849_();
    }

    public class StatCollector {
        public static String translateToLocal(String s) {
            return I18n.m_118938_((String)s, (Object[])new Object[0]);
        }
    }
}

