/*
 * Decompiled with CFR 0.152.
 */
package andrews.swampier_swamps.level.features.trunk_placers;

import andrews.swampier_swamps.registry.SSTrunkPlacers;
import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.OptionalInt;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.TreeFeature;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacerType;

public class BaldCypressTrunkPlacer
extends TrunkPlacer {
    public static final Codec<BaldCypressTrunkPlacer> CODEC = RecordCodecBuilder.create(instance -> BaldCypressTrunkPlacer.m_70305_((RecordCodecBuilder.Instance)instance).apply((Applicative)instance, BaldCypressTrunkPlacer::new));

    public BaldCypressTrunkPlacer(int baseHeight, int firstRandomHeight, int secondRandomHeight) {
        super(baseHeight, firstRandomHeight, secondRandomHeight);
    }

    protected TrunkPlacerType<?> m_7362_() {
        return (TrunkPlacerType)SSTrunkPlacers.BALD_CYPRESS_TRUNK_PLACER.get();
    }

    public List<FoliagePlacer.FoliageAttachment> m_213934_(LevelSimulatedReader level, BiConsumer<BlockPos, BlockState> consumer, RandomSource rand, int height, BlockPos pos, TreeConfiguration config) {
        BlockPos blockpos = pos.m_7495_();
        BaldCypressTrunkPlacer.m_226169_((LevelSimulatedReader)level, consumer, (RandomSource)rand, (BlockPos)blockpos, (TreeConfiguration)config);
        BaldCypressTrunkPlacer.m_226169_((LevelSimulatedReader)level, consumer, (RandomSource)rand, (BlockPos)blockpos.m_122029_(), (TreeConfiguration)config);
        BaldCypressTrunkPlacer.m_226169_((LevelSimulatedReader)level, consumer, (RandomSource)rand, (BlockPos)blockpos.m_122019_(), (TreeConfiguration)config);
        BaldCypressTrunkPlacer.m_226169_((LevelSimulatedReader)level, consumer, (RandomSource)rand, (BlockPos)blockpos.m_122012_(), (TreeConfiguration)config);
        BaldCypressTrunkPlacer.m_226169_((LevelSimulatedReader)level, consumer, (RandomSource)rand, (BlockPos)blockpos.m_122024_(), (TreeConfiguration)config);
        ArrayList lowerBranchHeights = Lists.newArrayList();
        for (int i = 0; i < height; ++i) {
            this.m_226187_(level, consumer, rand, pos.m_6630_(i), config);
            if (lowerBranchHeights.size() >= 3 || i <= 3 || i >= height - 2 || rand.m_188503_(2) != 0) continue;
            lowerBranchHeights.add(pos.m_6630_(i).m_123342_());
        }
        if (lowerBranchHeights.isEmpty()) {
            lowerBranchHeights.add(pos.m_123342_() + 4 + rand.m_188503_(height - 5));
        }
        this.placeLogs(level, consumer, rand, 1, rand.m_188503_(2) + 1, pos.m_122012_(), config);
        this.placeLogs(level, consumer, rand, 1, rand.m_188503_(2) + 1, pos.m_122019_(), config);
        this.placeLogs(level, consumer, rand, 1, rand.m_188503_(2) + 1, pos.m_122029_(), config);
        this.placeLogs(level, consumer, rand, 1, rand.m_188503_(2) + 1, pos.m_122024_(), config);
        this.randomDiagonalLog(level, consumer, rand, pos.m_7495_().m_7918_(1, 0, 1), config);
        this.randomDiagonalLog(level, consumer, rand, pos.m_7495_().m_7918_(-1, 0, -1), config);
        this.randomDiagonalLog(level, consumer, rand, pos.m_7495_().m_7918_(-1, 0, 1), config);
        this.randomDiagonalLog(level, consumer, rand, pos.m_7495_().m_7918_(1, 0, -1), config);
        ArrayList list = Lists.newArrayList();
        Direction direction = Direction.Plane.HORIZONTAL.m_235690_(rand);
        this.createBranch(level, consumer, rand, height, pos, config, list, direction, rand.m_188503_(3) + 1);
        this.createBranch(level, consumer, rand, height, pos, config, list, direction.m_122424_(), rand.m_188503_(3) + 1);
        ArrayList directions = Lists.newArrayList();
        Iterator iterator = lowerBranchHeights.iterator();
        while (iterator.hasNext()) {
            Direction branchDirection;
            int branchHeight = (Integer)iterator.next();
            while (directions.contains(branchDirection = Direction.Plane.HORIZONTAL.m_235690_(rand))) {
            }
            this.createBranch(level, consumer, rand, height, new BlockPos(pos.m_123341_(), branchHeight - height, pos.m_123343_()), config, list, branchDirection, rand.m_188503_(2) + 2);
            directions.add(branchDirection);
        }
        return list;
    }

    private void placeLogs(LevelSimulatedReader level, BiConsumer<BlockPos, BlockState> consumer, RandomSource rand, int height, int heightMod, BlockPos pos, TreeConfiguration config) {
        for (int i = 0; i < height + heightMod; ++i) {
            if (!TreeFeature.m_67272_((LevelSimulatedReader)level, (BlockPos)pos.m_6630_(i)) && !level.m_7433_(pos.m_6630_(i), state -> state.m_60713_(Blocks.f_50746_))) continue;
            consumer.accept(pos.m_6630_(i), config.f_68185_.m_213972_(rand, pos.m_6630_(i)));
        }
        if (rand.m_188503_(3) == 0 && level.m_7433_(pos.m_6630_(height + heightMod), BlockBehaviour.BlockStateBase::m_60795_)) {
            consumer.accept(pos.m_6630_(height + heightMod), Blocks.f_152543_.m_49966_());
        }
    }

    private void randomDiagonalLog(LevelSimulatedReader level, BiConsumer<BlockPos, BlockState> consumer, RandomSource rand, BlockPos pos, TreeConfiguration config) {
        if (level.m_7433_(pos.m_7494_(), state -> state.m_60713_(Blocks.f_50746_))) {
            consumer.accept(pos.m_7494_(), Blocks.f_50016_.m_49966_());
        }
        if (rand.m_188503_(2) == 1) {
            BaldCypressTrunkPlacer.m_226169_((LevelSimulatedReader)level, consumer, (RandomSource)rand, (BlockPos)pos, (TreeConfiguration)config);
            if (TreeFeature.m_67272_((LevelSimulatedReader)level, (BlockPos)pos.m_7494_())) {
                consumer.accept(pos.m_7494_(), config.f_68185_.m_213972_(rand, pos.m_7494_()));
            }
        }
    }

    private void createBranch(LevelSimulatedReader level, BiConsumer<BlockPos, BlockState> consumer, RandomSource rand, int height, BlockPos pos, TreeConfiguration config, List<FoliagePlacer.FoliageAttachment> list, Direction direction, int branchSize) {
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
        OptionalInt optionalInt = OptionalInt.empty();
        int xPos = pos.m_123341_();
        int zPos = pos.m_123343_();
        int logYOffset = 0;
        for (int heightMod = 0; heightMod < branchSize; ++heightMod) {
            int yPos = pos.m_123342_() + height + logYOffset;
            if (rand.m_188503_(2) == 0) {
                ++logYOffset;
            }
            if (!this.m_226187_(level, consumer, rand, (BlockPos)mutableBlockPos.m_122178_(xPos += direction.m_122429_(), yPos, zPos += direction.m_122431_()), config)) continue;
            optionalInt = OptionalInt.of(yPos + 1);
        }
        if (optionalInt.isPresent()) {
            list.add(new FoliagePlacer.FoliageAttachment(new BlockPos(xPos, optionalInt.getAsInt(), zPos), 1, false));
        }
    }
}

