/*
 * Decompiled with CFR 0.152.
 */
package andrews.swampier_swamps.events;

import andrews.swampier_swamps.entities.model.DragonflyModel;
import andrews.swampier_swamps.entities.renderer.DragonflyRenderer;
import andrews.swampier_swamps.entities.renderer.SwampGasRenderer;
import andrews.swampier_swamps.registry.SSBlocks;
import andrews.swampier_swamps.registry.SSEntities;
import net.minecraft.client.color.block.BlockColors;
import net.minecraft.client.renderer.BiomeColors;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.FoliageColor;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.RegisterColorHandlersEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="swampier_swamps", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class ClientEvents {
    @SubscribeEvent
    public static void registerLayers(EntityRenderersEvent.RegisterLayerDefinitions event) {
        event.registerLayerDefinition(DragonflyModel.LAYER, DragonflyModel::createBodyLayer);
    }

    @SubscribeEvent
    public static void registerRenderers(EntityRenderersEvent.RegisterRenderers event) {
        event.registerEntityRenderer((EntityType)SSEntities.DRAGONFLY.get(), DragonflyRenderer::new);
        event.registerEntityRenderer((EntityType)SSEntities.SWAMP_GAS.get(), SwampGasRenderer::new);
    }

    @SubscribeEvent
    public static void registerBlockColor(RegisterColorHandlersEvent.Block event) {
        event.register((state, level, pos, tintIndex) -> ClientEvents.isNotNull(level, pos) ? BiomeColors.m_108804_((BlockAndTintGetter)level, (BlockPos)pos) : FoliageColor.m_46113_(), new Block[]{(Block)SSBlocks.SWAMP_VINE.get()});
        event.register((state, level, pos, tintIndex) -> ClientEvents.isNotNull(level, pos) ? 2129968 : 7455580, new Block[]{(Block)SSBlocks.SINKING_LILY_PAD.get(), (Block)SSBlocks.BIG_LILY_PAD.get(), (Block)SSBlocks.SMALL_LILY_PAD.get()});
    }

    @SubscribeEvent
    public static void registerBlockColor(RegisterColorHandlersEvent.Item event) {
        BlockColors blockcolors = event.getBlockColors();
        event.register((stack, tintIndex) -> {
            BlockState blockstate = ((BlockItem)stack.m_41720_()).m_40614_().m_49966_();
            return blockcolors.m_92577_(blockstate, null, null, tintIndex);
        }, new ItemLike[]{(ItemLike)SSBlocks.SWAMP_VINE.get(), (ItemLike)SSBlocks.BIG_LILY_PAD.get(), (ItemLike)SSBlocks.SMALL_LILY_PAD.get()});
    }

    private static boolean isNotNull(BlockAndTintGetter level, BlockPos pos) {
        return level != null && pos != null;
    }
}

