/*
 * Decompiled with CFR 0.152.
 */
package net.pavocado.exoticbirds.network;

import java.util.AbstractMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.registries.ForgeRegistries;
import net.pavocado.exoticbirds.capabilities.BirdTrackingProvider;

public class PacketSyncCapabilities {
    private final Set<Map.Entry<EntityType<?>, Integer>> trackedBirdList;

    public PacketSyncCapabilities(Set<Map.Entry<EntityType<?>, Integer>> trackedBirdList) {
        this.trackedBirdList = trackedBirdList;
    }

    public static void encode(PacketSyncCapabilities message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.trackedBirdList.size());
        for (Map.Entry<EntityType<?>, Integer> pair : message.trackedBirdList) {
            buffer.m_130085_(new ResourceLocation(ForgeRegistries.ENTITY_TYPES.getKey(pair.getKey()).toString()));
            buffer.writeInt(pair.getValue().intValue());
        }
    }

    public static PacketSyncCapabilities decode(FriendlyByteBuf buffer) {
        HashSet trackedBirds = new HashSet();
        int count = buffer.readInt();
        for (int i = 0; i < count; ++i) {
            ResourceLocation resource = buffer.m_130281_();
            int variant = buffer.readInt();
            EntityType entityType = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(resource);
            if (entityType == null) continue;
            trackedBirds.add(new AbstractMap.SimpleEntry<EntityType, Integer>(entityType, variant));
        }
        return new PacketSyncCapabilities(trackedBirds);
    }

    public static void handle(PacketSyncCapabilities packet, Supplier<NetworkEvent.Context> contextSupplier) {
        contextSupplier.get().enqueueWork(() -> PacketSyncCapabilities.handleOnClient(packet));
        contextSupplier.get().setPacketHandled(true);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void handleOnClient(PacketSyncCapabilities packet) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player != null) {
            player.getCapability(BirdTrackingProvider.BIRD_TRACKING_CAPABILITY).ifPresent(cap -> cap.setAll(packet.trackedBirdList));
        }
    }
}

