/*
 * Decompiled with CFR 0.152.
 */
package net.pavocado.exoticbirds.network;

import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;
import net.pavocado.exoticbirds.container.PigeonMenu;
import net.pavocado.exoticbirds.entity.PigeonEntity;

public class PacketSendPigeonMail {
    private final int entityId;
    private final ItemStack stack;

    public PacketSendPigeonMail(int entityId, ItemStack stack) {
        this.entityId = entityId;
        this.stack = stack;
    }

    public static void encode(PacketSendPigeonMail message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.entityId);
        buffer.writeItemStack(message.stack, false);
    }

    public static PacketSendPigeonMail decode(FriendlyByteBuf buffer) {
        return new PacketSendPigeonMail(buffer.readInt(), buffer.m_130267_());
    }

    public static void handle(PacketSendPigeonMail packet, Supplier<NetworkEvent.Context> contextSupplier) {
        contextSupplier.get().enqueueWork(() -> {
            ServerPlayer sender = ((NetworkEvent.Context)contextSupplier.get()).getSender();
            if (sender != null) {
                AbstractContainerMenu abstractcontainermenu;
                PigeonEntity pigeon;
                boolean sent;
                Entity entity = sender.m_9236_().m_6815_(packet.entityId);
                if (entity instanceof PigeonEntity && (sent = (pigeon = (PigeonEntity)entity).takeItemToRoostBox(sender, packet.stack)) && (abstractcontainermenu = sender.f_36096_) instanceof PigeonMenu) {
                    PigeonMenu pigeonMenu = (PigeonMenu)abstractcontainermenu;
                    pigeonMenu.clearMailSlotItem();
                }
                sender.m_6915_();
            }
        });
        contextSupplier.get().setPacketHandled(true);
    }
}

