/*
 * Decompiled with CFR 0.152.
 */
package net.pavocado.exoticbirds.config;

import java.util.ArrayList;
import java.util.List;
import net.minecraftforge.common.ForgeConfigSpec;

public final class ExoticBirdsCommonConfig {
    public static final ForgeConfigSpec.Builder BUILDER = new ForgeConfigSpec.Builder();
    public static final ForgeConfigSpec SPEC;
    public static final ForgeConfigSpec.BooleanValue allowCreateExoticEggshell;
    public static final ForgeConfigSpec.BooleanValue allowCreateVanillaEggshell;
    public static final ForgeConfigSpec.BooleanValue allowLayEggs;
    public static final ForgeConfigSpec.BooleanValue allowPhoenixEggHatching;
    public static final ForgeConfigSpec.IntValue baseEggLayRate;
    public static final ForgeConfigSpec.BooleanValue allowMagpieScavenge;
    public static final ForgeConfigSpec.BooleanValue allowKingfisherScavenge;
    public static final ForgeConfigSpec.BooleanValue allowPelicanScavenge;
    public static final ForgeConfigSpec.BooleanValue allowOstrichRiding;
    public static final ForgeConfigSpec.BooleanValue allowPhoenixRiding;
    public static final ForgeConfigSpec.BooleanValue allowPigeonMail;
    public static final ForgeConfigSpec.BooleanValue allowBirdDespawning;
    public static final ForgeConfigSpec.BooleanValue allowAnythingInCages;
    public static final ForgeConfigSpec.BooleanValue allowNestEggRegen;
    public static final ForgeConfigSpec.ConfigValue<List<String>> blacklistedSpawningDimensions;
    public static final ForgeConfigSpec.BooleanValue allowBookExperience;

    static {
        BUILDER.push("general");
        BUILDER.push("eggs");
        allowCreateExoticEggshell = BUILDER.comment("Allow eggs from this mod to drop eggshell when broken. Default = true").define("createExoticEggshells", true);
        allowCreateVanillaEggshell = BUILDER.comment("Allow chicken eggs to drop eggshell when broken. Default = true").define("createChickenEggshells", true);
        allowLayEggs = BUILDER.comment("Allow exotic birds to lay eggs as items. Default = true").define("allowEggLaying", true);
        allowPhoenixEggHatching = BUILDER.comment("Allow phoenix eggs to hatch phoenixes. If disabled, they hatch chickens. Default = true").define("allowPhoenixHatching", true);
        baseEggLayRate = BUILDER.comment("How many ticks it takes for a bird to lay an egg. Default = 12000").defineInRange("eggLayRate", 12000, 6000, Integer.MAX_VALUE);
        BUILDER.pop();
        BUILDER.push("entity");
        allowMagpieScavenge = BUILDER.comment("Allow magpies to scavenge for items. Default = true").define("allowMagpieScavenging", true);
        allowKingfisherScavenge = BUILDER.comment("Allow kingfishers to collect fish. Default = true").define("allowKingfisherScavenging", true);
        allowPelicanScavenge = BUILDER.comment("Allow tamed pelicans to collect fish. Default = true").define("allowPelicanScavenging", true);
        allowOstrichRiding = BUILDER.comment("Allow ostriches to be ridden. Default = true").define("allowOstrichRiding", true);
        allowPhoenixRiding = BUILDER.comment("Allow phoenixes to be ridden. Default = true").define("allowPhoenixRiding", true);
        allowPigeonMail = BUILDER.comment("Allow pigeon mail. Default = true").define("allowPigeonMail", true);
        BUILDER.pop();
        BUILDER.push("spawning");
        blacklistedSpawningDimensions = BUILDER.comment("A list of dimensions that no birds are able to spawn in.").define("blacklistedSpawningDimensions", new ArrayList());
        allowBirdDespawning = BUILDER.comment("Allow non-tamed/non-named birds to naturally despawn. Default = false").define("allowDespawning", false);
        BUILDER.pop();
        BUILDER.push("cages");
        allowAnythingInCages = BUILDER.comment("Allow other non-hostile mobs to be caught by birdcages. Default = false").define("allowAnythingInCages", false);
        BUILDER.pop();
        BUILDER.push("nests");
        allowNestEggRegen = BUILDER.comment("Allow eggs to regenerate in nests. Default = true").define("allowNestEggRegen", true);
        BUILDER.pop();
        BUILDER.push("birdbook");
        allowBookExperience = BUILDER.comment("Allow experience to be obtained by logging birds. Default = true").define("allowBookExperience", true);
        BUILDER.pop();
        BUILDER.pop();
        SPEC = BUILDER.build();
    }
}

