/*
 * Decompiled with CFR 0.152.
 */
package net.pavocado.exoticbirds.client.model;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.AgeableListModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.pavocado.exoticbirds.entity.AbstractFlyingBirdEntity;
import net.pavocado.exoticbirds.entity.OwlEntity;

@OnlyIn(value=Dist.CLIENT)
public class OwlModel<T extends OwlEntity>
extends AgeableListModel<T> {
    public static final ModelLayerLocation OWL_LAYER = new ModelLayerLocation(new ResourceLocation("exoticbirds", "owl"), "main");
    private final ModelPart head;
    private final ModelPart upperBody;
    private final ModelPart lowerBody;
    private final ModelPart beak;
    private final ModelPart rightWing;
    private final ModelPart leftWing;
    private final ModelPart tail;
    private final ModelPart leftAnkle;
    private final ModelPart rightAnkle;
    private final ModelPart rightFoot;
    private final ModelPart leftFoot;

    public OwlModel(ModelPart part) {
        this.head = part.m_171324_("head");
        this.upperBody = part.m_171324_("upperBody");
        this.lowerBody = part.m_171324_("lowerBody");
        this.beak = part.m_171324_("beak");
        this.rightWing = part.m_171324_("rightWing");
        this.leftWing = part.m_171324_("leftWing");
        this.tail = part.m_171324_("tail");
        this.leftAnkle = part.m_171324_("leftAnkle");
        this.rightAnkle = part.m_171324_("rightAnkle");
        this.rightFoot = part.m_171324_("rightFoot");
        this.leftFoot = part.m_171324_("leftFoot");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition headDefinition = partdefinition.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(32, 0).m_171481_(-4.0f, -5.0f, -4.0f, 8.0f, 5.0f, 8.0f), PartPose.m_171423_((float)0.0f, (float)12.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        partdefinition.m_171599_("upperBody", CubeListBuilder.m_171558_().m_171514_(0, 14).m_171481_(-4.5f, 0.0f, -4.5f, 9.0f, 6.0f, 9.0f), PartPose.m_171423_((float)0.0f, (float)12.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        partdefinition.m_171599_("lowerBody", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(-4.0f, 5.0f, -5.0f, 8.0f, 6.0f, 8.0f), PartPose.m_171423_((float)0.0f, (float)12.0f, (float)0.0f, (float)0.1570796f, (float)0.0f, (float)0.0f));
        partdefinition.m_171599_("beak", CubeListBuilder.m_171558_().m_171514_(36, 13).m_171481_(-1.0f, -2.4f, -5.6f, 2.0f, 3.0f, 2.0f), PartPose.m_171423_((float)0.0f, (float)12.0f, (float)0.0f, (float)-0.1047198f, (float)0.0f, (float)0.0f));
        partdefinition.m_171599_("rightWing", CubeListBuilder.m_171558_().m_171514_(0, 29).m_171481_(-1.0f, 0.0f, -4.0f, 1.0f, 12.0f, 8.0f), PartPose.m_171423_((float)-4.5f, (float)12.0f, (float)0.0f, (float)0.1745329f, (float)0.0523599f, (float)-0.0698132f));
        partdefinition.m_171599_("leftWing", CubeListBuilder.m_171558_().m_171514_(18, 29).m_171481_(0.0f, 0.0f, -4.0f, 1.0f, 12.0f, 8.0f), PartPose.m_171423_((float)4.5f, (float)12.0f, (float)0.0f, (float)0.1745329f, (float)-0.0523599f, (float)0.0698132f));
        partdefinition.m_171599_("tail", CubeListBuilder.m_171558_().m_171514_(36, 21).m_171481_(-3.0f, 6.8f, -0.4f, 6.0f, 8.0f, 2.0f), PartPose.m_171423_((float)0.0f, (float)12.0f, (float)0.0f, (float)0.418879f, (float)0.0f, (float)0.0f));
        headDefinition.m_171599_("rightEar", CubeListBuilder.m_171558_().m_171514_(44, 13).m_171481_(-3.5f, -7.8f, -2.5f, 3.0f, 4.0f, 0.0f), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)-0.122173f, (float)0.2617994f, (float)-0.1396263f));
        headDefinition.m_171599_("leftEar", CubeListBuilder.m_171558_().m_171514_(44, 17).m_171481_(0.5f, -7.8f, -2.5f, 3.0f, 4.0f, 0.0f), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)-0.122173f, (float)-0.2617994f, (float)0.1396263f));
        partdefinition.m_171599_("leftAnkle", CubeListBuilder.m_171558_().m_171514_(54, 18).m_171481_(-1.0f, 0.0f, -2.0f, 2.0f, 2.0f, 3.0f), PartPose.m_171423_((float)1.8f, (float)22.0f, (float)2.0f, (float)0.1745329f, (float)0.0f, (float)0.0f));
        partdefinition.m_171599_("rightAnkle", CubeListBuilder.m_171558_().m_171514_(54, 13).m_171481_(-1.0f, 0.0f, -2.0f, 2.0f, 2.0f, 3.0f), PartPose.m_171423_((float)-1.8f, (float)22.0f, (float)2.0f, (float)0.1745329f, (float)0.0f, (float)0.0f));
        partdefinition.m_171599_("rightFoot", CubeListBuilder.m_171558_().m_171514_(54, 23).m_171481_(-1.0f, 1.2f, -3.0f, 2.0f, 1.0f, 3.0f), PartPose.m_171423_((float)-1.8f, (float)22.0f, (float)2.0f, (float)0.3490659f, (float)0.0f, (float)0.0f));
        partdefinition.m_171599_("leftFoot", CubeListBuilder.m_171558_().m_171514_(54, 27).m_171481_(-1.0f, 1.2f, -3.0f, 2.0f, 1.0f, 3.0f), PartPose.m_171423_((float)1.8f, (float)22.0f, (float)2.0f, (float)0.3490659f, (float)0.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    protected Iterable<ModelPart> m_5607_() {
        return ImmutableList.of((Object)this.head, (Object)this.beak);
    }

    protected Iterable<ModelPart> m_5608_() {
        return ImmutableList.of((Object)this.upperBody, (Object)this.lowerBody, (Object)this.rightWing, (Object)this.leftWing, (Object)this.tail, (Object)this.leftAnkle, (Object)this.rightAnkle, (Object)this.rightFoot, (Object)this.leftFoot);
    }

    public void setupAnim(T entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        if (((AbstractFlyingBirdEntity)((Object)entityIn)).m_29443_()) {
            this.head.m_104227_(0.0f, 13.0f, -3.0f);
            this.upperBody.m_104227_(0.0f, 12.0f, -4.0f);
            this.lowerBody.m_104227_(0.0f, 12.0f, -4.0f);
            this.beak.m_104227_(0.0f, 13.0f, -3.0f);
            this.rightWing.m_104227_(-4.5f, 12.0f, -2.0f);
            this.leftWing.m_104227_(4.5f, 12.0f, -2.0f);
            this.tail.m_104227_(0.0f, 12.0f, -4.0f);
            this.leftAnkle.m_104227_(1.8f, 13.6f, 6.0f);
            this.rightAnkle.m_104227_(-1.8f, 13.6f, 6.0f);
            this.rightFoot.m_104227_(-1.8f, 14.1f, 6.0f);
            this.leftFoot.m_104227_(1.8f, 14.1f, 6.0f);
            this.beak.f_104204_ = this.head.f_104204_ = netHeadYaw / 57.295776f;
            this.head.f_104203_ = 0.8726646f;
            this.upperBody.f_104203_ = 1.308997f;
            this.lowerBody.f_104203_ = 1.466077f;
            this.beak.f_104203_ = 0.7679449f;
            this.rightWing.f_104203_ = 2.9670596f;
            this.rightWing.f_104204_ = -2.9670596f;
            this.leftWing.f_104203_ = 2.9670596f;
            this.leftWing.f_104204_ = 2.9670596f;
            this.tail.f_104203_ = 1.660335f;
            this.rightAnkle.f_104203_ = 1.396263f;
            this.rightFoot.f_104203_ = 1.570796f;
            this.leftAnkle.f_104203_ = 1.396263f;
            this.leftFoot.f_104203_ = 1.570796f;
            this.rightWing.f_104205_ = Mth.m_14089_((float)(ageInTicks * 1.3f - 0.5f)) * (float)Math.PI * 0.15f - 1.6580628f;
            this.leftWing.f_104205_ = -(Mth.m_14089_((float)(ageInTicks * 1.3f - 0.5f)) * (float)Math.PI * 0.15f) + 1.6580628f;
        } else {
            this.head.m_104227_(0.0f, 12.0f, 0.0f);
            this.upperBody.m_104227_(0.0f, 12.0f, 0.0f);
            this.lowerBody.m_104227_(0.0f, 12.0f, 0.0f);
            this.beak.m_104227_(0.0f, 12.0f, 0.0f);
            this.rightWing.m_104227_(-4.5f, 12.0f, 0.0f);
            this.leftWing.m_104227_(4.5f, 12.0f, 0.0f);
            this.tail.m_104227_(0.0f, 12.0f, 0.0f);
            this.leftAnkle.m_104227_(1.8f, 22.0f, 2.0f);
            this.rightAnkle.m_104227_(-1.8f, 22.0f, 2.0f);
            this.rightFoot.m_104227_(-1.8f, 22.0f, 2.0f);
            this.leftFoot.m_104227_(1.8f, 22.0f, 2.0f);
            this.beak.f_104204_ = this.head.f_104204_ = netHeadYaw / 57.295776f;
            this.rightAnkle.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount + 0.1745329f;
            this.rightFoot.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount + 0.3490659f;
            this.leftAnkle.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount + 0.1745329f;
            this.leftFoot.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount + 0.3490659f;
            this.rightWing.f_104205_ = ageInTicks - 0.0698132f;
            this.leftWing.f_104205_ = -ageInTicks + 0.0698132f;
            this.head.f_104203_ = 0.0f;
            this.upperBody.f_104203_ = 0.0f;
            this.lowerBody.f_104203_ = 0.1570796f;
            this.beak.f_104203_ = -0.1047198f;
            this.rightWing.f_104203_ = 0.1745329f;
            this.rightWing.f_104204_ = 0.0523599f;
            this.leftWing.f_104203_ = 0.1745329f;
            this.leftWing.f_104204_ = -0.0523599f;
            this.tail.f_104203_ = 0.418879f;
        }
    }

    public void m_7695_(PoseStack stack, VertexConsumer builder, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        if (this.f_102610_) {
            stack.m_85836_();
            stack.m_85841_(0.5f, 0.5f, 0.5f);
            stack.m_252880_(0.0f, 1.45f, 0.0f);
            this.m_5607_().forEach(p_102061_ -> p_102061_.m_104306_(stack, builder, packedLight, packedOverlay, red, green, blue, alpha));
            this.m_5608_().forEach(p_102051_ -> p_102051_.m_104306_(stack, builder, packedLight, packedOverlay, red, green, blue, alpha));
            stack.m_85849_();
        } else {
            stack.m_85836_();
            stack.m_85841_(0.8f, 0.8f, 0.8f);
            stack.m_252880_(0.0f, 0.35f, 0.0f);
            this.m_5607_().forEach(p_102061_ -> p_102061_.m_104306_(stack, builder, packedLight, packedOverlay, red, green, blue, alpha));
            this.m_5608_().forEach(p_102051_ -> p_102051_.m_104306_(stack, builder, packedLight, packedOverlay, red, green, blue, alpha));
            stack.m_85849_();
        }
    }
}

