/*
 * Decompiled with CFR 0.152.
 */
package net.pavocado.exoticbirds.client.model;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.AgeableListModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.pavocado.exoticbirds.entity.BudgerigarEntity;

@OnlyIn(value=Dist.CLIENT)
public class BudgerigarModel<T extends BudgerigarEntity>
extends AgeableListModel<T> {
    public static final ModelLayerLocation BUDGERIGAR_LAYER = new ModelLayerLocation(new ResourceLocation("exoticbirds", "budgerigar"), "main");
    private final ModelPart body;
    private final ModelPart head;
    private final ModelPart beak;
    private final ModelPart breast;
    private final ModelPart tail;
    private final ModelPart leftLeg;
    private final ModelPart rightLeg;
    private final ModelPart leftFoot;
    private final ModelPart rightFoot;
    private final ModelPart rightWing;
    private final ModelPart leftWing;

    public BudgerigarModel(ModelPart part) {
        this.body = part.m_171324_("body");
        this.head = part.m_171324_("head");
        this.beak = part.m_171324_("beak");
        this.breast = part.m_171324_("breast");
        this.tail = part.m_171324_("tail");
        this.leftLeg = part.m_171324_("leftLeg");
        this.rightLeg = part.m_171324_("rightLeg");
        this.leftFoot = part.m_171324_("leftFoot");
        this.rightFoot = part.m_171324_("rightFoot");
        this.rightWing = part.m_171324_("rightWing");
        this.leftWing = part.m_171324_("leftWing");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        partdefinition.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(-2.5f, 0.0f, 0.0f, 5.0f, 8.0f, 4.0f), PartPose.m_171423_((float)0.0f, (float)15.2f, (float)-4.0f, (float)0.4089647f, (float)0.0f, (float)0.0f));
        partdefinition.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 12).m_171481_(-2.0f, -4.0f, -2.0f, 4.0f, 4.0f, 4.0f), PartPose.m_171423_((float)0.0f, (float)16.2f, (float)-1.8f, (float)0.0371786f, (float)0.0f, (float)0.0f));
        partdefinition.m_171599_("beak", CubeListBuilder.m_171558_().m_171514_(11, 20).m_171481_(-1.0f, 0.0f, -3.0f, 2.0f, 2.0f, 2.0f), PartPose.m_171423_((float)0.0f, (float)14.6f, (float)-1.8f, (float)-0.8551081f, (float)0.0f, (float)0.0f));
        partdefinition.m_171599_("breast", CubeListBuilder.m_171558_().m_171514_(0, 25).m_171481_(-2.0f, -1.0f, 0.0f, 4.0f, 3.0f, 4.0f), PartPose.m_171423_((float)0.0f, (float)16.0f, (float)-1.75f, (float)-1.524323f, (float)0.0f, (float)0.0f));
        partdefinition.m_171599_("tail", CubeListBuilder.m_171558_().m_171514_(20, 24).m_171481_(-1.5f, 0.0f, 0.0f, 3.0f, 7.0f, 1.0f), PartPose.m_171423_((float)0.0f, (float)20.2f, (float)1.5f, (float)0.5576792f, (float)0.0f, (float)0.0f));
        partdefinition.m_171599_("leftLeg", CubeListBuilder.m_171558_().m_171514_(18, 8).m_171481_(-0.5f, 0.0f, -0.5f, 1.0f, 3.0f, 1.0f), PartPose.m_171423_((float)1.0f, (float)21.0f, (float)0.4f, (float)0.0f, (float)0.0f, (float)-0.0872665f));
        partdefinition.m_171599_("rightLeg", CubeListBuilder.m_171558_().m_171514_(18, 4).m_171481_(-0.5f, 0.0f, -0.5f, 1.0f, 3.0f, 1.0f), PartPose.m_171423_((float)-1.0f, (float)21.0f, (float)0.4f, (float)0.0f, (float)0.0f, (float)0.0872665f));
        partdefinition.m_171599_("leftFoot", CubeListBuilder.m_171558_().m_171514_(13, 12).m_171481_(-0.7f, 3.0f, -2.5f, 2.0f, 0.0f, 3.0f), PartPose.m_171423_((float)1.0f, (float)21.0f, (float)1.4f, (float)0.0f, (float)0.0f, (float)0.0f));
        partdefinition.m_171599_("rightFoot", CubeListBuilder.m_171558_().m_171514_(13, 16).m_171481_(-1.3f, 3.0f, -2.5f, 2.0f, 0.0f, 3.0f), PartPose.m_171423_((float)-1.0f, (float)21.0f, (float)1.4f, (float)0.0f, (float)0.0f, (float)0.0f));
        partdefinition.m_171599_("rightWing", CubeListBuilder.m_171558_().m_171514_(22, 12).m_171481_(-1.0f, 0.0f, -1.0f, 1.0f, 8.0f, 4.0f), PartPose.m_171423_((float)-2.5f, (float)16.2f, (float)-2.0f, (float)0.5235988f, (float)0.2094395f, (float)0.0f));
        partdefinition.m_171599_("leftWing", CubeListBuilder.m_171558_().m_171514_(22, 0).m_171481_(0.0f, 0.0f, -1.0f, 1.0f, 8.0f, 4.0f), PartPose.m_171423_((float)2.5f, (float)16.2f, (float)-2.0f, (float)0.5235988f, (float)-0.2094395f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)32, (int)32);
    }

    protected Iterable<ModelPart> m_5607_() {
        return ImmutableList.of((Object)this.head, (Object)this.beak);
    }

    protected Iterable<ModelPart> m_5608_() {
        return ImmutableList.of((Object)this.body, (Object)this.breast, (Object)this.tail, (Object)this.leftLeg, (Object)this.rightLeg, (Object)this.leftFoot, (Object)this.rightFoot, (Object)this.rightWing, (Object)this.leftWing);
    }

    public void setupAnim(T entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.head.f_104203_ = -(headPitch / 57.295776f);
        this.head.f_104204_ = netHeadYaw / 57.295776f;
        this.beak.f_104203_ = -(headPitch / 57.295776f) - 0.8551081f;
        this.beak.f_104204_ = netHeadYaw / 57.295776f;
        this.rightLeg.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f)) * limbSwingAmount;
        this.rightFoot.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f)) * limbSwingAmount;
        this.leftLeg.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * limbSwingAmount;
        this.leftFoot.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * limbSwingAmount;
        this.rightWing.f_104205_ = ageInTicks;
        this.leftWing.f_104205_ = -ageInTicks;
    }

    public void m_7695_(PoseStack stack, VertexConsumer builder, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        stack.m_85836_();
        if (this.f_102610_) {
            stack.m_85841_(0.4f, 0.4f, 0.4f);
            stack.m_85837_(0.0, 2.23, 0.0);
            this.m_5607_().forEach(p_102061_ -> p_102061_.m_104306_(stack, builder, packedLight, packedOverlay, red, green, blue, alpha));
            this.m_5608_().forEach(p_102051_ -> p_102051_.m_104306_(stack, builder, packedLight, packedOverlay, red, green, blue, alpha));
        } else {
            stack.m_85841_(0.8f, 0.8f, 0.8f);
            stack.m_85837_(0.0, 0.35, 0.0);
            this.m_5607_().forEach(p_102061_ -> p_102061_.m_104306_(stack, builder, packedLight, packedOverlay, red, green, blue, alpha));
            this.m_5608_().forEach(p_102051_ -> p_102051_.m_104306_(stack, builder, packedLight, packedOverlay, red, green, blue, alpha));
        }
        stack.m_85849_();
    }
}

