/*
 * Decompiled with CFR 0.152.
 */
package net.pavocado.exoticbirds.blockentity;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.items.ItemStackHandler;
import net.pavocado.exoticbirds.block.RoostBoxBlock;
import net.pavocado.exoticbirds.blockentity.misc.BirdStorable;
import net.pavocado.exoticbirds.blockentity.misc.StoredBirdLogic;
import net.pavocado.exoticbirds.container.RoostBoxMenu;
import net.pavocado.exoticbirds.entity.PigeonEntity;
import net.pavocado.exoticbirds.init.ExoticBirdsBlockEntities;
import net.pavocado.exoticbirds.init.ExoticBirdsBlocks;
import net.pavocado.exoticbirds.item.BirdcageItem;

public class RoostBoxBlockEntity
extends RandomizableContainerBlockEntity
implements BirdStorable {
    private final StoredBirdLogic storedBird = new StoredBirdLogic();
    public final ItemStackHandler inventory = new ItemStackHandler(9){

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            return false;
        }
    };

    public RoostBoxBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ExoticBirdsBlockEntities.ROOST_BOX.get(), pos, state);
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128365_("inventory", (Tag)this.inventory.serializeNBT());
        this.storedBird.save(tag);
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.inventory.deserializeNBT(tag.m_128469_("inventory"));
        this.storedBird.load(tag);
    }

    public boolean insertItem(ItemStack stack) {
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            if (this.inventory.getStackInSlot(i) != ItemStack.f_41583_) continue;
            this.inventory.setStackInSlot(i, stack);
            return true;
        }
        return false;
    }

    protected Component m_6820_() {
        return Component.m_237115_((String)((RoostBoxBlock)((Object)ExoticBirdsBlocks.ROOST_BOX.get())).m_7705_());
    }

    protected NonNullList<ItemStack> m_7086_() {
        NonNullList stackList = NonNullList.m_122780_((int)9, (Object)ItemStack.f_41583_);
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            stackList.set(i, (Object)this.inventory.getStackInSlot(i));
        }
        return stackList;
    }

    public boolean couldInsertItem() {
        return this.m_7086_().contains((Object)ItemStack.f_41583_);
    }

    protected void m_6520_(NonNullList<ItemStack> stacks) {
        for (int i = 0; i < stacks.size(); ++i) {
            if (i >= this.inventory.getSlots()) continue;
            this.inventory.setStackInSlot(i, (ItemStack)stacks.get(i));
        }
    }

    protected AbstractContainerMenu m_6555_(int val, Inventory inventory) {
        return new RoostBoxMenu(val, inventory, this);
    }

    public int m_6643_() {
        return 9;
    }

    public boolean m_7013_(int slot, ItemStack stack) {
        return false;
    }

    public StoredBirdLogic getBirdcageLogic() {
        return this.storedBird;
    }

    @Nullable
    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    @Nonnull
    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    public PigeonEntity getPigeon() {
        return (PigeonEntity)this.storedBird.getOrCreateDisplayEntity(this.m_58904_());
    }

    public void setPigeon(PigeonEntity pigeon) {
        CompoundTag entityTag = new CompoundTag();
        if (BirdcageItem.saveEntityToTag((LivingEntity)pigeon, entityTag)) {
            this.storedBird.setCageData(entityTag);
            this.markUpdated();
        }
    }

    public void withdrawPigeon(ServerLevel level, BlockPos blockPos, BlockPos playerPos) {
        BlockPos spawnPos = playerPos;
        if (level.m_8055_(blockPos.m_7494_()).m_60795_()) {
            spawnPos = blockPos.m_7494_();
        }
        this.storedBird.spawnEntity(level, spawnPos);
        this.storedBird.setCageData(null);
        this.markUpdated();
    }

    private void markUpdated() {
        this.m_6596_();
        if (this.f_58857_ != null) {
            this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 3);
        }
    }

    public static void clientTick(Level level, BlockPos pos, BlockState state, RoostBoxBlockEntity entity) {
        entity.storedBird.clientTick(level, pos);
    }

    @Override
    public StoredBirdLogic getStoredBirdLogic() {
        return this.storedBird;
    }

    @Override
    public BlockPos getStoredBirdPos() {
        return this.m_58899_();
    }
}

