/*
 * Decompiled with CFR 0.152.
 */
package net.pavocado.exoticbirds.blockentity;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.RangedWrapper;
import net.pavocado.exoticbirds.block.NestBlock;
import net.pavocado.exoticbirds.container.NestMenu;
import net.pavocado.exoticbirds.init.ExoticBirdsBlockEntities;
import net.pavocado.exoticbirds.init.ExoticBirdsBlocks;
import net.pavocado.exoticbirds.init.ExoticBirdsItems;
import net.pavocado.exoticbirds.item.BirdEggItem;

public class NestBlockEntity
extends RandomizableContainerBlockEntity {
    public final ItemStackHandler inventory = new ItemStackHandler(3){

        public int getSlotLimit(int slot) {
            return 1;
        }

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            if (!stack.m_41619_()) {
                Item item = stack.m_41720_();
                return item == ExoticBirdsItems.MYSTERY_EGG.get() || item == Items.f_42521_ || item == ExoticBirdsItems.EGGSHELL.get() || item instanceof BirdEggItem;
            }
            return false;
        }

        protected void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            NestBlockEntity.this.markUpdated();
        }
    };
    private final LazyOptional<IItemHandlerModifiable> inventoryCapabilityExternalDown = LazyOptional.of(() -> new RangedWrapper((IItemHandlerModifiable)this.inventory, 0, 3));

    public NestBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ExoticBirdsBlockEntities.NEST.get(), pos, state);
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128365_("inventory", (Tag)this.inventory.serializeNBT());
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.inventory.deserializeNBT(tag.m_128469_("inventory"));
    }

    private void markUpdated() {
        this.m_6596_();
        if (this.m_58904_() != null) {
            this.m_58904_().m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 3);
        }
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, NestBlockEntity entity) {
        int currentEggCount = entity.getEggs();
        if ((Integer)state.m_61143_((Property)NestBlock.EGGS) != currentEggCount) {
            state = (BlockState)state.m_61124_((Property)NestBlock.EGGS, (Comparable)Integer.valueOf(currentEggCount));
            level.m_7731_(pos, state, 3);
        }
    }

    public boolean insertItem(ItemStack stack) {
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            if (this.inventory.getStackInSlot(i) != ItemStack.f_41583_) continue;
            this.inventory.setStackInSlot(i, stack);
            return true;
        }
        return false;
    }

    private int getEggs() {
        int eggCount = 0;
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            if (this.inventory.getStackInSlot(i).m_41619_()) continue;
            ++eggCount;
        }
        return eggCount;
    }

    protected Component m_6820_() {
        return Component.m_237115_((String)((NestBlock)((Object)ExoticBirdsBlocks.NEST.get())).m_7705_());
    }

    protected NonNullList<ItemStack> m_7086_() {
        NonNullList stackList = NonNullList.m_122780_((int)3, (Object)ItemStack.f_41583_);
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            stackList.set(i, (Object)this.inventory.getStackInSlot(i));
        }
        return stackList;
    }

    protected void m_6520_(NonNullList<ItemStack> stacks) {
        for (int i = 0; i < stacks.size(); ++i) {
            if (i >= this.inventory.getSlots()) continue;
            this.inventory.setStackInSlot(i, (ItemStack)stacks.get(i));
        }
    }

    protected AbstractContainerMenu m_6555_(int val, Inventory inventory) {
        return new NestMenu(val, inventory, this);
    }

    public int m_6643_() {
        return 3;
    }

    public boolean m_7013_(int slot, ItemStack stack) {
        Item item = stack.m_41720_();
        return item == ExoticBirdsItems.MYSTERY_EGG.get() || item == Items.f_42521_ || item == ExoticBirdsItems.EGGSHELL.get() || item instanceof BirdEggItem;
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER && side == Direction.DOWN) {
            return this.inventoryCapabilityExternalDown.cast();
        }
        return super.getCapability(cap, side);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.inventoryCapabilityExternalDown.invalidate();
    }
}

