/*
 * Decompiled with CFR 0.152.
 */
package com.scouter.netherdepthsupgrade.entity;

import com.mojang.logging.LogUtils;
import com.scouter.netherdepthsupgrade.entity.BucketableLava;
import com.scouter.netherdepthsupgrade.entity.LavaAnimal;
import com.scouter.netherdepthsupgrade.entity.ai.FishSwimGoal;
import com.scouter.netherdepthsupgrade.entity.ai.LavaBoundPathNavigation;
import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.slf4j.Logger;

public abstract class AbstractLavaFish
extends LavaAnimal
implements BucketableLava {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final EntityDataAccessor<Boolean> FROM_BUCKET = SynchedEntityData.m_135353_(AbstractLavaFish.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> JUMPING = SynchedEntityData.m_135353_(AbstractLavaFish.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    @Nullable
    public FishSwimGoal fishSwimGoal;

    public AbstractLavaFish(EntityType<? extends AbstractLavaFish> p_27461_, Level p_27462_) {
        super(p_27461_, p_27462_);
        this.f_21342_ = new FishMoveControl(this);
    }

    protected float m_6431_(Pose pPose, EntityDimensions pSize) {
        return pSize.f_20378_ * 0.65f;
    }

    public static AttributeSupplier setAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 3.0).m_22265_();
    }

    public boolean m_8023_() {
        return super.m_8023_() || this.fromBucket();
    }

    public boolean m_6785_(double pDistanceToClosestPlayer) {
        return !this.fromBucket() && !this.m_8077_();
    }

    public int m_5792_() {
        return 8;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(FROM_BUCKET, (Object)false);
        this.f_19804_.m_135372_(JUMPING, (Object)false);
    }

    @Override
    public boolean fromBucket() {
        return (Boolean)this.f_19804_.m_135370_(FROM_BUCKET);
    }

    @Override
    public void setFromBucket(boolean p_27498_) {
        this.f_19804_.m_135381_(FROM_BUCKET, (Object)p_27498_);
    }

    public void setIsJumping(boolean isJumping) {
        this.f_19804_.m_135381_(JUMPING, (Object)isJumping);
    }

    public boolean getIsJumping() {
        return (Boolean)this.f_19804_.m_135370_(JUMPING);
    }

    public void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
        pCompound.m_128379_("FromBucket", this.fromBucket());
        pCompound.m_128379_("isJumping", this.getIsJumping());
    }

    public void m_7378_(CompoundTag pCompound) {
        super.m_7378_(pCompound);
        this.setFromBucket(pCompound.m_128471_("FromBucket"));
        this.setIsJumping(pCompound.m_128471_("isJumping"));
    }

    protected void m_8099_() {
        super.m_8099_();
        this.fishSwimGoal = new FishSwimGoal(this);
        this.f_21345_.m_25352_(0, (Goal)new PanicGoal((PathfinderMob)this, 1.25));
        this.f_21345_.m_25352_(2, (Goal)new AvoidEntityGoal((PathfinderMob)this, Player.class, 8.0f, 1.6, 1.4, EntitySelector.f_20408_::test));
        this.f_21345_.m_25352_(3, (Goal)new FishSwimGoal(this));
        this.fishSwimGoal.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    protected PathNavigation m_6037_(Level pLevel) {
        return new LavaBoundPathNavigation((Mob)this, pLevel);
    }

    public void m_7023_(Vec3 pTravelVector) {
        if (this.m_21515_() && this.m_20077_()) {
            this.m_19920_(0.01f, pTravelVector);
            this.m_6478_(MoverType.SELF, this.m_20184_());
            this.m_20256_(this.m_20184_().m_82490_(0.9));
            if (this.m_5448_() == null) {
                this.m_20256_(this.m_20184_().m_82520_(0.0, -0.005, 0.0));
            }
        } else {
            super.m_7023_(pTravelVector);
        }
    }

    public void m_8107_() {
        if (this.m_20069_()) {
            this.m_6469_(this.m_269291_().m_269233_(), 4.0f);
        }
        if (!this.m_20077_() && this.m_20096_() && this.f_19863_) {
            this.m_20256_(this.m_20184_().m_82520_((double)((this.f_19796_.m_188501_() * 2.0f - 1.0f) * 0.05f), (double)0.4f, (double)((this.f_19796_.m_188501_() * 2.0f - 1.0f) * 0.05f)));
            this.m_6853_(false);
            this.f_19812_ = true;
            this.m_5496_(this.getFlopSound(), this.m_6121_(), this.m_6100_());
        }
        super.m_8107_();
    }

    protected InteractionResult m_6071_(Player pPlayer, InteractionHand pHand) {
        return BucketableLava.bucketMobPickup(pPlayer, pHand, this).orElse(super.m_6071_(pPlayer, pHand));
    }

    public boolean m_5825_() {
        return true;
    }

    @Override
    public void saveToBucketTag(ItemStack p_27494_) {
        BucketableLava.saveDefaultDataToBucketTag((Mob)this, p_27494_);
    }

    @Override
    public void loadFromBucketTag(CompoundTag p_148708_) {
        BucketableLava.loadDefaultDataFromBucketTag((Mob)this, p_148708_);
    }

    @Override
    public SoundEvent getPickupSound() {
        return SoundEvents.f_11782_;
    }

    protected boolean canRandomSwim() {
        return true;
    }

    protected abstract SoundEvent getFlopSound();

    protected SoundEvent m_5501_() {
        return SoundEvents.f_11938_;
    }

    protected void m_7355_(BlockPos pPos, BlockState pBlock) {
    }

    static class FishMoveControl
    extends MoveControl {
        private final PathfinderMob fish;

        FishMoveControl(PathfinderMob p_27501_) {
            super((Mob)p_27501_);
            this.fish = p_27501_;
        }

        public void m_8126_() {
            if (this.fish.m_204029_(FluidTags.f_13132_)) {
                this.fish.m_20256_(this.fish.m_20184_().m_82520_(0.0, 0.005, 0.0));
            }
            if (this.f_24981_ == MoveControl.Operation.MOVE_TO && !this.fish.m_21573_().m_26571_()) {
                float f = (float)(this.f_24978_ * this.fish.m_21133_(Attributes.f_22279_));
                this.fish.m_7910_(Mth.m_14179_((float)0.125f, (float)this.fish.m_6113_(), (float)f));
                double d0 = this.f_24975_ - this.fish.m_20185_();
                double d1 = this.f_24976_ - this.fish.m_20186_();
                double d2 = this.f_24977_ - this.fish.m_20189_();
                if (d1 != 0.0) {
                    double d3 = Math.sqrt(d0 * d0 + d1 * d1 + d2 * d2);
                    this.fish.m_20256_(this.fish.m_20184_().m_82520_(0.0, (double)this.fish.m_6113_() * (d1 / d3) * 0.1, 0.0));
                }
                if (d0 != 0.0 || d2 != 0.0) {
                    float f1 = (float)(Mth.m_14136_((double)d2, (double)d0) * 57.2957763671875) - 90.0f;
                    this.fish.m_146922_(this.m_24991_(this.fish.m_146908_(), f1, 90.0f));
                    this.fish.f_20883_ = this.fish.m_146908_();
                }
            } else {
                this.fish.m_7910_(0.0f);
            }
        }
    }
}

