/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.wits.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import java.util.List;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.DimensionArgument;
import net.minecraft.commands.arguments.coordinates.Coordinates;
import net.minecraft.commands.arguments.coordinates.Vec3Argument;
import net.minecraft.commands.arguments.coordinates.WorldCoordinates;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureStart;

public class WITSCommand {
    public static void createCommand(CommandDispatcher<CommandSourceStack> dispatcher) {
        String commandString = "wits";
        String opCommandString = "witsop";
        String dimensionArg = "dimension";
        String locationArg = "location";
        LiteralCommandNode source = dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)commandString).requires(permission -> permission.m_6761_(0))).executes(cs -> {
            WorldCoordinates coordinates;
            if (((CommandSourceStack)cs.getSource()).m_230897_()) {
                BlockPos currentPosition = ((CommandSourceStack)cs.getSource()).m_230896_().m_20183_();
                coordinates = WorldCoordinates.m_175085_((double)currentPosition.m_123341_(), (double)currentPosition.m_123342_(), (double)currentPosition.m_123343_());
            } else {
                coordinates = WorldCoordinates.m_175085_((double)0.0, (double)0.0, (double)0.0);
            }
            WITSCommand.listStructuresAtSpot(((CommandSourceStack)cs.getSource()).m_81372_(), (Coordinates)coordinates, true, (CommandContext<CommandSourceStack>)cs);
            return 1;
        }));
        dispatcher.register((LiteralArgumentBuilder)Commands.m_82127_((String)commandString).redirect((CommandNode)source));
        LiteralCommandNode source2 = dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)opCommandString).requires(permission -> permission.m_6761_(2))).then(Commands.m_82129_((String)dimensionArg, (ArgumentType)DimensionArgument.m_88805_()).then(Commands.m_82129_((String)locationArg, (ArgumentType)Vec3Argument.m_120841_()).executes(cs -> {
            WITSCommand.listStructuresAtSpot(DimensionArgument.m_88808_((CommandContext)cs, (String)dimensionArg), Vec3Argument.m_120849_((CommandContext)cs, (String)locationArg), false, (CommandContext<CommandSourceStack>)cs);
            return 1;
        }))));
        dispatcher.register((LiteralArgumentBuilder)Commands.m_82127_((String)opCommandString).redirect((CommandNode)source2));
    }

    private static void listStructuresAtSpot(ServerLevel level, Coordinates coordinates, boolean callerPosition, CommandContext<CommandSourceStack> cs) {
        BlockPos centerPos = coordinates.m_119568_((CommandSourceStack)cs.getSource());
        List structureStarts = level.m_215010_().m_220477_(new ChunkPos(centerPos), s -> true);
        List<Structure> structures = structureStarts.stream().filter(ss -> ss.m_73601_().m_71051_((Vec3i)centerPos)).map(StructureStart::m_226861_).toList();
        if (structures.isEmpty()) {
            MutableComponent component = Component.m_237113_((String)(callerPosition ? "There's no structures at your location." : "There's no structures at the location."));
            ((CommandSourceStack)cs.getSource()).m_288197_(() -> WITSCommand.lambda$listStructuresAtSpot$6((Component)component), !((CommandSourceStack)cs.getSource()).m_230897_());
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (callerPosition) {
            stringBuilder.append("Structure(s) at your location:");
        } else {
            stringBuilder.append("Structure(s) at ").append(centerPos).append(":");
        }
        for (Structure structure : structures) {
            ResourceLocation key = level.m_9598_().m_175515_(Registries.f_256944_).m_7981_((Object)structure);
            stringBuilder.append("\u00a7r\n - \u00a76").append(key);
        }
        MutableComponent component = Component.m_237113_((String)stringBuilder.toString());
        ((CommandSourceStack)cs.getSource()).m_288197_(() -> WITSCommand.lambda$listStructuresAtSpot$7((Component)component), !((CommandSourceStack)cs.getSource()).m_230897_());
    }

    private static /* synthetic */ Component lambda$listStructuresAtSpot$7(Component component) {
        return component;
    }

    private static /* synthetic */ Component lambda$listStructuresAtSpot$6(Component component) {
        return component;
    }
}

